/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.parser.AbstractParser;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenKind;
import jdk.nashorn.internal.parser.TokenStream;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.JSErrorType;
import jdk.nashorn.internal.runtime.ParserException;

public class Parser
extends AbstractParser {
    private final Compiler compiler;
    private final Context context;
    private FunctionNode script;
    private FunctionNode function;
    private Block block;

    public Parser(Compiler compiler) {
        this(compiler, compiler.getContext()._strict);
    }

    public Parser(Compiler compiler, boolean strict) {
        super(compiler.getSource(), compiler.getErrors(), strict);
        this.compiler = compiler;
        this.context = compiler.getContext();
    }

    public FunctionNode parse(String scriptName) {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.context._scripting);
            this.k = -1;
            this.next();
            return this.program(scriptName);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            if (e instanceof ParserException) {
                this.errors.error((ParserException)e);
            } else {
                this.errors.error(message);
            }
            if (this.context._dump_on_error) {
                e.printStackTrace(this.context.getErr());
            }
            return null;
        }
    }

    private void recover(Exception e) {
        if (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            if (e instanceof ParserException) {
                this.errors.error((ParserException)e);
            } else {
                this.errors.error(message);
            }
            if (this.context._dump_on_error) {
                e.printStackTrace(this.context.getErr());
            }
        }
        block4: while (true) {
            switch (this.type) {
                case EOF: {
                    break block4;
                }
                case EOL: 
                case SEMICOLON: 
                case RBRACE: {
                    this.next();
                    break block4;
                }
                default: {
                    this.nextOrEOL();
                    continue block4;
                }
            }
            break;
        }
    }

    private Block newBlock() {
        this.block = new Block(this.source, this.token, Token.descPosition(this.token), this.block, this.function);
        return this.block;
    }

    private FunctionNode newFunctionBlock(IdentNode ident) {
        FunctionNode functionBlock;
        StringBuilder sb = new StringBuilder();
        if (this.block != null) {
            this.block.addParentName(sb);
        }
        sb.append(ident != null ? ident.getName() : CompilerConstants.FUNCTION_PREFIX.tag());
        String name = this.compiler.uniqueName(sb.toString());
        assert (this.function != null || name.equals(CompilerConstants.RUN_SCRIPT.tag())) : "name = " + name;
        this.function = functionBlock = new FunctionNode(this.source, this.token, Token.descPosition(this.token), this.compiler, this.block, ident, name);
        this.block = this.function;
        this.function.setStrictMode(this.isStrictMode);
        return functionBlock;
    }

    private void restoreBlock() {
        this.block = this.block.getParent();
        this.function = this.block.getFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block getBlock(boolean needsBraces) {
        Block newBlock = this.newBlock();
        this.pushControlNode(newBlock);
        if (needsBraces) {
            this.expect(TokenType.LBRACE);
        }
        try {
            this.statementList();
        }
        finally {
            this.restoreBlock();
            this.popControlNode();
        }
        int possibleEnd = Token.descPosition(this.token) + Token.descLength(this.token);
        if (needsBraces) {
            this.expect(TokenType.RBRACE);
        }
        newBlock.setFinish(possibleEnd);
        return newBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block getStatement() {
        if (this.type == TokenType.LBRACE) {
            return this.getBlock(true);
        }
        Block newBlock = this.newBlock();
        try {
            this.statement();
        }
        finally {
            this.restoreBlock();
        }
        return newBlock;
    }

    private void detectSpecialFunction(IdentNode ident) {
        String name = ident.getName();
        if (CompilerConstants.EVAL.tag().equals(name)) {
            this.function.setHasEval();
            this.function.setIsVarArg();
        }
    }

    private void detectSpecialProperty(IdentNode ident) {
        String name = ident.getName();
        if (CompilerConstants.ARGUMENTS.tag().equals(name)) {
            this.function.setIsVarArg();
        }
    }

    private static boolean checkIdentLValue(IdentNode ident) {
        return Token.descType(ident.getToken()).getKind() != TokenKind.KEYWORD;
    }

    private Node verifyAssignment(long op, Node lhs, Node rhs) {
        TokenType opType = Token.descType(op);
        switch (opType) {
            case ASSIGN: 
            case ASSIGN_ADD: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_SHR: 
            case ASSIGN_SUB: {
                if (!(lhs instanceof AccessNode || lhs instanceof IndexNode || lhs instanceof IdentNode)) {
                    if (this.context._early_lvalue_error) {
                        this.error(JSErrorType.REFERENCE_ERROR, AbstractParser.message("invalid.lvalue", new String[0]), lhs.getToken());
                    }
                    return this.referenceError(lhs, rhs);
                }
                if (!(lhs instanceof IdentNode)) break;
                if (!Parser.checkIdentLValue((IdentNode)lhs)) {
                    return this.referenceError(lhs, rhs);
                }
                this.verifyStrictIdent((IdentNode)lhs, "assignment");
                break;
            }
        }
        return new BinaryNode(this.source, op, lhs, rhs);
    }

    private Node incDecExpression(long firstToken, TokenType tokenType, Node expression, boolean isPostfix) {
        long incDecToken = firstToken;
        if (isPostfix) {
            incDecToken = Token.recast(incDecToken, tokenType == TokenType.DECPREFIX ? TokenType.DECPOSTFIX : TokenType.INCPOSTFIX);
        }
        UnaryNode node = new UnaryNode(this.source, incDecToken, expression);
        if (isPostfix) {
            node.setStart(expression.getStart());
            node.setFinish(Token.descPosition(incDecToken) + Token.descLength(incDecToken));
        }
        return node;
    }

    private LabelNode findLabel(IdentNode ident) {
        for (LabelNode labelNode : this.function.getLabelStack()) {
            if (!labelNode.getLabel().equals(ident)) continue;
            return labelNode;
        }
        return null;
    }

    private void pushLabel(LabelNode labelNode) {
        this.function.getLabelStack().push(labelNode);
    }

    private void popLabel() {
        this.function.getLabelStack().pop();
    }

    private void pushControlNode(Node node) {
        boolean isLoop = node instanceof WhileNode;
        this.function.getControlStack().push(node);
        for (LabelNode labelNode : this.function.getLabelStack()) {
            if (labelNode.getBreakNode() == null) {
                labelNode.setBreakNode(node);
            }
            if (!isLoop || labelNode.getContinueNode() != null) continue;
            labelNode.setContinueNode(node);
        }
    }

    private void popControlNode() {
        Stack<Node> controlStack = this.function.getControlStack();
        if (!controlStack.isEmpty()) {
            controlStack.pop();
        }
    }

    private void popControlNode(Node node) {
        Stack<Node> controlStack = this.function.getControlStack();
        if (!controlStack.isEmpty() && controlStack.peek() == node) {
            controlStack.pop();
        }
    }

    private boolean isInWithBlock() {
        Stack<Node> controlStack = this.function.getControlStack();
        for (int i = controlStack.size() - 1; i >= 0; --i) {
            Node node = (Node)controlStack.get(i);
            if (!(node instanceof WithNode)) continue;
            return true;
        }
        return false;
    }

    private <T extends Node> T findControl(Class<T> ctype) {
        Stack<Node> controlStack = this.function.getControlStack();
        for (int i = controlStack.size() - 1; i >= 0; --i) {
            Node node = (Node)controlStack.get(i);
            if (!ctype.isAssignableFrom(node.getClass())) continue;
            return (T)((Node)ctype.cast(node));
        }
        return null;
    }

    private <T extends Node> List<T> findControls(Class<T> ctype, Node to) {
        Node node;
        ArrayList<T> nodes = new ArrayList<T>();
        Stack<Node> controlStack = this.function.getControlStack();
        for (int i = controlStack.size() - 1; i >= 0 && to != (node = (Node)controlStack.get(i)); --i) {
            if (!ctype.isAssignableFrom(node.getClass())) continue;
            nodes.add(ctype.cast(node));
        }
        return nodes;
    }

    private <T extends Node> int countControls(Class<T> ctype, Node to) {
        return this.findControls(ctype, to).size();
    }

    private FunctionNode program(String scriptName) {
        long functionToken = Token.toDesc(TokenType.FUNCTION, 0, this.source.getLength());
        this.script = this.newFunctionBlock(new IdentNode(this.source, functionToken, Token.descPosition(functionToken), scriptName));
        this.script.setKind(FunctionNode.Kind.SCRIPT);
        this.script.setFirstToken(functionToken);
        this.sourceElements();
        this.expect(TokenType.EOF);
        this.script.setLastToken(this.token);
        this.script.setFinish(this.source.getLength() - 1);
        this.block.addStatement(this.lineNumber());
        return this.script;
    }

    private String getDirective(Node stmt) {
        LiteralNode lit;
        long litToken;
        TokenType tt;
        Node expr;
        if (stmt instanceof ExecuteNode && (expr = ((ExecuteNode)stmt).getExpression()) instanceof LiteralNode && ((tt = Token.descType(litToken = (lit = (LiteralNode)expr).getToken())) == TokenType.STRING || tt == TokenType.ESCSTRING)) {
            return this.source.getString(lit.getStart(), Token.descLength(litToken));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceElements() {
        ArrayList<Node> directiveStmts = null;
        boolean checkDirective = true;
        boolean oldStrictMode = this.isStrictMode;
        try {
            while (this.type != TokenType.EOF) {
                if (this.type == TokenType.RBRACE) {
                    break;
                }
                try {
                    this.statement(true);
                    if (checkDirective) {
                        Node lastStatement = Node.lastStatement(this.block.getStatements());
                        String directive = this.getDirective(lastStatement);
                        boolean bl = checkDirective = directive != null;
                        if (checkDirective) {
                            if (!oldStrictMode) {
                                if (directiveStmts == null) {
                                    directiveStmts = new ArrayList<Node>();
                                }
                                directiveStmts.add(lastStatement);
                            }
                            if ("use strict".equals(directive)) {
                                this.isStrictMode = true;
                                this.function.setStrictMode(true);
                                if (!oldStrictMode && directiveStmts != null) {
                                    for (Node statement : directiveStmts) {
                                        this.getValue(statement.getToken());
                                    }
                                    this.verifyStrictIdent(this.function.getIdent(), "function name");
                                    for (IdentNode param : this.function.getParameters()) {
                                        this.verifyStrictIdent(param, "function parameter");
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.recover(e);
                }
                this.stream.commit(this.k);
            }
        }
        finally {
            this.isStrictMode = oldStrictMode;
        }
    }

    private void statement() {
        this.statement(false);
    }

    private void statement(boolean topLevel) {
        LineNumberNode lineNumberNode = this.lineNumber();
        if (this.type == TokenType.FUNCTION) {
            if (this.isStrictMode && !topLevel) {
                this.error(AbstractParser.message("strict.no.func.here", new String[0]), this.token);
            }
            this.functionExpression(true);
            return;
        }
        this.block.addStatement(lineNumberNode);
        switch (this.type) {
            case LBRACE: {
                this.block();
                break;
            }
            case RBRACE: {
                break;
            }
            case VAR: {
                this.variableStatement(true);
                break;
            }
            case SEMICOLON: {
                this.emptyStatement();
                break;
            }
            case IF: {
                this.ifStatement();
                break;
            }
            case FOR: {
                this.forStatement();
                break;
            }
            case WHILE: {
                this.whileStatement();
                break;
            }
            case DO: {
                this.doStatement();
                break;
            }
            case CONTINUE: {
                this.continueStatement();
                break;
            }
            case BREAK: {
                this.breakStatement();
                break;
            }
            case RETURN: {
                this.returnStatement();
                break;
            }
            case YIELD: {
                this.yieldStatement();
                break;
            }
            case WITH: {
                this.withStatement();
                break;
            }
            case SWITCH: {
                this.switchStatement();
                break;
            }
            case THROW: {
                this.throwStatement();
                break;
            }
            case TRY: {
                this.tryStatement();
                break;
            }
            case DEBUGGER: {
                this.debuggerStatement();
                break;
            }
            case EOF: 
            case RPAREN: 
            case RBRACKET: {
                this.expect(TokenType.SEMICOLON);
                break;
            }
            default: {
                if ((this.type == TokenType.IDENT || this.isNonStrictModeIdent()) && this.T(this.k + 1) == TokenType.COLON) {
                    this.labelStatement();
                    return;
                }
                this.expressionStatement();
            }
        }
    }

    private void block() {
        Block newBlock = this.getBlock(true);
        ExecuteNode executeNode = new ExecuteNode(this.source, newBlock.getToken(), this.finish, newBlock);
        this.block.addStatement(executeNode);
    }

    private void statementList() {
        block3: while (this.type != TokenType.EOF) {
            switch (this.type) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    break block3;
                }
                default: {
                    this.statement();
                    continue block3;
                }
            }
        }
    }

    private void verifyStrictIdent(IdentNode ident, String contextString) {
        if (this.isStrictMode && ("eval".equals(ident.getName()) || "arguments".equals(ident.getName()))) {
            this.error(AbstractParser.message("strict.name", ident.getName(), contextString), ident.getToken());
        }
    }

    private List<VarNode> variableStatement(boolean isStatement) {
        this.next();
        ArrayList<VarNode> vars = new ArrayList<VarNode>();
        while (true) {
            long varToken = this.token;
            IdentNode name = this.getIdent();
            this.verifyStrictIdent(name, "variable name");
            Node init = null;
            if (this.type == TokenType.ASSIGN) {
                this.next();
                init = this.assignmentExpression(!isStatement);
            }
            VarNode var = new VarNode(this.source, varToken, this.finish, name, init);
            if (isStatement) {
                this.function.addDeclaration(var);
            }
            vars.add(var);
            this.block.addStatement(var);
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        if (isStatement) {
            boolean semicolon = this.type == TokenType.SEMICOLON;
            this.endOfLine();
            if (semicolon) {
                this.block.setFinish(this.finish);
            }
        }
        return vars;
    }

    private void emptyStatement() {
        if (this.context._empty_statements) {
            this.block.addStatement(new EmptyNode(this.source, this.token, Token.descPosition(this.token) + Token.descLength(this.token)));
        }
        this.next();
    }

    private void expressionStatement() {
        long expressionToken = this.token;
        Node expression = this.expression();
        ExecuteNode executeNode = null;
        if (expression != null) {
            executeNode = new ExecuteNode(this.source, expressionToken, this.finish, expression);
            this.block.addStatement(executeNode);
        } else {
            this.expect(null);
        }
        this.endOfLine();
        if (executeNode != null) {
            executeNode.setFinish(this.finish);
            this.block.setFinish(this.finish);
        }
    }

    private void ifStatement() {
        long ifToken = this.token;
        this.next();
        this.expect(TokenType.LPAREN);
        Node test = this.expression();
        this.expect(TokenType.RPAREN);
        Block pass = this.getStatement();
        Block fail = null;
        if (this.type == TokenType.ELSE) {
            this.next();
            fail = this.getStatement();
        }
        IfNode ifNode = new IfNode(this.source, ifToken, fail != null ? fail.getFinish() : pass.getFinish(), test, pass, fail);
        this.block.addStatement(ifNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forStatement() {
        ForNode forNode = new ForNode(this.source, this.token, Token.descPosition(this.token));
        this.pushControlNode(forNode);
        Block outer = this.newBlock();
        try {
            this.next();
            if (this.type == TokenType.IDENT && "each".equals(this.getValue())) {
                forNode.setIsForEach();
                this.next();
            }
            this.expect(TokenType.LPAREN);
            this.forControl(forNode);
            this.expect(TokenType.RPAREN);
            Block body = this.getStatement();
            forNode.setBody(body);
            forNode.setFinish(body.getFinish());
            outer.setFinish(body.getFinish());
            this.block.addStatement(forNode);
        }
        finally {
            this.restoreBlock();
            this.popControlNode();
        }
        this.block.addStatement(new ExecuteNode(this.source, outer.getToken(), outer.getFinish(), outer));
    }

    private void forControl(ForNode forNode) {
        Node expression;
        List<VarNode> vars = null;
        switch (this.type) {
            case VAR: {
                vars = this.variableStatement(false);
                break;
            }
            case SEMICOLON: {
                break;
            }
            default: {
                expression = this.expression(this.unaryExpression(), TokenType.COMMARIGHT.getPrecedence(), true);
                forNode.setInit(expression);
            }
        }
        switch (this.type) {
            case SEMICOLON: {
                this.expect(TokenType.SEMICOLON);
                if (this.type != TokenType.SEMICOLON) {
                    forNode.setTest(this.expression());
                }
                this.expect(TokenType.SEMICOLON);
                if (this.type == TokenType.RPAREN) break;
                expression = this.expression();
                forNode.setModify(expression);
                break;
            }
            case IN: {
                forNode.setIsForIn();
                if (vars != null) {
                    if (vars.size() == 1) {
                        forNode.setInit(new IdentNode(vars.get(0).getName()));
                    } else {
                        this.error(AbstractParser.message("many.vars.in.for.in.loop", new String[0]), vars.get(1).getToken());
                    }
                } else {
                    Node init = forNode.getInit();
                    assert (init != null) : "for..in init expression can not be null here";
                    if (!(init instanceof AccessNode || init instanceof IndexNode || init instanceof IdentNode)) {
                        this.error(AbstractParser.message("not.lvalue.for.in.loop", new String[0]), init.getToken());
                    }
                    if (init instanceof IdentNode) {
                        if (!Parser.checkIdentLValue((IdentNode)init)) {
                            this.error(AbstractParser.message("not.lvalue.for.in.loop", new String[0]), init.getToken());
                        }
                        this.verifyStrictIdent((IdentNode)init, "for-in iterator");
                    }
                }
                this.next();
                forNode.setModify(this.expression());
                break;
            }
            default: {
                this.expect(TokenType.SEMICOLON);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whileStatement() {
        long whileToken = this.token;
        this.next();
        WhileNode whileNode = new WhileNode(this.source, whileToken, Token.descPosition(whileToken));
        this.pushControlNode(whileNode);
        try {
            this.expect(TokenType.LPAREN);
            Node test = this.expression();
            whileNode.setTest(test);
            this.expect(TokenType.RPAREN);
            Block statements = this.getStatement();
            whileNode.setBody(statements);
            whileNode.setFinish(statements.getFinish());
            this.block.addStatement(whileNode);
        }
        finally {
            this.popControlNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStatement() {
        long doToken = this.token;
        this.next();
        DoWhileNode doWhileNode = new DoWhileNode(this.source, doToken, Token.descPosition(doToken));
        this.pushControlNode(doWhileNode);
        try {
            Block statements = this.getStatement();
            doWhileNode.setBody(statements);
            this.expect(TokenType.WHILE);
            this.expect(TokenType.LPAREN);
            Node test = this.expression();
            doWhileNode.setTest(test);
            this.expect(TokenType.RPAREN);
            if (this.type == TokenType.SEMICOLON) {
                this.endOfLine();
            }
            doWhileNode.setFinish(this.finish);
            this.block.addStatement(doWhileNode);
        }
        finally {
            this.popControlNode();
        }
    }

    private void continueStatement() {
        Node targetNode;
        long continueToken = this.token;
        this.nextOrEOL();
        LabelNode labelNode = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                IdentNode ident = this.getIdent();
                labelNode = this.findLabel(ident);
                if (labelNode != null) break;
                this.error(AbstractParser.message("undefined.label", ident.getName()), ident.getToken());
            }
        }
        Node node = targetNode = labelNode != null ? labelNode.getContinueNode() : this.findControl(WhileNode.class);
        if (targetNode == null) {
            this.error(AbstractParser.message("illegal.continue.stmt", new String[0]), continueToken);
        }
        this.endOfLine();
        ContinueNode continueNode = new ContinueNode(this.source, continueToken, this.finish, labelNode, targetNode, this.findControl(TryNode.class));
        continueNode.setScopeNestingLevel(this.countControls(WithNode.class, targetNode));
        this.block.addStatement(continueNode);
    }

    private void breakStatement() {
        Node targetNode;
        long breakToken = this.token;
        this.nextOrEOL();
        LabelNode labelNode = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                IdentNode ident = this.getIdent();
                labelNode = this.findLabel(ident);
                if (labelNode != null) break;
                this.error(AbstractParser.message("undefined.label", ident.getName()), ident.getToken());
            }
        }
        Node node = targetNode = labelNode != null ? labelNode.getBreakNode() : this.findControl(BreakableNode.class);
        if (targetNode == null) {
            this.error(AbstractParser.message("illegal.break.stmt", new String[0]), breakToken);
        }
        this.endOfLine();
        BreakNode breakNode = new BreakNode(this.source, breakToken, this.finish, labelNode, targetNode, this.findControl(TryNode.class));
        breakNode.setScopeNestingLevel(this.countControls(WithNode.class, targetNode));
        this.block.addStatement(breakNode);
    }

    private void returnStatement() {
        if (this.function.getKind() == FunctionNode.Kind.SCRIPT) {
            this.error(AbstractParser.message("invalid.return", new String[0]));
        }
        long returnToken = this.token;
        this.nextOrEOL();
        Node expression = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        this.endOfLine();
        ReturnNode returnNode = new ReturnNode(this.source, returnToken, this.finish, expression, this.findControl(TryNode.class));
        this.block.addStatement(returnNode);
    }

    private void yieldStatement() {
        long yieldToken = this.token;
        this.nextOrEOL();
        Node expression = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        this.endOfLine();
        ReturnNode yieldNode = new ReturnNode(this.source, yieldToken, this.finish, expression, this.findControl(TryNode.class));
        this.block.addStatement(yieldNode);
        this.function.setHasYield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withStatement() {
        long withToken = this.token;
        this.next();
        if (this.isStrictMode) {
            this.error(AbstractParser.message("strict.no.with", new String[0]), withToken);
        }
        WithNode withNode = new WithNode(this.source, withToken, this.finish, null, null);
        this.function.setHasWith();
        try {
            this.pushControlNode(withNode);
            this.expect(TokenType.LPAREN);
            Node expression = this.expression();
            withNode.setExpression(expression);
            this.expect(TokenType.RPAREN);
            Block statements = this.getStatement();
            withNode.setBody(statements);
            withNode.setFinish(this.finish);
        }
        finally {
            this.popControlNode(withNode);
        }
        this.block.addStatement(withNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchStatement() {
        long switchToken = this.token;
        this.next();
        SwitchNode switchNode = new SwitchNode(this.source, switchToken, Token.descPosition(switchToken));
        this.pushControlNode(switchNode);
        try {
            this.expect(TokenType.LPAREN);
            Node switchExpression = this.expression();
            switchNode.setExpression(switchExpression);
            this.expect(TokenType.RPAREN);
            this.expect(TokenType.LBRACE);
            ArrayList<CaseNode> cases = new ArrayList<CaseNode>();
            CaseNode defaultCase = null;
            while (this.type != TokenType.RBRACE) {
                Node caseExpression = null;
                long caseToken = this.token;
                switch (this.type) {
                    case CASE: {
                        this.next();
                        caseExpression = this.expression();
                        break;
                    }
                    case DEFAULT: {
                        if (defaultCase != null) {
                            this.error(AbstractParser.message("duplicate.default.in.switch", new String[0]));
                        }
                        this.next();
                        break;
                    }
                    default: {
                        this.expect(TokenType.CASE);
                    }
                }
                this.expect(TokenType.COLON);
                Block statements = this.getBlock(false);
                CaseNode caseNode = new CaseNode(this.source, caseToken, this.finish, caseExpression, statements);
                statements.setFinish(this.finish);
                if (caseExpression == null) {
                    defaultCase = caseNode;
                }
                cases.add(caseNode);
            }
            switchNode.setCases(cases);
            switchNode.setDefaultCase(defaultCase);
            this.next();
            switchNode.setFinish(this.finish);
            this.block.addStatement(switchNode);
        }
        finally {
            this.popControlNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void labelStatement() {
        long labelToken = this.token;
        IdentNode ident = this.getIdent();
        this.expect(TokenType.COLON);
        if (this.findLabel(ident) != null) {
            this.error(AbstractParser.message("duplicate.label", ident.getName()), labelToken);
        }
        try {
            LabelNode labelNode = new LabelNode(this.source, labelToken, this.finish, ident, null);
            this.pushLabel(labelNode);
            Block statements = this.getStatement();
            labelNode.setBody(statements);
            labelNode.setFinish(this.finish);
            this.block.addStatement(labelNode);
        }
        finally {
            this.popLabel();
        }
    }

    private void throwStatement() {
        long throwToken = this.token;
        this.nextOrEOL();
        Node expression = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        if (expression == null) {
            this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
        }
        this.endOfLine();
        ThrowNode throwNode = new ThrowNode(this.source, throwToken, this.finish, expression, this.findControl(TryNode.class));
        this.function.setHasThrows(true);
        this.block.addStatement(throwNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStatement() {
        long tryToken = this.token;
        this.next();
        TryNode tryNode = new TryNode(this.source, tryToken, Token.descPosition(tryToken), this.findControl(TryNode.class));
        this.pushControlNode(tryNode);
        try {
            Block tryBody = this.getBlock(true);
            ArrayList<Block> catchBlocks = new ArrayList<Block>();
            while (this.type == TokenType.CATCH) {
                long catchToken = this.token;
                this.next();
                this.expect(TokenType.LPAREN);
                IdentNode exception = this.getIdent();
                this.verifyStrictIdent(exception, "catch argument");
                Node ifExpression = null;
                if (this.type == TokenType.IF) {
                    this.next();
                    ifExpression = this.expression();
                }
                this.expect(TokenType.RPAREN);
                try {
                    Block catchBlock = this.newBlock();
                    Block catchBody = this.getBlock(true);
                    CatchNode catchNode = new CatchNode(this.source, catchToken, this.finish, exception, ifExpression, catchBody);
                    this.block.addStatement(catchNode);
                    catchBlocks.add(catchBlock);
                }
                finally {
                    this.restoreBlock();
                }
                if (ifExpression != null) continue;
                break;
            }
            this.popControlNode();
            Block finallyStatements = null;
            if (this.type == TokenType.FINALLY) {
                this.next();
                finallyStatements = this.getBlock(true);
            }
            if (catchBlocks.isEmpty() && finallyStatements == null) {
                this.error(AbstractParser.message("missing.catch.or.finally", new String[0]), tryToken);
            }
            tryNode.setBody(tryBody);
            tryNode.setCatchBlocks(catchBlocks);
            tryNode.setFinallyBody(finallyStatements);
            tryNode.setFinish(this.finish);
            this.block.addStatement(tryNode);
        }
        finally {
            this.popControlNode(tryNode);
        }
    }

    private void debuggerStatement() {
        long debuggerToken = this.token;
        this.next();
        this.endOfLine();
        RuntimeNode runtimeNode = new RuntimeNode(this.source, debuggerToken, this.finish, RuntimeNode.Request.DEBUGGER, new ArrayList<Node>());
        this.block.addStatement(runtimeNode);
    }

    private Node primaryExpression() {
        long primaryToken = this.token;
        switch (this.type) {
            case THIS: {
                String name = this.type.getName();
                this.next();
                return new IdentNode(this.source, primaryToken, this.finish, name);
            }
            case IDENT: {
                IdentNode ident = this.getIdent();
                if (ident == null) break;
                this.detectSpecialProperty(ident);
                return ident;
            }
            case OCTAL: {
                if (this.isStrictMode) {
                    this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case FLOATING: 
            case REGEX: 
            case XML: {
                return this.getLiteral();
            }
            case FALSE: {
                this.next();
                return LiteralNode.newInstance(this.source, primaryToken, this.finish, false);
            }
            case TRUE: {
                this.next();
                return LiteralNode.newInstance(this.source, primaryToken, this.finish, true);
            }
            case NULL: {
                this.next();
                return LiteralNode.newInstance(this.source, primaryToken, this.finish);
            }
            case LBRACKET: {
                return this.arrayLiteral();
            }
            case LBRACE: {
                return this.objectLiteral();
            }
            case LPAREN: {
                this.next();
                Node expression = this.expression();
                this.expect(TokenType.RPAREN);
                return expression;
            }
            default: {
                if (this.lexer.scanLiteral(primaryToken, this.type)) {
                    this.next();
                    return this.getLiteral();
                }
                if (!this.isNonStrictModeIdent()) break;
                return this.getIdent();
            }
        }
        return null;
    }

    private Node arrayLiteral() {
        long arrayToken = this.token;
        this.next();
        ArrayList<Node> elements = new ArrayList<Node>();
        boolean elision = true;
        block4: while (true) {
            switch (this.type) {
                case RBRACKET: {
                    this.next();
                    break block4;
                }
                case COMMARIGHT: {
                    this.next();
                    if (elision) {
                        elements.add(null);
                    }
                    elision = true;
                    continue block4;
                }
                default: {
                    Node expression;
                    if (!elision) {
                        this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    if ((expression = this.assignmentExpression(false)) != null) {
                        elements.add(expression);
                    } else {
                        this.expect(TokenType.RBRACKET);
                    }
                    elision = false;
                    continue block4;
                }
            }
            break;
        }
        return LiteralNode.newInstance(this.source, arrayToken, this.finish, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Node objectLiteral() {
        block19: {
            objectToken = this.token;
            this.next();
            objectContext = null;
            elements = new ArrayList<Node>();
            map = new HashMap<String, PropertyNode>();
            try {
                objectContext = this.newBlock();
                commaSeen = true;
                block7: while (true) {
                    switch (1.$SwitchMap$jdk$nashorn$internal$parser$TokenType[this.type.ordinal()]) {
                        case 4: {
                            this.next();
                            ** break;
lbl16:
                            // 1 sources

                            break block19;
                        }
                        case 52: {
                            this.next();
                            commaSeen = true;
                            continue block7;
                        }
                        default: {
                            if (!commaSeen) {
                                this.error(AbstractParser.message("expected.comma", new String[]{this.type.getNameOrType()}));
                            }
                            commaSeen = false;
                            property = this.propertyAssignment();
                            key = property.getKeyName();
                            existingProperty = (PropertyNode)map.get(key);
                            if (existingProperty != null) {
                                value = property.getValue();
                                getter = property.getGetter();
                                setter = property.getSetter();
                                prevValue = existingProperty.getValue();
                                prevGetter = existingProperty.getGetter();
                                prevSetter = existingProperty.getSetter();
                                redefinitionOk = true;
                                if (this.isStrictMode && value != null && prevValue != null) {
                                    redefinitionOk = false;
                                }
                                isPrevAccessor = prevGetter != null || prevSetter != null;
                                v0 = isAccessor = getter != null || setter != null;
                                if (prevValue != null && isAccessor) {
                                    redefinitionOk = false;
                                }
                                if (isPrevAccessor && value != null) {
                                    redefinitionOk = false;
                                }
                                if (isAccessor && isPrevAccessor && (getter != null && prevGetter != null || setter != null && prevSetter != null)) {
                                    redefinitionOk = false;
                                }
                                if (!redefinitionOk) {
                                    this.error(AbstractParser.message("property.redefinition", new String[]{key.toString()}), property.getToken());
                                }
                                if (value != null) {
                                    existingValue = existingProperty.getValue();
                                    if (existingValue == null) {
                                        existingProperty.setValue(value);
                                    } else {
                                        propertyToken = Token.recast(existingProperty.getToken(), TokenType.COMMARIGHT);
                                        existingProperty.setValue(new BinaryNode(this.source, propertyToken, existingValue, value));
                                    }
                                    existingProperty.setGetter(null);
                                    existingProperty.setSetter(null);
                                }
                                if (getter != null) {
                                    existingProperty.setGetter(getter);
                                }
                                if (setter == null) continue block7;
                                existingProperty.setSetter(setter);
                                continue block7;
                            }
                            map.put(key, property);
                            elements.add(property);
                            continue block7;
                        }
                    }
                    break;
                }
            }
            finally {
                this.restoreBlock();
            }
        }
        objectContext.setFinish(this.finish);
        objectContext.setStart(Token.descPosition(objectToken));
        return new ObjectNode(this.source, objectToken, this.finish, objectContext, elements);
    }

    private PropertyKey propertyName() {
        switch (this.type) {
            case IDENT: {
                return this.getIdent();
            }
            case OCTAL: {
                if (this.isStrictMode) {
                    this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case FLOATING: {
                return this.getLiteral();
            }
        }
        return this.getIdentifierName();
    }

    private PropertyNode propertyAssignment() {
        PropertyKey propertyName;
        long propertyToken = this.token;
        if (this.type == TokenType.IDENT) {
            String ident = (String)this.expectValue(TokenType.IDENT);
            if (this.type != TokenType.COLON) {
                long getSetToken = this.token;
                if ("get".equals(ident)) {
                    PropertyKey getIdent = this.propertyName();
                    String getterName = getIdent.getPropertyName();
                    IdentNode getNameNode = new IdentNode(this.source, ((Node)((Object)getIdent)).getToken(), this.finish, "get " + getterName);
                    this.expect(TokenType.LPAREN);
                    this.expect(TokenType.RPAREN);
                    ArrayList<IdentNode> parameters = new ArrayList<IdentNode>();
                    FunctionNode functionNode = this.functionBody(getSetToken, getNameNode, parameters, FunctionNode.Kind.GETTER);
                    PropertyNode propertyNode = new PropertyNode(this.source, propertyToken, this.finish, getIdent, null);
                    propertyNode.setGetter(new ReferenceNode(this.source, propertyToken, this.finish, functionNode));
                    return propertyNode;
                }
                if ("set".equals(ident)) {
                    PropertyKey setIdent = this.propertyName();
                    String setterName = setIdent.getPropertyName();
                    IdentNode setNameNode = new IdentNode(this.source, ((Node)((Object)setIdent)).getToken(), this.finish, "set " + setterName);
                    this.expect(TokenType.LPAREN);
                    IdentNode argIdent = this.getIdent();
                    this.verifyStrictIdent(argIdent, "setter argument");
                    this.expect(TokenType.RPAREN);
                    ArrayList<IdentNode> parameters = new ArrayList<IdentNode>();
                    parameters.add(argIdent);
                    FunctionNode functionNode = this.functionBody(getSetToken, setNameNode, parameters, FunctionNode.Kind.SETTER);
                    PropertyNode propertyNode = new PropertyNode(this.source, propertyToken, this.finish, setIdent, null);
                    propertyNode.setSetter(new ReferenceNode(this.source, propertyToken, this.finish, functionNode));
                    return propertyNode;
                }
            }
            propertyName = new IdentNode(this.source, propertyToken, this.finish, ident);
        } else {
            propertyName = this.propertyName();
        }
        this.expect(TokenType.COLON);
        Node value = this.assignmentExpression(false);
        PropertyNode propertyNode = new PropertyNode(this.source, propertyToken, this.finish, propertyName, value);
        return propertyNode;
    }

    private Node leftHandSideExpression() {
        List<Node> arguments;
        long callToken = this.token;
        Node lhs = this.memberExpression();
        if (this.type == TokenType.LPAREN) {
            arguments = this.argumentList();
            if (lhs instanceof IdentNode) {
                this.detectSpecialFunction((IdentNode)lhs);
            }
            lhs = new CallNode(this.source, callToken, this.finish, lhs, arguments);
            if (this.isInWithBlock()) {
                ((CallNode)lhs).setInWithBlock();
            }
            this.function.setHasCalls(true);
        }
        block5: while (true) {
            callToken = this.token;
            switch (this.type) {
                case LPAREN: {
                    arguments = this.argumentList();
                    lhs = new CallNode(this.source, callToken, this.finish, lhs, arguments);
                    if (this.isInWithBlock()) {
                        ((CallNode)lhs).setInWithBlock();
                    }
                    this.function.setHasCalls(true);
                    continue block5;
                }
                case LBRACKET: {
                    this.next();
                    Node rhs = this.expression();
                    this.expect(TokenType.RBRACKET);
                    lhs = new IndexNode(this.source, callToken, this.finish, lhs, rhs);
                    continue block5;
                }
                case PERIOD: {
                    this.next();
                    IdentNode property = this.getIdentifierName();
                    lhs = new AccessNode(this.source, callToken, this.finish, lhs, property);
                    continue block5;
                }
            }
            break;
        }
        return lhs;
    }

    private Node newExpression() {
        long newToken = this.token;
        this.next();
        Node constructor = this.memberExpression();
        if (constructor == null) {
            return null;
        }
        List<Node> arguments = this.type == TokenType.LPAREN ? this.argumentList() : new ArrayList<Node>();
        if (this.type == TokenType.LBRACE) {
            arguments.add(this.objectLiteral());
        }
        this.function.setHasCalls(true);
        CallNode callNode = new CallNode(this.source, constructor.getToken(), this.finish, constructor, arguments);
        if (this.isInWithBlock()) {
            callNode.setInWithBlock();
        }
        return new UnaryNode(this.source, newToken, callNode);
    }

    private Node memberExpression() {
        Node lhs;
        switch (this.type) {
            case NEW: {
                lhs = this.newExpression();
                break;
            }
            case FUNCTION: {
                lhs = this.functionExpression(false);
                break;
            }
            default: {
                lhs = this.primaryExpression();
            }
        }
        block8: while (true) {
            long callToken = this.token;
            switch (this.type) {
                case LBRACKET: {
                    this.next();
                    Node index = this.expression();
                    this.expect(TokenType.RBRACKET);
                    lhs = new IndexNode(this.source, callToken, this.finish, lhs, index);
                    continue block8;
                }
                case PERIOD: {
                    if (lhs == null) {
                        this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
                        return null;
                    }
                    this.next();
                    IdentNode property = this.getIdentifierName();
                    lhs = new AccessNode(this.source, callToken, this.finish, lhs, property);
                    continue block8;
                }
            }
            break;
        }
        return lhs;
    }

    private List<Node> argumentList() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        this.next();
        boolean first = true;
        while (this.type != TokenType.RPAREN) {
            if (!first) {
                this.expect(TokenType.COMMARIGHT);
            } else {
                first = false;
            }
            nodeList.add(this.assignmentExpression(false));
        }
        this.expect(TokenType.RPAREN);
        return nodeList;
    }

    private Node functionExpression(boolean isStatement) {
        LineNumberNode lineNumber = this.lineNumber();
        long functionToken = this.token;
        this.next();
        IdentNode name = null;
        if (this.type == TokenType.IDENT || this.isNonStrictModeIdent()) {
            name = this.getIdent();
            this.verifyStrictIdent(name, "function name");
        } else if (isStatement && !this.context._anon_functions) {
            this.expect(TokenType.IDENT);
        }
        boolean isAnonymous = false;
        if (name == null) {
            String tmpName = "_L" + this.source.getLine(Token.descPosition(this.token));
            name = new IdentNode(this.source, functionToken, Token.descPosition(functionToken), tmpName);
            isAnonymous = true;
        }
        this.expect(TokenType.LPAREN);
        List<IdentNode> parameters = this.formalParameterList();
        this.expect(TokenType.RPAREN);
        FunctionNode functionNode = this.functionBody(functionToken, name, parameters, FunctionNode.Kind.NORMAL);
        if (isStatement) {
            functionNode.setIsStatement();
        }
        if (isAnonymous) {
            functionNode.setIsAnonymous();
        }
        ReferenceNode referenceNode = new ReferenceNode(this.source, functionToken, this.finish, functionNode);
        int arity = parameters.size();
        boolean strict = functionNode.isStrictMode();
        if (arity > 1) {
            HashSet<String> parametersSet = new HashSet<String>(arity);
            for (int i = arity - 1; i >= 0; --i) {
                IdentNode parameter = parameters.get(i);
                String parameterName = parameter.getName();
                if (CompilerConstants.ARGUMENTS.tag().equals(parameterName)) {
                    functionNode.setHideArguments();
                }
                if (parametersSet.contains(parameterName)) {
                    if (strict) {
                        this.error(AbstractParser.message("strict.param.redefinition", parameterName), parameter.getToken());
                    } else {
                        parameterName = functionNode.uniqueName(parameterName);
                        long parameterToken = parameter.getToken();
                        parameters.set(i, new IdentNode(this.source, parameterToken, Token.descPosition(parameterToken), functionNode.uniqueName(parameterName)));
                    }
                }
                parametersSet.add(parameterName);
            }
        } else if (arity == 1 && CompilerConstants.ARGUMENTS.tag().equals(parameters.get(0).getName())) {
            functionNode.setHideArguments();
        }
        if (arity > 250) {
            functionNode.setIsVarArg();
        }
        if (isStatement) {
            functionNode.setFunctionVarNode(new VarNode(this.source, functionToken, this.finish, name, referenceNode), lineNumber);
        }
        return referenceNode;
    }

    private List<IdentNode> formalParameterList() {
        ArrayList<IdentNode> parameters = new ArrayList<IdentNode>();
        boolean first = true;
        while (this.type != TokenType.RPAREN) {
            if (!first) {
                this.expect(TokenType.COMMARIGHT);
            } else {
                first = false;
            }
            IdentNode ident = this.getIdent();
            this.verifyStrictIdent(ident, "function parameter");
            parameters.add(ident);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode functionBody(long firstToken, IdentNode ident, List<IdentNode> parameters, FunctionNode.Kind kind) {
        FunctionNode functionNode = null;
        try {
            functionNode = this.newFunctionBlock(ident);
            functionNode.setParameters(parameters);
            functionNode.setKind(kind);
            functionNode.setFirstToken(firstToken);
            if (this.type != TokenType.LBRACE) {
                Node expr = this.expression();
                ReturnNode returnNode = new ReturnNode(this.source, expr.getToken(), this.finish, expr, null);
                ExecuteNode executeNode = new ExecuteNode(this.source, returnNode.getToken(), this.finish, returnNode);
                functionNode.addStatement(executeNode);
                functionNode.setLastToken(this.token);
                functionNode.setFinish(Token.descPosition(this.token) + Token.descLength(this.token));
            } else {
                this.expect(TokenType.LBRACE);
                this.sourceElements();
                functionNode.setLastToken(this.token);
                this.expect(TokenType.RBRACE);
                functionNode.setFinish(this.finish);
            }
            this.block.addStatement(this.lineNumber());
        }
        finally {
            this.restoreBlock();
        }
        this.block.addFunction(functionNode);
        return functionNode;
    }

    private RuntimeNode referenceError(Node lhs, Node rhs) {
        ArrayList<Node> args = new ArrayList<Node>();
        args.add(lhs);
        if (rhs == null) {
            args.add(LiteralNode.newInstance(this.source, lhs.getToken(), lhs.getFinish()));
        } else {
            args.add(rhs);
        }
        args.add(LiteralNode.newInstance(this.source, lhs.getToken(), lhs.getFinish(), lhs.toString()));
        RuntimeNode runtimeNode = new RuntimeNode(this.source, lhs.getToken(), lhs.getFinish(), RuntimeNode.Request.REFERENCE_ERROR, args);
        return runtimeNode;
    }

    private Node unaryExpression() {
        long unaryToken = this.token;
        switch (this.type) {
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case ADD: 
            case SUB: 
            case BIT_NOT: 
            case NOT: {
                this.next();
                Node expr = this.unaryExpression();
                return new UnaryNode(this.source, unaryToken, expr);
            }
            case INCPREFIX: 
            case DECPREFIX: {
                TokenType opType = this.type;
                this.next();
                Node lhs = this.leftHandSideExpression();
                if (lhs == null) {
                    return null;
                }
                if (!(lhs instanceof AccessNode || lhs instanceof IndexNode || lhs instanceof IdentNode)) {
                    return this.referenceError(lhs, null);
                }
                if (lhs instanceof IdentNode) {
                    if (!Parser.checkIdentLValue((IdentNode)lhs)) {
                        return this.referenceError(lhs, null);
                    }
                    this.verifyStrictIdent((IdentNode)lhs, "operand for " + opType.getName() + " operator");
                }
                return this.incDecExpression(unaryToken, opType, lhs, false);
            }
        }
        Node expression = this.leftHandSideExpression();
        if (this.last != TokenType.EOL) {
            switch (this.type) {
                case INCPREFIX: 
                case DECPREFIX: {
                    TokenType opType = this.type;
                    Node lhs = expression;
                    if (!(lhs instanceof AccessNode || lhs instanceof IndexNode || lhs instanceof IdentNode)) {
                        this.next();
                        return this.referenceError(lhs, null);
                    }
                    if (lhs instanceof IdentNode) {
                        if (!Parser.checkIdentLValue((IdentNode)lhs)) {
                            this.next();
                            return this.referenceError(lhs, null);
                        }
                        this.verifyStrictIdent((IdentNode)lhs, "operand for " + opType.getName() + " operator");
                    }
                    expression = this.incDecExpression(this.token, this.type, expression, true);
                    this.next();
                    break;
                }
            }
        }
        if (expression == null) {
            this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
        }
        return expression;
    }

    private Node expression() {
        return this.expression(this.unaryExpression(), TokenType.COMMARIGHT.getPrecedence(), false);
    }

    private Node expression(Node exprLhs, int minPrecedence, boolean noIn) {
        int precedence = this.type.getPrecedence();
        Node lhs = exprLhs;
        while (this.type.isOperator(noIn) && precedence >= minPrecedence) {
            Node rhs;
            long op = this.token;
            if (this.type == TokenType.TERNARY) {
                this.next();
                rhs = this.expression(this.unaryExpression(), TokenType.ASSIGN.getPrecedence(), false);
                this.expect(TokenType.COLON);
                Node third = this.expression(this.unaryExpression(), TokenType.ASSIGN.getPrecedence(), noIn);
                lhs = new TernaryNode(this.source, op, lhs, rhs, third);
            } else {
                this.next();
                rhs = this.unaryExpression();
                int nextPrecedence = this.type.getPrecedence();
                while (this.type.isOperator(noIn) && (nextPrecedence > precedence || nextPrecedence == precedence && !this.type.isLeftAssociative())) {
                    rhs = this.expression(rhs, nextPrecedence, noIn);
                    nextPrecedence = this.type.getPrecedence();
                }
                lhs = this.verifyAssignment(op, lhs, rhs);
            }
            precedence = this.type.getPrecedence();
        }
        return lhs;
    }

    private Node assignmentExpression(boolean noIn) {
        return this.expression(this.unaryExpression(), TokenType.ASSIGN.getPrecedence(), noIn);
    }

    private void endOfLine() {
        switch (this.type) {
            case EOL: 
            case SEMICOLON: {
                this.next();
                break;
            }
            case EOF: 
            case RBRACE: 
            case RPAREN: 
            case RBRACKET: {
                break;
            }
            default: {
                if (this.last == TokenType.EOL) break;
                this.expect(TokenType.SEMICOLON);
            }
        }
    }

    private LineNumberNode lineNumber() {
        if (this.context._debug_lines) {
            return new LineNumberNode(this.source, this.token, this.line);
        }
        return null;
    }
}

