/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.PrototypeObject;
import jdk.nashorn.internal.runtime.GlobalFunctions;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Lookup;

public class ScriptFunctionImpl
extends ScriptFunction {
    private static final int IS_STRICT = 1;
    private static final int IS_BUILTIN = 2;
    private static final MethodHandle BOUND_FUNCTION = ScriptFunctionImpl.findOwnMH("boundFunction", Object.class, ScriptFunction.class, Object.class, Object[].class, Object.class, Object[].class);
    private static final MethodHandle BOUND_CONSTRUCTOR = ScriptFunctionImpl.findOwnMH("boundConstructor", Object.class, ScriptFunction.class, Object[].class, Object.class, Object[].class);
    private static final PropertyMap nasgenmap$;
    private int flags;
    private static ScriptFunction typeErrorThrower;
    private static PropertyMap strictmodemap$;

    private void setIsBuiltin() {
        this.flags |= 2;
    }

    private void setIsStrict() {
        this.flags |= 1;
    }

    ScriptFunctionImpl(String name, MethodHandle invokeHandle, MethodHandle[] specs) {
        this(name, invokeHandle, nasgenmap$, specs);
    }

    ScriptFunctionImpl(String name, MethodHandle methodHandle, PropertyMap map, MethodHandle[] specs) {
        super(name, methodHandle, nasgenmap$ == map ? nasgenmap$ : map.addAll(nasgenmap$), null, null, 0L, false, specs);
        this.setIsBuiltin();
        this.init();
    }

    ScriptFunctionImpl(String name, MethodHandle methodHandle, ScriptObject scope, boolean strict, MethodHandle[] specs) {
        super(name, methodHandle, ScriptFunctionImpl.getMap(strict), scope, specs);
        if (strict) {
            this.setIsStrict();
        }
        this.init();
    }

    public ScriptFunctionImpl(String name, MethodHandle methodHandle, ScriptObject scope, Source source, long token, MethodHandle allocator, PropertyMap allocatorMap, boolean needCallee, boolean strict) {
        super(name, methodHandle, ScriptFunctionImpl.getMap(strict), scope, source, token, allocator, allocatorMap, needCallee, null);
        if (strict) {
            this.setIsStrict();
        }
        this.init();
    }

    static synchronized ScriptFunction getTypeErrorThrower() {
        if (typeErrorThrower == null) {
            ScriptFunctionImpl func = new ScriptFunctionImpl("TypeErrorThrower", Lookup.TYPE_ERROR_THROWER_SETTER, null, false, null);
            func.constructHandle = null;
            func.prototype = ScriptRuntime.UNDEFINED;
            typeErrorThrower = func;
        }
        return typeErrorThrower;
    }

    static synchronized PropertyMap newThrowerProperty(PropertyMap map, String name, int flags) {
        return map.newProperty(name, flags, Lookup.TYPE_ERROR_THROWER_GETTER, Lookup.TYPE_ERROR_THROWER_SETTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyMap getMap(boolean strict) {
        if (strict) {
            Class<ScriptFunctionImpl> clazz = ScriptFunctionImpl.class;
            synchronized (ScriptFunctionImpl.class) {
                if (strictmodemap$ == null) {
                    strictmodemap$ = nasgenmap$;
                    strictmodemap$ = ScriptFunctionImpl.newThrowerProperty(strictmodemap$, "arguments", 6);
                    strictmodemap$ = ScriptFunctionImpl.newThrowerProperty(strictmodemap$, "caller", 6);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return strictmodemap$;
            }
        }
        return nasgenmap$;
    }

    static ScriptFunctionImpl newAnonymousFunction() {
        return new AnonymousFunction();
    }

    @Override
    public final boolean isStrict() {
        return (this.flags & 1) != 0;
    }

    @Override
    public final boolean isBuiltin() {
        return (this.flags & 2) != 0;
    }

    public static ScriptFunction makeFunction(String name, MethodHandle methodHandle, MethodHandle[] specs, boolean strict) {
        ScriptFunctionImpl func = new ScriptFunctionImpl(name, methodHandle, null, strict, specs);
        func.setIsBuiltin();
        func.setConstructHandle(null);
        func.setPrototype(ScriptRuntime.UNDEFINED);
        return func;
    }

    public static ScriptFunction makeFunction(String name, MethodHandle methodHandle, MethodHandle[] specs) {
        return ScriptFunctionImpl.makeFunction(name, methodHandle, specs, false);
    }

    public static ScriptFunction makeFunction(String name, MethodHandle methodHandle) {
        return ScriptFunctionImpl.makeFunction(name, methodHandle, null);
    }

    @Override
    public ScriptFunction makeBoundFunction(Object thiz, Object[] args) {
        Object[] allArgs = args;
        if (allArgs == null) {
            allArgs = ScriptRuntime.EMPTY_ARRAY;
        }
        MethodHandle boundMethod = Lookup.MH.insertArguments(BOUND_FUNCTION, 0, this, thiz, allArgs);
        ScriptFunction boundFunc = ScriptFunctionImpl.makeFunction("", boundMethod, null, true);
        MethodHandle consHandle = this.getConstructHandle();
        if (consHandle != null) {
            consHandle = Lookup.MH.insertArguments(BOUND_CONSTRUCTOR, 0, this, allArgs);
        }
        boundFunc.setConstructHandle(consHandle);
        int newArity = this.getArity();
        if (newArity != -1) {
            newArity -= Math.min(newArity, allArgs.length);
        }
        boundFunc.setArity(newArity);
        return boundFunc;
    }

    private static Object boundFunction(ScriptFunction wrapped, Object boundThiz, Object[] boundArgs, Object thiz, Object[] args) {
        Object[] allArgs = new Object[boundArgs.length + args.length];
        System.arraycopy(boundArgs, 0, allArgs, 0, boundArgs.length);
        System.arraycopy(args, 0, allArgs, boundArgs.length, args.length);
        return ScriptRuntime.apply(wrapped, boundThiz, allArgs);
    }

    private static Object boundConstructor(ScriptFunction wrapped, Object[] boundArgs, Object thiz, Object[] args) {
        Object[] allArgs = new Object[boundArgs.length + args.length];
        System.arraycopy(boundArgs, 0, allArgs, 0, boundArgs.length);
        System.arraycopy(args, 0, allArgs, boundArgs.length, args.length);
        return ScriptRuntime.construct(wrapped, allArgs);
    }

    @Override
    protected final ScriptObject getObjectPrototype() {
        return Global.objectPrototype();
    }

    private void init() {
        this.setProto(Global.instance().getFunctionPrototype());
        this.setPrototype(new PrototypeObject(this));
        if (this.isStrict()) {
            ScriptFunction func = ScriptFunctionImpl.getTypeErrorThrower();
            this.setUserAccessors("arguments", func, func);
            this.setUserAccessors("caller", func, func);
        }
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), ScriptFunctionImpl.class, name, Lookup.MH.type(rtype, types));
    }

    static {
        PropertyMap map = PropertyMap.newMap(ScriptFunctionImpl.class);
        map = Lookup.newProperty(map, "prototype", 6, G$PROTOTYPE, S$PROTOTYPE);
        map = Lookup.newProperty(map, "length", 7, G$LENGTH, null);
        nasgenmap$ = map = Lookup.newProperty(map, "name", 7, G$NAME, null);
    }

    private static class AnonymousFunction
    extends ScriptFunctionImpl {
        private static final PropertyMap nasgenmap$$ = PropertyMap.newMap(AnonymousFunction.class);

        AnonymousFunction() {
            super("", GlobalFunctions.ANONYMOUS, nasgenmap$$, null);
        }
    }
}

