/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.NativeRegExp;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.SpecializedConstructor;
import jdk.nashorn.internal.objects.annotations.SpecializedFunction;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuards;
import jdk.nashorn.internal.runtime.linker.PrimitiveLookup;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;

@ScriptClass(value="String")
public final class NativeString
extends ScriptObject {
    private final CharSequence value;
    private static final MethodHandle WRAPFILTER = NativeString.findWrapFilter();

    NativeString(CharSequence value) {
        this(value, Global.instance().getStringPrototype());
    }

    private NativeString(CharSequence value, ScriptObject proto) {
        assert (value instanceof String || value instanceof ConsString);
        this.value = value;
        this.setProto(proto);
    }

    @Override
    public String safeToString() {
        return "[String " + this.toString() + "]";
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof NativeString) {
            return this.getStringValue().equals(((NativeString)other).getStringValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    private String getStringValue() {
        return this.value instanceof String ? (String)this.value : ((Object)this.value).toString();
    }

    private CharSequence getValue() {
        return this.value;
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @Override
    public Object getLength() {
        return this.value.length();
    }

    @Override
    public Object get(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index >= 0 && index < this.value.length()) {
            return String.valueOf(this.value.charAt(index));
        }
        return super.get(key);
    }

    @Override
    public Object get(double key) {
        if (JSType.isRepresentableAsInt(key)) {
            return this.get((int)key);
        }
        return super.get(key);
    }

    @Override
    public Object get(long key) {
        if (key >= 0L && key < (long)this.value.length()) {
            return String.valueOf(this.value.charAt((int)key));
        }
        return super.get(key);
    }

    @Override
    public Object get(int key) {
        if (key >= 0 && key < this.value.length()) {
            return String.valueOf(this.value.charAt(key));
        }
        return super.get(key);
    }

    @Override
    public int getInt(Object key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public int getInt(double key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public int getInt(long key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public int getInt(int key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public long getLong(Object key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public long getLong(double key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public long getLong(long key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public long getLong(int key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public double getDouble(Object key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public double getDouble(double key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public double getDouble(long key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public double getDouble(int key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public boolean has(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.has(key);
    }

    @Override
    public boolean has(int key) {
        return this.isValid(key) || super.has(key);
    }

    @Override
    public boolean has(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.has(key);
    }

    @Override
    public boolean has(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.has(key);
    }

    @Override
    public boolean hasOwnProperty(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(int key) {
        return this.isValid(key) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean delete(int key, boolean strict) {
        return this.checkDeleteIndex(key, strict) ? false : super.delete(key, strict);
    }

    @Override
    public boolean delete(long key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.checkDeleteIndex(index, strict) ? false : super.delete(key, strict);
    }

    @Override
    public boolean delete(double key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.checkDeleteIndex(index, strict) ? false : super.delete(key, strict);
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.checkDeleteIndex(index, strict) ? false : super.delete(key, strict);
    }

    private boolean checkDeleteIndex(int index, boolean strict) {
        if (this.isValid(index)) {
            if (strict) {
                ECMAErrors.typeError((ScriptObject)Global.instance(), "cant.delete.property", Integer.toString(index), ScriptRuntime.safeToString(this));
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getOwnPropertyDescriptor(String key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index >= 0 && index < this.value.length()) {
            Global global = Global.instance();
            return global.newDataDescriptor(String.valueOf(this.value.charAt(index)), false, true, false);
        }
        return super.getOwnPropertyDescriptor(key);
    }

    @Override
    public String[] getOwnKeys(boolean all) {
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < this.value.length(); ++i) {
            keys.add(JSType.toString(i));
        }
        keys.addAll(Arrays.asList(super.getOwnKeys(all)));
        return keys.toArray(new String[keys.size()]);
    }

    @Getter(attributes=7)
    public static Object length(Object self) {
        return NativeString.getCharSequence(self).length();
    }

    @Function(attributes=2, arity=1, where=Where.CONSTRUCTOR)
    public static Object fromCharCode(Object self, Object ... args) {
        char[] buf = new char[args.length];
        int index = 0;
        for (Object arg : args) {
            buf[index++] = (char)JSType.toUint16(arg);
        }
        return new String(buf);
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, Object value) {
        try {
            return "" + (char)JSType.toUint16(((Number)value).doubleValue());
        }
        catch (ClassCastException e) {
            return NativeString.fromCharCode(self, new Object[]{value});
        }
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, int value) {
        return "" + (char)(value & 0xFFFF);
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, long value) {
        return "" + (char)((int)value & 0xFFFF);
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, double value) {
        return "" + (char)JSType.toUint16(value);
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        return NativeString.getString(self);
    }

    @Function(attributes=2)
    public static Object valueOf(Object self) {
        return NativeString.getString(self);
    }

    @Function(attributes=2)
    public static Object charAt(Object self, Object pos) {
        try {
            return String.valueOf(((String)self).charAt(((Number)pos).intValue()));
        }
        catch (ClassCastException e) {
            Global.checkObjectCoercible(self);
            String str = JSType.toString(self);
            int at = JSType.toInteger(pos);
            if (at < 0 || at >= str.length()) {
                return "";
            }
            return String.valueOf(str.charAt(at));
        }
        catch (IndexOutOfBoundsException e) {
            Global.checkObjectCoercible(self);
            String str = JSType.toString(self);
            int at = JSType.toInteger(pos);
            if (at < 0 || at >= str.length()) {
                return "";
            }
            return String.valueOf(str.charAt(at));
        }
        catch (NullPointerException e) {
            Global.checkObjectCoercible(self);
            String str = JSType.toString(self);
            int at = JSType.toInteger(pos);
            if (at < 0 || at >= str.length()) {
                return "";
            }
            return String.valueOf(str.charAt(at));
        }
    }

    @Function(attributes=2)
    public static Object charCodeAt(Object self, Object pos) {
        try {
            return (int)((String)self).charAt(((Number)pos).intValue());
        }
        catch (ClassCastException e) {
            Global.checkObjectCoercible(self);
            String str = JSType.toString(self);
            int at = JSType.toInteger(pos);
            if (at < 0 || at >= str.length()) {
                return Double.NaN;
            }
            return JSType.toObject(str.charAt(at));
        }
        catch (IndexOutOfBoundsException e) {
            Global.checkObjectCoercible(self);
            String str = JSType.toString(self);
            int at = JSType.toInteger(pos);
            if (at < 0 || at >= str.length()) {
                return Double.NaN;
            }
            return JSType.toObject(str.charAt(at));
        }
        catch (NullPointerException e) {
            Global.checkObjectCoercible(self);
            String str = JSType.toString(self);
            int at = JSType.toInteger(pos);
            if (at < 0 || at >= str.length()) {
                return Double.NaN;
            }
            return JSType.toObject(str.charAt(at));
        }
    }

    @Function(attributes=2, arity=1)
    public static Object concat(Object self, Object ... args) {
        Global.checkObjectCoercible(self);
        StringBuilder sb = new StringBuilder(JSType.toString(self));
        if (args != null) {
            for (Object obj : args) {
                sb.append(JSType.toString(obj));
            }
        }
        return sb.toString();
    }

    @Function(attributes=2, arity=1)
    public static Object indexOf(Object self, Object search, Object pos) {
        try {
            return ((String)self).indexOf((String)search, ((Number)pos).intValue());
        }
        catch (ClassCastException e) {
            Global.checkObjectCoercible(self);
            return JSType.toString(self).indexOf(JSType.toString(search), JSType.toInteger(pos));
        }
        catch (IndexOutOfBoundsException e) {
            Global.checkObjectCoercible(self);
            return JSType.toString(self).indexOf(JSType.toString(search), JSType.toInteger(pos));
        }
        catch (NullPointerException e) {
            Global.checkObjectCoercible(self);
            return JSType.toString(self).indexOf(JSType.toString(search), JSType.toInteger(pos));
        }
    }

    @Function(attributes=2, arity=1)
    public static Object lastIndexOf(Object self, Object search, Object pos) {
        double numPos;
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        String searchStr = JSType.toString(search);
        int from = pos == ScriptRuntime.UNDEFINED ? str.length() : (!Double.isNaN(numPos = JSType.toNumber(pos)) ? (int)numPos : Integer.MAX_VALUE);
        return str.lastIndexOf(searchStr, from);
    }

    @Function(attributes=2)
    public static Object localeCompare(Object self, Object that) {
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        Collator collator = Collator.getInstance(Global.getThisContext().getLocale());
        collator.setStrength(3);
        collator.setDecomposition(1);
        return (double)collator.compare(str, JSType.toString(that));
    }

    @Function(attributes=2)
    public static Object match(Object self, Object regexp) {
        Object result;
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        NativeRegExp nativeRegExp = regexp == ScriptRuntime.UNDEFINED ? new NativeRegExp("") : Global.toRegExp(regexp);
        if (!nativeRegExp.getGlobal()) {
            return nativeRegExp.exec(str);
        }
        nativeRegExp.setLastIndex(0);
        int previousLastIndex = 0;
        ArrayList<Object> matches = new ArrayList<Object>();
        while ((result = nativeRegExp.exec(str)) != null) {
            int thisIndex = nativeRegExp.getLastIndex();
            if (thisIndex == previousLastIndex) {
                nativeRegExp.setLastIndex(thisIndex + 1);
                previousLastIndex = thisIndex + 1;
            } else {
                previousLastIndex = thisIndex;
            }
            matches.add(((ScriptObject)result).get(0));
        }
        if (matches.isEmpty()) {
            return null;
        }
        return new NativeArray(matches.toArray());
    }

    @Function(attributes=2)
    public static Object replace(Object self, Object string, Object replacement) {
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        NativeRegExp nativeRegExp = string instanceof NativeRegExp ? (NativeRegExp)string : new NativeRegExp(Pattern.compile(JSType.toString(string), 16));
        if (replacement instanceof ScriptFunction) {
            return nativeRegExp.replace(str, "", (ScriptFunction)replacement);
        }
        return nativeRegExp.replace(str, JSType.toString(replacement), null);
    }

    @Function(attributes=2)
    public static Object search(Object self, Object string) {
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        NativeRegExp nativeRegExp = Global.toRegExp(string == ScriptRuntime.UNDEFINED ? "" : string);
        return nativeRegExp.search(str);
    }

    @Function(attributes=2)
    public static Object slice(Object self, Object start, Object end) {
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        int len = str.length();
        int intStart = JSType.toInteger(start);
        int intEnd = end == ScriptRuntime.UNDEFINED ? len : JSType.toInteger(end);
        int from = intStart < 0 ? Math.max(len + intStart, 0) : Math.min(intStart, len);
        int to = intEnd < 0 ? Math.max(len + intEnd, 0) : Math.min(intEnd, len);
        return str.substring(Math.min(from, to), to);
    }

    @Function(attributes=2)
    public static Object split(Object self, Object separator, Object limit) {
        long lim;
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        if (separator == ScriptRuntime.UNDEFINED) {
            return new NativeArray(new Object[]{str});
        }
        long l = lim = limit == ScriptRuntime.UNDEFINED ? 0xFFFFFFFFL : JSType.toUint32(limit);
        if (separator instanceof NativeRegExp) {
            return ((NativeRegExp)separator).split(str, lim);
        }
        return new NativeRegExp(Pattern.compile(JSType.toString(separator), 16)).split(str, lim);
    }

    @Function(attributes=2)
    public static Object substr(Object self, Object start, Object length) {
        String str = JSType.toString(self);
        int strLength = str.length();
        int intStart = JSType.toInteger(start);
        if (intStart < 0) {
            intStart = Math.max(intStart + strLength, 0);
        }
        int intLen = Math.min(Math.max(length == ScriptRuntime.UNDEFINED ? Integer.MAX_VALUE : JSType.toInteger(length), 0), strLength - intStart);
        return intLen <= 0 ? "" : str.substring(intStart, intStart + intLen);
    }

    @Function(attributes=2)
    public static Object substring(Object self, Object start, Object end) {
        int to;
        int from;
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        int len = str.length();
        int intStart = JSType.toInteger(start);
        int intEnd = end == ScriptRuntime.UNDEFINED ? len : JSType.toInteger(end);
        int finalStart = Math.min(intStart < 0 ? 0 : intStart, len);
        int finalEnd = Math.min(intEnd < 0 ? 0 : intEnd, len);
        if (finalStart < finalEnd) {
            from = finalStart;
            to = finalEnd;
        } else {
            from = finalEnd;
            to = finalStart;
        }
        return str.substring(from, to);
    }

    @Function(attributes=2)
    public static Object toLowerCase(Object self) {
        Global.checkObjectCoercible(self);
        return JSType.toString(self).toLowerCase();
    }

    @Function(attributes=2)
    public static Object toLocaleLowerCase(Object self) {
        Global.checkObjectCoercible(self);
        return JSType.toString(self).toLowerCase(Global.getThisContext().getLocale());
    }

    @Function(attributes=2)
    public static Object toUpperCase(Object self) {
        Global.checkObjectCoercible(self);
        return JSType.toString(self).toUpperCase();
    }

    @Function(attributes=2)
    public static Object toLocaleUpperCase(Object self) {
        Global.checkObjectCoercible(self);
        return JSType.toString(self).toUpperCase(Global.getThisContext().getLocale());
    }

    @Function(attributes=2)
    public static Object trim(Object self) {
        int start;
        Global.checkObjectCoercible(self);
        String str = JSType.toString(self);
        int end = str.length() - 1;
        for (start = 0; start <= end && Lexer.isJSWhitespace(str.charAt(start)); ++start) {
        }
        while (end > start && Lexer.isJSWhitespace(str.charAt(end))) {
            --end;
        }
        return str.substring(start, end + 1);
    }

    private static Object newObj(Object self, CharSequence str) {
        if (self instanceof ScriptObject) {
            return new NativeString(str, ((ScriptObject)self).getProto());
        }
        return new NativeString(str, Global.instance().getStringPrototype());
    }

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        String str = args.length > 0 ? JSType.toCharSequence(args[0]) : "";
        return newObj ? NativeString.newObj(self, str) : str.toString();
    }

    @SpecializedConstructor
    public static Object constructor(boolean newObj, Object self) {
        return newObj ? NativeString.newObj(self, "") : "";
    }

    @SpecializedConstructor
    public static Object constructor(boolean newObj, Object self, int arg) {
        CharSequence str = JSType.toCharSequence(arg);
        return newObj ? NativeString.newObj(self, str) : str;
    }

    public static GuardedInvocation lookupPrimitive(NashornCallSiteDescriptor desc, Object receiver) {
        MethodHandle guard = NashornGuards.getInstanceOf2Guard(String.class, ConsString.class);
        return PrimitiveLookup.lookupPrimitive((CallSiteDescriptor)desc, guard, (ScriptObject)new NativeString((CharSequence)receiver), WRAPFILTER);
    }

    private static NativeString wrapFilter(Object receiver) {
        return new NativeString((CharSequence)receiver);
    }

    private static CharSequence getCharSequence(Object self) {
        if (self instanceof String || self instanceof ConsString) {
            return (CharSequence)self;
        }
        if (self instanceof NativeString) {
            return ((NativeString)self).getValue();
        }
        if (self != null && self == Global.instance().getStringPrototype()) {
            return "";
        }
        ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.string", ScriptRuntime.safeToString(self));
        return null;
    }

    private static String getString(Object self) {
        if (self instanceof String) {
            return (String)self;
        }
        if (self instanceof ConsString) {
            return self.toString();
        }
        if (self instanceof NativeString) {
            return ((NativeString)self).getStringValue();
        }
        if (self != null && self == Global.instance().getStringPrototype()) {
            return "";
        }
        ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.string", ScriptRuntime.safeToString(self));
        return null;
    }

    private boolean isValid(int key) {
        return key >= 0 && key < this.value.length();
    }

    private static MethodHandle findWrapFilter() {
        try {
            return MethodHandles.lookup().findStatic(NativeString.class, "wrapFilter", Lookup.MH.type(NativeString.class, Object.class));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

