/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.NativeBoolean;
import jdk.nashorn.internal.objects.NativeNumber;
import jdk.nashorn.internal.objects.NativeString;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.parser.JSONParser;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.arrays.ArrayLikeIterator;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.InvokeByName;

@ScriptClass(value="JSON")
public final class NativeJSON
extends ScriptObject {
    private static final InvokeByName TO_JSON = new InvokeByName("toJSON", ScriptObject.class, Object.class, Object.class);
    private static final MethodHandle REPLACER_INVOKER = Bootstrap.createDynamicInvoker("dyn:call", Object.class, ScriptFunction.class, ScriptObject.class, Object.class, Object.class);
    private static final MethodHandle REVIVER_INVOKER = Bootstrap.createDynamicInvoker("dyn:call", Object.class, ScriptFunction.class, ScriptObject.class, String.class, Object.class);

    NativeJSON() {
        this.setProto(Global.objectPrototype());
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object parse(Object self, Object text, Object reviver) {
        Node node;
        String str = JSType.toString(text);
        Context context = Global.getThisContext();
        JSONParser parser = new JSONParser(new Source("<json>", str), new Context.ThrowErrorManager(), context != null ? context._strict : false);
        try {
            node = parser.parse();
        }
        catch (ParserException e) {
            ECMAErrors.syntaxError((ScriptObject)Global.instance(), e, "invalid.json", e.getMessage());
            return ScriptRuntime.UNDEFINED;
        }
        Object unfiltered = NativeJSON.convertNode(node);
        return NativeJSON.applyReviver(unfiltered, reviver);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object stringify(Object self, Object value, Object replacer, Object space) {
        String gap;
        StringifyState state = new StringifyState();
        if (replacer instanceof ScriptFunction) {
            state.replacerFunction = (ScriptFunction)replacer;
        } else if (NativeJSON.isArray(replacer) || replacer instanceof Iterable || replacer != null && replacer.getClass().isArray()) {
            state.propertyList = new ArrayList<String>();
            ArrayLikeIterator<Object> iter = ArrayLikeIterator.arrayLikeIterator(replacer);
            while (iter.hasNext()) {
                String item = null;
                Object v = iter.next();
                if (v instanceof String) {
                    item = (String)v;
                } else if (v instanceof ConsString) {
                    item = v.toString();
                } else if (v instanceof Number || v instanceof NativeNumber || v instanceof NativeString) {
                    item = JSType.toString(v);
                }
                if (item == null) continue;
                state.propertyList.add(item);
            }
        }
        if (space instanceof Number || space instanceof NativeNumber) {
            int indent = space instanceof NativeNumber ? ((NativeNumber)space).intValue() : ((Number)space).intValue();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(10, indent); ++i) {
                sb.append(' ');
            }
            gap = sb.toString();
        } else if (space instanceof String || space instanceof ConsString || space instanceof NativeString) {
            String str = space instanceof String ? (String)space : space.toString();
            gap = str.substring(0, Math.min(10, str.length()));
        } else {
            gap = "";
        }
        state.gap = gap;
        ScriptObject wrapper = Global.newEmptyInstance();
        wrapper.set((Object)"", value, Global.isStrict());
        return NativeJSON.str("", wrapper, state);
    }

    private static Object applyReviver(Object unfiltered, Object reviver) {
        if (reviver instanceof ScriptFunction) {
            ScriptObject root = Global.newEmptyInstance();
            root.set((Object)"", unfiltered, Global.isStrict());
            return NativeJSON.walk(root, "", (ScriptFunction)reviver);
        }
        return unfiltered;
    }

    private static Object walk(ScriptObject holder, Object name, ScriptFunction reviver) {
        Object val = holder.get(name);
        if (val == ScriptRuntime.UNDEFINED) {
            return val;
        }
        if (val instanceof ScriptObject) {
            ScriptObject valueObj = (ScriptObject)val;
            boolean strict = Global.isStrict();
            Iterator<String> iter = valueObj.propertyIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                Object newElement = NativeJSON.walk(valueObj, key, reviver);
                if (newElement == ScriptRuntime.UNDEFINED) {
                    valueObj.delete(key, strict);
                    continue;
                }
                valueObj.set((Object)key, newElement, strict);
            }
            return valueObj;
        }
        if (NativeJSON.isArray(val)) {
            NativeArray valueArray = (NativeArray)val;
            boolean strict = Global.isStrict();
            Iterator<String> iter = valueArray.propertyIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                Object newElement = NativeJSON.walk(valueArray, valueArray.get(key), reviver);
                if (newElement == ScriptRuntime.UNDEFINED) {
                    valueArray.delete(key, strict);
                    continue;
                }
                valueArray.set((Object)key, newElement, strict);
            }
            return valueArray;
        }
        try {
            return REVIVER_INVOKER.invokeExact(reviver, holder, JSType.toString(name), val);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Error t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static Object convertNode(Node node) {
        if (node instanceof LiteralNode) {
            if (node.tokenType() == TokenType.LBRACKET) {
                assert (node instanceof LiteralNode.ArrayLiteralNode);
                Node[] elements = (Node[])((LiteralNode.ArrayLiteralNode)node).getValue();
                if (NativeJSON.isNumericArray(elements)) {
                    double[] values = new double[elements.length];
                    int index = 0;
                    for (Node elem : elements) {
                        values[index++] = JSType.toNumber(NativeJSON.convertNode(elem));
                    }
                    return Global.allocate(values);
                }
                Object[] values = new Object[elements.length];
                int index = 0;
                for (Node elem : elements) {
                    values[index++] = NativeJSON.convertNode(elem);
                }
                return Global.allocate(values);
            }
            return ((LiteralNode)node).getValue();
        }
        if (node instanceof ObjectNode) {
            ObjectNode objNode = (ObjectNode)node;
            ScriptObject object = Global.newEmptyInstance();
            boolean strict = Global.isStrict();
            List<Node> elements = objNode.getElements();
            for (Node elem : elements) {
                PropertyNode pNode = (PropertyNode)elem;
                Node valueNode = pNode.getValue();
                object.set((Object)pNode.getKeyName(), NativeJSON.convertNode(valueNode), strict);
            }
            return object;
        }
        if (node instanceof UnaryNode) {
            UnaryNode unaryNode = (UnaryNode)node;
            return -((LiteralNode)unaryNode.rhs()).getNumber();
        }
        return null;
    }

    private static boolean isNumericArray(Node[] values) {
        for (Node node : values) {
            if (node instanceof LiteralNode && ((LiteralNode)node).getValue() instanceof Number) continue;
            return false;
        }
        return true;
    }

    private static Object str(Object key, ScriptObject holder, StringifyState state) {
        Object value = holder.get(key);
        try {
            if (value instanceof ScriptObject) {
                ScriptObject svalue = (ScriptObject)value;
                Object toJSON = TO_JSON.getGetter().invokeExact(svalue);
                if (toJSON instanceof ScriptFunction) {
                    value = TO_JSON.getInvoker().invokeExact(toJSON, svalue, key);
                }
            }
            if (state.replacerFunction != null) {
                value = REPLACER_INVOKER.invokeExact(state.replacerFunction, holder, key, value);
            }
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Error t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        boolean isObj = value instanceof ScriptObject;
        if (isObj) {
            if (value instanceof NativeNumber) {
                value = JSType.toNumber(value);
            } else if (value instanceof NativeString) {
                value = JSType.toString(value);
            } else if (value instanceof NativeBoolean) {
                value = ((NativeBoolean)value).booleanValue();
            }
        }
        if (value == null) {
            return "null";
        }
        if (Boolean.TRUE.equals(value)) {
            return "true";
        }
        if (Boolean.FALSE.equals(value)) {
            return "false";
        }
        if (value instanceof String) {
            return JSONParser.quote((String)value);
        }
        if (value instanceof ConsString) {
            return JSONParser.quote(value.toString());
        }
        if (value instanceof Number) {
            return JSType.isFinite(((Number)value).doubleValue()) ? JSType.toString(value) : "null";
        }
        JSType type = JSType.of(value);
        if (type == JSType.OBJECT) {
            if (NativeJSON.isArray(value)) {
                return NativeJSON.JA((NativeArray)value, state);
            }
            if (value instanceof ScriptObject) {
                return NativeJSON.JO((ScriptObject)value, state);
            }
        }
        return ScriptRuntime.UNDEFINED;
    }

    private static String JO(ScriptObject value, StringifyState state) {
        if (state.stack.containsKey(value)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "JSON.stringify.cyclic", new String[0]);
        }
        state.stack.put(value, value);
        StringBuilder stepback = new StringBuilder(state.indent.toString());
        state.indent.append(state.gap);
        StringBuilder finalStr = new StringBuilder();
        ArrayList<StringBuilder> partial = new ArrayList<StringBuilder>();
        List<String> k = state.propertyList == null ? Arrays.asList(value.getOwnKeys(false)) : state.propertyList;
        for (String p : k) {
            Object strP = NativeJSON.str(p, value, state);
            if (strP == ScriptRuntime.UNDEFINED) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(JSONParser.quote(p.toString())).append(':');
            if (!state.gap.isEmpty()) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(strP);
            partial.add(stringBuilder);
        }
        if (partial.isEmpty()) {
            finalStr.append("{}");
        } else if (state.gap.isEmpty()) {
            int size = partial.size();
            int index = 0;
            finalStr.append('{');
            for (Object e : partial) {
                finalStr.append(e);
                if (index < size - 1) {
                    finalStr.append(',');
                }
                ++index;
            }
            finalStr.append('}');
        } else {
            int size = partial.size();
            int index = 0;
            finalStr.append("{\n");
            finalStr.append((CharSequence)state.indent);
            for (Object e : partial) {
                finalStr.append(e);
                if (index < size - 1) {
                    finalStr.append(",\n");
                    finalStr.append((CharSequence)state.indent);
                }
                ++index;
            }
            finalStr.append('\n');
            finalStr.append((CharSequence)stepback);
            finalStr.append('}');
        }
        state.stack.remove(value);
        state.indent = stepback;
        return finalStr.toString();
    }

    private static Object JA(NativeArray value, StringifyState state) {
        int index;
        if (state.stack.containsKey(value)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "JSON.stringify.cyclic", new String[0]);
        }
        state.stack.put(value, value);
        StringBuilder stepback = new StringBuilder(state.indent.toString());
        state.indent.append(state.gap);
        ArrayList<Object> partial = new ArrayList<Object>();
        int length = JSType.toInteger(value.getLength());
        for (index = 0; index < length; ++index) {
            Object strP = NativeJSON.str(index, value, state);
            if (strP == ScriptRuntime.UNDEFINED) {
                strP = "null";
            }
            partial.add(strP);
        }
        StringBuilder finalStr = new StringBuilder();
        if (partial.isEmpty()) {
            finalStr.append("[]");
        } else if (state.gap.isEmpty()) {
            int size = partial.size();
            index = 0;
            finalStr.append('[');
            for (Object e : partial) {
                finalStr.append(e);
                if (index < size - 1) {
                    finalStr.append(',');
                }
                ++index;
            }
            finalStr.append(']');
        } else {
            int size = partial.size();
            index = 0;
            finalStr.append("[\n");
            finalStr.append((CharSequence)state.indent);
            for (Object e : partial) {
                finalStr.append(e);
                if (index < size - 1) {
                    finalStr.append(",\n");
                    finalStr.append((CharSequence)state.indent);
                }
                ++index;
            }
            finalStr.append('\n');
            finalStr.append((CharSequence)stepback);
            finalStr.append(']');
        }
        state.stack.remove(value);
        state.indent = stepback;
        return finalStr.toString();
    }

    private static class StringifyState {
        final Map<ScriptObject, ScriptObject> stack = new IdentityHashMap<ScriptObject, ScriptObject>();
        StringBuilder indent = new StringBuilder();
        String gap = "";
        List<String> propertyList = null;
        ScriptFunction replacerFunction = null;

        private StringifyState() {
        }
    }
}

