/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.List;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

@ScriptClass(value="Function")
public final class NativeFunction {
    private NativeFunction() {
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        if (!(self instanceof ScriptFunction)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
        return ((ScriptFunction)self).toSource();
    }

    private static Object convertThis(ScriptFunction func, Object thiz) {
        if (!(thiz instanceof ScriptObject || func.isStrict() || func.isBuiltin())) {
            if (thiz == ScriptRuntime.UNDEFINED || thiz == null) {
                return Global.instance();
            }
            return JSType.toObject(Global.instance(), thiz);
        }
        return thiz;
    }

    @Function(attributes=2)
    public static Object apply(Object self, Object thiz, Object array) {
        if (!(self instanceof ScriptFunction)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
        Object[] args = null;
        if (ScriptObject.isArray(array)) {
            args = ((NativeArray)array).asObjectArray();
        } else if (array instanceof ScriptObject) {
            int n;
            ScriptObject sobj = (ScriptObject)array;
            Object len = sobj.getLength();
            if (len == ScriptRuntime.UNDEFINED || len == null) {
                ECMAErrors.typeError((ScriptObject)Global.instance(), "function.apply.expects.array", new String[0]);
            }
            if ((double)(n = (int)JSType.toUint32(len)) != JSType.toNumber(len)) {
                ECMAErrors.typeError((ScriptObject)Global.instance(), "function.apply.expects.array", new String[0]);
            }
            args = new Object[(int)JSType.toUint32(len)];
            for (int i = 0; i < args.length; ++i) {
                args[i] = sobj.get(i);
            }
        } else if (array instanceof Object[]) {
            args = (Object[])array;
        } else if (array instanceof List) {
            List list = (List)array;
            args = new Object[list.size()];
            list.toArray(args);
        } else if (array == null || array == ScriptRuntime.UNDEFINED) {
            args = ScriptRuntime.EMPTY_ARRAY;
        } else {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "function.apply.expects.array", new String[0]);
        }
        ScriptFunction func = (ScriptFunction)self;
        return ScriptRuntime.apply(func, NativeFunction.convertThis(func, thiz), args);
    }

    @Function(attributes=2, arity=1)
    public static Object call(Object self, Object ... args) {
        Object[] arguments;
        Object thiz;
        if (!(self instanceof ScriptFunction)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
        Object object = thiz = args.length == 0 ? ScriptRuntime.UNDEFINED : args[0];
        if (args.length > 1) {
            arguments = new Object[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, arguments.length);
        } else {
            arguments = ScriptRuntime.EMPTY_ARRAY;
        }
        ScriptFunction func = (ScriptFunction)self;
        thiz = NativeFunction.convertThis(func, thiz);
        return ScriptRuntime.apply(func, thiz, arguments);
    }

    @Function(attributes=2, arity=1)
    public static Object bind(Object self, Object ... args) {
        Object[] arguments;
        if (!(self instanceof ScriptFunction)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
        Object thiz = NativeFunction.convertThis((ScriptFunction)self, args.length == 0 ? ScriptRuntime.UNDEFINED : args[0]);
        if (args.length > 1) {
            arguments = new Object[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, arguments.length);
        } else {
            arguments = ScriptRuntime.EMPTY_ARRAY;
        }
        return ((ScriptFunction)self).makeBoundFunction(thiz, arguments);
    }

    @Function(attributes=2)
    public static Object toSource(Object self) {
        if (!(self instanceof ScriptFunction)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
        return ((ScriptFunction)self).toSource();
    }

    @Constructor(arity=1)
    public static Object function(boolean newObj, Object self, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("(function (");
        if (args.length > 0) {
            for (int i = 0; i < args.length - 1; ++i) {
                sb.append(JSType.toString(args[i]));
                if (i >= args.length - 2) continue;
                sb.append(",");
            }
        }
        sb.append(") {\n");
        if (args.length > 0) {
            sb.append(JSType.toString(args[args.length - 1]));
            sb.append('\n');
        }
        sb.append("})");
        Global global = Global.instance();
        return Global.directEval(global, sb.toString(), global, "<function>", Global.isStrict());
    }
}

