/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.io.PrintWriter;
import jdk.nashorn.internal.compat.Objects;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyListenerManager;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.LinkerCallSite;

@ScriptClass(value="Debug")
public class NativeDebug
extends ScriptObject {
    NativeDebug() {
        this.setProto(Global.objectPrototype());
    }

    @Override
    public String getClassName() {
        return "Debug";
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object getContext(Object self) {
        return Global.getThisContext();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object map(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).getMap();
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object embed0(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).embed0;
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object embed1(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).embed1;
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object embed2(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).embed2;
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object embed3(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).embed3;
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object spill(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).spill;
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object methodHandle(Object self, Object obj) {
        if (obj instanceof ScriptFunction) {
            return ((ScriptFunction)obj).getInvokeHandle();
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object identical(Object self, Object obj1, Object obj2) {
        return obj1 == obj2;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object getClass(Object self, Object obj) {
        if (obj != null) {
            return obj.getClass();
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object equals(Object self, Object obj1, Object obj2) {
        return obj1 != null ? obj1.equals(obj2) : false;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object toJavaString(Object self, Object obj) {
        return Objects.toString(obj);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object toIdentString(Object self, Object obj) {
        if (obj == null) {
            return "null";
        }
        int hash = System.identityHashCode(obj);
        return obj.getClass() + "@" + Integer.toHexString(hash);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object dumpCounters(Object self) {
        PrintWriter out = Context.getContext().getErr();
        out.println("ScriptObject count " + ScriptObject.getCount());
        out.println("Scope count " + ScriptObject.getScopeCount());
        out.println("ScriptObject listeners added " + PropertyListenerManager.getListenersAdded());
        out.println("ScriptObject listeners removed " + PropertyListenerManager.getListenersRemoved());
        out.println("ScriptObject listeners dead " + PropertyListenerManager.getListenersDead());
        out.println("ScriptFunction count " + ScriptObject.getCount());
        out.println("ScriptFunction invokes " + ScriptFunction.getInvokes());
        out.println("ScriptFunction allocations " + ScriptFunction.getAllocations());
        out.println("PropertyMap count " + PropertyMap.getCount());
        out.println("PropertyMap cloned " + PropertyMap.getClonedCount());
        out.println("PropertyMap history hit " + PropertyMap.getHistoryHit());
        out.println("PropertyMap proto invalidations " + PropertyMap.getProtoInvalidations());
        out.println("PropertyMap proto history hit " + PropertyMap.getProtoHistoryHit());
        out.println("PropertyMap setProtoNewMapCount " + PropertyMap.getSetProtoNewMapCount());
        out.println("Callsite count " + LinkerCallSite.getCount());
        out.println("Callsite misses " + LinkerCallSite.getMissCount());
        out.println("Callsite misses by site at " + LinkerCallSite.getMissSamplingPercentage() + "%");
        LinkerCallSite.getMissCounts(out);
        return ScriptRuntime.UNDEFINED;
    }
}

