/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.objects.AccessorPropertyDescriptor;
import jdk.nashorn.internal.objects.DataPropertyDescriptor;
import jdk.nashorn.internal.objects.GenericPropertyDescriptor;
import jdk.nashorn.internal.objects.NativeArguments;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.NativeBoolean;
import jdk.nashorn.internal.objects.NativeDate;
import jdk.nashorn.internal.objects.NativeError;
import jdk.nashorn.internal.objects.NativeEvalError;
import jdk.nashorn.internal.objects.NativeNumber;
import jdk.nashorn.internal.objects.NativeRangeError;
import jdk.nashorn.internal.objects.NativeReferenceError;
import jdk.nashorn.internal.objects.NativeRegExp;
import jdk.nashorn.internal.objects.NativeString;
import jdk.nashorn.internal.objects.NativeSyntaxError;
import jdk.nashorn.internal.objects.NativeTypeError;
import jdk.nashorn.internal.objects.NativeURIError;
import jdk.nashorn.internal.objects.ScriptFunctionImpl;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalFunctions;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.NativeJavaPackage;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.Scope;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.ScriptingFunctions;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.InvokeByName;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.scripts.JO$;
import org.dynalang.dynalink.linker.GuardedInvocation;

@ScriptClass(value="Global")
public final class Global
extends ScriptObject
implements GlobalObject,
Scope {
    private static final InvokeByName TO_STRING = new InvokeByName("toString", ScriptObject.class);
    private static final InvokeByName VALUE_OF = new InvokeByName("valueOf", ScriptObject.class);
    @Property(attributes=2)
    public Object parseInt;
    @Property(attributes=2)
    public Object parseFloat;
    @Property(attributes=2)
    public Object isNaN;
    @Property(attributes=2)
    public Object isFinite;
    @Property(attributes=2)
    public Object encodeURI;
    @Property(attributes=2)
    public Object encodeURIComponent;
    @Property(attributes=2)
    public Object decodeURI;
    @Property(attributes=2)
    public Object decodeURIComponent;
    @Property(attributes=2)
    public Object escape;
    @Property(attributes=2)
    public Object unescape;
    @Property(attributes=2)
    public Object print;
    @Property(attributes=2)
    public Object load;
    @Property(attributes=7)
    public final Object NaN = Double.NaN;
    @Property(attributes=7)
    public final Object Infinity = Double.POSITIVE_INFINITY;
    @Property(attributes=7)
    public final Object undefined = ScriptRuntime.UNDEFINED;
    @Property(attributes=2)
    public Object eval;
    @Property(name="Object", attributes=2)
    public volatile Object object;
    @Property(name="Function", attributes=2)
    public volatile Object function;
    @Property(name="Array", attributes=2)
    public volatile Object array;
    @Property(name="String", attributes=2)
    public volatile Object string;
    @Property(name="Boolean", attributes=2)
    public volatile Object _boolean;
    @Property(name="Number", attributes=2)
    public volatile Object number;
    @Property(name="Date", attributes=2)
    public volatile Object date;
    @Property(name="RegExp", attributes=2)
    public volatile Object regexp;
    @Property(name="JSON", attributes=2)
    public volatile Object json;
    @Property(name="JSAdapter", attributes=2)
    public volatile Object jsadapter;
    @Property(name="Math", attributes=2)
    public volatile Object math;
    @Property(name="Error", attributes=2)
    public volatile Object error;
    @Property(name="EvalError", attributes=2)
    public volatile Object evalError;
    @Property(name="RangeError", attributes=2)
    public volatile Object rangeError;
    @Property(name="ReferenceError", attributes=2)
    public volatile Object referenceError;
    @Property(name="SyntaxError", attributes=2)
    public volatile Object syntaxError;
    @Property(name="TypeError", attributes=2)
    public volatile Object typeError;
    @Property(name="URIError", attributes=2)
    public volatile Object uriError;
    @Property(name="ArrayBuffer", attributes=2)
    public volatile Object arrayBuffer;
    @Property(name="Int8Array", attributes=2)
    public volatile Object int8Array;
    @Property(name="Uint8Array", attributes=2)
    public volatile Object uint8Array;
    @Property(name="Uint8ClampedArray", attributes=2)
    public volatile Object uint8ClampedArray;
    @Property(name="Int16Array", attributes=2)
    public volatile Object int16Array;
    @Property(name="Uint16Array", attributes=2)
    public volatile Object uint16Array;
    @Property(name="Int32Array", attributes=2)
    public volatile Object int32Array;
    @Property(name="Uint32Array", attributes=2)
    public volatile Object uint32Array;
    @Property(name="Float32Array", attributes=2)
    public volatile Object float32Array;
    @Property(name="Float64Array", attributes=2)
    public volatile Object float64Array;
    @Property(name="Packages", attributes=2)
    public volatile Object packages;
    @Property(attributes=2)
    public volatile Object java;
    @Property(attributes=2)
    public Object javax;
    @Property(name="JavaImporter", attributes=2)
    public volatile Object javaImporter;
    @Property(name="Java", attributes=2)
    public volatile Object javaApi;
    @Property(name="__FILE__", attributes=7)
    public Object __FILE__;
    @Property(name="__DIR__", attributes=7)
    public Object __DIR__;
    @Property(name="__LINE__", attributes=7)
    public Object __LINE__;
    public NativeDate DEFAULT_DATE;
    public NativeRegExp DEFAULT_REGEXP;
    private ScriptFunction builtinFunction;
    private ScriptFunction builtinObject;
    private ScriptFunction builtinArray;
    private ScriptFunction builtinBoolean;
    private ScriptFunction builtinDate;
    private ScriptObject builtinJSON;
    private ScriptFunction builtinJSAdapter;
    private ScriptObject builtinMath;
    private ScriptFunction builtinNumber;
    private ScriptFunction builtinRegExp;
    private ScriptFunction builtinString;
    private ScriptFunction builtinError;
    private ScriptFunction builtinEval;
    private ScriptFunction builtinEvalError;
    private ScriptFunction builtinRangeError;
    private ScriptFunction builtinReferenceError;
    private ScriptFunction builtinSyntaxError;
    private ScriptFunction builtinTypeError;
    private ScriptFunction builtinURIError;
    private ScriptObject builtinPackages;
    private ScriptObject builtinJava;
    private ScriptObject builtinJavax;
    private ScriptObject builtinJavaImporter;
    private ScriptObject builtinJavaApi;
    private ScriptObject builtinArrayBuffer;
    private ScriptObject builtinInt8Array;
    private ScriptObject builtinUint8Array;
    private ScriptObject builtinUint8ClampedArray;
    private ScriptObject builtinInt16Array;
    private ScriptObject builtinUint16Array;
    private ScriptObject builtinInt32Array;
    private ScriptObject builtinUint32Array;
    private ScriptObject builtinFloat32Array;
    private ScriptObject builtinFloat64Array;
    private int splitState = -1;
    private ClassCache classCache;
    private static final MethodHandle EVAL = Global.findOwnMH("eval", Object.class, Object.class, Object.class);
    private static final MethodHandle PRINT = Global.findOwnMH("print", Object.class, Object.class, Object[].class);
    private static final MethodHandle PRINTLN = Global.findOwnMH("println", Object.class, Object.class, Object[].class);
    private static final MethodHandle LOAD = Global.findOwnMH("load", Object.class, Object.class, Object.class);

    public Global() {
        this.setIsScope();
        this.setMap(this.getMap().duplicate());
        int cacheSize = this.getContext()._class_cache_size;
        if (cacheSize > 0) {
            this.classCache = new ClassCache(cacheSize);
        }
    }

    public static Global instance() {
        return (Global)Context.getGlobal();
    }

    public static Context getThisContext() {
        return Global.instance().getContext();
    }

    public static boolean isStrict() {
        return Global.getThisContext()._strict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initBuiltinObjects() {
        if (this.builtinObject != null) {
            return;
        }
        ScriptObject oldGlobal = Context.getGlobal();
        Context.setGlobal(this);
        try {
            this.init();
        }
        finally {
            Context.setGlobal(oldGlobal);
        }
    }

    @Override
    public ScriptFunction newScriptFunction(String name, MethodHandle handle, ScriptObject scope, boolean strict) {
        return new ScriptFunctionImpl(name, handle, scope, strict, null);
    }

    @Override
    public Object wrapAsObject(Object obj) {
        if (obj instanceof Boolean) {
            return new NativeBoolean((Boolean)obj);
        }
        if (obj instanceof Number) {
            return new NativeNumber(((Number)obj).doubleValue());
        }
        if (obj instanceof String || obj instanceof ConsString) {
            return new NativeString((CharSequence)obj);
        }
        if (obj instanceof Object[]) {
            return new NativeArray((Object[])obj);
        }
        if (obj instanceof double[]) {
            return new NativeArray((double[])obj);
        }
        if (obj instanceof long[]) {
            return new NativeArray((long[])obj);
        }
        if (obj instanceof int[]) {
            return new NativeArray((int[])obj);
        }
        return obj;
    }

    @Override
    public GuardedInvocation numberLookup(NashornCallSiteDescriptor callSite, Number self) {
        return NativeNumber.lookupPrimitive(callSite, self);
    }

    @Override
    public GuardedInvocation stringLookup(NashornCallSiteDescriptor callSite, CharSequence self) {
        return NativeString.lookupPrimitive(callSite, self);
    }

    @Override
    public GuardedInvocation booleanLookup(NashornCallSiteDescriptor callSite, Boolean self) {
        return NativeBoolean.lookupPrimitive(callSite, self);
    }

    @Override
    public ScriptObject newObject() {
        return Global.newEmptyInstance();
    }

    @Override
    public Object getDefaultValue(ScriptObject sobj, Class<?> typeHint) {
        Class<Object> hint = typeHint;
        if (hint == null) {
            hint = Number.class;
        }
        try {
            Object value;
            Object value2;
            if (hint == String.class) {
                Object toString = TO_STRING.getGetter().invokeExact(sobj);
                if (toString instanceof ScriptFunction && JSType.isPrimitive(value2 = TO_STRING.getInvoker().invokeExact(toString, sobj))) {
                    return value2;
                }
                Object valueOf = VALUE_OF.getGetter().invokeExact(sobj);
                if (valueOf instanceof ScriptFunction && JSType.isPrimitive(value = VALUE_OF.getInvoker().invokeExact(valueOf, sobj))) {
                    return value;
                }
                ECMAErrors.typeError((ScriptObject)this, "cannot.get.default.string", new String[0]);
            }
            if (hint == Number.class) {
                Object valueOf = VALUE_OF.getGetter().invokeExact(sobj);
                if (valueOf instanceof ScriptFunction && JSType.isPrimitive(value2 = VALUE_OF.getInvoker().invokeExact(valueOf, sobj))) {
                    return value2;
                }
                Object toString = TO_STRING.getGetter().invokeExact(sobj);
                if (toString instanceof ScriptFunction && JSType.isPrimitive(value = TO_STRING.getInvoker().invokeExact(toString, sobj))) {
                    return value;
                }
                ECMAErrors.typeError((ScriptObject)this, "cannot.get.default.number", new String[0]);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Override
    public boolean isError(ScriptObject sobj) {
        ScriptObject errorProto = this.getErrorPrototype();
        for (ScriptObject proto = sobj.getProto(); proto != null; proto = proto.getProto()) {
            if (proto != errorProto) continue;
            return true;
        }
        return false;
    }

    @Override
    public ScriptObject newError(String msg) {
        return new NativeError(msg);
    }

    @Override
    public ScriptObject newEvalError(String msg) {
        return new NativeEvalError(msg);
    }

    @Override
    public ScriptObject newRangeError(String msg) {
        return new NativeRangeError(msg);
    }

    @Override
    public ScriptObject newReferenceError(String msg) {
        return new NativeReferenceError(msg);
    }

    @Override
    public ScriptObject newSyntaxError(String msg) {
        return new NativeSyntaxError(msg);
    }

    @Override
    public ScriptObject newTypeError(String msg) {
        return new NativeTypeError(msg);
    }

    @Override
    public ScriptObject newURIError(String msg) {
        return new NativeURIError(msg);
    }

    @Override
    public PropertyDescriptor newGenericDescriptor(boolean configurable, boolean enumerable) {
        return new GenericPropertyDescriptor(configurable, enumerable);
    }

    @Override
    public PropertyDescriptor newDataDescriptor(Object value, boolean configurable, boolean enumerable, boolean writable) {
        return new DataPropertyDescriptor(configurable, enumerable, writable, value);
    }

    @Override
    public PropertyDescriptor newAccessorDescriptor(Object get, Object set, boolean configurable, boolean enumerable) {
        AccessorPropertyDescriptor desc = new AccessorPropertyDescriptor(configurable, enumerable, get == null ? ScriptRuntime.UNDEFINED : get, set == null ? ScriptRuntime.UNDEFINED : set);
        boolean strict = this.getContext()._strict;
        if (get == null) {
            desc.delete("get", strict);
        }
        if (set == null) {
            desc.delete("set", strict);
        }
        return desc;
    }

    @Override
    public Class<?> findCachedClass(Source source) {
        assert (this.classCache != null) : "Class cache used without being initialized";
        SoftReference ref = (SoftReference)this.classCache.get(source);
        if (ref != null) {
            Class clazz = (Class)ref.get();
            if (clazz == null) {
                this.classCache.remove(source);
            }
            return clazz;
        }
        return null;
    }

    @Override
    public void cacheClass(Source source, Class<?> clazz) {
        assert (this.classCache != null) : "Class cache used without being initialized";
        this.classCache.put(source, new SoftReference(clazz));
    }

    public static Object eval(Object self, Object str) {
        return Global.directEval(self, str, ScriptRuntime.UNDEFINED, ScriptRuntime.UNDEFINED, ScriptRuntime.UNDEFINED);
    }

    public static Object directEval(Object self, Object str, Object callThis, Object location, Object strict) {
        if (!(str instanceof String) && !(str instanceof ConsString)) {
            return str;
        }
        ScriptObject scope = self instanceof ScriptObject ? (ScriptObject)self : Global.instance();
        return Global.getThisContext().eval(scope, str.toString(), callThis, location, Boolean.TRUE.equals(strict));
    }

    public static Object print(Object self, Object ... objects) {
        return Global.printImpl(false, objects);
    }

    public static Object println(Object self, Object ... objects) {
        return Global.printImpl(true, objects);
    }

    public static Object load(Object self, Object source) throws IOException {
        ScriptObject scope = self instanceof ScriptObject ? (ScriptObject)self : Global.instance();
        return Global.getThisContext().load(scope, source);
    }

    ScriptObject getFunctionPrototype() {
        return ScriptFunction.getPrototype(this.builtinFunction);
    }

    ScriptObject getObjectPrototype() {
        return ScriptFunction.getPrototype(this.builtinObject);
    }

    ScriptObject getArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinArray);
    }

    ScriptObject getBooleanPrototype() {
        return ScriptFunction.getPrototype(this.builtinBoolean);
    }

    ScriptObject getNumberPrototype() {
        return ScriptFunction.getPrototype(this.builtinNumber);
    }

    ScriptObject getDatePrototype() {
        return ScriptFunction.getPrototype(this.builtinDate);
    }

    ScriptObject getRegExpPrototype() {
        return ScriptFunction.getPrototype(this.builtinRegExp);
    }

    ScriptObject getStringPrototype() {
        return ScriptFunction.getPrototype(this.builtinString);
    }

    ScriptObject getErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinError);
    }

    ScriptObject getEvalErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinEvalError);
    }

    ScriptObject getRangeErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinRangeError);
    }

    ScriptObject getReferenceErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinReferenceError);
    }

    ScriptObject getSyntaxErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinSyntaxError);
    }

    ScriptObject getTypeErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinTypeError);
    }

    ScriptObject getURIErrorPrototype() {
        return ScriptFunction.getPrototype(this.builtinURIError);
    }

    ScriptObject getJavaImporterPrototype() {
        return ScriptFunction.getPrototype(this.builtinJavaImporter);
    }

    ScriptObject getJSAdapterPrototype() {
        return ScriptFunction.getPrototype(this.builtinJSAdapter);
    }

    ScriptObject getArrayBufferPrototype() {
        return ScriptFunction.getPrototype(this.builtinArrayBuffer);
    }

    ScriptObject getInt8ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinInt8Array);
    }

    ScriptObject getUint8ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinUint8Array);
    }

    ScriptObject getUint8ClampedArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinUint8ClampedArray);
    }

    ScriptObject getInt16ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinInt16Array);
    }

    ScriptObject getUint16ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinUint16Array);
    }

    ScriptObject getInt32ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinInt32Array);
    }

    ScriptObject getUint32ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinUint32Array);
    }

    ScriptObject getFloat32ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinFloat32Array);
    }

    ScriptObject getFloat64ArrayPrototype() {
        return ScriptFunction.getPrototype(this.builtinFloat64Array);
    }

    private ScriptFunction getBuiltinArray() {
        return this.builtinArray;
    }

    public static boolean isBuiltinArray() {
        Global instance = Global.instance();
        return instance.array == instance.getBuiltinArray();
    }

    private ScriptFunction getBuiltinBoolean() {
        return this.builtinBoolean;
    }

    public static boolean isBuiltinBoolean() {
        Global instance = Global.instance();
        return instance._boolean == instance.getBuiltinBoolean();
    }

    private ScriptFunction getBuiltinDate() {
        return this.builtinDate;
    }

    public static boolean isBuiltinDate() {
        Global instance = Global.instance();
        return instance.date == instance.getBuiltinDate();
    }

    private ScriptFunction getBuiltinError() {
        return this.builtinError;
    }

    public static boolean isBuiltinError() {
        Global instance = Global.instance();
        return instance.error == instance.getBuiltinError();
    }

    private ScriptFunction getBuiltinEvalError() {
        return this.builtinEvalError;
    }

    public static boolean isBuiltinEvalError() {
        Global instance = Global.instance();
        return instance.evalError == instance.getBuiltinEvalError();
    }

    private ScriptFunction getBuiltinFunction() {
        return this.builtinFunction;
    }

    public static boolean isBuiltinFunction() {
        Global instance = Global.instance();
        return instance.function == instance.getBuiltinFunction();
    }

    private ScriptFunction getBuiltinJSAdapter() {
        return this.builtinJSAdapter;
    }

    public static boolean isBuiltinJSAdapter() {
        Global instance = Global.instance();
        return instance.jsadapter == instance.getBuiltinJSAdapter();
    }

    private ScriptObject getBuiltinJSON() {
        return this.builtinJSON;
    }

    public static boolean isBuiltinJSON() {
        Global instance = Global.instance();
        return instance.json == instance.getBuiltinJSON();
    }

    private ScriptObject getBuiltinJava() {
        return this.builtinJava;
    }

    public static boolean isBuiltinJava() {
        Global instance = Global.instance();
        return instance.java == instance.getBuiltinJava();
    }

    private ScriptObject getBuiltinJavax() {
        return this.builtinJavax;
    }

    public static boolean isBuiltinJavax() {
        Global instance = Global.instance();
        return instance.javax == instance.getBuiltinJavax();
    }

    private ScriptObject getBuiltinJavaImporter() {
        return this.builtinJavaImporter;
    }

    public static boolean isBuiltinJavaImporter() {
        Global instance = Global.instance();
        return instance.javaImporter == instance.getBuiltinJavaImporter();
    }

    private ScriptObject getBuiltinMath() {
        return this.builtinMath;
    }

    public static boolean isBuiltinMath() {
        Global instance = Global.instance();
        return instance.math == instance.getBuiltinMath();
    }

    private ScriptFunction getBuiltinNumber() {
        return this.builtinNumber;
    }

    public static boolean isBuiltinNumber() {
        Global instance = Global.instance();
        return instance.number == instance.getBuiltinNumber();
    }

    private ScriptFunction getBuiltinObject() {
        return this.builtinObject;
    }

    public static boolean isBuiltinObject() {
        Global instance = Global.instance();
        return instance.object == instance.getBuiltinObject();
    }

    private ScriptObject getBuiltinPackages() {
        return this.builtinPackages;
    }

    public static boolean isBuiltinPackages() {
        Global instance = Global.instance();
        return instance.packages == instance.getBuiltinPackages();
    }

    private ScriptFunction getBuiltinRangeError() {
        return this.builtinRangeError;
    }

    public static boolean isBuiltinRangeError() {
        Global instance = Global.instance();
        return instance.rangeError == instance.getBuiltinRangeError();
    }

    private ScriptFunction getBuiltinReferenceError() {
        return this.builtinReferenceError;
    }

    public static boolean isBuiltinReferenceError() {
        Global instance = Global.instance();
        return instance.referenceError == instance.getBuiltinReferenceError();
    }

    private ScriptFunction getBuiltinRegExp() {
        return this.builtinRegExp;
    }

    public static boolean isBuiltinRegExp() {
        Global instance = Global.instance();
        return instance.regexp == instance.getBuiltinRegExp();
    }

    private ScriptFunction getBuiltinString() {
        return this.builtinString;
    }

    public static boolean isBuiltinString() {
        Global instance = Global.instance();
        return instance.string == instance.getBuiltinString();
    }

    private ScriptFunction getBuiltinSyntaxError() {
        return this.builtinSyntaxError;
    }

    public static boolean isBuiltinSyntaxError() {
        Global instance = Global.instance();
        return instance.syntaxError == instance.getBuiltinSyntaxError();
    }

    private ScriptFunction getBuiltinTypeError() {
        return this.builtinTypeError;
    }

    public static boolean isBuiltinTypeError() {
        Global instance = Global.instance();
        return instance.typeError == instance.getBuiltinTypeError();
    }

    private ScriptFunction getBuiltinURIError() {
        return this.builtinURIError;
    }

    public static boolean isBuiltinURIError() {
        Global instance = Global.instance();
        return instance.uriError == instance.getBuiltinURIError();
    }

    @Override
    public String getClassName() {
        return "global";
    }

    public static Object regExpCopy(Object regexp) {
        return new NativeRegExp((NativeRegExp)regexp);
    }

    public static NativeRegExp toRegExp(Object obj) {
        if (obj instanceof NativeRegExp) {
            return (NativeRegExp)obj;
        }
        return new NativeRegExp(JSType.toString(obj));
    }

    public static Object toObject(Object obj) {
        if (obj == null || obj == ScriptRuntime.UNDEFINED) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.an.object", ScriptRuntime.safeToString(obj));
        }
        if (obj instanceof ScriptObject) {
            return obj;
        }
        return Global.instance().wrapAsObject(obj);
    }

    public static Object allocate(Object[] initial) {
        return new NativeArray(initial);
    }

    public static Object allocate(double[] initial) {
        return new NativeArray(initial);
    }

    public static Object allocate(long[] initial) {
        return new NativeArray(initial);
    }

    public static Object allocate(int[] initial) {
        return new NativeArray(initial);
    }

    public static Object allocateArguments(Object[] arguments, Object callee, int numParams) {
        return NativeArguments.allocate(arguments, (ScriptFunction)callee, numParams);
    }

    public static boolean isEval(Object fn) {
        return fn == Global.instance().builtinEval;
    }

    public static Object newRegExp(String expression, String options) {
        if (options == null) {
            return new NativeRegExp(expression);
        }
        return new NativeRegExp(expression, options);
    }

    public static ScriptObject objectPrototype() {
        return Global.instance().getObjectPrototype();
    }

    public static ScriptObject newEmptyInstance() {
        JO$ sobj = new JO$();
        sobj.setProto(Global.objectPrototype());
        return sobj;
    }

    public static void checkObject(Object obj) {
        if (!(obj instanceof ScriptObject)) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.an.object", ScriptRuntime.safeToString(obj));
        }
    }

    public static void checkObjectCoercible(Object obj) {
        if (obj == null || obj == ScriptRuntime.UNDEFINED) {
            ECMAErrors.typeError((ScriptObject)Global.instance(), "not.an.object", ScriptRuntime.safeToString(obj));
        }
    }

    @Override
    public int getSplitState() {
        return this.splitState;
    }

    @Override
    public void setSplitState(int state) {
        this.splitState = state;
    }

    private void init() {
        this.initFunctionAndObject();
        this.setProto(this.getObjectPrototype());
        this.builtinEval = ScriptFunctionImpl.makeFunction("eval", EVAL);
        this.eval = this.builtinEval;
        ((ScriptFunction)this.eval).setArity(1);
        this.parseInt = ScriptFunctionImpl.makeFunction("parseInt", GlobalFunctions.PARSEINT);
        this.parseFloat = ScriptFunctionImpl.makeFunction("parseFloat", GlobalFunctions.PARSEFLOAT);
        this.isNaN = ScriptFunctionImpl.makeFunction("isNaN", GlobalFunctions.IS_NAN);
        this.isFinite = ScriptFunctionImpl.makeFunction("isFinite", GlobalFunctions.IS_FINITE);
        this.encodeURI = ScriptFunctionImpl.makeFunction("encodeURI", GlobalFunctions.ENCODE_URI);
        this.encodeURIComponent = ScriptFunctionImpl.makeFunction("encodeURIComponent", GlobalFunctions.ENCODE_URICOMPONENT);
        this.decodeURI = ScriptFunctionImpl.makeFunction("decodeURI", GlobalFunctions.DECODE_URI);
        this.decodeURIComponent = ScriptFunctionImpl.makeFunction("decodeURIComponent", GlobalFunctions.DECODE_URICOMPONENT);
        this.escape = ScriptFunctionImpl.makeFunction("escape", GlobalFunctions.ESCAPE);
        this.unescape = ScriptFunctionImpl.makeFunction("unescape", GlobalFunctions.UNESCAPE);
        this.print = ScriptFunctionImpl.makeFunction("print", this.getContext()._print_no_newline ? PRINT : PRINTLN);
        this.load = ScriptFunctionImpl.makeFunction("load", LOAD);
        this.builtinArray = (ScriptFunction)this.initConstructor("Array");
        this.builtinBoolean = (ScriptFunction)this.initConstructor("Boolean");
        this.builtinDate = (ScriptFunction)this.initConstructor("Date");
        this.builtinJSON = this.initConstructor("JSON");
        this.builtinJSAdapter = (ScriptFunction)this.initConstructor("JSAdapter");
        this.builtinMath = this.initConstructor("Math");
        this.builtinNumber = (ScriptFunction)this.initConstructor("Number");
        this.builtinRegExp = (ScriptFunction)this.initConstructor("RegExp");
        this.builtinString = (ScriptFunction)this.initConstructor("String");
        ScriptObject stringPrototype = this.getStringPrototype();
        stringPrototype.addOwnProperty("length", 7, 0.0);
        ScriptObject arrayPrototype = this.getArrayPrototype();
        arrayPrototype.addOwnProperty("length", 7, 0.0);
        this.DEFAULT_DATE = new NativeDate(Double.NaN);
        this.DEFAULT_REGEXP = new NativeRegExp("(?:)");
        ScriptObject regExpProto = this.getRegExpPrototype();
        regExpProto.addBoundProperties(this.DEFAULT_REGEXP);
        this.initErrorObjects();
        this.initJavaAccess();
        this.initTypedArray();
        if (this.getContext()._scripting) {
            this.initScripting();
        }
        if (Context.DEBUG) {
            this.initDebug();
        }
        this.copyBuiltins();
        this.__FILE__ = "";
        this.__DIR__ = "";
        this.__LINE__ = 0.0;
        List<String> arguments = this.getContext().getOptions().getArguments();
        Object argsObj = this.wrapAsObject(arguments.toArray());
        this.addOwnProperty("arguments", 2, argsObj);
        if (this.getContext()._scripting) {
            this.addOwnProperty("$ARG", 2, argsObj);
        }
    }

    private void initErrorObjects() {
        this.builtinError = (ScriptFunction)this.initConstructor("Error");
        ScriptObject errorProto = this.getErrorPrototype();
        boolean strict = Global.isStrict();
        ScriptFunction getStack = ScriptFunctionImpl.makeFunction("getStack", NativeError.GET_STACK);
        ScriptFunction setStack = ScriptFunctionImpl.makeFunction("setStack", NativeError.SET_STACK);
        errorProto.addOwnProperty("stack", 2, getStack, setStack);
        ScriptFunction getLineNumber = ScriptFunctionImpl.makeFunction("getLineNumber", NativeError.GET_LINENUMBER);
        ScriptFunction setLineNumber = ScriptFunctionImpl.makeFunction("setLineNumber", NativeError.SET_LINENUMBER);
        errorProto.addOwnProperty("lineNumber", 2, getLineNumber, setLineNumber);
        ScriptFunction getColumnNumber = ScriptFunctionImpl.makeFunction("getColumnNumber", NativeError.GET_COLUMNNUMBER);
        ScriptFunction setColumnNumber = ScriptFunctionImpl.makeFunction("setColumnNumber", NativeError.SET_COLUMNNUMBER);
        errorProto.addOwnProperty("columnNumber", 2, getColumnNumber, setColumnNumber);
        ScriptFunction getFileName = ScriptFunctionImpl.makeFunction("getFileName", NativeError.GET_FILENAME);
        ScriptFunction setFileName = ScriptFunctionImpl.makeFunction("setFileName", NativeError.SET_FILENAME);
        errorProto.addOwnProperty("fileName", 2, getFileName, setFileName);
        errorProto.set((Object)"name", (Object)"Error", strict);
        errorProto.set((Object)"message", (Object)"", strict);
        this.builtinEvalError = this.initErrorSubtype("EvalError", errorProto);
        this.builtinRangeError = this.initErrorSubtype("RangeError", errorProto);
        this.builtinReferenceError = this.initErrorSubtype("ReferenceError", errorProto);
        this.builtinSyntaxError = this.initErrorSubtype("SyntaxError", errorProto);
        this.builtinTypeError = this.initErrorSubtype("TypeError", errorProto);
        this.builtinURIError = this.initErrorSubtype("URIError", errorProto);
    }

    private ScriptFunction initErrorSubtype(String name, ScriptObject errorProto) {
        ScriptObject cons = this.initConstructor(name);
        ScriptObject prototype = ScriptFunction.getPrototype(cons);
        boolean strict = Global.isStrict();
        prototype.set((Object)"name", (Object)name, strict);
        prototype.set((Object)"message", (Object)"", strict);
        prototype.setProto(errorProto);
        return (ScriptFunction)cons;
    }

    private void initJavaAccess() {
        ScriptObject objectProto = this.getObjectPrototype();
        this.builtinPackages = new NativeJavaPackage("", objectProto);
        this.builtinJava = new NativeJavaPackage("java", objectProto);
        this.builtinJavax = new NativeJavaPackage("javax", objectProto);
        this.builtinJavaImporter = this.initConstructor("JavaImporter");
        this.builtinJavaApi = this.initConstructor("Java");
    }

    private void initScripting() {
        Object value = ScriptFunctionImpl.makeFunction("readLine", ScriptingFunctions.READLINE);
        this.addOwnProperty("readLine", 2, value);
        value = ScriptFunctionImpl.makeFunction("read", ScriptingFunctions.READ);
        this.addOwnProperty("read", 2, value);
        value = ScriptFunctionImpl.makeFunction("quit", ScriptingFunctions.QUIT);
        this.addOwnProperty("quit", 2, value);
        value = this.get("print");
        this.addOwnProperty("echo", 2, value);
        value = this.getContext();
        this.addOwnProperty("$OPTIONS", 2, value);
    }

    private void initTypedArray() {
        this.builtinArrayBuffer = this.initConstructor("ArrayBuffer");
        this.builtinInt8Array = this.initConstructor("Int8Array");
        this.builtinUint8Array = this.initConstructor("Uint8Array");
        this.builtinUint8ClampedArray = this.initConstructor("Uint8ClampedArray");
        this.builtinInt16Array = this.initConstructor("Int16Array");
        this.builtinUint16Array = this.initConstructor("Uint16Array");
        this.builtinInt32Array = this.initConstructor("Int32Array");
        this.builtinUint32Array = this.initConstructor("Uint32Array");
        this.builtinFloat32Array = this.initConstructor("Float32Array");
        this.builtinFloat64Array = this.initConstructor("Float64Array");
    }

    private void copyBuiltins() {
        this.array = this.builtinArray;
        this._boolean = this.builtinBoolean;
        this.date = this.builtinDate;
        this.error = this.builtinError;
        this.evalError = this.builtinEvalError;
        this.function = this.builtinFunction;
        this.jsadapter = this.builtinJSAdapter;
        this.json = this.builtinJSON;
        this.java = this.builtinJava;
        this.javax = this.builtinJavax;
        this.javaImporter = this.builtinJavaImporter;
        this.javaApi = this.builtinJavaApi;
        this.math = this.builtinMath;
        this.number = this.builtinNumber;
        this.object = this.builtinObject;
        this.packages = this.builtinPackages;
        this.rangeError = this.builtinRangeError;
        this.referenceError = this.builtinReferenceError;
        this.regexp = this.builtinRegExp;
        this.string = this.builtinString;
        this.syntaxError = this.builtinSyntaxError;
        this.typeError = this.builtinTypeError;
        this.uriError = this.builtinURIError;
        this.arrayBuffer = this.builtinArrayBuffer;
        this.int8Array = this.builtinInt8Array;
        this.uint8Array = this.builtinUint8Array;
        this.uint8ClampedArray = this.builtinUint8ClampedArray;
        this.int16Array = this.builtinInt16Array;
        this.uint16Array = this.builtinUint16Array;
        this.int32Array = this.builtinInt32Array;
        this.uint32Array = this.builtinUint32Array;
        this.float32Array = this.builtinFloat32Array;
        this.float64Array = this.builtinFloat64Array;
    }

    private void initDebug() {
        this.addOwnProperty("Debug", 2, this.initConstructor("Debug"));
    }

    private static Object printImpl(boolean newLine, Object ... objects) {
        PrintWriter out = Global.getThisContext().getOut();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                out.print(' ');
            }
            out.print(JSType.toString(object));
        }
        if (newLine) {
            out.println();
        }
        out.flush();
        return ScriptRuntime.UNDEFINED;
    }

    private ScriptObject initConstructor(String name) {
        try {
            StringBuilder sb = new StringBuilder("jdk.nashorn.internal.objects.");
            sb.append("Native");
            sb.append(name);
            sb.append("$Constructor");
            Class<?> funcClass = Class.forName(sb.toString());
            ScriptObject res = (ScriptObject)funcClass.newInstance();
            if (res instanceof ScriptFunction) {
                ScriptFunction func = (ScriptFunction)res;
                func.modifyOwnProperty(func.getProperty("prototype"), 7);
            }
            if (res.getProto() == null) {
                res.setProto(this.getObjectPrototype());
            }
            return res;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void initFunctionAndObject() {
        ScriptObject prototype;
        ScriptFunction func;
        Object value;
        String key;
        jdk.nashorn.internal.runtime.Property[] properties;
        this.builtinFunction = (ScriptFunction)this.initConstructor("Function");
        ScriptFunctionImpl anon = ScriptFunctionImpl.newAnonymousFunction();
        anon.addBoundProperties(this.getFunctionPrototype());
        this.builtinFunction.setProto(anon);
        this.builtinFunction.setPrototype(anon);
        anon.set((Object)"constructor", (Object)this.builtinFunction, ((ScriptFunction)anon).isStrict());
        anon.deleteOwnProperty(anon.getMap().findProperty("prototype"));
        this.builtinObject = (ScriptFunction)this.initConstructor("Object");
        ScriptObject ObjectPrototype = this.getObjectPrototype();
        anon.setProto(ObjectPrototype);
        for (jdk.nashorn.internal.runtime.Property property : properties = this.getFunctionPrototype().getMap().getProperties()) {
            key = property.getKey();
            value = this.builtinFunction.get(key);
            if (!(value instanceof ScriptFunction) || value == anon) continue;
            func = (ScriptFunction)value;
            func.setProto(this.getFunctionPrototype());
            prototype = ScriptFunction.getPrototype(func);
            if (prototype == null) continue;
            prototype.setProto(ObjectPrototype);
        }
        for (jdk.nashorn.internal.runtime.Property property : this.builtinObject.getMap().getProperties()) {
            key = property.getKey();
            value = this.builtinObject.get(key);
            if (!(value instanceof ScriptFunction) || (prototype = ScriptFunction.getPrototype(func = (ScriptFunction)value)) == null) continue;
            prototype.setProto(ObjectPrototype);
        }
        for (jdk.nashorn.internal.runtime.Property property : properties = this.getObjectPrototype().getMap().getProperties()) {
            key = property.getKey();
            value = ObjectPrototype.get(key);
            if (key.equals("constructor") || !(value instanceof ScriptFunction) || (prototype = ScriptFunction.getPrototype(func = (ScriptFunction)value)) == null) continue;
            prototype.setProto(ObjectPrototype);
        }
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), Global.class, name, Lookup.MH.type(rtype, types));
    }

    private static class ClassCache
    extends LinkedHashMap<Source, SoftReference<Class<?>>> {
        private final int size;

        ClassCache(int size) {
            super(size, 0.75f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Source, SoftReference<Class<?>>> eldest) {
            return this.size() >= this.size;
        }
    }
}

