/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.compat.Objects;
import jdk.nashorn.internal.objects.AccessorPropertyDescriptor;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

@ScriptClass(value="GenericPropertyDescriptor")
public final class GenericPropertyDescriptor
extends ScriptObject
implements PropertyDescriptor {
    @Property
    public Object configurable;
    @Property
    public Object enumerable;

    GenericPropertyDescriptor() {
        this(false, false);
    }

    GenericPropertyDescriptor(boolean configurable, boolean enumerable) {
        this.configurable = configurable;
        this.enumerable = enumerable;
        this.setProto(Global.objectPrototype());
    }

    @Override
    public boolean isConfigurable() {
        return JSType.toBoolean(this.configurable);
    }

    @Override
    public boolean isEnumerable() {
        return JSType.toBoolean(this.enumerable);
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("value");
    }

    @Override
    public ScriptFunction getGetter() {
        throw new UnsupportedOperationException("get");
    }

    @Override
    public ScriptFunction getSetter() {
        throw new UnsupportedOperationException("set");
    }

    @Override
    public void setConfigurable(boolean flag) {
        this.configurable = flag;
    }

    @Override
    public void setEnumerable(boolean flag) {
        this.enumerable = flag;
    }

    @Override
    public void setWritable(boolean flag) {
        throw new UnsupportedOperationException("set writable");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("set value");
    }

    @Override
    public void setGetter(Object getter) {
        throw new UnsupportedOperationException("set getter");
    }

    @Override
    public void setSetter(Object setter) {
        throw new UnsupportedOperationException("set setter");
    }

    @Override
    public PropertyDescriptor fillFrom(ScriptObject sobj) {
        boolean strict = this.getContext()._strict;
        if (sobj.has("configurable")) {
            this.configurable = JSType.toBoolean(sobj.get("configurable"));
        } else {
            this.delete("configurable", strict);
        }
        if (sobj.has("enumerable")) {
            this.enumerable = JSType.toBoolean(sobj.get("enumerable"));
        } else {
            this.delete("enumerable", strict);
        }
        return this;
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessorPropertyDescriptor)) {
            return false;
        }
        AccessorPropertyDescriptor other = (AccessorPropertyDescriptor)obj;
        return ScriptRuntime.sameValue(this.configurable, other.configurable) && ScriptRuntime.sameValue(this.enumerable, other.enumerable);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.configurable);
        hash = 97 * hash + Objects.hashCode(this.enumerable);
        return hash;
    }
}

