/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.compat.Objects;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

@ScriptClass(value="DataPropertyDescriptor")
public final class DataPropertyDescriptor
extends ScriptObject
implements PropertyDescriptor {
    @Property
    public Object configurable;
    @Property
    public Object enumerable;
    @Property
    public Object writable;
    @Property
    public Object value;

    DataPropertyDescriptor() {
        this(false, false, false, ScriptRuntime.UNDEFINED);
    }

    DataPropertyDescriptor(boolean configurable, boolean enumerable, boolean writable, Object value) {
        this.configurable = configurable;
        this.enumerable = enumerable;
        this.writable = writable;
        this.value = value;
        this.setProto(Global.objectPrototype());
    }

    @Override
    public boolean isConfigurable() {
        return JSType.toBoolean(this.configurable);
    }

    @Override
    public boolean isEnumerable() {
        return JSType.toBoolean(this.enumerable);
    }

    @Override
    public boolean isWritable() {
        return JSType.toBoolean(this.writable);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public ScriptFunction getGetter() {
        throw new UnsupportedOperationException("getter");
    }

    @Override
    public ScriptFunction getSetter() {
        throw new UnsupportedOperationException("setter");
    }

    @Override
    public void setConfigurable(boolean flag) {
        this.configurable = flag;
    }

    @Override
    public void setEnumerable(boolean flag) {
        this.enumerable = flag;
    }

    @Override
    public void setWritable(boolean flag) {
        this.writable = flag;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setGetter(Object getter) {
        throw new UnsupportedOperationException("set getter");
    }

    @Override
    public void setSetter(Object setter) {
        throw new UnsupportedOperationException("set setter");
    }

    @Override
    public PropertyDescriptor fillFrom(ScriptObject sobj) {
        boolean strict = this.getContext()._strict;
        if (sobj.has("configurable")) {
            this.configurable = JSType.toBoolean(sobj.get("configurable"));
        } else {
            this.delete("configurable", strict);
        }
        if (sobj.has("enumerable")) {
            this.enumerable = JSType.toBoolean(sobj.get("enumerable"));
        } else {
            this.delete("enumerable", strict);
        }
        if (sobj.has("writable")) {
            this.writable = JSType.toBoolean(sobj.get("writable"));
        } else {
            this.delete("writable", strict);
        }
        if (sobj.has("value")) {
            this.value = sobj.get("value");
        } else {
            this.delete("value", strict);
        }
        return this;
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataPropertyDescriptor)) {
            return false;
        }
        DataPropertyDescriptor other = (DataPropertyDescriptor)obj;
        return ScriptRuntime.sameValue(this.configurable, other.configurable) && ScriptRuntime.sameValue(this.enumerable, other.enumerable) && ScriptRuntime.sameValue(this.writable, other.writable) && ScriptRuntime.sameValue(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + Objects.hashCode(this.configurable);
        hash = 43 * hash + Objects.hashCode(this.enumerable);
        hash = 43 * hash + Objects.hashCode(this.writable);
        hash = 43 * hash + Objects.hashCode(this.value);
        return hash;
    }
}

