/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.compat.Objects;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

@ScriptClass(value="AccessorPropertyDescriptor")
public final class AccessorPropertyDescriptor
extends ScriptObject
implements PropertyDescriptor {
    @Property
    public Object configurable;
    @Property
    public Object enumerable;
    @Property
    public Object get;
    @Property
    public Object set;

    AccessorPropertyDescriptor() {
        this(false, false, ScriptRuntime.UNDEFINED, ScriptRuntime.UNDEFINED);
    }

    AccessorPropertyDescriptor(boolean configurable, boolean enumerable, Object get, Object set) {
        this.configurable = configurable;
        this.enumerable = enumerable;
        this.get = get;
        this.set = set;
        this.setProto(Global.objectPrototype());
    }

    @Override
    public boolean isConfigurable() {
        return JSType.toBoolean(this.configurable);
    }

    @Override
    public boolean isEnumerable() {
        return JSType.toBoolean(this.enumerable);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("value");
    }

    @Override
    public ScriptFunction getGetter() {
        return this.get instanceof ScriptFunction ? (ScriptFunction)this.get : null;
    }

    @Override
    public ScriptFunction getSetter() {
        return this.set instanceof ScriptFunction ? (ScriptFunction)this.set : null;
    }

    @Override
    public void setConfigurable(boolean flag) {
        this.configurable = flag;
    }

    @Override
    public void setEnumerable(boolean flag) {
        this.enumerable = flag;
    }

    @Override
    public void setWritable(boolean flag) {
        throw new UnsupportedOperationException("set writable");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("set value");
    }

    @Override
    public void setGetter(Object getter) {
        this.get = getter;
    }

    @Override
    public void setSetter(Object setter) {
        this.set = setter;
    }

    @Override
    public PropertyDescriptor fillFrom(ScriptObject sobj) {
        boolean strict = this.getContext()._strict;
        if (sobj.has("configurable")) {
            this.configurable = JSType.toBoolean(sobj.get("configurable"));
        } else {
            this.delete("configurable", strict);
        }
        if (sobj.has("enumerable")) {
            this.enumerable = JSType.toBoolean(sobj.get("enumerable"));
        } else {
            this.delete("enumerable", strict);
        }
        if (sobj.has("get")) {
            Object getter = sobj.get("get");
            if (getter == ScriptRuntime.UNDEFINED || getter instanceof ScriptFunction) {
                this.get = getter;
            } else {
                ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(getter));
            }
        } else {
            this.delete("get", strict);
        }
        if (sobj.has("set")) {
            Object setter = sobj.get("set");
            if (setter == ScriptRuntime.UNDEFINED || setter instanceof ScriptFunction) {
                this.set = setter;
            } else {
                ECMAErrors.typeError((ScriptObject)Global.instance(), "not.a.function", ScriptRuntime.safeToString(setter));
            }
        } else {
            this.delete("set", strict);
        }
        return this;
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessorPropertyDescriptor)) {
            return false;
        }
        AccessorPropertyDescriptor other = (AccessorPropertyDescriptor)obj;
        return ScriptRuntime.sameValue(this.configurable, other.configurable) && ScriptRuntime.sameValue(this.enumerable, other.enumerable) && ScriptRuntime.sameValue(this.get, other.get) && ScriptRuntime.sameValue(this.set, other.set);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.configurable);
        hash = 41 * hash + Objects.hashCode(this.enumerable);
        hash = 41 * hash + Objects.hashCode(this.get);
        hash = 41 * hash + Objects.hashCode(this.set);
        return hash;
    }
}

