/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir.debug;

import java.util.List;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

public final class PrintVisitor
extends NodeVisitor {
    private static final int TABWIDTH = 1;
    private final StringBuilder sb = new StringBuilder();
    private int indent;
    private final String EOLN;
    private final boolean printLineNumbers;

    public PrintVisitor() {
        this(true);
    }

    public PrintVisitor(boolean printLineNumbers) {
        this.EOLN = "\n";
        this.printLineNumbers = printLineNumbers;
    }

    public PrintVisitor(Node root) {
        this(root, true);
    }

    public PrintVisitor(Node root, boolean printLineNumbers) {
        this(printLineNumbers);
        this.visit(root);
    }

    private void visit(Node root) {
        root.accept(this);
    }

    public String toString() {
        return this.sb.append(this.EOLN).toString();
    }

    private void indent() {
        for (int i = this.indent; i > 0; --i) {
            this.sb.append(' ');
        }
    }

    @Override
    public Node enter(AccessNode accessNode) {
        accessNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(Block block) {
        this.sb.append(' ');
        this.sb.append('{');
        ++this.indent;
        boolean isFunction = block instanceof FunctionNode;
        if (isFunction) {
            FunctionNode function = (FunctionNode)block;
            List<FunctionNode> functions = function.getFunctions();
            for (FunctionNode f : functions) {
                this.sb.append(this.EOLN);
                this.indent();
                f.accept(this);
            }
            if (!functions.isEmpty()) {
                this.sb.append(this.EOLN);
            }
        }
        List<Node> statements = block.getStatements();
        boolean lastLineNumber = false;
        for (Node statement : statements) {
            char lastChar;
            if (this.printLineNumbers || !lastLineNumber) {
                this.sb.append(this.EOLN);
                this.indent();
            }
            if (statement instanceof UnaryNode) {
                statement.toString(this.sb);
            } else {
                statement.accept(this);
            }
            lastLineNumber = statement instanceof LineNumberNode;
            Symbol symbol = statement.getSymbol();
            if (symbol != null) {
                this.sb.append("  [");
                this.sb.append(symbol.toString());
                this.sb.append(']');
            }
            if ((lastChar = this.sb.charAt(this.sb.length() - 1)) != '}' && lastChar != ';' && (this.printLineNumbers || !lastLineNumber)) {
                this.sb.append(';');
            }
            if (statement.hasGoto()) {
                this.sb.append(" [GOTO]");
            }
            if (!statement.isTerminal()) continue;
            this.sb.append(" [TERMINAL]");
        }
        --this.indent;
        this.sb.append(this.EOLN);
        this.indent();
        this.sb.append("}");
        if (isFunction) {
            this.sb.append(this.EOLN);
        }
        return null;
    }

    @Override
    public Node enter(BreakNode breakNode) {
        breakNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(CallNode callNode) {
        callNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(ContinueNode continueNode) {
        continueNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(DoWhileNode doWhileNode) {
        this.sb.append("do");
        doWhileNode.getBody().accept(this);
        this.sb.append(' ');
        doWhileNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(ExecuteNode executeNode) {
        Node expression = executeNode.getExpression();
        if (expression instanceof UnaryNode) {
            expression.toString(this.sb);
        } else {
            expression.accept(this);
        }
        return null;
    }

    @Override
    public Node enter(ForNode forNode) {
        forNode.toString(this.sb);
        forNode.getBody().accept(this);
        return null;
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        functionNode.toString(this.sb);
        this.enter((Block)functionNode);
        return null;
    }

    @Override
    public Node enter(IfNode ifNode) {
        ifNode.toString(this.sb);
        ifNode.getPass().accept(this);
        Block fail = ifNode.getFail();
        if (fail != null) {
            this.sb.append(" else ");
            fail.accept(this);
        }
        return null;
    }

    @Override
    public Node enter(IndexNode indexNode) {
        indexNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(LabelNode labeledNode) {
        --this.indent;
        this.indent();
        ++this.indent;
        labeledNode.toString(this.sb);
        labeledNode.getBody().accept(this);
        return null;
    }

    @Override
    public Node enter(LineNumberNode lineNumberNode) {
        if (this.printLineNumbers) {
            lineNumberNode.toString(this.sb);
        }
        return null;
    }

    @Override
    public Node enter(ReferenceNode referenceNode) {
        referenceNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(ReturnNode returnNode) {
        returnNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(RuntimeNode runtimeNode) {
        runtimeNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(SplitNode splitNode) {
        splitNode.toString(this.sb);
        this.sb.append(this.EOLN);
        ++this.indent;
        this.indent();
        return splitNode;
    }

    @Override
    public Node leave(SplitNode splitNode) {
        this.sb.append("</split>");
        this.sb.append(this.EOLN);
        --this.indent;
        this.indent();
        return splitNode;
    }

    @Override
    public Node enter(SwitchNode switchNode) {
        switchNode.toString(this.sb);
        this.sb.append(" {");
        List<CaseNode> cases = switchNode.getCases();
        for (CaseNode caseNode : cases) {
            this.sb.append(this.EOLN);
            this.indent();
            caseNode.toString(this.sb);
            ++this.indent;
            caseNode.getBody().accept(this);
            --this.indent;
            this.sb.append(this.EOLN);
        }
        this.sb.append(this.EOLN);
        this.indent();
        this.sb.append("}");
        return null;
    }

    @Override
    public Node enter(ThrowNode throwNode) {
        throwNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(TryNode tryNode) {
        tryNode.toString(this.sb);
        tryNode.getBody().accept(this);
        List<Block> catchBlocks = tryNode.getCatchBlocks();
        for (Block catchBlock : catchBlocks) {
            CatchNode catchNode = (CatchNode)catchBlock.getStatements().get(0);
            catchNode.toString(this.sb);
            catchNode.getBody().accept(this);
        }
        Block finallyBody = tryNode.getFinallyBody();
        if (finallyBody != null) {
            this.sb.append(" finally ");
            finallyBody.accept(this);
        }
        return null;
    }

    @Override
    public Node enter(VarNode varNode) {
        varNode.toString(this.sb);
        return null;
    }

    @Override
    public Node enter(WhileNode whileNode) {
        whileNode.toString(this.sb);
        whileNode.getBody().accept(this);
        return null;
    }

    @Override
    public Node enter(WithNode withNode) {
        withNode.toString(this.sb);
        withNode.getBody().accept(this);
        return null;
    }
}

