/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Reference;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class TryNode
extends Node {
    @Reference
    private TryNode next;
    private Block body;
    private List<Block> catchBlocks;
    private Block finallyBody;
    private MethodEmitter.Label exit;
    private Symbol exception;

    public TryNode(Source source, long token, int finish, TryNode next) {
        super(source, token, finish);
        this.next = next;
        this.exit = new MethodEmitter.Label("exit");
    }

    private TryNode(TryNode tryNode, Node.CopyState cs) {
        super(tryNode);
        ArrayList<Block> newCatchBlocks = new ArrayList<Block>();
        for (Block block : tryNode.catchBlocks) {
            newCatchBlocks.add((Block)cs.existingOrCopy(block));
        }
        this.next = (TryNode)cs.existingOrSame(tryNode.getNext());
        this.body = (Block)cs.existingOrCopy(tryNode.getBody());
        this.catchBlocks = newCatchBlocks;
        this.finallyBody = (Block)cs.existingOrCopy(tryNode.getFinallyBody());
        this.exit = new MethodEmitter.Label(tryNode.getExit());
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new TryNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            if (this.finallyBody != null) {
                this.finallyBody = (Block)this.finallyBody.accept(visitor);
            }
            this.body = (Block)this.body.accept(visitor);
            ArrayList<Block> newCatchBlocks = new ArrayList<Block>(this.catchBlocks.size());
            for (Block catchBlock : this.catchBlocks) {
                newCatchBlocks.add((Block)catchBlock.accept(visitor));
            }
            this.catchBlocks = newCatchBlocks;
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("try");
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        this.body = body;
    }

    public List<CatchNode> getCatches() {
        ArrayList<CatchNode> catches = new ArrayList<CatchNode>(this.catchBlocks.size());
        for (Block catchBlock : this.catchBlocks) {
            catches.add((CatchNode)catchBlock.getStatements().get(0));
        }
        return catches;
    }

    public List<Block> getCatchBlocks() {
        return Collections.unmodifiableList(this.catchBlocks);
    }

    public void setCatchBlocks(List<Block> catchBlocks) {
        this.catchBlocks = catchBlocks;
    }

    public Symbol getException() {
        return this.exception;
    }

    public void setException(Symbol exception) {
        this.exception = exception;
    }

    public MethodEmitter.Label getExit() {
        return this.exit;
    }

    public void setExit(MethodEmitter.Label exit) {
        this.exit = exit;
    }

    public Block getFinallyBody() {
        return this.finallyBody;
    }

    public void setFinallyBody(Block finallyBody) {
        this.finallyBody = finallyBody;
    }

    public TryNode getNext() {
        return this.next;
    }

    public void setNext(TryNode next) {
        this.next = next;
    }
}

