/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.io.PrintWriter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.options.Options;

public final class Symbol
implements Comparable<Symbol> {
    public static final int IS_TEMP = 1;
    public static final int IS_GLOBAL = 2;
    public static final int IS_VAR = 3;
    public static final int IS_PARAM = 4;
    public static final int IS_CONSTANT = 5;
    static final int KINDMASK = 15;
    public static final int IS_SCOPE = 16;
    public static final int IS_THIS = 32;
    public static final int CAN_BE_UNDEFINED = 64;
    public static final int CAN_BE_PRIMITIVE = 128;
    public static final int IS_LET = 256;
    public static final int IS_INTERNAL = 512;
    private final String name;
    private int flags;
    private Node node;
    private final Block block;
    private Type type;
    private int slot;
    private int fieldIndex;
    private int useCount;
    private static final String TRACE_SYMBOL = Options.getStringProperty("nashorn.compiler.symbol.trace", null);

    protected Symbol(String name, int flags, Node node, Block block, Type type, int slot) {
        this.name = name;
        this.flags = flags;
        this.node = node;
        this.block = block;
        this.type = type;
        this.slot = slot;
        this.fieldIndex = -1;
    }

    public Symbol(String name, int flags, Node node, Block block) {
        this(name, flags, node, block, Type.UNKNOWN, -1);
    }

    public Symbol(String name, int flags, Type type) {
        this(name, flags, null, null, type, -1);
    }

    private static String align(String string, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append(string.substring(0, Math.min(string.length(), max)));
        while (sb.length() < max) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public final Type getSymbolType() {
        return this.type;
    }

    void print(PrintWriter stream) {
        String printName = Symbol.align(this.name, 20);
        String printType = Symbol.align(this.type.toString(), 10);
        String printSlot = Symbol.align(this.slot == -1 ? "none" : "" + this.slot, 10);
        String printFlags = "";
        switch (this.flags & 0xF) {
            case 1: {
                printFlags = "temp " + printFlags;
                break;
            }
            case 2: {
                printFlags = "global " + printFlags;
                break;
            }
            case 3: {
                printFlags = "var " + printFlags;
                break;
            }
            case 4: {
                printFlags = "param " + printFlags;
                break;
            }
            case 5: {
                printFlags = "CONSTANT " + printFlags;
                break;
            }
        }
        if (this.isScope()) {
            printFlags = printFlags + "scope ";
        }
        if (this.isInternal()) {
            printFlags = printFlags + "internal ";
        }
        if (this.isLet()) {
            printFlags = printFlags + "let ";
        }
        if (this.isThis()) {
            printFlags = printFlags + "this ";
        }
        if (!this.canBeUndefined()) {
            printFlags = printFlags + "always_def ";
        }
        if (this.canBePrimitive()) {
            printFlags = printFlags + "can_be_prim ";
        }
        stream.print(printName + ": " + printType + ", " + printSlot + ", " + printFlags);
        stream.println();
    }

    public boolean less(int other) {
        return (this.flags & 0xF) < (other & 0xF);
    }

    public void setNeedsSlot(boolean needsSlot) {
        this.setSlot(needsSlot ? 0 : -1);
    }

    public int slotCount() {
        return this.type.isCategory2() ? 2 : 1;
    }

    public FunctionNode findFunction() {
        return this.block != null ? this.block.getFunction() : null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)other;
        return this.name.equals(symbol.name) && this.block.equals(symbol.block);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.block.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String desc = this.getSymbolType().getDescriptor();
        sb.append(this.name).append(' ').append("(type=").append(desc.charAt(desc.length() - 1) == ';' ? Character.valueOf('O') : desc).append(')');
        if (this.hasSlot()) {
            sb.append(' ').append('(').append("slot=").append(this.slot).append(')');
        }
        if (this.isScope()) {
            sb.append(" S");
        }
        if (this.canBePrimitive()) {
            sb.append(" P?");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Symbol other) {
        return this.name.compareTo(other.name);
    }

    public boolean hasSlot() {
        return this.slot >= 0;
    }

    public boolean isTemp() {
        return (this.flags & 0xF) == 1;
    }

    public boolean isScope() {
        assert ((this.flags & 0xF) != 2 || (this.flags & 0x10) == 16) : "global without scope flag";
        return (this.flags & 0x10) == 16;
    }

    public void setIsScope() {
        this.flags |= 0x10;
        this.getBlock().setNeedsScope(true);
    }

    public boolean isVar() {
        return (this.flags & 0xF) == 3;
    }

    public boolean isGlobal() {
        return (this.flags & 0xF) == 2;
    }

    public boolean isParam() {
        return (this.flags & 0xF) == 4;
    }

    public boolean canBePrimitive() {
        return (this.flags & 0x80) == 128;
    }

    public boolean canBeUndefined() {
        return (this.flags & 0x40) == 64;
    }

    public void setCanBeUndefined() {
        assert (this.type.isObject()) : this.type;
        this.flags |= 0x40;
    }

    public void setCanBePrimitive(Type type) {
        this.flags |= 0x80;
    }

    public boolean isConstant() {
        return (this.flags & 0xF) == 5;
    }

    public boolean isInternal() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isThis() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLet() {
        return (this.flags & 0x100) == 256;
    }

    public void setIsLet() {
        this.flags |= 0x100;
    }

    public boolean isFastScope(FunctionNode currentFunction) {
        if (!this.isScope() || !this.block.needsScope()) {
            return false;
        }
        for (FunctionNode func = currentFunction; func != null; func = func.findParentFunction()) {
            if (!func.hasWith() && !func.hasEval()) continue;
            return false;
        }
        return true;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getFieldIndex() {
        assert (this.fieldIndex != -1) : "fieldIndex must be initialized";
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        assert (this.fieldIndex == -1) : "fieldIndex must be initialized only once";
        this.fieldIndex = fieldIndex;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public void increaseUseCount() {
        ++this.useCount;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void setSlot(int slot) {
        this.trace("SET SLOT " + slot);
        this.slot = slot;
    }

    public void setType(Class<?> type) {
        assert (!type.isPrimitive() && !Number.class.isAssignableFrom(type)) : "Class<?> types can only be subclasses of object";
        this.setType(Type.typeFor(type));
    }

    public void setType(Type type) {
        this.setTypeOverride(Type.widest(this.type, type));
    }

    public void setTypeOverride(Type type) {
        Type old = this.type;
        if (old != type) {
            this.trace("TYPE CHANGE: " + old + "=>" + type + " == " + type);
            this.type = type;
        }
    }

    public boolean isTopLevel() {
        return this.block instanceof FunctionNode && ((FunctionNode)this.block).isScript();
    }

    private void trace(String desc) {
        if (TRACE_SYMBOL != null && TRACE_SYMBOL.equals(this.name)) {
            Context.err("SYMBOL: '" + this.name + "' " + desc);
            new Throwable().printStackTrace(Context.getContext().getErr());
        }
    }
}

