/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.Reference;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class SwitchNode
extends BreakableNode {
    private Node expression;
    private Symbol tag;
    private List<CaseNode> cases;
    @Reference
    @Ignore
    private CaseNode defaultCase;

    public SwitchNode(Source source, long token, int finish) {
        super(source, token, finish);
        this.expression = null;
        this.tag = null;
        this.cases = null;
        this.defaultCase = null;
        this.breakLabel = new MethodEmitter.Label("switch_break");
    }

    private SwitchNode(SwitchNode switchNode, Node.CopyState cs) {
        super(switchNode);
        ArrayList<CaseNode> newCases = new ArrayList<CaseNode>();
        for (CaseNode caseNode : switchNode.getCases()) {
            newCases.add((CaseNode)cs.existingOrCopy(caseNode));
        }
        this.expression = cs.existingOrCopy(switchNode.getExpression());
        this.tag = switchNode.getTag();
        this.cases = newCases;
        this.defaultCase = (CaseNode)cs.existingOrCopy(switchNode.getDefaultCase());
        this.breakLabel = new MethodEmitter.Label(switchNode.getBreakLabel());
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new SwitchNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.expression = this.expression.accept(visitor);
            int count = this.cases.size();
            for (int i = 0; i < count; ++i) {
                this.cases.set(i, (CaseNode)this.cases.get(i).accept(visitor));
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("switch (");
        this.expression.toString(sb);
        sb.append(')');
    }

    public List<CaseNode> getCases() {
        return Collections.unmodifiableList(this.cases);
    }

    public void setCases(List<CaseNode> cases) {
        this.cases = cases;
    }

    public CaseNode getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(CaseNode defaultCase) {
        this.defaultCase = defaultCase;
    }

    public Node getExpression() {
        return this.expression;
    }

    public void setExpression(Node expression) {
        this.expression = expression;
    }

    public Symbol getTag() {
        return this.tag;
    }

    public void setTag(Symbol tag) {
        this.tag = tag;
    }
}

