/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.Reference;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Source;

public class ReturnNode
extends Node {
    private Node expression;
    @Reference
    @Ignore
    private final TryNode tryChain;

    public ReturnNode(Source source, long token, int finish, Node expression, TryNode tryChain) {
        super(source, token, finish);
        this.expression = expression;
        this.tryChain = tryChain;
        this.setIsTerminal(true);
    }

    private ReturnNode(ReturnNode returnNode, Node.CopyState cs) {
        super(returnNode);
        this.expression = cs.existingOrCopy(returnNode.expression);
        this.tryChain = (TryNode)cs.existingOrSame(returnNode.tryChain);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new ReturnNode(this, cs);
    }

    public boolean isReturn() {
        return this.isTokenType(TokenType.RETURN);
    }

    public boolean hasExpression() {
        return this.expression != null;
    }

    public boolean isYield() {
        return this.isTokenType(TokenType.YIELD);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            if (this.expression != null) {
                this.expression = this.expression.accept(visitor);
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.isYield() ? "yield" : "return ");
        if (this.expression != null) {
            this.expression.toString(sb);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ReturnNode) {
            ReturnNode otherReturn = (ReturnNode)other;
            if (this.hasExpression() != otherReturn.hasExpression()) {
                return false;
            }
            if (this.hasExpression()) {
                return otherReturn.getExpression().equals(this.getExpression());
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x471117 ^ (this.expression == null ? 0 : this.expression.hashCode());
    }

    public Node getExpression() {
        return this.expression;
    }

    public void setExpression(Node expression) {
        this.expression = expression;
    }

    public TryNode getTryChain() {
        return this.tryChain;
    }
}

