/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.compat.Objects;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Source;

public class Location
implements Cloneable {
    private final Source source;
    private final long token;

    public Location(Source source, long token) {
        this.source = source;
        this.token = token;
    }

    protected Location(Location location) {
        this.source = location.source;
        this.token = location.token;
    }

    protected Object clone() {
        return new Location(this);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Location loc = (Location)other;
        return this.token == loc.token && Objects.equals(this.source, loc.source);
    }

    public int hashCode() {
        return Token.hashCode(this.token) ^ Objects.hashCode(this.source);
    }

    public int position() {
        return Token.descPosition(this.token);
    }

    public int length() {
        return Token.descLength(this.token);
    }

    public TokenType tokenType() {
        return Token.descType(this.token);
    }

    public boolean isTokenType(TokenType type) {
        return Token.descType(this.token) == type;
    }

    public Source getSource() {
        return this.source;
    }

    public long getToken() {
        return this.token;
    }
}

