/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class IndexNode
extends BaseNode
implements TypeOverride {
    private Node index;
    private boolean hasCallSiteType;

    public IndexNode(Source source, long token, int finish, Node base, Node index) {
        super(source, token, finish, base);
        this.index = index;
    }

    public IndexNode(IndexNode indexNode) {
        this(indexNode, new Node.CopyState());
    }

    private IndexNode(IndexNode indexNode, Node.CopyState cs) {
        super(indexNode, cs);
        this.index = cs.existingOrCopy(indexNode.index);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new IndexNode(this, cs);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.index.equals(((IndexNode)other).getIndex());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getIndex().hashCode();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.base = this.base.accept(visitor);
            this.index = this.index.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean needsParen = this.tokenType().needsParens(this.base.tokenType(), true);
        if (this.hasCallSiteType) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? "O" : this.getType().getDescriptor());
            sb.append('}');
        }
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('[');
        this.index.toString(sb);
        sb.append(']');
    }

    public Node getIndex() {
        return this.index;
    }

    public void setIndex(Node index) {
        this.index = index;
    }

    @Override
    public void setType(Type type) {
        if (ObjectClassGenerator.DEBUG_FIELDS && !Type.areEquivalent(this.getSymbol().getSymbolType(), type)) {
            ObjectClassGenerator.LOG.info(this.getClass().getName() + " " + this + " => " + type + " instead of " + this.getType());
        }
        this.hasCallSiteType = true;
        this.getSymbol().setTypeOverride(type);
    }

    @Override
    public boolean canHaveCallSiteType() {
        return true;
    }
}

