/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class ExecuteNode
extends Node {
    private Node expression;

    public ExecuteNode(Source source, long token, int finish, Node expression) {
        super(source, token, finish);
        this.expression = expression;
    }

    private ExecuteNode(ExecuteNode executeNode, Node.CopyState cs) {
        super(executeNode);
        this.expression = cs.existingOrCopy(executeNode.expression);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new ExecuteNode(this, cs);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.expression.equals(((ExecuteNode)other).getExpression());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.expression.hashCode();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.setExpression(this.expression.accept(visitor));
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        this.expression.toString(sb);
    }

    public Node getExpression() {
        return this.expression;
    }

    public void setExpression(Node expression) {
        this.expression = expression;
    }
}

