/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class CallNode
extends Node
implements TypeOverride {
    private Type type;
    private Node function;
    private List<Node> args;
    private boolean isNew;
    private boolean inWithBlock;
    private EvalArgs evalArgs;

    public CallNode(Source source, long token, int finish, Node function, List<Node> args) {
        super(source, token, finish);
        this.setStart(function.getStart());
        this.function = function;
        this.args = args;
    }

    private CallNode(CallNode callNode, Node.CopyState cs) {
        super(callNode);
        ArrayList<Node> newArgs = new ArrayList<Node>();
        for (Node arg : callNode.args) {
            newArgs.add(cs.existingOrCopy(arg));
        }
        this.function = cs.existingOrCopy(callNode.function);
        this.args = newArgs;
        this.isNew = callNode.isNew;
        this.inWithBlock = callNode.inWithBlock;
    }

    @Override
    public Type getType() {
        if (this.hasCallSiteType()) {
            return this.type;
        }
        assert (!this.function.getType().isUnknown());
        return this.function.getType();
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    private boolean hasCallSiteType() {
        return this.type != null;
    }

    @Override
    public boolean canHaveCallSiteType() {
        return true;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new CallNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.function = this.function.accept(visitor);
            int count = this.args.size();
            for (int i = 0; i < count; ++i) {
                this.args.set(i, this.args.get(i).accept(visitor));
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.hasCallSiteType()) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? "O" : this.getType().getDescriptor());
            sb.append('}');
        }
        this.function.toString(sb);
        sb.append('(');
        boolean first = true;
        for (Node arg : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            arg.toString(sb);
        }
        sb.append(')');
    }

    public List<Node> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public void setArgs(List<Node> args) {
        this.args = args;
    }

    public EvalArgs getEvalArgs() {
        return this.evalArgs;
    }

    public void setEvalArgs(EvalArgs evalArgs) {
        this.evalArgs = evalArgs;
    }

    public boolean isEval() {
        return this.evalArgs != null;
    }

    public Node getFunction() {
        return this.function;
    }

    public void setFunction(Node node) {
        this.function = node;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew() {
        this.isNew = true;
    }

    public boolean inWithBlock() {
        return this.inWithBlock;
    }

    public void setInWithBlock() {
        this.inWithBlock = true;
    }

    public static class EvalArgs {
        public Node code;
        public Node evalThis;
        public String location;
        public boolean strictMode;
    }
}

