/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.ArrayType;
import jdk.nashorn.internal.codegen.types.BooleanType;
import jdk.nashorn.internal.codegen.types.BytecodeOps;
import jdk.nashorn.internal.codegen.types.IntType;
import jdk.nashorn.internal.codegen.types.LongType;
import jdk.nashorn.internal.codegen.types.NumberType;
import jdk.nashorn.internal.codegen.types.NumericType;
import jdk.nashorn.internal.codegen.types.ObjectType;
import org.objectweb.asm.MethodVisitor;

public abstract class Type
implements Comparable<Type>,
BytecodeOps {
    private final String name;
    private final String descriptor;
    private final int weight;
    private final int slots;
    private final Class<?> clazz;
    protected static final int MIN_WEIGHT = -1;
    protected static final int MAX_WEIGHT = 20;
    public static final Type BOOLEAN = new BooleanType();
    public static final Type INT = new IntType();
    public static final Type NUMBER = new NumberType();
    public static final Type LONG = new LongType();
    public static final Type STRING = new ObjectType(String.class);
    public static final Type OBJECT = new ObjectType();
    public static final ArrayType INT_ARRAY = new ArrayType((Class)int[].class){

        @Override
        public void astore(MethodVisitor method) {
            method.visitInsn(79);
        }

        @Override
        public Type aload(MethodVisitor method) {
            method.visitInsn(46);
            return INT;
        }

        @Override
        public Type newarray(MethodVisitor method) {
            method.visitIntInsn(188, 10);
            return this;
        }

        @Override
        public Type getElementType() {
            return INT;
        }
    };
    public static final ArrayType LONG_ARRAY = new ArrayType((Class)long[].class){

        @Override
        public void astore(MethodVisitor method) {
            method.visitInsn(80);
        }

        @Override
        public Type aload(MethodVisitor method) {
            method.visitInsn(46);
            return INT;
        }

        @Override
        public Type newarray(MethodVisitor method) {
            method.visitIntInsn(188, 10);
            return this;
        }

        @Override
        public Type getElementType() {
            return INT;
        }
    };
    public static final ArrayType NUMBER_ARRAY = new ArrayType((Class)double[].class){

        @Override
        public void astore(MethodVisitor method) {
            method.visitInsn(82);
        }

        @Override
        public Type aload(MethodVisitor method) {
            method.visitInsn(49);
            return NUMBER;
        }

        @Override
        public Type newarray(MethodVisitor method) {
            method.visitIntInsn(188, 7);
            return this;
        }

        @Override
        public Type getElementType() {
            return NUMBER;
        }
    };
    public static final ArrayType METHODHANDLE_ARRAY = null;
    public static final ArrayType STRING_ARRAY = new ArrayType(new String[0].getClass());
    public static final ArrayType OBJECT_ARRAY = new ArrayType(new Object[0].getClass());
    public static final Type THIS = new ObjectType(){

        @Override
        public String toString() {
            return "this";
        }
    };
    public static final Type SCOPE = new ObjectType(){

        @Override
        public String toString() {
            return "scope";
        }
    };
    public static final Type UNKNOWN = new Type("<unknown>", (Class)Unknown.class, -1, 1){

        @Override
        public String getDescriptor() {
            return "<unknown>";
        }

        @Override
        public Type load(MethodVisitor method, int slot) {
            assert (false) : "unsupported operation";
            return null;
        }

        @Override
        public void store(MethodVisitor method, int slot) {
            assert (false) : "unsupported operation";
        }

        @Override
        public Type ldc(MethodVisitor method, Object c) {
            assert (false) : "unsupported operation";
            return null;
        }

        @Override
        public Type loadUndefined(MethodVisitor method) {
            assert (false) : "unsupported operation";
            return null;
        }

        @Override
        public Type loadEmpty(MethodVisitor method) {
            assert (false) : "unsupported operation";
            return null;
        }

        @Override
        public Type convert(MethodVisitor method, Type to) {
            assert (false) : "unsupported operation";
            return null;
        }

        @Override
        public void _return(MethodVisitor method) {
            assert (false) : "unsupported operation";
        }

        @Override
        public Type add(MethodVisitor method) {
            assert (false) : "unsupported operation";
            return null;
        }
    };
    private static final Map<Class<?>, Type> cache = Collections.synchronizedMap(new HashMap());

    Type(String name, Class<?> clazz, int weight, int slots) {
        this.name = name;
        this.clazz = clazz;
        this.descriptor = Type.getDescriptor(clazz);
        this.weight = weight;
        assert (weight >= -1 && weight <= 20) : "illegal type weight: " + weight;
        this.slots = slots;
    }

    public static String getDescriptor(Class<?> type) {
        return org.objectweb.asm.Type.getDescriptor(type);
    }

    public int getWeight() {
        return this.weight;
    }

    public Class<?> getTypeClass() {
        return this.clazz;
    }

    public Type nextWider() {
        return null;
    }

    public Class<?> getBoxedType() {
        assert (!this.getTypeClass().isPrimitive());
        return null;
    }

    public static String getMethodDescriptor(Type returnType, Type ... types) {
        org.objectweb.asm.Type[] itypes = new org.objectweb.asm.Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            itypes[i] = types[i].getInternalType();
        }
        return org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType.getInternalType(), (org.objectweb.asm.Type[])itypes);
    }

    public static String getMethodDescriptor(Class<?> returnType, Class<?> ... types) {
        org.objectweb.asm.Type[] itypes = new org.objectweb.asm.Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            itypes[i] = Type.getInternalType(types[i]);
        }
        return org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)Type.getInternalType(returnType), (org.objectweb.asm.Type[])itypes);
    }

    static Type typeFor(org.objectweb.asm.Type itype) {
        switch (itype.getSort()) {
            case 1: {
                return BOOLEAN;
            }
            case 5: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 8: {
                return NUMBER;
            }
            case 10: {
                return OBJECT;
            }
            case 0: {
                return null;
            }
            case 9: {
                switch (itype.getElementType().getSort()) {
                    case 8: {
                        return NUMBER_ARRAY;
                    }
                    case 5: {
                        return INT_ARRAY;
                    }
                    case 7: {
                        return LONG_ARRAY;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                    case 10: 
                }
                return OBJECT_ARRAY;
            }
        }
        assert (false) : "Unknown itype : " + itype + " sort " + itype.getSort();
        return null;
    }

    public static Type getMethodReturnType(String methodDescriptor) {
        return Type.typeFor(org.objectweb.asm.Type.getReturnType((String)methodDescriptor));
    }

    public static Type[] getMethodArguments(String methodDescriptor) {
        org.objectweb.asm.Type[] itypes = org.objectweb.asm.Type.getArgumentTypes((String)methodDescriptor);
        Type[] types = new Type[itypes.length];
        for (int i = 0; i < itypes.length; ++i) {
            types[i] = Type.typeFor(itypes[i]);
        }
        return types;
    }

    static org.objectweb.asm.Type getInternalType(String className) {
        return org.objectweb.asm.Type.getType((String)className);
    }

    private org.objectweb.asm.Type getInternalType() {
        return org.objectweb.asm.Type.getType(this.getTypeClass());
    }

    private static org.objectweb.asm.Type getInternalType(Class<?> type) {
        return org.objectweb.asm.Type.getType(type);
    }

    static void invokeStatic(MethodVisitor method, CompilerConstants.Call call) {
        method.visitMethodInsn(184, call.className(), call.name(), call.descriptor());
    }

    public String getInternalName() {
        return org.objectweb.asm.Type.getInternalName(this.getTypeClass());
    }

    public static String getInternalName(Class<?> clazz) {
        return org.objectweb.asm.Type.getInternalName(clazz);
    }

    public boolean isUnknown() {
        return this.equals(UNKNOWN);
    }

    public boolean isBoolean() {
        return this.equals(BOOLEAN);
    }

    public boolean isInteger() {
        return this.equals(INT);
    }

    public boolean isLong() {
        return this.equals(LONG);
    }

    public boolean isNumber() {
        return this.equals(NUMBER);
    }

    public boolean isNumeric() {
        return this instanceof NumericType;
    }

    public boolean isArray() {
        return this instanceof ArrayType;
    }

    public boolean isCategory2() {
        return this.getSlots() == 2;
    }

    public boolean isObject() {
        return this instanceof ObjectType;
    }

    public boolean isString() {
        return this.equals(STRING);
    }

    public boolean isEquivalentTo(Type type) {
        return this.weight() == type.weight() || this.isObject() && type.isObject();
    }

    public static boolean isAssignableFrom(Type type0, Type type1) {
        if (type0.isObject() && type1.isObject()) {
            return type0.weight() >= type1.weight();
        }
        return type0.weight() == type1.weight();
    }

    public boolean isAssignableFrom(Type type) {
        return Type.isAssignableFrom(this, type);
    }

    public static boolean areEquivalent(Type type0, Type type1) {
        return type0.isEquivalentTo(type1);
    }

    public int getSlots() {
        return this.slots;
    }

    public static Type widest(Type type0, Type type1) {
        if (type0.isArray() && type1.isArray()) {
            return ((ArrayType)type0).getElementType() == ((ArrayType)type1).getElementType() ? type0 : OBJECT;
        }
        if (type0.isArray() != type1.isArray()) {
            return OBJECT;
        }
        return type0.weight() > type1.weight() ? type0 : type1;
    }

    public static Type narrowest(Type type0, Type type1) {
        return type0.weight() < type1.weight() ? type0 : type1;
    }

    public static Type widest(Type type0, Type type1, Type limit) {
        Type type = Type.widest(type0, type1);
        if (type.weight() > limit.weight()) {
            return limit;
        }
        return type;
    }

    public static Type narrowest(Type type0, Type type1, Type limit) {
        Type type;
        Type type2 = type = type0.weight() < type1.weight() ? type0 : type1;
        if (type.weight() < limit.weight()) {
            return limit;
        }
        return type;
    }

    public Type narrowest(Type other) {
        return Type.narrowest(this, other);
    }

    public Type widest(Type other) {
        return Type.widest(this, other);
    }

    int weight() {
        return this.weight;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.name;
    }

    public static Type typeFor(Class<?> clazz) {
        Type type = cache.get(clazz);
        if (type == null) {
            assert (!clazz.isPrimitive() || clazz == Void.TYPE);
            type = clazz.isArray() ? new ArrayType(clazz) : new ObjectType(clazz);
            cache.put(clazz, type);
        }
        return type;
    }

    @Override
    public int compareTo(Type o) {
        return o.weight() - this.weight();
    }

    @Override
    public Type dup(MethodVisitor method, int depth) {
        return Type.dup(method, this, depth);
    }

    @Override
    public Type swap(MethodVisitor method, Type other) {
        Type.swap(method, this, other);
        return other;
    }

    @Override
    public Type pop(MethodVisitor method) {
        Type.pop(method, this);
        return this;
    }

    protected static void pop(MethodVisitor method, Type type) {
        method.visitInsn(type.isCategory2() ? 88 : 87);
    }

    private static Type dup(MethodVisitor method, Type type, int depth) {
        boolean cat2 = type.isCategory2();
        switch (depth) {
            case 0: {
                method.visitInsn(cat2 ? 92 : 89);
                break;
            }
            case 1: {
                method.visitInsn(cat2 ? 93 : 90);
                break;
            }
            case 2: {
                method.visitInsn(cat2 ? 94 : 91);
                break;
            }
            default: {
                return null;
            }
        }
        return type;
    }

    private static void swap(MethodVisitor method, Type above, Type below) {
        MethodVisitor mv = method;
        if (below.isCategory2()) {
            if (above.isCategory2()) {
                mv.visitInsn(94);
                mv.visitInsn(88);
            } else {
                mv.visitInsn(91);
                mv.visitInsn(87);
            }
        } else if (above.isCategory2()) {
            mv.visitInsn(93);
            mv.visitInsn(88);
        } else {
            mv.visitInsn(95);
        }
    }

    static {
        cache.put(BOOLEAN.getTypeClass(), BOOLEAN);
        cache.put(INT.getTypeClass(), INT);
        cache.put(LONG.getTypeClass(), LONG);
        cache.put(NUMBER.getTypeClass(), NUMBER);
        cache.put(STRING.getTypeClass(), STRING);
        cache.put(OBJECT.getTypeClass(), OBJECT);
        cache.put(OBJECT_ARRAY.getTypeClass(), OBJECT_ARRAY);
    }

    private static interface Unknown {
    }
}

