/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.objects;

import java.util.List;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.objects.MapCreator;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyMap;

public abstract class ObjectCreator {
    protected final CompileUnit compileUnit;
    protected final List<String> keys;
    protected final List<Symbol> symbols;
    protected final CodeGenerator codegen;
    private final boolean isScope;
    private final boolean isVarArg;
    private int fieldCount;
    private int paramCount;
    private String fieldObjectClassName;
    private Class<?> fieldObjectClass;
    private PropertyMap propertyMap;

    protected ObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, boolean isScope, boolean isVarArg) {
        this.codegen = codegen;
        this.compileUnit = codegen.getCurrentCompileUnit();
        this.keys = keys;
        this.symbols = symbols;
        this.isScope = isScope;
        this.isVarArg = isVarArg;
        this.countFields();
        this.findClass();
    }

    private void countFields() {
        for (Symbol symbol : this.symbols) {
            if (symbol == null) continue;
            if (this.isVarArg() && symbol.isParam()) {
                symbol.setFieldIndex(this.paramCount++);
                continue;
            }
            symbol.setFieldIndex(this.fieldCount++);
        }
    }

    private void findClass() {
        this.fieldObjectClassName = this.isScope() ? ObjectClassGenerator.getClassName(this.fieldCount, this.paramCount) : ObjectClassGenerator.getClassName(this.fieldCount);
        try {
            this.fieldObjectClass = Context.forStructureClass(Compiler.binaryName(this.fieldObjectClassName));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"Nashorn has encountered an internal error.  Structure can not be created.");
        }
    }

    public abstract void makeObject(MethodEmitter var1);

    protected MapCreator newMapCreator(Class<?> clazz) {
        return new MapCreator(clazz, this.keys, this.symbols);
    }

    protected void makeMap() {
        if (this.keys.isEmpty()) {
            this.propertyMap = PropertyMap.newMap(this.fieldObjectClass);
            return;
        }
        this.propertyMap = this.newMapCreator(this.fieldObjectClass).makeMap(this.isVarArg());
    }

    protected MethodEmitter loadMap(MethodEmitter method) {
        this.codegen.loadConstant(this.propertyMap);
        return method;
    }

    public String getClassName() {
        return this.fieldObjectClassName;
    }

    protected boolean isScope() {
        return this.isScope;
    }

    protected boolean isVarArg() {
        return this.isVarArg;
    }
}

