/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.objects;

import java.lang.invoke.MethodHandle;
import java.util.EnumSet;
import java.util.List;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.FunctionSignature;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.objects.ObjectCreator;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.Source;

public class FunctionObjectCreator
extends ObjectCreator {
    private final FunctionNode functionNode;

    public FunctionObjectCreator(CodeGenerator codegen, FunctionNode functionNode, List<String> keys, List<Symbol> symbols) {
        super(codegen, keys, symbols, false, false);
        this.functionNode = functionNode;
    }

    private void loadHandle(MethodEmitter method, String signature) {
        method.loadHandle(this.functionNode.getCompileUnit().getUnitClassName(), this.functionNode.getName(), signature, EnumSet.of(ClassEmitter.Flag.HANDLE_STATIC));
    }

    @Override
    public void makeObject(MethodEmitter method) {
        this.makeMap();
        IdentNode identNode = this.functionNode.getIdent();
        String signature = new FunctionSignature(true, this.functionNode.needsCallee(), this.functionNode.getReturnType(), this.functionNode.isVarArg() ? null : this.functionNode.getParameters()).toString();
        long firstToken = this.functionNode.getFirstToken();
        long lastToken = this.functionNode.getLastToken();
        int position = Token.descPosition(firstToken);
        int length = Token.descPosition(lastToken) - position + Token.descLength(lastToken);
        long token = Token.toDesc(TokenType.FUNCTION, position, length);
        method._new("jdk/nashorn/internal/objects/ScriptFunctionImpl").dup();
        method.load(this.functionNode.isAnonymous() ? "" : identNode.getName());
        this.loadHandle(method, signature);
        method.loadScope();
        method.getStatic(this.compileUnit.getUnitClassName(), CompilerConstants.SOURCE.tag(), CompilerConstants.SOURCE.descriptor());
        method.load(token);
        method.loadHandle(this.getClassName(), CompilerConstants.ALLOCATE.tag(), CompilerConstants.methodDescriptor(ScriptObject.class, PropertyMap.class), EnumSet.of(ClassEmitter.Flag.HANDLE_STATIC));
        this.loadMap(method);
        method.load(this.functionNode.needsCallee());
        method.load(this.functionNode.isStrictMode());
        method.invoke(CompilerConstants.constructorNoLookup("jdk/nashorn/internal/objects/ScriptFunctionImpl", String.class, MethodHandle.class, ScriptObject.class, Source.class, Long.TYPE, MethodHandle.class, PropertyMap.class, Boolean.TYPE, Boolean.TYPE));
        if (this.functionNode.isVarArg()) {
            method.dup();
            method.load(this.functionNode.getParameters().size());
            method.invoke(ScriptFunction.SET_ARITY);
        }
    }
}

