/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.objects;

import java.util.Iterator;
import java.util.List;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.objects.ObjectCreator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;

public abstract class FieldObjectCreator<T>
extends ObjectCreator {
    private final List<T> values;
    private final int callSiteFlags;

    public FieldObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, List<T> values) {
        this(codegen, keys, symbols, values, false, false);
    }

    public FieldObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, List<T> values, boolean isScope, boolean isVarArg) {
        super(codegen, keys, symbols, isScope, isVarArg);
        this.values = values;
        this.callSiteFlags = codegen.getCallSiteFlags();
    }

    @Override
    public void makeObject(MethodEmitter method) {
        this.makeMap();
        method._new(this.getClassName()).dup();
        this.loadMap(method);
        if (this.isScope()) {
            method.loadScope();
            if (this.isVarArg()) {
                method.loadArguments();
                method.invoke(CompilerConstants.constructorNoLookup(this.getClassName(), PropertyMap.class, ScriptObject.class, CompilerConstants.ARGUMENTS.type()));
            } else {
                method.invoke(CompilerConstants.constructorNoLookup(this.getClassName(), PropertyMap.class, ScriptObject.class));
            }
        } else {
            method.invoke(CompilerConstants.constructorNoLookup(this.getClassName(), PropertyMap.class));
        }
        Iterator symbolIter = this.symbols.iterator();
        Iterator keyIter = this.keys.iterator();
        Iterator<T> valueIter = this.values.iterator();
        while (symbolIter.hasNext()) {
            Symbol symbol = (Symbol)symbolIter.next();
            String key = (String)keyIter.next();
            T value = valueIter.next();
            if (symbol == null || value == null) continue;
            int index = ArrayIndex.getArrayIndexNoThrow(key);
            if (index < 0) {
                this.putField(method, key, symbol.getFieldIndex(), value);
                continue;
            }
            this.putSlot(method, index, value);
        }
    }

    protected abstract void loadValue(T var1);

    protected abstract Type getValueType(T var1);

    private void putField(MethodEmitter method, String key, int fieldIndex, T value) {
        method.dup();
        this.loadValue(value);
        Type valueType = this.getValueType(value);
        if (valueType.isObject() || valueType.isBoolean()) {
            method.convert(Type.OBJECT);
        }
        method.convert(Type.OBJECT);
        method.putField(this.getClassName(), ObjectClassGenerator.getFieldName(fieldIndex, Type.OBJECT), CompilerConstants.typeDescriptor(Object.class));
    }

    private void putSlot(MethodEmitter method, int index, T value) {
        method.dup();
        method.load(index);
        this.loadValue(value);
        method.dynamicSetIndex(this.callSiteFlags);
    }
}

