/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;

public class WeighNodes
extends NodeVisitor {
    static final long FUNCTION_WEIGHT = 40L;
    private static final long ACCESS_WEIGHT = 4L;
    private static final long ADD_WEIGHT = 10L;
    private static final long BREAK_WEIGHT = 1L;
    private static final long CALL_WEIGHT = 10L;
    private static final long CATCH_WEIGHT = 10L;
    private static final long CONTINUE_WEIGHT = 1L;
    private static final long IF_WEIGHT = 2L;
    private static final long LITERAL_WEIGHT = 10L;
    private static final long LOOP_WEIGHT = 4L;
    private static final long REFERENCE_WEIGHT = 20L;
    private static final long RETURN_WEIGHT = 2L;
    private static final long SPLIT_WEIGHT = 40L;
    private static final long SWITCH_WEIGHT = 8L;
    private static final long THROW_WEIGHT = 2L;
    private static final long VAR_WEIGHT = 40L;
    private static final long WITH_WEIGHT = 8L;
    private long weight;
    private final Map<Node, Long> weightCache;

    private WeighNodes(Map<Node, Long> weightCache) {
        super(null, null);
        this.weightCache = weightCache;
    }

    static long weigh(Node node) {
        WeighNodes weighNodes = new WeighNodes(null);
        node.accept(weighNodes);
        return weighNodes.weight;
    }

    static long weigh(Node node, Map<Node, Long> weightCache) {
        WeighNodes weighNodes = new WeighNodes(weightCache);
        node.accept(weighNodes);
        return weighNodes.weight;
    }

    @Override
    public Node leave(AccessNode accessNode) {
        this.weight += 4L;
        return accessNode;
    }

    @Override
    public Node leave(BinaryNode binaryNode) {
        TokenType tokenType = binaryNode.tokenType();
        this.weight = tokenType == TokenType.ADD || tokenType == TokenType.ASSIGN_ADD ? (this.weight += 10L) : ++this.weight;
        return binaryNode;
    }

    @Override
    public Node enter(Block block) {
        if (this.weightCache != null && this.weightCache.containsKey(block)) {
            this.weight += this.weightCache.get(block).longValue();
            return null;
        }
        return block;
    }

    @Override
    public Node leave(BreakNode breakNode) {
        ++this.weight;
        return breakNode;
    }

    @Override
    public Node leave(CallNode callNode) {
        this.weight += 10L;
        return callNode;
    }

    @Override
    public Node leave(CatchNode catchNode) {
        this.weight += 10L;
        return catchNode;
    }

    @Override
    public Node leave(ContinueNode continueNode) {
        ++this.weight;
        return continueNode;
    }

    @Override
    public Node leave(DoWhileNode doWhileNode) {
        this.weight += 4L;
        return doWhileNode;
    }

    @Override
    public Node leave(ExecuteNode executeNode) {
        return executeNode;
    }

    @Override
    public Node leave(ForNode forNode) {
        this.weight += 4L;
        return forNode;
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        List<Node> statements = functionNode.getStatements();
        for (Node statement : statements) {
            statement.accept(this);
        }
        return null;
    }

    @Override
    public Node leave(IdentNode identNode) {
        this.weight += 4L + (long)(identNode.getName().length() * 2);
        return identNode;
    }

    @Override
    public Node leave(IfNode ifNode) {
        this.weight += 2L;
        return ifNode;
    }

    @Override
    public Node leave(IndexNode indexNode) {
        this.weight += 4L;
        return indexNode;
    }

    @Override
    public Node enter(LiteralNode literalNode) {
        this.weight += 10L;
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literalNode;
            Node[] value = (Node[])arrayLiteralNode.getValue();
            int[] postsets = arrayLiteralNode.getPostsets();
            List<LiteralNode.ArrayLiteralNode.ArrayUnit> units = arrayLiteralNode.getUnits();
            if (units == null) {
                for (int postset : postsets) {
                    Node element = value[postset];
                    if (element == null) continue;
                    element.accept(this);
                }
            }
            return null;
        }
        return literalNode;
    }

    @Override
    public Node leave(PropertyNode propertyNode) {
        this.weight += 10L;
        return propertyNode;
    }

    @Override
    public Node leave(ReferenceNode referenceNode) {
        this.weight += 20L;
        return referenceNode;
    }

    @Override
    public Node leave(ReturnNode returnNode) {
        this.weight += 2L;
        return returnNode;
    }

    @Override
    public Node leave(RuntimeNode runtimeNode) {
        this.weight += 10L;
        return runtimeNode;
    }

    @Override
    public Node enter(SplitNode splitNode) {
        this.weight += 40L;
        return null;
    }

    @Override
    public Node leave(SwitchNode switchNode) {
        this.weight += 8L;
        return switchNode;
    }

    @Override
    public Node leave(ThrowNode throwNode) {
        this.weight += 2L;
        return throwNode;
    }

    @Override
    public Node leave(TryNode tryNode) {
        this.weight += 2L;
        return tryNode;
    }

    @Override
    public Node leave(VarNode varNode) {
        this.weight += 40L;
        return varNode;
    }

    @Override
    public Node leave(WhileNode whileNode) {
        this.weight += 4L;
        return whileNode;
    }

    @Override
    public Node leave(WithNode withNode) {
        this.weight += 8L;
        return withNode;
    }
}

