/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.HashMap;
import java.util.Map;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;

public class RuntimeCallSite
extends MutableCallSite {
    static final CompilerConstants.Call BOOTSTRAP = CompilerConstants.staticCallNoLookup(RuntimeCallSite.class, "bootstrap", CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    private static final MethodHandle NEXT = RuntimeCallSite.findOwnMH("next", MethodHandle.class, new Class[0]);
    private final RuntimeNode.Request request;
    private String name;
    private static final Map<String, MethodHandle> METHODS;
    private static final Map<String, MethodHandle> GENERIC_METHODS;
    private static final Map<Class<?>, MethodHandle> UNBOX;
    private static final MethodHandle CHECKCAST;
    private static final MethodHandle CHECKCAST2;
    private static final MethodHandle ADDCHECK;

    RuntimeCallSite(MethodType type, String name) {
        super(type);
        this.name = name;
        this.request = RuntimeNode.Request.valueOf(name.substring(0, name.indexOf(58)));
        this.setTarget(this.makeMethod(name));
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String initialName, MethodType type) {
        return new RuntimeCallSite(type, initialName);
    }

    private String nextName(String requestName) {
        int last;
        if (requestName.equals(this.request.toString())) {
            return null;
        }
        char[] c = requestName.toCharArray();
        if (c[(last = c.length - 1) - 1] != '_') {
            return null;
        }
        switch (c[last]) {
            case 'Z': {
                c[last] = 73;
                break;
            }
            case 'I': {
                c[last] = 74;
                break;
            }
            case 'J': {
                c[last] = 68;
                break;
            }
            default: {
                return this.request.toString();
            }
        }
        return new String(c);
    }

    private boolean isSpecialized(String requestName) {
        return this.nextName(requestName) != null;
    }

    private MethodHandle makeMethod(String requestName) {
        if (this.isSpecialized(requestName)) {
            MethodHandle guard;
            MethodHandle mh;
            boolean isStrictCmp;
            Class<Number> primitiveType;
            Class boxedType;
            switch (requestName.charAt(requestName.length() - 1)) {
                case 'Z': {
                    boxedType = Boolean.class;
                    primitiveType = Integer.TYPE;
                    break;
                }
                case 'I': {
                    boxedType = Integer.class;
                    primitiveType = Integer.TYPE;
                    break;
                }
                case 'J': {
                    boxedType = Long.class;
                    primitiveType = Long.TYPE;
                    break;
                }
                case 'D': {
                    boxedType = Number.class;
                    primitiveType = Double.TYPE;
                    break;
                }
                default: {
                    throw new RuntimeException("should not reach here");
                }
            }
            boolean bl = isStrictCmp = this.request == RuntimeNode.Request.EQ_STRICT || this.request == RuntimeNode.Request.NE_STRICT;
            if (isStrictCmp && boxedType != Boolean.class && (this.type().parameterType(0) == Boolean.TYPE || this.type().parameterType(1) == Boolean.TYPE)) {
                mh = Lookup.MH.dropArguments(Lookup.MH.constant(Boolean.TYPE, this.request == RuntimeNode.Request.NE_STRICT), 0, this.type().parameterArray());
            } else {
                mh = METHODS.get(this.request.name().replace("_STRICT", "") + primitiveType.getSimpleName());
                for (int i = 0; i < this.type().parameterCount(); ++i) {
                    if (((Class)this.type().parameterType(i)).isPrimitive()) continue;
                    mh = Lookup.MH.filterArguments(mh, i, UNBOX.get(boxedType));
                }
                mh = Lookup.filterReturnType(mh, this.type().returnType());
                mh = Lookup.MH.explicitCastArguments(mh, this.type());
            }
            MethodHandle fallback = Lookup.MH.foldArguments(MethodHandles.exactInvoker(this.type()), Lookup.MH.bindTo(NEXT, this));
            if (((Class)this.type().parameterType(0)).isPrimitive()) {
                guard = Lookup.MH.insertArguments(Lookup.MH.dropArguments(CHECKCAST, 1, new Class[]{this.type().parameterType(0)}), 0, boxedType);
            } else if (((Class)this.type().parameterType(1)).isPrimitive()) {
                guard = Lookup.MH.insertArguments(Lookup.MH.dropArguments(CHECKCAST, 2, new Class[]{this.type().parameterType(1)}), 0, boxedType);
            } else {
                assert (!((Class)this.type().parameterType(0)).isPrimitive() && !((Class)this.type().parameterType(1)).isPrimitive());
                guard = Lookup.MH.insertArguments(CHECKCAST2, 0, boxedType);
            }
            if (this.request == RuntimeNode.Request.ADD && boxedType == Integer.class) {
                MethodHandle addcheck = ADDCHECK;
                for (int i = 0; i < this.type().parameterCount(); ++i) {
                    if (((Class)this.type().parameterType(i)).isPrimitive()) continue;
                    addcheck = Lookup.MH.filterArguments(addcheck, i, UNBOX.get(boxedType));
                }
                addcheck = Lookup.MH.explicitCastArguments(addcheck, this.type().changeReturnType(Boolean.TYPE));
                guard = Lookup.MH.guardWithTest(guard, addcheck, Lookup.MH.dropArguments(Lookup.MH.constant(Boolean.TYPE, false), 0, this.type().parameterArray()));
            }
            return Lookup.MH.guardWithTest(guard, mh, fallback);
        }
        return Lookup.MH.explicitCastArguments(Lookup.filterReturnType(GENERIC_METHODS.get(this.request.name()), this.type().returnType()), this.type());
    }

    public MethodHandle next() {
        this.name = this.nextName(this.name);
        MethodHandle next = this.makeMethod(this.name);
        this.setTarget(next);
        return next;
    }

    public String toString() {
        return super.toString() + " " + this.name;
    }

    public static boolean NE(int a, int b) {
        return a != b;
    }

    public static boolean NE(double a, double b) {
        return a != b;
    }

    public static boolean NE(long a, long b) {
        return a != b;
    }

    public static boolean EQ(int a, int b) {
        return a == b;
    }

    public static boolean EQ(double a, double b) {
        return a == b;
    }

    public static boolean EQ(long a, long b) {
        return a == b;
    }

    public static boolean LT(int a, int b) {
        return a < b;
    }

    public static boolean LT(double a, double b) {
        return a < b;
    }

    public static boolean LT(long a, long b) {
        return a < b;
    }

    public static boolean LE(int a, int b) {
        return a <= b;
    }

    public static boolean LE(double a, double b) {
        return a <= b;
    }

    public static boolean LE(long a, long b) {
        return a <= b;
    }

    public static boolean GT(int a, int b) {
        return a > b;
    }

    public static boolean GT(double a, double b) {
        return a > b;
    }

    public static boolean GT(long a, long b) {
        return a > b;
    }

    public static boolean GE(int a, int b) {
        return a >= b;
    }

    public static boolean GE(double a, double b) {
        return a >= b;
    }

    public static boolean GE(long a, long b) {
        return a >= b;
    }

    public static int ADD(int a, int b) {
        return a + b;
    }

    public static long ADD(long a, long b) {
        return a + b;
    }

    public static double ADD(double a, double b) {
        return a + b;
    }

    public static boolean ADDcheck(int a, int b) {
        return (long)(a + b) == (long)a + (long)b;
    }

    public static boolean checkcast(Class<?> type, Object obj) {
        return type.isInstance(obj);
    }

    public static boolean checkcast(Class<?> type, Object objA, Object objB) {
        return type.isInstance(objA) && type.isInstance(objB);
    }

    public static int unboxZ(Object obj) {
        return (Boolean)obj != false ? 1 : 0;
    }

    public static int unboxI(Object obj) {
        return (Integer)obj;
    }

    public static long unboxJ(Object obj) {
        return (Long)obj;
    }

    public static double unboxD(Object obj) {
        return ((Number)obj).doubleValue();
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        try {
            return Lookup.MH.findStatic(MethodHandles.lookup(), RuntimeCallSite.class, name, Lookup.MH.type(rtype, types));
        }
        catch (MethodHandleFactory.LookupException e) {
            return Lookup.MH.findVirtual(MethodHandles.lookup(), RuntimeCallSite.class, name, Lookup.MH.type(rtype, types));
        }
    }

    static {
        GENERIC_METHODS = new HashMap<String, MethodHandle>();
        CHECKCAST = RuntimeCallSite.findOwnMH("checkcast", Boolean.TYPE, Class.class, Object.class);
        CHECKCAST2 = RuntimeCallSite.findOwnMH("checkcast", Boolean.TYPE, Class.class, Object.class, Object.class);
        ADDCHECK = RuntimeCallSite.findOwnMH("ADDcheck", Boolean.TYPE, Integer.TYPE, Integer.TYPE);
        UNBOX = new HashMap();
        UNBOX.put(Boolean.class, RuntimeCallSite.findOwnMH("unboxZ", Integer.TYPE, Object.class));
        UNBOX.put(Integer.class, RuntimeCallSite.findOwnMH("unboxI", Integer.TYPE, Object.class));
        UNBOX.put(Long.class, RuntimeCallSite.findOwnMH("unboxJ", Long.TYPE, Object.class));
        UNBOX.put(Number.class, RuntimeCallSite.findOwnMH("unboxD", Double.TYPE, Object.class));
        METHODS = new HashMap<String, MethodHandle>();
        for (RuntimeNode.Request req : RuntimeNode.Request.values()) {
            if (!req.canSpecialize() || req.name().endsWith("_STRICT")) continue;
            boolean isCmp = RuntimeNode.Request.isComparison(req);
            METHODS.put(req.name() + "int", RuntimeCallSite.findOwnMH(req.name(), isCmp ? Boolean.TYPE : Integer.TYPE, Integer.TYPE, Integer.TYPE));
            METHODS.put(req.name() + "long", RuntimeCallSite.findOwnMH(req.name(), isCmp ? Boolean.TYPE : Long.TYPE, Long.TYPE, Long.TYPE));
            METHODS.put(req.name() + "double", RuntimeCallSite.findOwnMH(req.name(), isCmp ? Boolean.TYPE : Double.TYPE, Double.TYPE, Double.TYPE));
        }
        for (RuntimeNode.Request req : RuntimeNode.Request.values()) {
            if (!req.canSpecialize()) continue;
            GENERIC_METHODS.put(req.name(), Lookup.MH.findStatic(MethodHandles.lookup(), ScriptRuntime.class, req.name(), Lookup.MH.type(req.getReturnType().getTypeClass(), Object.class, Object.class)));
        }
    }

    static final class SpecializedRuntimeNode {
        private static final char REQUEST_SEPARATOR = ':';
        private final RuntimeNode.Request request;
        private final Type[] parameterTypes;
        private final Type returnType;

        SpecializedRuntimeNode(RuntimeNode.Request request, Type[] parameterTypes, Type returnType) {
            this.request = request;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        public Type firstTypeGuess() {
            Type widest = Type.UNKNOWN;
            for (Type type : this.parameterTypes) {
                if (type.isObject()) continue;
                widest = Type.widest(type, widest);
            }
            widest = Type.widest(widest, SpecializedRuntimeNode.firstTypeGuessForObject(this.request));
            return widest;
        }

        private static Type firstTypeGuessForObject(RuntimeNode.Request request) {
            switch (request) {
                case ADD: {
                    return Type.INT;
                }
            }
            return Type.BOOLEAN;
        }

        RuntimeNode.Request getRequest() {
            return this.request;
        }

        Type[] getParameterTypes() {
            return this.parameterTypes;
        }

        Type getReturnType() {
            return this.returnType;
        }

        private static char descFor(Type type) {
            if (type.isObject()) {
                return 'O';
            }
            return type.getDescriptor().charAt(0);
        }

        public boolean equals(Object other) {
            if (other instanceof SpecializedRuntimeNode) {
                SpecializedRuntimeNode otherNode = (SpecializedRuntimeNode)other;
                if (!otherNode.getReturnType().equals(this.getReturnType())) {
                    return false;
                }
                if (this.getParameterTypes().length != otherNode.getParameterTypes().length) {
                    return false;
                }
                for (int i = 0; i < this.getParameterTypes().length; ++i) {
                    if (Type.areEquivalent(this.getParameterTypes()[i], otherNode.getParameterTypes()[i])) continue;
                    return false;
                }
                return otherNode.getRequest().equals((Object)this.getRequest());
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.getRequest().toString().hashCode();
            hashCode ^= this.getReturnType().hashCode();
            for (Type type : this.getParameterTypes()) {
                hashCode ^= type.hashCode();
            }
            return hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getRequest().toString());
            sb.append(':');
            sb.append(SpecializedRuntimeNode.descFor(this.getReturnType()));
            for (Type type : this.getParameterTypes()) {
                sb.append(SpecializedRuntimeNode.descFor(type));
            }
            return sb.toString();
        }

        String getName(Type extraType) {
            return this.toString() + "_" + SpecializedRuntimeNode.descFor(extraType);
        }

        String getInitialName() {
            return this.getName(this.firstTypeGuess());
        }
    }
}

