/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Location;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;

final class Lower
extends NodeOperatorVisitor {
    private final Compiler compiler;
    private final Source source;
    private List<Node> statements;
    private List<Symbol> declaredSymbolsLocal;
    private Set<String> localDefs;
    private Set<String> localUses;
    private final Deque<Node> nesting;
    private static final DebugLogger LOG = new DebugLogger("lower");
    private static final boolean DEBUG = LOG.isEnabled();

    Lower(Compiler compiler) {
        this.compiler = compiler;
        this.source = compiler.getSource();
        this.statements = new ArrayList<Node>();
        this.nesting = new ArrayDeque<Node>();
    }

    private void nest(Node node) {
        this.nesting.push(node);
    }

    private void unnest() {
        this.nesting.pop();
    }

    static void debug(String str) {
        if (DEBUG) {
            LOG.info(str);
        }
    }

    @Override
    public Node leave(AccessNode accessNode) {
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, accessNode);
        return accessNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(Block block) {
        List<Node> savedStatements = this.statements;
        Set<String> savedDefs = this.localDefs;
        Set<String> savedUses = this.localUses;
        block.setFrame(this.getCurrentFunctionNode().pushFrame());
        try {
            this.statements = new ArrayList<Node>();
            this.localDefs = new HashSet<String>(savedDefs);
            this.localUses = new HashSet<String>(savedUses);
            for (Node statement : block.getStatements()) {
                statement.accept(this);
                Node lastStatement = Node.lastStatement(this.statements);
                if (lastStatement == null || !lastStatement.isTerminal()) continue;
                block.copyTerminalFlags(lastStatement);
                break;
            }
            block.setStatements(this.statements);
        }
        finally {
            this.statements = savedStatements;
            this.localDefs = savedDefs;
            this.localUses = savedUses;
            this.getCurrentFunctionNode().popFrame();
        }
        return null;
    }

    private boolean isNestedTry(TryNode tryNode, Block target) {
        for (Block current = this.getCurrentBlock(); current != target; current = current.getParent()) {
            if (tryNode.getBody() == current) {
                return true;
            }
            for (Block catchBlock : tryNode.getCatchBlocks()) {
                if (catchBlock != current) continue;
                return true;
            }
        }
        return false;
    }

    private boolean copyFinally(TryNode node, Node targetNode) {
        Block target = null;
        if (targetNode instanceof Block) {
            target = (Block)targetNode;
        }
        for (TryNode tryNode = node; tryNode != null; tryNode = tryNode.getNext()) {
            if (target != null && !this.isNestedTry(tryNode, target)) {
                return false;
            }
            Block finallyBody = tryNode.getFinallyBody();
            if (finallyBody == null) continue;
            finallyBody = (Block)finallyBody.clone();
            boolean hasTerminalFlags = finallyBody.hasTerminalFlags();
            new ExecuteNode(this.source, finallyBody.getToken(), finallyBody.getFinish(), finallyBody).accept(this);
            if (!hasTerminalFlags) continue;
            this.getCurrentBlock().copyTerminalFlags(finallyBody);
            return true;
        }
        return false;
    }

    @Override
    public Node enter(BreakNode breakNode) {
        TryNode tryNode = breakNode.getTryChain();
        if (tryNode != null && this.copyFinally(tryNode, breakNode.getTargetNode())) {
            return null;
        }
        this.statements.add(breakNode);
        return null;
    }

    private Node convert(Node node, Type type) {
        Symbol symbol = node.getSymbol();
        FunctionNode functionNode = this.getCurrentFunctionNode();
        assert (!type.isUnknown()) : "unknown";
        assert (symbol != null) : "no symbol for " + node;
        if (!functionNode.hasEval() && ((Node)node).getType().isEquivalentTo(Type.OBJECT) && type.isEquivalentTo(Type.OBJECT)) {
            return node;
        }
        Node resultNode = node;
        if (node instanceof LiteralNode) {
            LiteralNode<?> convertedLiteral = new LiteralNodeConstantEvaluator(node, type).eval();
            if (convertedLiteral != null) {
                resultNode = this.newLiteral(convertedLiteral);
            }
            if (type.isObject()) {
                resultNode = new UnaryNode(this.source, Token.recast(node.getToken(), TokenType.CONVERT), node);
            }
        } else {
            if (resultNode.getSymbol().isParam()) {
                resultNode.getSymbol().setType(type);
            }
            resultNode = new UnaryNode(this.source, Token.recast(node.getToken(), TokenType.CONVERT), resultNode);
        }
        functionNode.newTemporary(type, resultNode);
        resultNode.copyTerminalFlags(node);
        return resultNode;
    }

    private Type acceptArgs(CallNode callNode) {
        List<Node> oldArgs = callNode.getArgs();
        ArrayList<Node> acceptedArgs = new ArrayList<Node>(oldArgs.size());
        for (Node arg : oldArgs) {
            acceptedArgs.add(arg.accept(this));
        }
        callNode.setArgs(acceptedArgs);
        return Type.OBJECT;
    }

    private static String evalLocation(IdentNode node) {
        StringBuilder sb = new StringBuilder(node.getSource().getName());
        sb.append('#');
        sb.append(node.getSource().getLine(node.position()));
        sb.append("<eval>");
        return sb.toString();
    }

    private void checkEval(CallNode callNode) {
        if (callNode.getFunction() instanceof IdentNode) {
            List<Node> args = callNode.getArgs();
            IdentNode callee = (IdentNode)callNode.getFunction();
            if (args.size() >= 1 && CompilerConstants.EVAL.tag().equals(callee.getName())) {
                CallNode.EvalArgs evalArgs = new CallNode.EvalArgs();
                evalArgs.code = args.get(0).clone();
                evalArgs.code.accept(this);
                evalArgs.evalThis = new IdentNode(this.getCurrentFunctionNode().getThisNode());
                evalArgs.location = Lower.evalLocation(callee);
                evalArgs.strictMode = this.getCurrentFunctionNode().isStrictMode();
                callNode.setEvalArgs(evalArgs);
            }
        }
    }

    private static Node markerFunction(Node function) {
        if (function instanceof IdentNode) {
            return new IdentNode((IdentNode)function){

                @Override
                public boolean isFunction() {
                    return true;
                }
            };
        }
        if (function instanceof AccessNode) {
            return new AccessNode((AccessNode)function){

                @Override
                public boolean isFunction() {
                    return true;
                }
            };
        }
        if (function instanceof IndexNode) {
            return new IndexNode((IndexNode)function){

                @Override
                public boolean isFunction() {
                    return true;
                }
            };
        }
        return function;
    }

    @Override
    public Node enter(CallNode callNode) {
        Node function = callNode.getFunction();
        Node markedFunction = Lower.markerFunction(function);
        callNode.setFunction(markedFunction.accept(this));
        this.checkEval(callNode);
        Type returnType = this.acceptArgs(callNode);
        this.getCurrentFunctionNode().newTemporary(returnType, callNode);
        callNode.getFunction().getSymbol().setType(returnType);
        return null;
    }

    @Override
    public Node leave(CaseNode caseNode) {
        caseNode.copyTerminalFlags(caseNode.getBody());
        return caseNode;
    }

    @Override
    public Node enter(CatchNode catchNode) {
        IdentNode ident = catchNode.getException();
        Block block = this.getCurrentBlock();
        block.defineSymbol(ident.getName(), 259, ident).setType(Type.OBJECT);
        this.localDefs.add(ident.getName());
        return catchNode;
    }

    @Override
    public Node leave(CatchNode catchNode) {
        Node exceptionCondition = catchNode.getExceptionCondition();
        if (exceptionCondition != null) {
            catchNode.setExceptionCondition(this.convert(exceptionCondition, Type.BOOLEAN));
        }
        catchNode.copyTerminalFlags(catchNode.getBody());
        this.statements.add(catchNode);
        return catchNode;
    }

    @Override
    public Node enter(ContinueNode continueNode) {
        TryNode tryNode = continueNode.getTryChain();
        Node target = continueNode.getTargetNode();
        if (tryNode != null && this.copyFinally(tryNode, target)) {
            return null;
        }
        this.statements.add(continueNode);
        return null;
    }

    @Override
    public Node enter(DoWhileNode whileNode) {
        return this.enter((WhileNode)whileNode);
    }

    @Override
    public Node leave(DoWhileNode whileNode) {
        return this.leave((WhileNode)whileNode);
    }

    @Override
    public Node enter(EmptyNode emptyNode) {
        return null;
    }

    private boolean isEvalResultAssignment(Node expression) {
        Node e = expression;
        if (e.tokenType() == TokenType.DISCARD) {
            e = ((UnaryNode)expression).rhs();
        }
        IdentNode resultNode = this.getCurrentFunctionNode().getResultNode();
        return e instanceof BinaryNode && ((BinaryNode)e).lhs().equals(resultNode);
    }

    private static boolean isInternalExpression(Node expression) {
        Symbol symbol = expression.getSymbol();
        return symbol != null && symbol.isInternal();
    }

    private Node discard(Node expression) {
        expression.setDiscard(true);
        if (expression.getSymbol() != null) {
            UnaryNode discard = new UnaryNode(this.source, Token.recast(expression.getToken(), TokenType.DISCARD), expression);
            discard.copyTerminalFlags(expression);
            return discard;
        }
        return expression;
    }

    @Override
    public Node leave(ExecuteNode executeNode) {
        Node expression = executeNode.getExpression();
        if (this.getCurrentFunctionNode().isScript() && !(expression instanceof Block) && !this.isEvalResultAssignment(expression) && !Lower.isInternalExpression(expression)) {
            IdentNode resultNode = this.getCurrentFunctionNode().getResultNode();
            expression = new BinaryNode(this.source, Token.recast(executeNode.getToken(), TokenType.ASSIGN), resultNode, this.convert(expression, ((Node)resultNode).getType()));
            this.getCurrentFunctionNode().newTemporary(Type.OBJECT, expression);
        }
        expression = this.discard(expression);
        executeNode.setExpression(expression);
        executeNode.copyTerminalFlags(expression);
        this.statements.add(executeNode);
        return executeNode;
    }

    private boolean controlFlowEscapes(Node loopBody) {
        final ArrayList escapes = new ArrayList();
        loopBody.accept(new NodeVisitor(){

            @Override
            public Node leave(BreakNode node) {
                escapes.add(node);
                return node;
            }

            @Override
            public Node leave(ContinueNode node) {
                if (Lower.this.nesting.contains(node.getTargetNode())) {
                    escapes.add(node);
                }
                return node;
            }
        });
        return !escapes.isEmpty();
    }

    @Override
    public Node enter(ForNode forNode) {
        this.nest(forNode);
        return forNode;
    }

    private static boolean conservativeAlwaysTrue(Node node) {
        return node == null || node instanceof LiteralNode && Boolean.TRUE.equals(((LiteralNode)node).getValue());
    }

    @Override
    public Node leave(ForNode forNode) {
        Node init = forNode.getInit();
        Node test = forNode.getTest();
        Node modify = forNode.getModify();
        if (forNode.isForIn()) {
            String name = this.compiler.uniqueName(CompilerConstants.ITERATOR_PREFIX.tag());
            Symbol iter = this.getCurrentFunctionNode().defineSymbol(name, 515, null);
            iter.setType(Type.OBJECT);
            forNode.setIterator(iter);
            forNode.setModify(this.convert(forNode.getModify(), Type.OBJECT));
            forNode.getInit().getSymbol().setType(Type.OBJECT);
        } else {
            if (init != null) {
                forNode.setInit(this.discard(init));
            }
            if (test != null) {
                forNode.setTest(this.convert(test, Type.BOOLEAN));
            } else {
                forNode.setHasGoto();
            }
            if (modify != null) {
                forNode.setModify(this.discard(modify));
            }
        }
        Block body = forNode.getBody();
        boolean escapes = this.controlFlowEscapes(body);
        if (escapes) {
            body.setIsTerminal(false);
        }
        this.unnest();
        if (!forNode.isForIn() && Lower.conservativeAlwaysTrue(test)) {
            forNode.setTest(null);
            forNode.setIsTerminal(!escapes);
        }
        this.statements.add(forNode);
        return forNode;
    }

    private void initThis(FunctionNode functionNode) {
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        Symbol thisSymbol = functionNode.defineSymbol(CompilerConstants.THIS.tag(), 36, null);
        IdentNode thisNode = new IdentNode(this.source, token, finish, thisSymbol.getName());
        thisSymbol.setType(Type.OBJECT);
        thisSymbol.setNeedsSlot(true);
        thisNode.setSymbol(thisSymbol);
        functionNode.setThisNode(thisNode);
    }

    private void initScope(FunctionNode functionNode) {
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        Symbol scopeSymbol = functionNode.defineSymbol(CompilerConstants.SCOPE.tag(), 515, null);
        IdentNode scopeNode = new IdentNode(this.source, token, finish, scopeSymbol.getName());
        scopeSymbol.setType(ScriptObject.class);
        scopeSymbol.setNeedsSlot(true);
        scopeNode.setSymbol(scopeSymbol);
        functionNode.setScopeNode(scopeNode);
    }

    private void initReturn(FunctionNode functionNode) {
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        Symbol returnSymbol = functionNode.defineSymbol(CompilerConstants.SCRIPT_RETURN.tag(), 515, null);
        IdentNode returnNode = new IdentNode(this.source, token, finish, returnSymbol.getName());
        returnSymbol.setType(Object.class);
        returnSymbol.setNeedsSlot(true);
        returnNode.setSymbol(returnSymbol);
        functionNode.setResultNode(returnNode);
    }

    private void initVarArg(FunctionNode functionNode) {
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        assert (functionNode.getCalleeNode() != null);
        Symbol varArgsSymbol = functionNode.defineSymbol(CompilerConstants.VARARGS.tag(), 516, null);
        IdentNode varArgsNode = new IdentNode(this.source, token, finish, varArgsSymbol.getName());
        varArgsSymbol.setType(Type.OBJECT_ARRAY);
        varArgsSymbol.setNeedsSlot(true);
        varArgsNode.setSymbol(varArgsSymbol);
        functionNode.setVarArgsNode(varArgsNode);
        String argumentsName = CompilerConstants.ARGUMENTS.tag();
        String name = functionNode.hideArguments() ? functionNode.uniqueName("$" + argumentsName) : argumentsName;
        Symbol argumentsSymbol = functionNode.defineSymbol(name, 516, null);
        IdentNode argumentsNode = new IdentNode(this.source, token, finish, argumentsSymbol.getName());
        argumentsSymbol.setType(Type.OBJECT);
        argumentsSymbol.setNeedsSlot(true);
        argumentsNode.setSymbol(argumentsSymbol);
        functionNode.setArgumentsNode(argumentsNode);
    }

    private void initCallee(FunctionNode functionNode) {
        if (functionNode.getCalleeNode() != null) {
            return;
        }
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        Symbol calleeSymbol = functionNode.defineSymbol(CompilerConstants.CALLEE.tag(), 516, null);
        IdentNode calleeNode = new IdentNode(this.source, token, finish, calleeSymbol.getName());
        calleeSymbol.setType(ScriptFunction.class);
        calleeSymbol.setNeedsSlot(true);
        calleeNode.setSymbol(calleeSymbol);
        functionNode.setCalleeNode(calleeNode);
    }

    private void initParameters(FunctionNode functionNode) {
        functionNode.setReturnType(Type.UNKNOWN);
        for (IdentNode ident : functionNode.getParameters()) {
            this.localDefs.add(ident.getName());
            Symbol paramSymbol = functionNode.defineSymbol(ident.getName(), 4, ident);
            if (paramSymbol == null) continue;
            paramSymbol.setType(Type.UNKNOWN);
        }
    }

    private static void fixParameters(FunctionNode functionNode) {
        boolean nonObjectParams = false;
        ArrayList<Type> paramSpecializations = new ArrayList<Type>();
        for (IdentNode ident : functionNode.getParameters()) {
            Symbol paramSymbol = ident.getSymbol();
            if (paramSymbol == null) continue;
            Type type = paramSymbol.getSymbolType();
            if (type.isUnknown()) {
                type = Type.OBJECT;
            }
            paramSpecializations.add(type);
            if (!type.isObject()) {
                nonObjectParams = true;
            }
            paramSymbol.setType(Type.OBJECT);
        }
        if (!nonObjectParams) {
            paramSpecializations = null;
        } else {
            LOG.info("parameter specialization possible: " + functionNode.getName() + " " + paramSpecializations);
        }
    }

    private LiteralNode<Undefined> undefined() {
        return LiteralNode.newInstance(this.source, 0L, 0, ScriptRuntime.UNDEFINED);
    }

    private void guaranteeReturn(FunctionNode functionNode) {
        Node resultNode;
        if (functionNode.isScript()) {
            resultNode = functionNode.getResultNode();
        } else {
            Node lastStatement = Node.lastStatement(functionNode.getStatements());
            if (lastStatement != null && (lastStatement.isTerminal() || lastStatement instanceof ReturnNode)) {
                return;
            }
            resultNode = this.undefined().accept(this);
        }
        new ReturnNode(this.source, functionNode.getLastToken(), functionNode.getFinish(), resultNode, null).accept(this);
        functionNode.setReturnType(Type.OBJECT);
    }

    private void fixReturnTypes(final FunctionNode node) {
        if (node.getReturnType().isUnknown()) {
            node.setReturnType(Type.OBJECT);
        }
        node.accept(new NodeVisitor(){

            @Override
            public Node enter(FunctionNode subFunction) {
                return null;
            }

            @Override
            public Node leave(ReturnNode returnNode) {
                if (returnNode.hasExpression()) {
                    returnNode.setExpression(Lower.this.convert(returnNode.getExpression(), node.getReturnType()));
                }
                return returnNode;
            }
        });
    }

    private void fixAssignmentTypes(final FunctionNode node, List<Symbol> declaredSymbols) {
        for (Symbol symbol : declaredSymbols) {
            if (symbol.getSymbolType().isUnknown()) {
                LOG.finest("fixAssignmentTypes: widening " + symbol + " to object " + symbol + " in " + this.getCurrentFunctionNode());
                symbol.setType(Type.OBJECT);
                symbol.setCanBeUndefined();
            }
            if (!symbol.canBeUndefined() || Type.areEquivalent(symbol.getSymbolType(), Type.OBJECT)) continue;
            Lower.debug(symbol + " in " + this.getCurrentFunctionNode() + " can be undefined. Widening to object");
            symbol.setType(Type.OBJECT);
        }
        node.accept(new NodeVisitor(){

            private void fix(Assignment<? extends Node> assignment) {
                Node src = assignment.getAssignmentSource();
                Node dest = assignment.getAssignmentDest();
                if (src == null) {
                    return;
                }
                Type srcType = src.getType();
                Type destType = dest.getType();
                if (!dest.getSymbol().hasSlot() && !node.hasDeepWithOrEval()) {
                    destType = Type.narrowest(((Node)((Object)assignment)).getWidestOperationType(), destType);
                }
                if (!Type.areEquivalent(destType, srcType)) {
                    LOG.finest("fixAssignment " + assignment + " type = " + src.getType() + "=>" + dest.getType());
                    assignment.setAssignmentSource(Lower.this.convert(src, destType));
                }
            }

            private Node checkAssignment(Node assignNode) {
                if (!assignNode.isAssignment()) {
                    return assignNode;
                }
                this.fix((Assignment)((Object)assignNode));
                return assignNode;
            }

            @Override
            public Node leave(UnaryNode unaryNode) {
                return this.checkAssignment(unaryNode);
            }

            @Override
            public Node leave(BinaryNode binaryNode) {
                return this.checkAssignment(binaryNode);
            }

            @Override
            public Node leave(VarNode varNode) {
                return this.checkAssignment(varNode);
            }
        });
    }

    private static void initFromPropertyMap(FunctionNode functionNode) {
        assert (functionNode.isScript());
        PropertyMap map = Context.getGlobal().getMap();
        for (Property property : map.getProperties()) {
            String key = property.getKey();
            functionNode.defineSymbol(key, 2, null).setType(Type.OBJECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(FunctionNode functionNode) {
        Node initialEvalResult = this.undefined();
        this.nest(functionNode);
        this.localDefs = new HashSet<String>();
        this.localUses = new HashSet<String>();
        functionNode.setFrame(functionNode.pushFrame());
        this.initThis(functionNode);
        this.initCallee(functionNode);
        if (functionNode.isVarArg()) {
            this.initVarArg(functionNode);
        }
        this.initParameters(functionNode);
        this.initScope(functionNode);
        this.initReturn(functionNode);
        for (FunctionNode nestedFunction : functionNode.getFunctions()) {
            IdentNode ident = nestedFunction.getIdent();
            if (ident == null || !nestedFunction.isStatement()) continue;
            Symbol functionSymbol = functionNode.defineSymbol(ident.getName(), 3, nestedFunction);
            functionSymbol.setType(ScriptFunction.class);
            initialEvalResult = new IdentNode(ident);
        }
        if (functionNode.isScript()) {
            Lower.initFromPropertyMap(functionNode);
        }
        if (!(functionNode.isStatement() || functionNode.isAnonymous() || functionNode.isScript())) {
            Symbol selfSymbol = functionNode.defineSymbol(functionNode.getIdent().getName(), 3, functionNode);
            selfSymbol.setType(Type.OBJECT);
            selfSymbol.setNode(functionNode);
        }
        List<Node> savedStatements = this.statements;
        this.statements = new ArrayList<Node>();
        ArrayList<Symbol> declaredSymbols = new ArrayList<Symbol>();
        for (VarNode decl : functionNode.getDeclarations()) {
            IdentNode ident = decl.getName();
            declaredSymbols.add(functionNode.defineSymbol(ident.getName(), 3, new IdentNode(ident)));
        }
        this.declaredSymbolsLocal = new ArrayList<Symbol>();
        try {
            for (FunctionNode nestedFunction : functionNode.getFunctions()) {
                VarNode varNode = nestedFunction.getFunctionVarNode();
                if (varNode == null) continue;
                LineNumberNode lineNumberNode = nestedFunction.getFunctionVarLineNumberNode();
                if (lineNumberNode != null) {
                    lineNumberNode.accept(this);
                }
                varNode.accept(this);
                varNode.setIsFunctionVarNode();
            }
            if (functionNode.isScript()) {
                new ExecuteNode(this.source, functionNode.getFirstToken(), functionNode.getFinish(), initialEvalResult).accept(this);
            }
            for (Node statement : functionNode.getStatements()) {
                statement.accept(this);
                Node lastStatement = Node.lastStatement(this.statements);
                if (lastStatement == null || !lastStatement.hasTerminalFlags()) continue;
                functionNode.copyTerminalFlags(lastStatement);
                break;
            }
            functionNode.setStatements(this.statements);
            if (!functionNode.isTerminal()) {
                this.guaranteeReturn(functionNode);
            }
            for (FunctionNode nestedFunction : functionNode.getFunctions()) {
                nestedFunction.accept(this);
            }
            this.fixReturnTypes(functionNode);
            if (functionNode.needsSelfSymbol()) {
                IdentNode selfSlotNode = new IdentNode(functionNode.getIdent());
                selfSlotNode.setSymbol(functionNode.findSymbol(functionNode.getIdent().getName()));
                IdentNode functionRef = new IdentNode(functionNode.getCalleeNode());
                this.statements.add(0, new VarNode(this.source, functionNode.getToken(), functionNode.getFinish(), selfSlotNode, functionRef, false).accept(this));
            }
        }
        finally {
            this.statements = savedStatements;
        }
        this.unnest();
        Lower.fixParameters(functionNode);
        this.fixAssignmentTypes(functionNode, declaredSymbols);
        functionNode.setIsLowered(true);
        functionNode.popFrame();
        return null;
    }

    @Override
    public Node enter(IdentNode identNode) {
        String name = identNode.getName();
        if (identNode.isPropertyName()) {
            identNode.setSymbol(new Symbol(name, 0, Type.OBJECT));
            return null;
        }
        Block block = this.getCurrentBlock();
        Symbol oldSymbol = identNode.getSymbol();
        Symbol symbol = block.findSymbol(name);
        if (symbol != null) {
            if (Lower.isFunctionExpressionSelfReference(symbol)) {
                ((FunctionNode)symbol.getNode()).setNeedsSelfSymbol();
            }
            if (!identNode.isInitializedHere() && !this.localDefs.contains(name)) {
                symbol.setType(Type.OBJECT);
                symbol.setCanBeUndefined();
            }
            identNode.setSymbol(symbol);
            if (!this.getCurrentFunctionNode().isLocal(symbol) && !symbol.isScope()) {
                List<Block> lookupBlocks = Lower.findLookupBlocksHelper(this.getCurrentFunctionNode(), symbol.findFunction());
                for (Block lookupBlock : lookupBlocks) {
                    Symbol refSymbol = lookupBlock.findSymbol(name);
                    refSymbol.setIsScope();
                }
            }
        } else {
            symbol = block.useSymbol(name, identNode);
            symbol.setType(Type.OBJECT);
            symbol.setCanBeUndefined();
        }
        if (symbol != oldSymbol && !identNode.isInitializedHere()) {
            symbol.increaseUseCount();
        }
        this.localUses.add(identNode.getName());
        return null;
    }

    private static List<Block> findLookupBlocksHelper(FunctionNode currentFunction, FunctionNode topFunction) {
        if (currentFunction.findParentFunction() == topFunction) {
            LinkedList<Block> blocks = new LinkedList<Block>();
            blocks.add(currentFunction.getParent());
            blocks.addAll(currentFunction.getReferencingParentBlocks());
            return blocks;
        }
        return Lower.findLookupBlocksHelper(currentFunction.findParentFunction(), topFunction);
    }

    private static boolean isFunctionExpressionSelfReference(Symbol symbol) {
        if (symbol.isVar() && symbol.getNode() == symbol.getBlock() && symbol.getNode() instanceof FunctionNode) {
            return ((FunctionNode)symbol.getNode()).getIdent().getName().equals(symbol.getName());
        }
        return false;
    }

    @Override
    public Node enter(IfNode ifNode) {
        this.nest(ifNode);
        return ifNode;
    }

    @Override
    public Node leave(IfNode ifNode) {
        Node test = this.convert(ifNode.getTest(), Type.BOOLEAN);
        if (test.getSymbol().isConstant()) {
            Block shortCut;
            assert (test instanceof LiteralNode);
            Block block = shortCut = ((LiteralNode)test).isTrue() ? ifNode.getPass() : ifNode.getFail();
            if (shortCut != null) {
                for (Node statement : shortCut.getStatements()) {
                    this.statements.add(statement);
                }
            }
            return null;
        }
        Block pass = ifNode.getPass();
        Block fail = ifNode.getFail();
        if (pass.isTerminal() && fail != null && fail.isTerminal()) {
            ifNode.setIsTerminal(true);
        }
        ifNode.setTest(test);
        this.statements.add(ifNode);
        this.unnest();
        return ifNode;
    }

    @Override
    public Node leave(IndexNode indexNode) {
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, indexNode);
        return indexNode;
    }

    @Override
    public Node enter(LabelNode labeledNode) {
        Block body = labeledNode.getBody();
        body.accept(this);
        labeledNode.copyTerminalFlags(body);
        this.statements.add(labeledNode);
        return null;
    }

    @Override
    public Node enter(LineNumberNode lineNumberNode) {
        this.statements.add(lineNumberNode);
        return null;
    }

    private LiteralNode<?> newLiteral(LiteralNode<?> literalNode) {
        return Lower.newLiteral(this.getCurrentFunctionNode(), literalNode);
    }

    private static LiteralNode<?> newLiteral(FunctionNode functionNode, LiteralNode<?> literalNode) {
        functionNode.newLiteral(literalNode);
        return literalNode;
    }

    @Override
    public Node enter(LiteralNode literalNode) {
        if (literalNode.isTokenType(TokenType.THIS)) {
            literalNode.setSymbol(this.getCurrentFunctionNode().getThisNode().getSymbol());
            return null;
        }
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literalNode;
            Node[] array = (Node[])arrayLiteralNode.getValue();
            for (int i = 0; i < array.length; ++i) {
                Node element = array[i];
                if (element == null) continue;
                array[i] = array[i].accept(this);
            }
            arrayLiteralNode.analyze();
            Type elementType = arrayLiteralNode.getElementType();
            for (int i = 0; i < array.length; ++i) {
                Node element = array[i];
                if (element == null) continue;
                array[i] = this.convert(element, elementType);
            }
        } else {
            Node node;
            Object value = literalNode.getValue();
            if (value instanceof Node && (node = ((Node)value).accept(this)) != null) {
                return this.newLiteral(LiteralNode.newInstance(this.source, node.getToken(), node.getFinish(), node));
            }
        }
        this.newLiteral(literalNode);
        return null;
    }

    @Override
    public Node leave(ObjectNode objectNode) {
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, objectNode);
        return objectNode;
    }

    @Override
    public Node enter(PropertyNode propertyNode) {
        propertyNode.setSymbol(new Symbol(propertyNode.getKeyName(), 0, Type.OBJECT));
        return propertyNode;
    }

    @Override
    public Node enter(ReferenceNode referenceNode) {
        FunctionNode fn = referenceNode.getReference();
        if (fn != null) {
            fn.addReferencingParentBlock(this.getCurrentBlock());
        }
        return referenceNode;
    }

    @Override
    public Node leave(ReferenceNode referenceNode) {
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, referenceNode);
        return referenceNode;
    }

    private void setReturnExpression(ReturnNode returnNode, Node expression) {
        FunctionNode functionNode = this.getCurrentFunctionNode();
        returnNode.setExpression(expression);
        Symbol symbol = expression.getSymbol();
        if (expression.getType().isUnknown() && symbol.isParam()) {
            symbol.setType(Type.OBJECT);
        }
        functionNode.setReturnType(Type.widest(expression.getType(), functionNode.getReturnType()));
    }

    @Override
    public Node enter(ReturnNode returnNode) {
        TryNode tryNode = returnNode.getTryChain();
        Node expression = returnNode.getExpression();
        if (tryNode != null) {
            if (expression != null) {
                long token = returnNode.getToken();
                IdentNode resultNode = this.getCurrentFunctionNode().getResultNode();
                new ExecuteNode(this.source, token, Token.descPosition(token), new BinaryNode(this.source, Token.recast(token, TokenType.ASSIGN), resultNode, expression)).accept(this);
                if (this.copyFinally(tryNode, null)) {
                    return null;
                }
                this.setReturnExpression(returnNode, resultNode);
            } else if (this.copyFinally(tryNode, null)) {
                return null;
            }
        } else if (expression != null) {
            this.setReturnExpression(returnNode, expression.accept(this));
        }
        this.statements.add(returnNode);
        return null;
    }

    @Override
    public Node leave(RuntimeNode runtimeNode) {
        for (Node arg : runtimeNode.getArgs()) {
            Lower.ensureTypeNotUnknown(arg);
        }
        this.getCurrentFunctionNode().newTemporary(runtimeNode.getRequest().getReturnType(), runtimeNode);
        return runtimeNode;
    }

    @Override
    public Node enter(SwitchNode switchNode) {
        this.nest(switchNode);
        return switchNode;
    }

    @Override
    public Node leave(SwitchNode switchNode) {
        Node test;
        this.unnest();
        Node expression = switchNode.getExpression();
        List<CaseNode> cases = switchNode.getCases();
        CaseNode defaultCase = switchNode.getDefaultCase();
        boolean hasDefault = defaultCase != null;
        int n = cases.size() + (hasDefault ? -1 : 0);
        boolean allTerminal = !cases.isEmpty();
        boolean allInteger = n > 1;
        for (CaseNode caseNode : cases) {
            allTerminal &= caseNode.isTerminal();
            test = caseNode.getTest();
            if (test == null) continue;
            if (!(test instanceof LiteralNode) || !test.getType().isNumeric()) {
                allInteger = false;
                continue;
            }
            LiteralNode testLiteral = (LiteralNode)test;
            if (testLiteral.getValue() instanceof Integer) continue;
            if (!JSType.isRepresentableAsInt(testLiteral.getNumber())) {
                allInteger = false;
                continue;
            }
            caseNode.setTest(this.newLiteral(LiteralNode.newInstance(this.source, testLiteral.getToken(), testLiteral.getFinish(), testLiteral.getInt32())));
        }
        if (allTerminal && defaultCase != null && defaultCase.isTerminal()) {
            switchNode.setIsTerminal(true);
        }
        if (!allInteger) {
            switchNode.setExpression(this.convert(expression, Type.OBJECT));
            for (CaseNode caseNode : cases) {
                test = caseNode.getTest();
                if (test == null) continue;
                caseNode.setTest(this.convert(test, Type.OBJECT));
            }
        }
        String name = this.compiler.uniqueName(CompilerConstants.SWITCH_TAG_PREFIX.tag());
        Symbol tag = this.getCurrentFunctionNode().defineSymbol(name, 515, null);
        tag.setType(allInteger ? Type.INT : Type.OBJECT);
        switchNode.setTag(tag);
        this.statements.add(switchNode);
        return switchNode;
    }

    @Override
    public Node leave(ThrowNode throwNode) {
        throwNode.setExpression(this.convert(throwNode.getExpression(), Type.OBJECT));
        this.statements.add(throwNode);
        return throwNode;
    }

    @Override
    public Node enter(TryNode tryNode) {
        Block finallyBody = tryNode.getFinallyBody();
        Source tryNodeSource = tryNode.getSource();
        long token = tryNode.getToken();
        int finish = tryNode.getFinish();
        this.nest(tryNode);
        if (finallyBody == null) {
            return tryNode;
        }
        if (!tryNode.getCatchBlocks().isEmpty()) {
            TryNode innerTryNode = new TryNode(tryNodeSource, token, finish, tryNode.getNext());
            innerTryNode.setBody(tryNode.getBody());
            innerTryNode.setCatchBlocks(tryNode.getCatchBlocks());
            Block outerBody = new Block(tryNodeSource, token, finish, tryNode.getBody().getParent(), this.getCurrentFunctionNode());
            outerBody.setStatements(new ArrayList<Node>(Arrays.asList(innerTryNode)));
            tryNode.setBody(outerBody);
            tryNode.setCatchBlocks(null);
            innerTryNode.getBody().setParent(tryNode.getBody());
            for (Block block : innerTryNode.getCatchBlocks()) {
                block.setParent(tryNode.getBody());
            }
        }
        String name = this.compiler.uniqueName(CompilerConstants.EXCEPTION_PREFIX.tag());
        IdentNode exception = new IdentNode(tryNodeSource, token, finish, name);
        exception.accept(this);
        Block catchBlock = new Block(tryNodeSource, token, finish, this.getCurrentBlock(), this.getCurrentFunctionNode());
        Block catchBody = new Block(tryNodeSource, token, finish, catchBlock, this.getCurrentFunctionNode());
        Node catchAllFinally = finallyBody.clone();
        catchBody.addStatement(new ExecuteNode(tryNodeSource, finallyBody.getToken(), finallyBody.getFinish(), catchAllFinally));
        catchBody.setIsTerminal(true);
        CatchNode catchNode = new CatchNode(tryNodeSource, token, finish, new IdentNode(exception), null, catchBody);
        catchNode.setIsSyntheticRethrow();
        this.getCurrentFunctionNode().setHasThrows(true);
        catchBlock.addStatement(catchNode);
        tryNode.setCatchBlocks(new ArrayList<Block>(Arrays.asList(catchBlock)));
        return tryNode;
    }

    @Override
    public Node leave(TryNode tryNode) {
        Block finallyBody = tryNode.getFinallyBody();
        boolean allTerminal = tryNode.getBody().isTerminal() && (finallyBody == null || finallyBody.isTerminal());
        for (Block catchBlock : tryNode.getCatchBlocks()) {
            allTerminal &= catchBlock.isTerminal();
        }
        tryNode.setIsTerminal(allTerminal);
        String name = this.compiler.uniqueName(CompilerConstants.EXCEPTION_PREFIX.tag());
        Symbol exception = this.getCurrentFunctionNode().defineSymbol(name, 515, null);
        exception.setType(ECMAException.class);
        tryNode.setException(exception);
        this.statements.add(tryNode);
        this.unnest();
        if (finallyBody != null) {
            tryNode.setFinallyBody(null);
            this.statements.add(finallyBody);
        }
        return tryNode;
    }

    @Override
    public Node enter(VarNode varNode) {
        IdentNode ident = varNode.getName();
        String name = ident.getName();
        Symbol symbol = this.getCurrentBlock().defineSymbol(name, 3, ident);
        assert (symbol != null);
        varNode.setSymbol(symbol);
        this.declaredSymbolsLocal.add(symbol);
        if (this.localUses.contains(ident.getName())) {
            symbol.setType(Type.OBJECT);
            symbol.setCanBeUndefined();
        }
        return varNode;
    }

    private static boolean isScopeOrGlobal(Symbol symbol) {
        return symbol.getBlock().getFunction().isScript();
    }

    @Override
    public Node leave(VarNode varNode) {
        Node init = varNode.getInit();
        IdentNode ident = varNode.getName();
        String name = ident.getName();
        if (init != null) {
            this.localDefs.add(name);
        }
        if (varNode.shouldAppend()) {
            this.statements.add(varNode);
        }
        if (init == null) {
            this.localDefs.remove(name);
            return varNode;
        }
        Symbol symbol = varNode.getSymbol();
        if ((init.getType().isNumeric() || init.getType().isBoolean()) && !Lower.isScopeOrGlobal(symbol)) {
            Type type = Compiler.shouldUseIntegers() ? init.getType() : Type.NUMBER;
            varNode.setInit(this.convert(init, type));
            symbol.setType(type);
        } else {
            symbol.setType(Type.OBJECT);
        }
        return varNode;
    }

    @Override
    public Node enter(WhileNode whileNode) {
        this.nest(whileNode);
        return whileNode;
    }

    @Override
    public Node leave(WhileNode whileNode) {
        Node test = whileNode.getTest();
        if (test != null) {
            whileNode.setTest(this.convert(test, Type.BOOLEAN));
        } else {
            whileNode.setHasGoto();
        }
        WhileNode returnNode = whileNode;
        Block body = whileNode.getBody();
        boolean escapes = this.controlFlowEscapes(body);
        if (escapes) {
            body.setIsTerminal(false);
        }
        if (body.isTerminal()) {
            if (whileNode instanceof DoWhileNode) {
                whileNode.setIsTerminal(true);
            } else if (Lower.conservativeAlwaysTrue(test)) {
                returnNode = new ForNode(this.source, whileNode.getToken(), whileNode.getFinish());
                ((ForNode)returnNode).setBody(body);
                returnNode.setIsTerminal(!escapes);
            }
        }
        this.unnest();
        this.statements.add(returnNode);
        return returnNode;
    }

    @Override
    public Node leave(WithNode withNode) {
        withNode.setExpression(this.convert(withNode.getExpression(), Type.OBJECT));
        if (withNode.getBody().isTerminal()) {
            withNode.setIsTerminal(true);
        }
        this.statements.add(withNode);
        return withNode;
    }

    public Node leaveUnary(UnaryNode unaryNode, Type type) {
        LiteralNode<?> literalNode = new UnaryNodeConstantEvaluator(unaryNode).eval();
        if (literalNode != null) {
            return this.newLiteral(literalNode);
        }
        unaryNode.setRHS(this.convert(unaryNode.rhs(), type));
        this.getCurrentFunctionNode().newTemporary(type, unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveADD(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode, Type.NUMBER);
    }

    @Override
    public Node leaveBIT_NOT(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode, Type.INT);
    }

    @Override
    public Node leaveCONVERT(UnaryNode unaryNode) {
        Node rhs = unaryNode.rhs();
        if (rhs.isTokenType(TokenType.CONVERT)) {
            rhs.setSymbol(unaryNode.getSymbol());
            return rhs;
        }
        return unaryNode;
    }

    private static void ensureAssignmentSlots(final FunctionNode functionNode, Node assignmentDest) {
        assignmentDest.accept(new NodeVisitor(){

            @Override
            public Node leave(AccessNode accessNode) {
                Node base = accessNode.getBase();
                if (base.getSymbol().isThis()) {
                    functionNode.addThisProperty(accessNode.getProperty().getName(), accessNode);
                }
                return accessNode;
            }

            @Override
            public Node leave(IndexNode indexNode) {
                Node index = indexNode.getIndex();
                index.getSymbol().setNeedsSlot(!index.getSymbol().isConstant());
                return indexNode;
            }
        });
    }

    @Override
    public Node leaveDECINC(UnaryNode unaryNode) {
        Lower.ensureAssignmentSlots(this.getCurrentFunctionNode(), unaryNode.rhs());
        Type type = Compiler.shouldUseIntegerArithmetic() ? Type.INT : Type.NUMBER;
        unaryNode.rhs().getSymbol().setType(type);
        this.getCurrentFunctionNode().newTemporary(type, unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveDELETE(final UnaryNode unaryNode) {
        final boolean strictMode = this.getCurrentFunctionNode().isStrictMode();
        Node rhs = unaryNode.rhs();
        final long token = unaryNode.getToken();
        final int finish = unaryNode.getFinish();
        final LiteralNode<Boolean> trueNode = LiteralNode.newInstance(this.source, token, finish, true);
        final LiteralNode<Boolean> strictFlagNode = LiteralNode.newInstance(this.source, token, finish, strictMode);
        this.newLiteral(trueNode);
        this.newLiteral(strictFlagNode);
        final Lower lower = this;
        final FunctionNode currentFunctionNode = this.getCurrentFunctionNode();
        ResultNodeVisitor visitor = new ResultNodeVisitor(trueNode){

            private void initRuntimeNode(RuntimeNode node) {
                node.accept(lower);
                currentFunctionNode.newTemporary(Type.BOOLEAN, unaryNode);
                node.setSymbol(unaryNode.getSymbol());
                this.setResultNode(node);
            }

            @Override
            public Node enter(IdentNode node) {
                boolean failDelete = strictMode || node.getSymbol().isParam() || node.getSymbol().isVar() && !node.getSymbol().isTopLevel();
                LiteralNode literalNode = Lower.newLiteral(currentFunctionNode, LiteralNode.newInstance(Lower.this.source, node.getToken(), node.getFinish(), node.getName()));
                if (failDelete && CompilerConstants.THIS.tag().equals(node.getName())) {
                    Lower.this.statements.add(new ExecuteNode(Lower.this.source, token, finish, Lower.this.discard(node)));
                    currentFunctionNode.newTemporary(Type.BOOLEAN, trueNode);
                    return null;
                }
                ArrayList<Node> args = new ArrayList<Node>();
                args.add(Lower.this.convert(currentFunctionNode.getScopeNode(), Type.OBJECT));
                args.add(Lower.this.convert(literalNode, Type.OBJECT));
                args.add(strictFlagNode);
                this.initRuntimeNode(new RuntimeNode(Lower.this.source, token, finish, failDelete ? RuntimeNode.Request.FAIL_DELETE : RuntimeNode.Request.DELETE, args));
                return null;
            }

            @Override
            public Node enter(AccessNode node) {
                IdentNode property = node.getProperty();
                this.initRuntimeNode(new RuntimeNode(Lower.this.source, token, finish, RuntimeNode.Request.DELETE, Lower.this.convert(node.getBase(), Type.OBJECT), Lower.this.convert(Lower.newLiteral(currentFunctionNode, LiteralNode.newInstance(Lower.this.source, property.getToken(), property.getFinish(), property.getName())), Type.OBJECT), strictFlagNode));
                return null;
            }

            @Override
            public Node enter(IndexNode node) {
                this.initRuntimeNode(new RuntimeNode(Lower.this.source, token, finish, RuntimeNode.Request.DELETE, Lower.this.convert(node.getBase(), Type.OBJECT), Lower.this.convert(node.getIndex(), Type.OBJECT), strictFlagNode));
                return null;
            }

            @Override
            public Node enterDefault(Node node) {
                Lower.this.statements.add(new ExecuteNode(Lower.this.source, token, finish, Lower.this.discard(node)));
                currentFunctionNode.newTemporary(Type.BOOLEAN, trueNode);
                return null;
            }
        };
        rhs.accept(visitor);
        return visitor.getResultNode();
    }

    @Override
    public Node enterNEW(UnaryNode unaryNode) {
        CallNode callNode = (CallNode)unaryNode.rhs();
        callNode.setIsNew();
        Node function = callNode.getFunction();
        Node markedFunction = Lower.markerFunction(function);
        callNode.setFunction(markedFunction.accept(this));
        this.acceptArgs(callNode);
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, unaryNode);
        return null;
    }

    @Override
    public Node leaveNOT(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode, Type.BOOLEAN);
    }

    private LiteralNode<?> newNullLiteral(Node parent) {
        return this.newLiteral(LiteralNode.newInstance(parent.getSource(), parent.getToken(), parent.getFinish()));
    }

    @Override
    public Node leaveTYPEOF(UnaryNode unaryNode) {
        IdentNode ident;
        Node rhs = unaryNode.rhs();
        long token = unaryNode.getToken();
        int finish = unaryNode.getFinish();
        RuntimeNode runtimeNode = rhs instanceof IdentNode ? ((ident = (IdentNode)rhs).getSymbol().isParam() || ident.getSymbol().isVar() ? new RuntimeNode(this.source, token, finish, RuntimeNode.Request.TYPEOF, this.convert(rhs, Type.OBJECT), this.newNullLiteral(unaryNode)) : new RuntimeNode(this.source, token, finish, RuntimeNode.Request.TYPEOF, this.convert(this.getCurrentFunctionNode().getScopeNode(), Type.OBJECT), this.convert(this.newLiteral(LiteralNode.newInstance(this.source, ident.getToken(), ident.getFinish(), ident.getName())), Type.OBJECT))) : new RuntimeNode(this.source, token, finish, RuntimeNode.Request.TYPEOF, this.convert(rhs, Type.OBJECT), this.newNullLiteral(unaryNode));
        runtimeNode.accept(this);
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, unaryNode);
        runtimeNode.setSymbol(unaryNode.getSymbol());
        return runtimeNode;
    }

    @Override
    public Node leaveSUB(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode, Type.NUMBER);
    }

    @Override
    public Node leaveVOID(UnaryNode unaryNode) {
        Node rhs = unaryNode.rhs();
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, unaryNode);
        RuntimeNode runtimeNode = new RuntimeNode(this.source, unaryNode.getToken(), unaryNode.getFinish(), RuntimeNode.Request.VOID, this.convert(rhs, Type.OBJECT));
        runtimeNode.setSymbol(unaryNode.getSymbol());
        return runtimeNode;
    }

    private static Type binaryType(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        assert (lhs.hasType());
        Node rhs = binaryNode.rhs();
        assert (rhs.hasType());
        switch (binaryNode.tokenType()) {
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_SHL: 
            case ASSIGN_SAR: {
                return Compiler.shouldUseIntegers() ? Type.widest(lhs.getType(), rhs.getType(), Type.INT) : Type.INT;
            }
            case ASSIGN_SHR: {
                return Type.LONG;
            }
            case ASSIGN: {
                return Compiler.shouldUseIntegers() ? Type.widest(lhs.getType(), rhs.getType(), Type.NUMBER) : Type.NUMBER;
            }
        }
        return Lower.binaryArithType(lhs.getType(), rhs.getType());
    }

    private static Type binaryArithType(Type lhsType, Type rhsType) {
        if (!Compiler.shouldUseIntegerArithmetic()) {
            return Type.NUMBER;
        }
        return Type.widest(lhsType, rhsType, Type.NUMBER);
    }

    private Node leaveBinary(BinaryNode binaryNode, Type type) {
        return this.leaveBinary(binaryNode, type, type, type);
    }

    private Node leaveBinary(BinaryNode binaryNode, Type destType, Type lhsType, Type rhsType) {
        LiteralNode<?> literalNode = new BinaryNodeConstantEvaluator(binaryNode).eval();
        if (literalNode != null) {
            return this.newLiteral(literalNode);
        }
        if (lhsType != null) {
            binaryNode.setLHS(this.convert(binaryNode.lhs(), lhsType));
        }
        if (rhsType != null) {
            binaryNode.setRHS(this.convert(binaryNode.rhs(), rhsType));
        }
        this.getCurrentFunctionNode().newTemporary(destType, binaryNode);
        return binaryNode;
    }

    private boolean isAddString(Node node) {
        if (node instanceof BinaryNode && node.isTokenType(TokenType.ADD)) {
            BinaryNode binaryNode = (BinaryNode)node;
            Node lhs = binaryNode.lhs();
            Node rhs = binaryNode.rhs();
            return this.isAddString(lhs) || this.isAddString(rhs);
        }
        return node instanceof LiteralNode && ((LiteralNode)node).getObject() instanceof String;
    }

    private RuntimeNode newRuntime(Node parent, List<Node> args, RuntimeNode.Request request) {
        RuntimeNode runtimeNode = new RuntimeNode(this.source, parent.getToken(), parent.getFinish(), request, args);
        runtimeNode.setStart(parent.getStart());
        runtimeNode.setFinish(parent.getFinish());
        runtimeNode.accept(this);
        runtimeNode.setSymbol(parent.getSymbol());
        return runtimeNode;
    }

    private RuntimeNode newRuntime(BinaryNode binaryNode, RuntimeNode.Request request) {
        return this.newRuntime(binaryNode, Arrays.asList(binaryNode.lhs(), binaryNode.rhs()), request);
    }

    @Override
    public Node leaveADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Lower.ensureTypeNotUnknown(lhs);
        Lower.ensureTypeNotUnknown(rhs);
        if ((lhs.getType().isNumeric() || lhs.getType().isBoolean()) && (rhs.getType().isNumeric() || rhs.getType().isBoolean())) {
            return this.leaveBinary(binaryNode, Lower.binaryType(binaryNode));
        }
        if (!this.isAddString(binaryNode)) {
            this.getCurrentFunctionNode().newTemporary(Type.OBJECT, binaryNode);
            return this.newRuntime(binaryNode, RuntimeNode.Request.ADD);
        }
        binaryNode.setLHS(this.convert(lhs, Type.OBJECT));
        binaryNode.setRHS(this.convert(rhs, Type.OBJECT));
        this.getCurrentFunctionNode().newTemporary(Type.OBJECT, binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveAND(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.OBJECT, null, null);
    }

    private Node enterAssign(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        if (!(lhs instanceof IdentNode)) {
            return binaryNode;
        }
        Block block = this.getCurrentBlock();
        IdentNode ident = (IdentNode)lhs;
        String name = ident.getName();
        Symbol symbol = this.getCurrentBlock().findSymbol(name);
        if (symbol == null) {
            symbol = block.defineSymbol(name, 2, ident);
            binaryNode.setSymbol(symbol);
        } else if (!this.getCurrentFunctionNode().isLocal(symbol)) {
            symbol.setIsScope();
        }
        this.localDefs.add(name);
        return binaryNode;
    }

    private Node leaveAssign(BinaryNode binaryNode, Type destType) {
        binaryNode.lhs().getSymbol().setType(destType);
        this.getCurrentFunctionNode().newTemporary(destType, binaryNode);
        Lower.ensureAssignmentSlots(this.getCurrentFunctionNode(), binaryNode.lhs());
        return binaryNode;
    }

    @Override
    public Node enterASSIGN(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN(BinaryNode binaryNode) {
        Node baseNode;
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        if (rhs.getType().isNumeric()) {
            Symbol lhsSymbol = lhs.getSymbol();
            Type lhsType = Type.widest(lhs.getType(), Lower.binaryType(binaryNode));
            lhsSymbol.setType(lhsType);
            this.getCurrentFunctionNode().newTemporary(lhs.getType(), binaryNode);
            if (!(lhs instanceof IndexNode)) {
                binaryNode.setRHS(this.convert(rhs, lhsType));
            }
        } else {
            binaryNode.setRHS(this.convert(rhs, Type.OBJECT));
            this.getCurrentFunctionNode().newTemporary(Type.OBJECT, binaryNode);
            if (lhs instanceof IdentNode) {
                lhs.getSymbol().setType(Type.OBJECT);
            }
        }
        if (lhs instanceof AccessNode && (baseNode = ((AccessNode)lhs).getBase()).getSymbol().isThis()) {
            IdentNode property = ((AccessNode)lhs).getProperty();
            this.getCurrentFunctionNode().addThisProperty(property.getName(), property);
        }
        return binaryNode;
    }

    @Override
    public Node enterASSIGN_ADD(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        boolean bothNumeric = lhs.getType().isNumeric() && rhs.getType().isNumeric();
        return this.leaveAssign(binaryNode, bothNumeric ? Lower.binaryType(binaryNode) : Type.OBJECT);
    }

    @Override
    public Node enterASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_DIV(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_MOD(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_MUL(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_SAR(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_SHL(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_SHR(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node enterASSIGN_SUB(BinaryNode binaryNode) {
        return this.enterAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode binaryNode) {
        return this.leaveAssign(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node leaveBIT_AND(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT);
    }

    @Override
    public Node leaveBIT_OR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT);
    }

    @Override
    public Node leaveBIT_XOR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT);
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        binaryNode.setLHS(this.discard(binaryNode.lhs()));
        this.getCurrentFunctionNode().newTemporary(binaryNode.rhs().getType(), binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        binaryNode.setRHS(this.discard(binaryNode.rhs()));
        this.getCurrentFunctionNode().newTemporary(binaryNode.lhs().getType(), binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveDIV(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node leaveEQ(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ);
    }

    @Override
    public Node leaveEQ_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ_STRICT);
    }

    private Node leaveCmp(BinaryNode binaryNode, RuntimeNode.Request request) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        LiteralNode<?> literalNode = new BinaryNodeConstantEvaluator(binaryNode).eval();
        if (literalNode != null) {
            return this.newLiteral(literalNode);
        }
        this.getCurrentFunctionNode().newTemporary(request.getReturnType(), binaryNode);
        Lower.ensureTypeNotUnknown(lhs);
        Lower.ensureTypeNotUnknown(rhs);
        Type type = Type.widest(lhs.getType(), rhs.getType());
        if (type.isObject()) {
            return this.newRuntime(binaryNode, request);
        }
        if ((request.equals((Object)RuntimeNode.Request.EQ_STRICT) || request.equals((Object)RuntimeNode.Request.NE_STRICT)) && lhs.getType().isBoolean() != rhs.getType().isBoolean()) {
            boolean result = request.equals((Object)RuntimeNode.Request.NE_STRICT);
            LiteralNode<Boolean> resultNode = LiteralNode.newInstance(this.source, 0L, 0, result);
            boolean canSkipLHS = lhs instanceof LiteralNode;
            boolean canSkipRHS = rhs instanceof LiteralNode;
            if (canSkipLHS && canSkipRHS) {
                return resultNode.accept(this);
            }
            Node argNode = !canSkipLHS && !canSkipRHS ? new BinaryNode(this.source, Token.recast(binaryNode.getToken(), TokenType.COMMARIGHT), lhs, rhs) : (!canSkipLHS ? lhs : rhs);
            return new BinaryNode(this.source, Token.recast(binaryNode.getToken(), TokenType.COMMARIGHT), argNode, resultNode).accept(this);
        }
        binaryNode.setLHS(this.convert(lhs, type));
        binaryNode.setRHS(this.convert(rhs, type));
        return binaryNode;
    }

    @Override
    public Node leaveGE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GE);
    }

    @Override
    public Node leaveGT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GT);
    }

    private Node exitIN_INSTANCEOF(BinaryNode binaryNode, RuntimeNode.Request request) {
        this.getCurrentFunctionNode().newTemporary(request.getReturnType(), binaryNode);
        return this.newRuntime(binaryNode, request);
    }

    @Override
    public Node leaveIN(BinaryNode binaryNode) {
        return this.exitIN_INSTANCEOF(binaryNode, RuntimeNode.Request.IN);
    }

    @Override
    public Node leaveINSTANCEOF(BinaryNode binaryNode) {
        return this.exitIN_INSTANCEOF(binaryNode, RuntimeNode.Request.INSTANCEOF);
    }

    @Override
    public Node leaveLE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LE);
    }

    @Override
    public Node leaveLT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LT);
    }

    @Override
    public Node leaveMOD(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node leaveMUL(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node leaveNE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE);
    }

    @Override
    public Node leaveNE_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE_STRICT);
    }

    @Override
    public Node leaveOR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.OBJECT, null, null);
    }

    @Override
    public Node leaveSAR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT);
    }

    @Override
    public Node leaveSHL(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT);
    }

    @Override
    public Node leaveSHR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.LONG, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSUB(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Lower.binaryType(binaryNode));
    }

    @Override
    public Node leave(TernaryNode ternaryNode) {
        Node test = ternaryNode.lhs();
        Node lhs = ternaryNode.rhs();
        Node rhs = ternaryNode.third();
        Lower.ensureTypeNotUnknown(lhs);
        Lower.ensureTypeNotUnknown(rhs);
        Type type = Type.widest(lhs.getType(), rhs.getType());
        ternaryNode.setRHS(this.convert(lhs, type));
        ternaryNode.setThird(this.convert(rhs, type));
        if (test.getSymbol().isConstant()) {
            return ((LiteralNode)test).isTrue() ? lhs : rhs;
        }
        ternaryNode.setLHS(this.convert(test, Type.BOOLEAN));
        this.getCurrentFunctionNode().newTemporary(type, ternaryNode);
        return ternaryNode;
    }

    private static void ensureTypeNotUnknown(Node node) {
        Symbol symbol = node.getSymbol();
        if (node.getType().isUnknown() || symbol.isParam()) {
            symbol.setType(Type.OBJECT);
            symbol.setCanBeUndefined();
        }
    }

    private static class BinaryNodeConstantEvaluator
    extends ConstantEvaluator<BinaryNode> {
        BinaryNodeConstantEvaluator(BinaryNode parent) {
            super(parent);
        }

        @Override
        protected LiteralNode<?> eval() {
            double value;
            if (!((BinaryNode)this.parent).lhs().getSymbol().isConstant() || !((BinaryNode)this.parent).rhs().getSymbol().isConstant()) {
                return null;
            }
            LiteralNode lhs = (LiteralNode)((BinaryNode)this.parent).lhs();
            LiteralNode rhs = (LiteralNode)((BinaryNode)this.parent).rhs();
            Type widest = Type.widest(lhs.getType(), rhs.getType());
            boolean isInteger = widest.isInteger();
            boolean isLong = widest.isLong();
            switch (((BinaryNode)this.parent).tokenType()) {
                case AND: {
                    return JSType.toBoolean(lhs.getObject()) ? rhs : lhs;
                }
                case OR: {
                    return JSType.toBoolean(lhs.getObject()) ? lhs : rhs;
                }
                case DIV: {
                    value = lhs.getNumber() / rhs.getNumber();
                    break;
                }
                case ADD: {
                    value = lhs.getNumber() + rhs.getNumber();
                    break;
                }
                case MUL: {
                    value = lhs.getNumber() * rhs.getNumber();
                    break;
                }
                case MOD: {
                    value = lhs.getNumber() % rhs.getNumber();
                    break;
                }
                case SUB: {
                    value = lhs.getNumber() - rhs.getNumber();
                    break;
                }
                case SHR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, (long)(lhs.getInt32() >>> rhs.getInt32()) & 0xFFFFFFFFL);
                }
                case SAR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() >> rhs.getInt32());
                }
                case SHL: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() << rhs.getInt32());
                }
                case BIT_XOR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() ^ rhs.getInt32());
                }
                case BIT_AND: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() & rhs.getInt32());
                }
                case BIT_OR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() | rhs.getInt32());
                }
                case GE: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.GE(lhs.getObject(), rhs.getObject()));
                }
                case LE: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.LE(lhs.getObject(), rhs.getObject()));
                }
                case GT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.GT(lhs.getObject(), rhs.getObject()));
                }
                case LT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.LT(lhs.getObject(), rhs.getObject()));
                }
                case NE: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.NE(lhs.getObject(), rhs.getObject()));
                }
                case NE_STRICT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.NE_STRICT(lhs.getObject(), rhs.getObject()));
                }
                case EQ: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.EQ(lhs.getObject(), rhs.getObject()));
                }
                case EQ_STRICT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.EQ_STRICT(lhs.getObject(), rhs.getObject()));
                }
                default: {
                    return null;
                }
            }
            isLong &= value != 0.0 && JSType.isRepresentableAsLong(value);
            if (isInteger &= value != 0.0 && JSType.isRepresentableAsInt(value)) {
                return LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toInt32(value));
            }
            if (isLong) {
                return LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toLong(value));
            }
            return LiteralNode.newInstance(this.source, this.token, this.finish, value);
        }
    }

    private static class UnaryNodeConstantEvaluator
    extends ConstantEvaluator<UnaryNode> {
        UnaryNodeConstantEvaluator(UnaryNode parent) {
            super(parent);
        }

        @Override
        protected LiteralNode<?> eval() {
            LiteralNode<Serializable> literalNode;
            Node rhsNode = ((UnaryNode)this.parent).rhs();
            if (!rhsNode.getSymbol().isConstant()) {
                return null;
            }
            LiteralNode rhs = (LiteralNode)rhsNode;
            boolean rhsInteger = rhs.getType().isInteger();
            switch (((UnaryNode)this.parent).tokenType()) {
                case ADD: {
                    if (rhsInteger) {
                        literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, rhs.getInt32());
                        break;
                    }
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, rhs.getNumber());
                    break;
                }
                case SUB: {
                    if (rhsInteger && rhs.getInt32() != 0) {
                        literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, -rhs.getInt32());
                        break;
                    }
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, -rhs.getNumber());
                    break;
                }
                case NOT: {
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, !rhs.getBoolean());
                    break;
                }
                case BIT_NOT: {
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, ~rhs.getInt32());
                    break;
                }
                default: {
                    return null;
                }
            }
            return literalNode;
        }
    }

    static class LiteralNodeConstantEvaluator
    extends ConstantEvaluator<LiteralNode<?>> {
        private final Type type;

        LiteralNodeConstantEvaluator(LiteralNode<?> parent, Type type) {
            super(parent);
            this.type = type;
        }

        @Override
        protected LiteralNode<?> eval() {
            Object value = ((LiteralNode)this.parent).getValue();
            LiteralNode<Object> literalNode = null;
            if (this.type.isString()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toString(value));
            } else if (this.type.isBoolean()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toBoolean(value));
            } else if (this.type.isInteger()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toInt32(value));
            } else if (this.type.isLong()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toLong(value));
            } else if (this.type.isNumber() || ((LiteralNode)this.parent).getType().isNumeric() && !((LiteralNode)this.parent).getType().isNumber()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toNumber(value));
            }
            return literalNode;
        }
    }

    private static abstract class ConstantEvaluator<T extends Node> {
        protected T parent;
        protected final Source source;
        protected final long token;
        protected final int finish;

        protected ConstantEvaluator(T parent) {
            this.parent = parent;
            this.source = ((Location)parent).getSource();
            this.token = ((Location)parent).getToken();
            this.finish = ((Node)parent).getFinish();
        }

        protected abstract LiteralNode<?> eval();
    }

    private static abstract class ResultNodeVisitor
    extends NodeVisitor {
        private Node resultNode;

        ResultNodeVisitor(Node resultNode) {
            this.resultNode = resultNode;
        }

        Node getResultNode() {
            return this.resultNode;
        }

        void setResultNode(Node resultNode) {
            this.resultNode = resultNode;
        }
    }
}

