/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.List;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.runtime.ScriptFunction;

public final class FunctionSignature {
    private final Type[] paramTypes;
    private final Type returnType;
    private final String descriptor;

    public FunctionSignature(boolean hasSelf, Type retType, List<? extends Node> args) {
        this(hasSelf, false, retType, FunctionSignature.typeArray(args));
    }

    public FunctionSignature(boolean hasSelf, boolean hasCallee, Type retType, List<? extends Node> args) {
        this(hasSelf, hasCallee, retType, FunctionSignature.typeArray(args));
    }

    public FunctionSignature(boolean hasSelf, Type retType, int nArgs) {
        this(hasSelf, false, retType, FunctionSignature.objectArgs(nArgs));
    }

    public FunctionSignature(boolean hasSelf, boolean hasCallee, Type retType, Type ... argTypes) {
        boolean isVarArg;
        int count = 1;
        if (argTypes == null) {
            isVarArg = true;
        } else {
            isVarArg = argTypes.length > 250;
            count = isVarArg ? 1 : argTypes.length;
        }
        int first = 0;
        if (hasSelf) {
            ++count;
            ++first;
        }
        if (hasCallee) {
            ++count;
            ++first;
        }
        this.paramTypes = new Type[count];
        if (hasSelf) {
            this.paramTypes[CompilerConstants.THIS.slot()] = Type.OBJECT;
        }
        if (hasCallee) {
            this.paramTypes[CompilerConstants.CALLEE.slot()] = Type.typeFor(ScriptFunction.class);
        }
        if (isVarArg) {
            this.paramTypes[first] = Type.OBJECT_ARRAY;
        } else if (argTypes != null) {
            int i = first;
            int j = 0;
            while (i < count) {
                this.paramTypes[i] = argTypes[j];
                if (this.paramTypes[i].isObject()) {
                    this.paramTypes[i] = Type.OBJECT;
                }
                ++i;
                ++j;
            }
        } else assert (false) : "isVarArgs cannot be false when argTypes are null";
        this.returnType = retType;
        this.descriptor = Type.getMethodDescriptor(this.returnType, this.paramTypes);
    }

    private static Type[] typeArray(List<? extends Node> args) {
        if (args == null) {
            return null;
        }
        Type[] typeArray = new Type[args.size()];
        int pos = 0;
        for (Node node : args) {
            typeArray[pos++] = node.getType();
        }
        return typeArray;
    }

    public String toString() {
        return this.descriptor;
    }

    public int size() {
        return this.paramTypes.length;
    }

    public static String functionSignature(FunctionNode functionNode) {
        return new FunctionSignature(true, functionNode.needsCallee(), functionNode.getReturnType(), (List<? extends Node>)(functionNode.isVarArg() && !functionNode.isScript() ? null : functionNode.getParameters())).toString();
    }

    private static Type[] objectArgs(int nArgs) {
        Type[] array = new Type[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            array[i] = Type.OBJECT;
        }
        return array;
    }
}

