/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.ConstantData;
import jdk.nashorn.internal.codegen.Lower;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.Namespace;
import jdk.nashorn.internal.codegen.Splitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.debug.PrintVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Mangler;
import jdk.nashorn.internal.runtime.options.Options;
import jdk.nashorn.internal.scripts.JS$;

public final class Compiler {
    private final Context context;
    private final Source source;
    private final ErrorManager errors;
    private final Namespace namespace;
    private FunctionNode functionNode;
    private final EnumSet<State> state;
    public static final String SCRIPTS_PACKAGE = "jdk/nashorn/internal/scripts";
    public static final String OBJECTS_PACKAGE = "jdk/nashorn/internal/objects";
    public static final String GLOBAL_OBJECT = "jdk/nashorn/internal/objects/Global";
    public static final String SCRIPTOBJECT_IMPL_OBJECT = "jdk/nashorn/internal/objects/ScriptFunctionImpl";
    public static final String TRAMPOLINE_OBJECT = "jdk/nashorn/internal/objects/Trampoline";
    private final Set<CompileUnit> compileUnits;
    private final ConstantData constantData;
    static final DebugLogger LOG = new DebugLogger("compiler");
    private String scriptName;
    private final boolean dumpClass;
    private Map<String, byte[]> code;
    private boolean strict;
    private boolean isLazy;
    private static final boolean LAZY_JIT = false;
    private static final boolean USE_INTS = !Options.getBooleanProperty("nashorn.compiler.ints.disable");
    private static final boolean USE_INT_ARITH = Options.getBooleanProperty("nashorn.compiler.intarithmetic");

    static boolean shouldUseIntegers() {
        return USE_INTS;
    }

    static boolean shouldUseIntegerArithmetic() {
        return Compiler.shouldUseIntegers() && USE_INT_ARITH;
    }

    public static Compiler compiler(Source source, Context context) {
        return Compiler.compiler(source, context, context.getErrors(), context._strict);
    }

    public static Compiler compiler(Source source, Context context, ErrorManager errors, boolean strict) {
        return new Compiler(source, context, errors, strict);
    }

    public static Compiler compiler(Compiler compiler, FunctionNode functionNode) {
        assert (false) : "lazy jit - not implemented";
        Compiler newCompiler = new Compiler(compiler);
        newCompiler.state.add(State.PARSED);
        newCompiler.functionNode = functionNode;
        newCompiler.isLazy = true;
        return compiler;
    }

    private Compiler(Compiler compiler) {
        this(compiler.source, compiler.context, compiler.errors, compiler.strict);
    }

    private Compiler(Source source, Context context, ErrorManager errors, boolean strict) {
        this.source = source;
        this.context = context;
        this.errors = errors;
        this.strict = strict;
        this.namespace = new Namespace(context.getNamespace());
        this.compileUnits = new HashSet<CompileUnit>();
        this.constantData = new ConstantData();
        this.state = EnumSet.of(State.INITIALIZED);
        this.dumpClass = context._compile_only && context._dest_dir != null;
    }

    private String scriptsPackageName() {
        return this.dumpClass ? "" : "jdk/nashorn/internal/scripts/";
    }

    private int nextCompileUnitIndex() {
        return this.compileUnits.size() + 1;
    }

    private String firstCompileUnitName() {
        return this.scriptsPackageName() + this.scriptName;
    }

    private String nextCompileUnitName() {
        return this.firstCompileUnitName() + '$' + this.nextCompileUnitIndex();
    }

    private CompileUnit addCompileUnit(long initialWeight) {
        return this.addCompileUnit(this.nextCompileUnitName(), initialWeight);
    }

    private CompileUnit addCompileUnit(String unitClassName, long initialWeight) {
        CompileUnit compileUnit = this.initCompileUnit(unitClassName, initialWeight);
        this.compileUnits.add(compileUnit);
        LOG.info("Added compile unit " + compileUnit);
        return compileUnit;
    }

    private CompileUnit initCompileUnit(String unitClassName, long initialWeight) {
        ClassEmitter classEmitter = new ClassEmitter(this, unitClassName, this.strict);
        CompileUnit compileUnit = new CompileUnit(unitClassName, classEmitter, initialWeight);
        classEmitter.begin();
        MethodEmitter initMethod = classEmitter.init(EnumSet.of(ClassEmitter.Flag.PRIVATE), new Class[0]);
        initMethod.begin();
        initMethod.load(Type.OBJECT, 0);
        initMethod.newInstance(JS$.class);
        initMethod.returnVoid();
        initMethod.end();
        return compileUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile() {
        assert (this.state.contains((Object)State.INITIALIZED));
        if (!this.state.contains((Object)State.PARSED)) {
            assert (this.functionNode == null);
            this.functionNode = new Parser(this, this.strict).parse(CompilerConstants.RUN_SCRIPT.tag());
            this.state.add(State.PARSED);
            this.debugPrintParse();
            if (this.errors.hasErrors() || this.context._parse_only) {
                return false;
            }
            assert (!this.isLazy);
            this.functionNode.accept(new NodeVisitor(){

                @Override
                public Node enter(FunctionNode node) {
                    return node;
                }
            });
        } else {
            assert (this.isLazy);
            this.functionNode.accept(new NodeVisitor(){

                @Override
                public Node enter(FunctionNode node) {
                    node.setIsLazy(false);
                    return null;
                }
            });
        }
        assert (this.functionNode != null);
        boolean oldStrict = this.strict;
        try {
            this.strict |= this.functionNode.isStrictMode();
            if (!this.state.contains((Object)State.LOWERED)) {
                this.debugPrintAST();
                this.functionNode.accept(new Lower(this));
                this.state.add(State.LOWERED);
                if (this.errors.hasErrors()) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.scriptName = this.computeNames();
            CompileUnit scriptCompileUnit = this.addCompileUnit(this.firstCompileUnitName(), 0L);
            new Splitter(this, this.functionNode, scriptCompileUnit).split();
            assert (this.functionNode.getCompileUnit() == scriptCompileUnit);
            assert (this.strict == this.functionNode.isStrictMode()) : "strict == " + this.strict + " but functionNode == " + this.functionNode.isStrictMode();
            if (this.functionNode.isStrictMode()) {
                this.strict = true;
            }
            try {
                CodeGenerator codegen = new CodeGenerator(this);
                this.functionNode.accept(codegen);
                codegen.generateScopeCalls();
                this.debugPrintAST();
                this.debugPrintParse();
            }
            catch (VerifyError e) {
                if (this.context._verify_code || this.context._print_code) {
                    this.context.getErr().println(e.getClass().getSimpleName() + ": " + e.getMessage());
                    if (this.context._dump_on_error) {
                        e.printStackTrace(this.context.getErr());
                    }
                }
                throw e;
            }
            this.state.add(State.EMITTED);
            this.code = new TreeMap<String, byte[]>();
            for (CompileUnit compileUnit : this.compileUnits) {
                byte[] bytecode;
                ClassEmitter classEmitter = compileUnit.getClassEmitter();
                classEmitter.end();
                if (this.errors.hasErrors() || (bytecode = classEmitter.toByteArray()) == null) continue;
                this.code.put(compileUnit.getUnitClassName(), bytecode);
                this.debugDisassemble();
                this.debugVerify();
            }
            if (this.code.isEmpty()) {
                boolean i$ = false;
                return i$;
            }
            try {
                this.dumpClassFiles();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.strict = oldStrict;
        }
    }

    public Class<?> install(CodeInstaller installer) {
        assert (this.state.contains((Object)State.EMITTED));
        assert (this.scriptName != null);
        Class<?> rootClass = null;
        for (Map.Entry<String, byte[]> entry : this.code.entrySet()) {
            String className = entry.getKey();
            LOG.info("Installing class " + className);
            byte[] bytecode = entry.getValue();
            Class<?> clazz = installer.install(Compiler.binaryName(className), bytecode);
            if (rootClass == null && this.firstCompileUnitName().equals(className)) {
                rootClass = clazz;
            }
            try {
                clazz.getField(CompilerConstants.SOURCE.tag()).set(null, this.source);
                clazz.getField(CompilerConstants.CONSTANTS.tag()).set(null, this.constantData.toArray());
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        LOG.info("Root class: " + rootClass);
        return rootClass;
    }

    CompileUnit findUnit(long weight) {
        for (CompileUnit unit : this.compileUnits) {
            if (!unit.canHold(weight)) continue;
            unit.addWeight(weight);
            return unit;
        }
        return this.addCompileUnit(weight);
    }

    public String uniqueName(String name) {
        return this.namespace.uniqueName(name);
    }

    private String computeNames() {
        this.addReservedNames();
        if (this.dumpClass) {
            String baseName = this.getSource().getName();
            int index = baseName.lastIndexOf(".js");
            if (index != -1) {
                return baseName.substring(0, index);
            }
            return baseName;
        }
        return this.namespace.getParent().uniqueName(CompilerConstants.DEFAULT_SCRIPT_NAME.tag() + '$' + Compiler.safeSourceName(this.source) + (this.isLazy ? CompilerConstants.LAZY.tag() : ""));
    }

    private static String safeSourceName(Source source) {
        String mangled;
        String baseName = new File(source.getName()).getName();
        int index = baseName.lastIndexOf(".js");
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        baseName = (mangled = Mangler.mangle(baseName = baseName.replace('.', '_').replace('-', '_'))) != null ? mangled : baseName;
        return baseName;
    }

    static void verify(Context context, byte[] code) {
        context.verify(code);
    }

    private void addReservedNames() {
        this.namespace.uniqueName(CompilerConstants.SCOPE.tag());
        this.namespace.uniqueName(CompilerConstants.THIS.tag());
    }

    public ConstantData getConstantData() {
        return this.constantData;
    }

    public Context getContext() {
        return this.context;
    }

    public Source getSource() {
        return this.source;
    }

    public ErrorManager getErrors() {
        return this.errors;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    private void debugPrintAST() {
        assert (this.functionNode != null);
        if (this.context._print_lower_ast && this.state.contains((Object)State.LOWERED) || this.context._print_ast && !this.state.contains((Object)State.LOWERED)) {
            this.context.getErr().println(new ASTWriter(this.functionNode));
        }
    }

    private boolean debugPrintParse() {
        if (this.errors.hasErrors()) {
            return false;
        }
        assert (this.functionNode != null);
        if (this.context._print_lower_parse && this.state.contains((Object)State.LOWERED) || this.context._print_parse && !this.state.contains((Object)State.LOWERED)) {
            PrintVisitor pv = new PrintVisitor();
            this.functionNode.accept(pv);
            this.context.getErr().print(pv);
            this.context.getErr().flush();
        }
        return true;
    }

    private void debugDisassemble() {
        assert (this.code != null);
        if (this.context._print_code) {
            for (Map.Entry<String, byte[]> entry : this.code.entrySet()) {
                this.context.getErr().println("CLASS: " + entry.getKey());
                this.context.getErr().println();
                ClassEmitter.disassemble(this.context, entry.getValue());
                this.context.getErr().println("======");
            }
        }
    }

    private void debugVerify() {
        if (this.context._verify_code) {
            for (Map.Entry<String, byte[]> entry : this.code.entrySet()) {
                Compiler.verify(this.context, entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpClassFiles() throws IOException {
        if (this.context._dest_dir == null) {
            return;
        }
        assert (this.code != null);
        for (Map.Entry<String, byte[]> entry : this.code.entrySet()) {
            File dir;
            String className = entry.getKey();
            String fileName = className.replace('.', File.separatorChar) + ".class";
            int index = fileName.lastIndexOf(File.separatorChar);
            if (index != -1 && !(dir = new File(fileName.substring(0, index))).exists() && !dir.mkdirs()) {
                throw new IOException(ECMAErrors.getMessage("io.error.cant.write", dir.toString()));
            }
            byte[] bytecode = entry.getValue();
            File outFile = new File(this.context._dest_dir, fileName);
            FileOutputStream fos = new FileOutputStream(outFile);
            try {
                fos.write(bytecode);
            }
            finally {
                fos.close();
            }
        }
    }

    public static String binaryName(String name) {
        return name.replace('/', '.');
    }

    public static String pathName(String name) {
        return name.replace('.', '/');
    }

    static {
        assert (!USE_INT_ARITH) : "Integer arithmetic is not enabled";
    }

    public static enum State {
        INITIALIZED,
        PARSED,
        LOWERED,
        EMITTED;

    }
}

