/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import jdk.nashorn.internal.codegen.ClassEmitter;

public class CompileUnit {
    private final String className;
    private final ClassEmitter classEmitter;
    private long weight;

    CompileUnit(String className, ClassEmitter classEmitter) {
        this(className, classEmitter, 0L);
    }

    CompileUnit(String className, ClassEmitter classEmitter, long initialWeight) {
        this.className = className;
        this.classEmitter = classEmitter;
        this.weight = initialWeight;
    }

    public void addWeight(long w) {
        this.weight += w;
    }

    public long getWeight() {
        return this.weight;
    }

    public boolean canHold(long w) {
        return this.weight + w < 32768L;
    }

    public ClassEmitter getClassEmitter() {
        return this.classEmitter;
    }

    public String getUnitClassName() {
        return this.className;
    }

    public String toString() {
        return "[classname=" + this.className + " weight=" + this.weight + '/' + 32768L + ']';
    }
}

