/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.HashSet;
import jdk.nashorn.internal.codegen.Transform;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;

final class AccessSpecializer
extends NodeOperatorVisitor
implements Transform {
    private static final DebugLogger LOG = new DebugLogger("access", "nashorn.callsiteaccess.debug");
    private static final boolean DEBUG = LOG.isEnabled();

    AccessSpecializer() {
    }

    @Override
    public Node enter(FunctionNode node) {
        if (node.isTransformApplied(AccessSpecializer.class)) {
            return null;
        }
        return node;
    }

    @Override
    public Node leave(FunctionNode node) {
        node.registerTransform(AccessSpecializer.class);
        return node;
    }

    @Override
    public Node leave(VarNode varNode) {
        if (varNode.isAssignment()) {
            return AccessSpecializer.leaveAssign(varNode);
        }
        return varNode;
    }

    @Override
    public Node leave(CallNode callNode) {
        Node function = callNode.getFunction();
        if (function instanceof ReferenceNode) {
            AccessSpecializer.changeType(callNode, ((ReferenceNode)function).getReference().getType());
        }
        return callNode;
    }

    @Override
    public Node leaveASSIGN(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode binaryNode) {
        return AccessSpecializer.leaveAssign(binaryNode);
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        return AccessSpecializer.propagateResultType(binaryNode, binaryNode.lhs().getType());
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        return AccessSpecializer.propagateResultType(binaryNode, binaryNode.rhs().getType());
    }

    @Override
    public Node leaveCONVERT(UnaryNode unaryNode) {
        Type castTo = unaryNode.getType();
        Node rhs = unaryNode.rhs();
        while (rhs.tokenType() == TokenType.CONVERT) {
            rhs = ((UnaryNode)rhs).rhs();
        }
        if (AccessSpecializer.canHaveCallSiteType(rhs) && AccessSpecializer.isSupportedCallSiteType(castTo)) {
            AccessSpecializer.changeType(rhs, castTo);
            AccessSpecializer.fine("*** cast: converting " + AccessSpecializer.debugNode(unaryNode) + " to " + AccessSpecializer.debugNode(rhs));
            return rhs;
        }
        if (unaryNode.getType().isEquivalentTo(rhs.getType())) {
            return rhs;
        }
        return unaryNode;
    }

    @Override
    public Node leaveDECINC(UnaryNode unaryNode) {
        assert (unaryNode.isAssignment());
        Node dest = unaryNode.getAssignmentDest();
        if (AccessSpecializer.canHaveCallSiteType(dest) && AccessSpecializer.isSupportedCallSiteType(unaryNode.getType())) {
            AccessSpecializer.changeTypeInAssignment(dest, unaryNode.getType());
        }
        return unaryNode;
    }

    private static boolean canHaveCallSiteType(Node node) {
        return node instanceof TypeOverride && ((TypeOverride)((Object)node)).canHaveCallSiteType();
    }

    private static boolean isSupportedCallSiteType(Type castTo) {
        return castTo.isNumeric();
    }

    private static Node convert(Node node) {
        return new UnaryNode(node.getSource(), Token.recast(node.getToken(), TokenType.CONVERT), node);
    }

    private static Node leaveAssign(Node node) {
        assert (node.isAssignment()) : node + " is not an assignment";
        Object lhs = ((Assignment)((Object)node)).getAssignmentDest();
        Node rhs = ((Assignment)((Object)node)).getAssignmentSource();
        Symbol lhsSymbol = ((Node)lhs).getSymbol();
        if (lhsSymbol.hasSlot() && !lhsSymbol.isScope()) {
            AccessSpecializer.finest(((Node)lhs).getSymbol() + " has slot!");
            if (!((Node)lhs).getType().isEquivalentTo(rhs.getType())) {
                AccessSpecializer.finest("\tslot assignment: " + ((Node)lhs).getType() + " " + rhs.getType() + " " + AccessSpecializer.debugNode(node));
                Node c = AccessSpecializer.convert(rhs);
                c.setSymbol(lhsSymbol);
                ((Assignment)((Object)node)).setAssignmentSource(c);
                AccessSpecializer.fine("*** slot assignment turned to : " + AccessSpecializer.debugNode(node));
            } else {
                AccessSpecializer.finest("aborted - type equivalence between lhs and rhs");
            }
            return node;
        }
        if (lhs instanceof IdentNode && ((IdentNode)lhs).isSpecialIdentity()) {
            return node;
        }
        Type castTo = rhs.getType();
        if (!AccessSpecializer.canHaveCallSiteType(lhs)) {
            return node;
        }
        while (rhs.tokenType() == TokenType.CONVERT) {
            rhs = ((UnaryNode)rhs).rhs();
            castTo = Type.narrowest(rhs.getType(), castTo);
        }
        Type widestOperationType = node.getWidestOperationType();
        AccessSpecializer.finest("node wants to be " + castTo + " and its widest operation is " + widestOperationType);
        if (widestOperationType != castTo && Type.widest(castTo, widestOperationType) == castTo) {
            AccessSpecializer.info("###" + node + " castTo was " + castTo + " but could be downgraded to " + node.getWidestOperationType());
            castTo = node.getWidestOperationType();
            if (rhs instanceof TypeOverride) {
                AccessSpecializer.changeType(rhs, castTo);
            }
        }
        if (node.isSelfModifying()) {
            castTo = Type.widest(widestOperationType, castTo);
        }
        if (AccessSpecializer.isSupportedCallSiteType(castTo)) {
            if (rhs.getType() != castTo) {
                AccessSpecializer.finest("cast was necessary, abort: " + node + " " + rhs.getType() + " != " + castTo);
                return node;
            }
            AccessSpecializer.finest("assign: " + AccessSpecializer.debugNode(node));
            AccessSpecializer.changeTypeInAssignment(lhs, castTo);
            ((Assignment)((Object)node)).setAssignmentSource(rhs);
            AccessSpecializer.info("### modified to " + AccessSpecializer.debugNode(node) + " (given type override " + castTo + ")");
            AccessSpecializer.propagateResultType(node, castTo);
        }
        return node;
    }

    private static Node propagateResultType(Node node, Type type) {
        if (AccessSpecializer.isSupportedCallSiteType(type) && node.getSymbol().isTemp()) {
            AccessSpecializer.finest("changing temporary type: " + AccessSpecializer.debugNode(node) + " to " + type);
            node.getSymbol().setTypeOverride(type);
            AccessSpecializer.info("### node modified to " + AccessSpecializer.debugNode(node) + " (given type override " + type + ")");
        }
        return node;
    }

    private static void changeTypeInAssignment(Node dest, final Type newType) {
        if (AccessSpecializer.changeType(dest, newType)) {
            AccessSpecializer.finest("changed assignment " + dest + " " + dest.getSymbol());
            assert (!newType.isObject());
            final HashSet exclude = new HashSet();
            dest.accept(new NodeVisitor(){

                private void setCanBePrimitive(Symbol symbol) {
                    AccessSpecializer.fine("*** can be primitive symbol " + symbol + " " + Debug.id(symbol));
                    symbol.setCanBePrimitive(newType);
                }

                @Override
                public Node enter(IdentNode identNode) {
                    if (!exclude.contains(identNode)) {
                        this.setCanBePrimitive(identNode.getSymbol());
                    }
                    return null;
                }

                @Override
                public Node enter(AccessNode accessNode) {
                    this.setCanBePrimitive(accessNode.getProperty().getSymbol());
                    return null;
                }

                @Override
                public Node enter(IndexNode indexNode) {
                    exclude.add(indexNode.getBase());
                    return indexNode;
                }
            });
        }
    }

    private static boolean changeType(Node node, Type newType) {
        if (!node.getType().equals(newType)) {
            ((TypeOverride)((Object)node)).setType(newType);
            return true;
        }
        return false;
    }

    private static String debugNode(Node node) {
        if (DEBUG) {
            return node.toString();
        }
        return "";
    }

    private static void info(String str) {
        LOG.info(str);
    }

    private static void fine(String str) {
        LOG.fine(str);
    }

    private static void finest(String str) {
        LOG.finest(str);
    }
}

