/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.api.scripting;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.options.Options;

public final class NashornScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private final ScriptEngineFactory factory;
    private final Context nashornContext;
    private final ScriptObject global;
    private static final String[] DEFAULT_OPTIONS = new String[]{"-scripting", "-af", "-doe"};

    NashornScriptEngine(NashornScriptEngineFactory factory) {
        this(factory, DEFAULT_OPTIONS);
    }

    NashornScriptEngine(NashornScriptEngineFactory factory, String[] args) {
        this.factory = factory;
        final Options options = new Options("nashorn");
        options.process(args);
        final Context.ThrowErrorManager errors = new Context.ThrowErrorManager();
        this.nashornContext = AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                try {
                    return new Context(options, errors);
                }
                catch (RuntimeException e) {
                    if (Context.DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
        });
        this.global = this.nashornContext.createGlobal();
        this.global.addOwnProperty("context", 2, this.context);
        this.global.addOwnProperty("engine", 2, this);
        this.global.addOwnProperty("arguments", 2, ScriptRuntime.UNDEFINED);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ScriptException {
                    NashornScriptEngine.this.evalEngineScript();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (Context.DEBUG) {
                e.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        try {
            return this.evalImpl(Source.readFully(reader), ctxt);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        return this.evalImpl(script.toCharArray(), ctxt);
    }

    @Override
    public Object get(String key) {
        Object value = super.get(key);
        if (value == null) {
            value = ScriptObjectMirror.wrap(this.global.get(key), this.global);
        }
        return value == ScriptRuntime.UNDEFINED ? null : value;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            return this.asCompiledScript(this.compileImpl(Source.readFully(reader), this.context));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public CompiledScript compile(String str) throws ScriptException {
        return this.asCompiledScript(this.compileImpl(str.toCharArray(), this.context));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    @Override
    public Object invokeMethod(Object self, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (self == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        return this.invokeImpl(self, name, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getInterfaceInner(Object self, Class<T> clazz) {
        Object realSelf = self == null ? this.global : (!(self instanceof ScriptObject) ? ScriptObjectMirror.unwrap(self, this.global) : self);
        try {
            ScriptObject oldGlobal = Context.getGlobal();
            try {
                if (oldGlobal != this.global) {
                    NashornScriptEngine.setNashornGlobal(this.global);
                }
                T t = clazz.cast(JavaAdapterFactory.getConstructor(realSelf.getClass(), clazz).invoke(realSelf));
                return t;
            }
            finally {
                if (oldGlobal != this.global) {
                    NashornScriptEngine.setNashornGlobal(oldGlobal);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.getInterfaceInner(null, clazz);
    }

    @Override
    public <T> T getInterface(Object self, Class<T> clazz) {
        if (self == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        return this.getInterfaceInner(self, clazz);
    }

    public Object __noSuchProperty__(Object self, ScriptContext ctxt, String name) {
        int scope = ctxt.getAttributesScope(name);
        if (scope != -1) {
            return ScriptObjectMirror.unwrap(ctxt.getAttribute(name, scope), this.global);
        }
        if (self == ScriptRuntime.UNDEFINED) {
            ECMAErrors.referenceError(this.global, "not.defined", name);
        }
        return ScriptRuntime.UNDEFINED;
    }

    public Object __noSuchMethod__(Object self, ScriptContext ctxt, String name, Object args) {
        Method method;
        int mods;
        int scope = ctxt.getAttributesScope(name);
        if (scope == -1) {
            if (self == ScriptRuntime.UNDEFINED) {
                ECMAErrors.referenceError(this.global, "not.defined", name);
            } else {
                ECMAErrors.typeError(this.global, "no.such.function", name, ScriptRuntime.safeToString(this.global));
            }
            return ScriptRuntime.UNDEFINED;
        }
        Object value = ctxt.getAttribute(name, scope);
        value = ScriptObjectMirror.unwrap(value, this.global);
        if (value instanceof Method && Modifier.isStatic(mods = (method = (Method)value).getModifiers()) && Modifier.isPublic(mods)) {
            value = Lookup.MH.find((Method)value);
        }
        if (value instanceof MethodHandle) {
            value = ((GlobalObject)((Object)this.global)).newScriptFunction(name, (MethodHandle)value, null, false);
        }
        if (!(value instanceof ScriptFunction)) {
            ECMAErrors.typeError(this.global, "not.a.function", name);
        }
        if (value instanceof ScriptFunction) {
            return ScriptObjectMirror.unwrap(ScriptRuntime.apply((ScriptFunction)value, this.global, args), this.global);
        }
        ECMAErrors.typeError(this.global, "not.a.function", ScriptRuntime.safeToString(name));
        return ScriptRuntime.UNDEFINED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalEngineScript() throws ScriptException {
        URL url = NashornScriptEngine.class.getResource("resources/engine.js");
        try {
            InputStream is = url.openStream();
            this.put("javax.script.filename", url);
            InputStreamReader isr = new InputStreamReader(is);
            try {
                this.eval(isr);
            }
            finally {
                isr.close();
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        finally {
            this.put("javax.script.filename", null);
        }
    }

    private void setContextVariables(ScriptContext ctxt) {
        ctxt.setAttribute("context", ctxt, 100);
        this.global.set((Object)"context", (Object)ctxt, false);
        Object args = ctxt.getAttribute("arguments");
        if (args == null) {
            args = ScriptRuntime.EMPTY_ARRAY;
        }
        args = ((GlobalObject)((Object)this.global)).wrapAsObject(args);
        this.global.set((Object)"arguments", args, false);
    }

    private Object invokeImpl(Object selfObject, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        ScriptObject oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        Object self = selfObject;
        try {
            Object value;
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(this.global);
            }
            if ((self = ScriptObjectMirror.unwrap(self, this.global)) instanceof ScriptObject) {
                ScriptObject sobj = (ScriptObject)self;
                value = sobj.get(name);
            } else if (self == null) {
                self = this.global;
                ScriptObject sobj = this.global;
                value = sobj.get(name);
            } else {
                Method[] methods = self.getClass().getMethods();
                Method target = null;
                for (Method mth : methods) {
                    if (!mth.getName().equals(name) || mth.getParameterTypes().length != args.length) continue;
                    target = mth;
                    break;
                }
                if (target == null) {
                    throw new NoSuchMethodException(name);
                }
                GlobalObject gobj = (GlobalObject)((Object)this.global);
                value = gobj.newScriptFunction(name, Lookup.MH.find(target), null, false);
            }
            if (value instanceof ScriptFunction) {
                Object res;
                try {
                    res = ScriptRuntime.apply((ScriptFunction)value, self, ScriptObjectMirror.unwrapArray(args, this.global));
                }
                catch (Exception e) {
                    NashornScriptEngine.throwAsScriptException(e);
                    throw new AssertionError((Object)"should not reach here");
                }
                Object object = ScriptObjectMirror.wrap(res, this.global);
                return object;
            }
            throw new NoSuchMethodException(name);
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    private Object evalImpl(char[] buf, ScriptContext ctxt) throws ScriptException {
        return this.evalImpl(this.compileImpl(buf, ctxt), ctxt);
    }

    private Object evalImpl(ScriptFunction script, ScriptContext ctxt) throws ScriptException {
        if (script == null) {
            return null;
        }
        ScriptObject oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        try {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(this.global);
            }
            this.setContextVariables(ctxt);
            Object res = ScriptRuntime.apply(script, this.global, new Object[0]);
            res = ScriptObjectMirror.wrap(res, this.global);
            Object object = res == ScriptRuntime.UNDEFINED ? null : res;
            return object;
        }
        catch (Exception e) {
            NashornScriptEngine.throwAsScriptException(e);
            throw new AssertionError((Object)"should not reach here");
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    private static void throwAsScriptException(Exception e) throws ScriptException {
        if (e instanceof ScriptException) {
            throw (ScriptException)e;
        }
        if (e instanceof NashornException) {
            NashornException ne = (NashornException)e;
            ScriptException se = new ScriptException(ne.getMessage(), ne.getFileName(), ne.getLineNumber(), ne.getColumnNumber());
            se.initCause(e);
            throw se;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ScriptException(e);
    }

    private CompiledScript asCompiledScript(final ScriptFunction script) {
        return new CompiledScript(){

            @Override
            public Object eval(ScriptContext ctxt) throws ScriptException {
                return NashornScriptEngine.this.evalImpl(script, ctxt);
            }

            @Override
            public ScriptEngine getEngine() {
                return NashornScriptEngine.this;
            }
        };
    }

    private ScriptFunction compileImpl(char[] buf, ScriptContext ctxt) throws ScriptException {
        ScriptObject oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        try {
            String fileName;
            Object val = ctxt.getAttribute("javax.script.filename");
            String string = fileName = val != null ? val.toString() : "<eval>";
            if ("<system-init>".equals(fileName)) {
                ScriptFunction scriptFunction = null;
                return scriptFunction;
            }
            Source source = new Source(fileName, buf);
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(this.global);
            }
            this.setContextVariables(ctxt);
            ScriptFunction scriptFunction = this.nashornContext.compileScript(source, this.global, this.nashornContext._strict);
            return scriptFunction;
        }
        catch (Exception e) {
            NashornScriptEngine.throwAsScriptException(e);
            throw new AssertionError((Object)"should not reach here");
        }
        finally {
            if (globalChanged) {
                NashornScriptEngine.setNashornGlobal(oldGlobal);
            }
        }
    }

    static void setNashornGlobal(final ScriptObject global) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Context.setGlobal(global);
                return null;
            }
        });
    }
}

