/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc.oracle;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;

public class OracleSchema
extends JDBCSchema {
    private static final Logger LOGGER = Logger.getLogger(OracleSchema.class.getName());

    public OracleSchema(JDBCCatalog catalog, String name, boolean _default, boolean synthetic) {
        super(catalog, name, _default, synthetic);
    }

    @Override
    public String toString() {
        return "OracleSchema[name='" + this.name + "',default=" + this._default + ",synthetic=" + this.synthetic + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTables() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, Table> newTables = new LinkedHashMap<String, Table>();
        try {
            DatabaseMetaData dmd = this.jdbcCatalog.getJDBCMetadata().getDmd();
            Set<String> recycleBinTables = this.getRecycleBinObjects(dmd, "TABLE");
            ResultSet rs = dmd.getTables(this.jdbcCatalog.getName(), this.name, "%", new String[]{"TABLE"});
            try {
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (!recycleBinTables.contains(tableName)) {
                        Table table = this.createJDBCTable(tableName).getTable();
                        newTables.put(tableName, table);
                        LOGGER.log(Level.FINE, "Created table {0}", table);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Ignoring recycle bin table ''{0}''", tableName);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.tables = Collections.unmodifiableMap(newTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRecycleBinObjects(DatabaseMetaData dmd, String ... types) {
        String driverName = null;
        String driverVer = null;
        List emptyList = Collections.emptyList();
        HashSet<String> result = new HashSet<String>();
        try {
            driverName = dmd.getDriverName();
            driverVer = dmd.getDriverVersion();
            int databaseMajorVersion = 0;
            try {
                databaseMajorVersion = dmd.getDatabaseMajorVersion();
            }
            catch (UnsupportedOperationException use) {
                LOGGER.log(Level.FINEST, "getDatabaseMajorVersion() on " + dmd, use);
            }
            if (databaseMajorVersion < 10 || types == null) {
                return Collections.emptySet();
            }
            Statement stmt = dmd.getConnection().createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery("SELECT OBJECT_NAME, TYPE FROM SYS.DBA_RECYCLEBIN");
            }
            catch (SQLException ex) {
                LOGGER.log(Level.FINE, ex.getMessage(), ex);
                rs = stmt.executeQuery("SELECT OBJECT_NAME, TYPE FROM RECYCLEBIN");
            }
            if (rs != null) {
                List<Object> typesL = types == null ? emptyList : Arrays.asList(types);
                try {
                    while (rs.next()) {
                        String type = rs.getString("TYPE");
                        if (!typesL.isEmpty() && !typesL.contains(type)) continue;
                        result.add(rs.getString("OBJECT_NAME"));
                    }
                }
                finally {
                    rs.close();
                }
            }
            stmt.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error while analyzing the recycle bin. JDBC Driver: " + driverName + "(" + driverVer + ")", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProcedures() {
        LOGGER.log(Level.FINE, "Initializing Oracle procedures in {0}", this);
        LinkedHashMap<String, Procedure> newProcedures = new LinkedHashMap<String, Procedure>();
        try {
            DatabaseMetaData dmd = this.jdbcCatalog.getJDBCMetadata().getDmd();
            Statement stmt = dmd.getConnection().createStatement();
            Set<String> recycleBinObjects = this.getRecycleBinObjects(dmd, "TRIGGER", "FUNCTION", "PROCEDURE");
            ResultSet rs = stmt.executeQuery("SELECT OBJECT_NAME, OBJECT_TYPE, STATUS FROM SYS.ALL_OBJECTS WHERE OWNER='" + this.name + "'" + " AND ( OBJECT_TYPE = 'PROCEDURE' OR OBJECT_TYPE = 'TRIGGER' OR OBJECT_TYPE = 'FUNCTION' )");
            try {
                while (rs.next()) {
                    String procedureName = rs.getString("OBJECT_NAME");
                    Procedure procedure = this.createJDBCProcedure(procedureName).getProcedure();
                    if (!recycleBinObjects.contains(procedureName)) {
                        newProcedures.put(procedureName, procedure);
                        LOGGER.log(Level.FINE, "Created Oracle procedure: {0}, type: {1}, status: {2}", new Object[]{procedure, rs.getString("OBJECT_TYPE"), rs.getString("STATUS")});
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "Oracle procedure found id RECYCLEBIN: {0}, type: {1}, status: {2}", new Object[]{procedure, rs.getString("OBJECT_TYPE"), rs.getString("STATUS")});
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.procedures = Collections.unmodifiableMap(newProcedures);
    }
}

