/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.graph.layout.SceneElementComparator;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class MapActionUtility {
    public static Action handleEscape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sourceObj = e.getSource();
            if (!(sourceObj instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
            if (CONNECT_WIDGET != null) {
                CONNECT_WIDGET.removeFromParent();
                CONNECT_WIDGET = null;
            }
        }
    };
    public static Action handleRename = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sourceObj = e.getSource();
            if (sourceObj instanceof PageFlowScene) {
                PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
                PageFlowSceneElement selElement = MapActionUtility.getSelectedPageFlowSceneElement(scene);
                Widget widget = scene.findWidget(selElement);
                assert (widget != null);
                if (widget instanceof VMDNodeWidget) {
                    LabelWidget labelWidget = ((VMDNodeWidget)widget).getNodeNameWidget();
                    InplaceEditorProvider.EditorController controller = this.findEditorController(labelWidget.getActions().getActions());
                    if (controller != null) {
                        controller.openEditor((Widget)labelWidget);
                    }
                } else if (widget instanceof VMDConnectionWidget) {
                    List childWidgets = widget.getChildren();
                    for (Widget childWidget : childWidgets) {
                        InplaceEditorProvider.EditorController controller;
                        if (!(childWidget instanceof LabelWidget) || (controller = this.findEditorController(childWidget.getActions().getActions())) == null) continue;
                        controller.openEditor(childWidget);
                    }
                }
            }
        }

        public InplaceEditorProvider.EditorController findEditorController(List<WidgetAction> actionList) {
            for (WidgetAction action : actionList) {
                if (!(action instanceof InplaceEditorProvider.EditorController)) continue;
                InplaceEditorProvider.EditorController controller = ActionFactory.getInplaceEditorController((WidgetAction)action);
                return controller;
            }
            return null;
        }
    };
    public static final Action handleTabAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean reverse = false;
            MapActionUtility.handleTabActionEvent(e, reverse);
        }
    };
    public static final Action handleCtrlTab = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean reverse = true;
            MapActionUtility.handleTabActionEvent(e, reverse);
        }
    };
    public static final Action handleDownArrow = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sourceObj = e.getSource();
            if (!(sourceObj instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
            boolean reverse = false;
            MapActionUtility.handleArrow(scene, reverse);
        }
    };
    public static final Action handleUpArrow = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sourceObj = e.getSource();
            if (!(sourceObj instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
            boolean reverse = true;
            MapActionUtility.handleArrow(scene, reverse);
        }
    };
    private static ConnectDecorator CONNECT_DECORATOR_DEFAULT = null;
    private static ConnectionWidget CONNECT_WIDGET = null;
    public static Action handleLinkStart = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageFlowScene scene;
            PageFlowSceneElement selElement;
            Object sourceObj = e.getSource();
            if (sourceObj instanceof PageFlowScene && (selElement = MapActionUtility.getSelectedPageFlowSceneElement(scene = (PageFlowScene)((Object)sourceObj))) != null) {
                Widget selWidget = null;
                if (selElement instanceof Page) {
                    selWidget = scene.findWidget(selElement);
                } else if (selElement instanceof Pin) {
                    selWidget = scene.findWidget((Pin)selElement);
                }
                if (selWidget != null) {
                    CONNECT_DECORATOR_DEFAULT = ActionFactory.createDefaultConnectDecorator();
                    CONNECT_DECORATOR_DEFAULT.createTargetAnchor(selWidget);
                    CONNECT_WIDGET = CONNECT_DECORATOR_DEFAULT.createConnectionWidget((Scene)scene);
                    CONNECT_WIDGET.setSourceAnchor(CONNECT_DECORATOR_DEFAULT.createSourceAnchor(selWidget));
                    CONNECT_WIDGET.setTargetAnchor(CONNECT_DECORATOR_DEFAULT.createSourceAnchor(selWidget));
                    scene.getConnectionLayer().addChild((Widget)CONNECT_WIDGET);
                    scene.validate();
                }
            }
        }
    };
    public static Action handleLinkEnd = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sourceObj = e.getSource();
            if (sourceObj instanceof PageFlowScene) {
                PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
                if (CONNECT_WIDGET != null) {
                    Anchor sourceAnchor = CONNECT_WIDGET.getSourceAnchor();
                    Anchor targetAnchor = CONNECT_WIDGET.getTargetAnchor();
                    if (sourceAnchor != null && targetAnchor != null) {
                        Object sourceObject = scene.findObject(CONNECT_WIDGET.getSourceAnchor().getRelatedWidget());
                        Page sourcePage = null;
                        Pin sourcePin = null;
                        if (scene.isPin(sourceObject)) {
                            sourcePin = (Pin)sourceObject;
                            sourcePage = sourcePin.getPage();
                        }
                        if (scene.isNode(sourceObject)) {
                            sourcePage = (Page)sourceObject;
                        }
                        Object targetObject = scene.findObject(CONNECT_WIDGET.getTargetAnchor().getRelatedWidget());
                        Page targetPage = null;
                        if (scene.isPin(targetObject)) {
                            targetPage = ((Pin)targetObject).getPage();
                        }
                        if (scene.isNode(targetObject)) {
                            targetPage = (Page)targetObject;
                        }
                        if (sourcePage != null && targetPage != null) {
                            scene.getPageFlowView().getPageFlowController().createLink(sourcePage, targetPage, sourcePin);
                        }
                        CONNECT_WIDGET.removeFromParent();
                        CONNECT_WIDGET = null;
                        scene.validate();
                    }
                }
            }
        }
    };
    public static final Action handleOpenPage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sourceObj = e.getSource();
            if (sourceObj instanceof PageFlowScene) {
                PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
                HashSet selectedObjs = new HashSet(scene.getSelectedObjects());
                for (Object obj : selectedObjs) {
                    if (!(obj instanceof PageFlowSceneElement)) continue;
                    MapActionUtility.openPageFlowSceneElement((PageFlowSceneElement)obj);
                }
            }
        }
    };
    public static Action handleNewWebForm = new AbstractAction(){
        PageFlowScene scene;
        private static final String DEFAULT_DOC_BASE_FOLDER = "web";

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj instanceof PageFlowScene) {
                try {
                    this.scene = (PageFlowScene)((Object)obj);
                    PageFlowController pfc = this.scene.getPageFlowView().getPageFlowController();
                    FileObject webFileObject = pfc.getWebFolder();
                    String name = FileUtil.findFreeFileName((FileObject)webFileObject, (String)"Templates/JSP_Servlet/JSP.jsp", (String)"jsp");
                    name = JOptionPane.showInputDialog("Select Page Name", (Object)name);
                    this.createIndexJSP(webFileObject, name);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private void createIndexJSP(FileObject targetFolder, String name) throws IOException {
            FileObject jspTemplate = FileUtil.getConfigFile((String)"Templates/JSP_Servlet/JSP.jsp");
            if (jspTemplate == null) {
                return;
            }
            DataObject mt = DataObject.find((FileObject)jspTemplate);
            DataFolder webDf = DataFolder.findFolder((FileObject)targetFolder);
            mt.createFromTemplate(webDf, name);
        }
    };
    public static final Action handleZoomPage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageFlowScene scene;
            Page selPage;
            Object obj = e.getSource();
            if (obj instanceof PageFlowScene && (selPage = MapActionUtility.getSelectedPage(scene = (PageFlowScene)((Object)obj))) != null) {
                VMDNodeWidget pageWidget = (VMDNodeWidget)scene.findWidget(selPage);
                if (pageWidget.isMinimized()) {
                    pageWidget.expandWidget();
                } else {
                    pageWidget.collapseWidget();
                }
            }
        }
    };
    public static final Action handleUnZoomPage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    public static Action handlePopup = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Point popupPoint;
            Object selectedWidget;
            Object obj = e.getSource();
            if (!(obj instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene scene = (PageFlowScene)((Object)obj);
            PopupMenuProvider provider = scene.getPopupMenuProvider();
            PageFlowSceneElement selElement = MapActionUtility.getSelectedPageFlowSceneElement(scene);
            if (selElement != null && selElement instanceof PageFlowSceneElement) {
                selectedWidget = scene.findWidget(selElement);
                assert (selectedWidget != null);
                if (selElement instanceof NavigationCaseEdge) {
                    NavigationCaseEdge edge = (NavigationCaseEdge)selElement;
                    VMDConnectionWidget connectionWidget = (VMDConnectionWidget)scene.findWidget(edge);
                    popupPoint = connectionWidget.getFirstControlPoint();
                } else {
                    popupPoint = selectedWidget.getLocation();
                }
            } else {
                Rectangle rectangleScene = scene.getClientArea();
                popupPoint = scene.convertSceneToLocal(new Point(rectangleScene.width / 2, rectangleScene.height / 2));
                selectedWidget = scene;
            }
            assert (selectedWidget != null);
            assert (popupPoint != null);
            JPopupMenu popupMenu = provider.getPopupMenu(selectedWidget, popupPoint);
            if (popupMenu != null) {
                popupMenu.show(scene.getView(), popupPoint.x, popupPoint.y);
            }
        }
    };
    public static Action handleRightCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageFlowScene scene;
            Page page;
            Object obj = e.getSource();
            if (obj instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(scene = (PageFlowScene)((Object)obj))) != null) {
                MapActionUtility.movePage(scene, page, 5, 0);
            }
        }
    };
    public static Action handleLeftCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageFlowScene scene;
            Page page;
            Object obj = e.getSource();
            if (obj instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(scene = (PageFlowScene)((Object)obj))) != null) {
                MapActionUtility.movePage(scene, page, -5, 0);
            }
        }
    };
    public static Action handleUpCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageFlowScene scene;
            Page page;
            Object obj = e.getSource();
            if (obj instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(scene = (PageFlowScene)((Object)obj))) != null) {
                MapActionUtility.movePage(scene, page, 0, -5);
            }
        }
    };
    public static Action handleDownCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageFlowScene scene;
            Page page;
            Object obj = e.getSource();
            if (obj instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(scene = (PageFlowScene)((Object)obj))) != null) {
                MapActionUtility.movePage(scene, page, 0, 5);
            }
        }
    };

    private MapActionUtility() {
    }

    public static ActionMap initActionMap() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("handleTab", handleTabAction);
        actionMap.put("handleCtrlTab", handleCtrlTab);
        actionMap.put("handleEscape", handleEscape);
        actionMap.put("handleLinkStart", handleLinkStart);
        actionMap.put("handleLinkEnd", handleLinkEnd);
        actionMap.put("handleZoomPage", handleZoomPage);
        actionMap.put("handleUnZoomPage", handleZoomPage);
        actionMap.put("handleOpenPage", handleOpenPage);
        actionMap.put("handleLeftArrowKey", handleCtrlTab);
        actionMap.put("handleRightArrowKey", handleTabAction);
        actionMap.put("handleUpArrowKey", handleUpArrow);
        actionMap.put("handleDownArrowKey", handleDownArrow);
        actionMap.put("handleRename", handleRename);
        actionMap.put("handlePopup", handlePopup);
        actionMap.put("handleLeftCtrlArrowKey", handleLeftCtrlArrowKey);
        actionMap.put("handleRightCtrlArrowKey", handleRightCtrlArrowKey);
        actionMap.put("handleDownCtrlArrowKey", handleDownCtrlArrowKey);
        actionMap.put("handleUpCtrlArrowKey", handleUpCtrlArrowKey);
        return actionMap;
    }

    public static InputMap initInputMap() {
        InputMap inputMap = new InputMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "handleTab");
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "handleCtrlTab");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "handleEscape");
        inputMap.put(KeyStroke.getKeyStroke(83, 0), "handleLinkStart");
        inputMap.put(KeyStroke.getKeyStroke(69, 0), "handleLinkEnd");
        inputMap.put(KeyStroke.getKeyStroke(90, 0), "handleZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(85, 0), "handleUnZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(80, 0), "handlePopup");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "handleOpenPage");
        inputMap.put(KeyStroke.getKeyStroke(83, 1), "handleLinkStart");
        inputMap.put(KeyStroke.getKeyStroke(69, 1), "handleLinkEnd");
        inputMap.put(KeyStroke.getKeyStroke(90, 1), "handleZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(85, 1), "handleUnZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(80, 1), "handlePopup");
        inputMap.put(KeyStroke.getKeyStroke(82, 2), "handleRename");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "handleLeftArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "handleRightArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "handleUpArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "handleDownArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(226, 0), "handleLeftArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(227, 0), "handleRightArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(224, 0), "handleUpArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(225, 0), "handleDownArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(37, 2), "handleLeftCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(226, 2), "handleLeftCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(39, 2), "handleRightCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(227, 2), "handleRightCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(38, 2), "handleUpCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(38, 2), "handleUpCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(40, 2), "handleDownCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(40, 2), "handleDownCtrlArrowKey");
        return inputMap;
    }

    private static final void handleTabActionEvent(ActionEvent e, boolean reverse) {
        Object sourceObj = e.getSource();
        if (!(sourceObj instanceof PageFlowScene)) {
            return;
        }
        PageFlowScene scene = (PageFlowScene)((Object)sourceObj);
        MapActionUtility.handleTab(scene, reverse);
    }

    private static final void handleTab(PageFlowScene scene, boolean reverse) {
        PageFlowSceneElement nextElement = SceneElementComparator.getNextSelectableElement(scene, reverse, true, true, false);
        if (nextElement != null) {
            if (CONNECT_WIDGET != null && scene.getConnectionLayer().getChildren().contains(CONNECT_WIDGET)) {
                Anchor targetAnchor;
                if (nextElement instanceof Page) {
                    assert (CONNECT_DECORATOR_DEFAULT != null);
                    targetAnchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(scene.findWidget(nextElement));
                    CONNECT_WIDGET.setTargetAnchor(targetAnchor);
                    scene.validate();
                } else if (nextElement instanceof Pin) {
                    Widget pageWidget = scene.findWidget(((Pin)nextElement).getPage());
                    targetAnchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(pageWidget);
                    CONNECT_WIDGET.setTargetAnchor(targetAnchor);
                    scene.validate();
                }
            }
            HashSet<PageFlowSceneElement> set = new HashSet<PageFlowSceneElement>();
            set.add(nextElement);
            scene.setHoveredObject(nextElement);
            scene.setSelectedObjects(set);
            scene.setFocusedObject(nextElement);
        } else {
            scene.setSelectedObjects(new HashSet());
            scene.setHoveredObject(null);
        }
    }

    private static final void handleArrow(PageFlowScene scene, boolean reverse) {
        PageFlowSceneElement nextElement = SceneElementComparator.getNextSelectableElement(scene, reverse, false, false, true);
        if (nextElement != null) {
            if (CONNECT_WIDGET != null && scene.getConnectionLayer().getChildren().contains(CONNECT_WIDGET)) {
                Anchor targetAnchor = null;
                if (nextElement instanceof Page) {
                    assert (CONNECT_DECORATOR_DEFAULT != null);
                    targetAnchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(scene.findWidget(nextElement));
                } else if (nextElement instanceof Pin) {
                    Widget pageWidget = scene.findWidget(((Pin)nextElement).getPage());
                    targetAnchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(pageWidget);
                }
                if (targetAnchor != null) {
                    CONNECT_WIDGET.setTargetAnchor(targetAnchor);
                    scene.validate();
                }
            }
            HashSet<PageFlowSceneElement> set = new HashSet<PageFlowSceneElement>();
            set.add(nextElement);
            scene.setSelectedObjects(set);
        }
    }

    public static void openPageFlowSceneElement(PageFlowSceneElement element) {
        OpenCookie openCookie = (OpenCookie)element.getNode().getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
        }
    }

    public static Page getSelectedPage(PageFlowScene scene) {
        assert (scene != null);
        PageFlowSceneElement element = MapActionUtility.getSelectedPageFlowSceneElement(scene);
        if (element != null && element instanceof Page) {
            return (Page)element;
        }
        return null;
    }

    public static PageFlowSceneElement getSelectedPageFlowSceneElement(PageFlowScene scene) {
        assert (scene != null);
        Iterator i$ = scene.getSelectedObjects().iterator();
        if (i$.hasNext()) {
            Object selObj = i$.next();
            return (PageFlowSceneElement)selObj;
        }
        return null;
    }

    public static void movePage(PageFlowScene scene, Page page, int horizontal, int vertical) {
        assert (scene != null);
        assert (page != null);
        Widget pageWidget = scene.findWidget(page);
        Point currentLocation = pageWidget.getLocation();
        currentLocation.translate(horizontal, vertical);
        pageWidget.setPreferredLocation(currentLocation);
        scene.validate();
    }
}

