/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class PageFlowElement
extends CloneableEditor
implements MultiViewElement,
Serializable {
    private static final Logger LOG = Logger.getLogger(PageFlowElement.class.getName());
    private transient PageFlowView tc;
    private transient JComponent toolbar;
    private static final long serialVersionUID = 5454879177214643L;
    private JSFConfigEditorContext context;
    private DataObject dataObject;
    private MultiViewElementCallback callback;

    public PageFlowElement(Lookup lookup) {
        super((CloneableEditorSupport)lookup.lookup(DataEditorSupport.class));
        this.context = (JSFConfigEditorContext)lookup.lookup(JSFConfigEditorContext.class);
        this.dataObject = (DataObject)lookup.lookup(DataObject.class);
        assert (this.context != null);
        this.init();
    }

    private void init() {
        this.getTopComponent().setName(this.context.getFacesConfigFile().getName());
    }

    public JComponent getVisualRepresentation() {
        return this.getTopComponent();
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = this.getTopComponent().getToolbarRepresentation();
        }
        return this.toolbar;
    }

    private synchronized PageFlowView getTopComponent() {
        if (this.tc == null) {
            this.tc = new PageFlowView(this, this.context);
        }
        return this.tc;
    }

    public Action[] getActions() {
        Action[] a = this.getTopComponent().getActions();
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = this.getClass().getClassLoader();
            }
            Class<SystemAction> c = Class.forName("org.openide.actions.FileSystemAction", true, l).asSubclass(SystemAction.class);
            SystemAction ra = (SystemAction)SystemAction.findObject(c, (boolean)true);
            Action[] a2 = new Action[a.length + 1];
            System.arraycopy(a, 0, a2, 0, a.length);
            a2[a.length] = ra;
            return a2;
        }
        catch (Exception exception) {
            return new Action[0];
        }
    }

    public Lookup getLookup() {
        return this.getTopComponent().getLookup();
    }

    public void componentOpened() {
        this.getTopComponent().registerListeners();
        LOG.finest("PageFlowEditor componentOpened");
    }

    public void componentClosed() {
        long time = System.currentTimeMillis();
        FileObject storageFile = PageFlowView.getStorageFile(this.context.getFacesConfigFile());
        if (storageFile != null && storageFile.isValid()) {
            this.getTopComponent().serializeNodeLocations(storageFile);
        } else {
            DialogDescriptor dialog = storageFile != null ? new DialogDescriptor((Object)NbBundle.getMessage(PageFlowElement.class, (String)"MSG_NoFileToSave", (Object)storageFile), NbBundle.getMessage(PageFlowElement.class, (String)"TLE_NoFileToSave")) : new DialogDescriptor((Object)NbBundle.getMessage(PageFlowElement.class, (String)"MSG_NoProjectToSave"), NbBundle.getMessage(PageFlowElement.class, (String)"TLE_NoFileToSave"));
            dialog.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
            Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
            d.setVisible(true);
        }
        this.getTopComponent().unregstierListeners();
        PageFlowToolbarUtilities.removePageFlowView(this.getTopComponent());
        this.getTopComponent().destroyScene();
        this.toolbar = null;
        this.tc = null;
        LOG.finest("PageFlowEditor componentClosed took: " + (System.currentTimeMillis() - time) + " ms");
    }

    public void componentShowing() {
        if (this.getTopComponent().getPageFlowController() == null) {
            return;
        }
        this.getTopComponent().getPageFlowController().flushGraphIfDirty();
    }

    public void componentHidden() {
        LOG.finest("PageFlowEditor componentHidden");
    }

    public void componentActivated() {
        LOG.finest("PageFlowView componentActivated");
        this.getTopComponent().requestActive();
    }

    public void componentDeactivated() {
        LOG.finest("PageFlowView Deactivated");
    }

    public MultiViewElementCallback getMultiViewCallback() {
        return this.callback;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
        this.context.setMultiViewTopComponent(callback.getTopComponent());
    }

    public CloseOperationState canCloseElement() {
        if (!this.getEditorSupport().isModified()) {
            return CloseOperationState.STATE_OK;
        }
        AbstractAction save = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    PageFlowElement.this.getEditorSupport().saveDocument();
                    PageFlowElement.this.getEditorSupport().getDataObject().setModified(false);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "File {0} couldn''t be saved.", PageFlowElement.this.context.getFacesConfigFile().getName());
                }
            }
        };
        save.putValue("LongDescription", NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.getEditorSupport().getDataObject().getPrimaryFile().getNameExt()));
        return MultiViewFactory.createUnsafeCloseState((String)"ID_FACES_CONFIG_CLOSING", (Action)save, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getTopComponent().serializeNodeLocations(PageFlowView.getStorageFile(this.context.getFacesConfigFile()));
        out.writeObject(this.context);
        LOG.finest("writeObject");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof JSFConfigEditorContext)) {
            throw new ClassNotFoundException("JSFConfigEditorContext expected but not found");
        }
        this.context = (JSFConfigEditorContext)object;
        this.init();
        LOG.finest("readObject");
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.cloneableEditorSupport();
    }

    public UndoRedo getUndoRedo() {
        return this.context.getUndoRedo();
    }
}

