/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.refactoring.php.RefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public abstract class RefactoringTask
extends UserTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(RefactoringTask.class.getName());
    protected RefactoringUI ui;

    public final RefactoringUI getRefactoringUI() {
        return this.ui;
    }

    public static abstract class TextComponentTask
    extends RefactoringTask {
        private final JTextComponent textC;
        private final int caret;
        private final Document document;

        public TextComponentTask(EditorCookie ec) {
            this.textC = ec.getOpenedPanes()[0];
            this.document = this.textC.getDocument();
            this.caret = this.textC.getCaretPosition();
            assert (this.caret != -1);
        }

        @Override
        public void run() {
            try {
                Source source = Source.create((Document)this.document);
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringTask.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program root;
            Parser.Result parserResult = resultIterator.getParserResult();
            if (parserResult instanceof PHPParseResult && (root = RefactoringUtils.getRoot((ParserResult)((PHPParseResult)parserResult))) != null) {
                this.ui = this.createRefactoringUI((PHPParseResult)parserResult, this.caret);
                return;
            }
            LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
        }

        protected abstract RefactoringUI createRefactoringUI(PHPParseResult var1, int var2);
    }

    public static abstract class NodeToFileTask
    extends RefactoringTask {
        private final Node node;
        private FileObject fileObject;

        public NodeToFileTask(Node node) {
            this.node = node;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program root;
            Parser.Result parserResult = resultIterator.getParserResult();
            if (parserResult != null && parserResult instanceof PHPParseResult && (root = RefactoringUtils.getRoot((ParserResult)((PHPParseResult)parserResult))) != null) {
                this.ui = this.createRefactoringUI((PHPParseResult)parserResult);
                return;
            }
            LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
        }

        @Override
        public void run() {
            DataObject dobj = (DataObject)this.node.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                this.fileObject = dobj.getPrimaryFile();
                if (this.fileObject.isFolder()) {
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringTask.class, (String)"ERR_CannotRefactorLoc"));
                } else {
                    Source source = Source.create((FileObject)this.fileObject);
                    try {
                        ParserManager.parse(Collections.singletonList(source), (UserTask)this);
                    }
                    catch (ParseException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        return;
                    }
                    TopComponent activetc = TopComponent.getRegistry().getActivated();
                    if (this.ui != null) {
                        UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
                    } else {
                        JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringTask.class, (String)"ERR_CannotRefactorLoc"));
                    }
                }
            }
        }

        protected abstract RefactoringUI createRefactoringUI(PHPParseResult var1);
    }
}

