/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy.extender;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.support.spi.GroovyExtender;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.groovy.extender.AddGroovyDependency;
import org.netbeans.modules.maven.groovy.extender.AddGroovyEclipseCompiler;
import org.netbeans.modules.maven.groovy.extender.AddMavenCompilerPlugin;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class MavenGroovyExtender
implements GroovyExtender {
    private static final String GROOVY_GROUP_ID = "org.codehaus.groovy";
    private static final String GROOVY_ARTIFACT_ID = "groovy-all";
    private final FileObject pom;

    public MavenGroovyExtender(Project project) {
        this.pom = project.getProjectDirectory().getFileObject("pom.xml");
    }

    public boolean isActive() {
        final Boolean[] retValue = new Boolean[]{false};
        try {
            this.pom.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    Utilities.performPOMModelOperations((FileObject)MavenGroovyExtender.this.pom, Collections.singletonList(new ModelOperation<POMModel>(){

                        public void performOperation(POMModel model) {
                            retValue[0] = ModelUtils.hasModelDependency((POMModel)model, (String)MavenGroovyExtender.GROOVY_GROUP_ID, (String)MavenGroovyExtender.GROOVY_ARTIFACT_ID) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        }
                    }));
                }
            });
        }
        catch (IOException ex) {
            return retValue[0];
        }
        return retValue[0];
    }

    public boolean activate() {
        try {
            this.pom.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ArrayList<Object> operations = new ArrayList<Object>();
                    operations.add(new AddGroovyDependency());
                    operations.add(new AddMavenCompilerPlugin());
                    operations.add(new AddGroovyEclipseCompiler());
                    Utilities.performPOMModelOperations((FileObject)MavenGroovyExtender.this.pom, operations);
                }
            });
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean deactivate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

