/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.status.HgVersioningTopComponent;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.status.SyncFileNode;
import org.netbeans.modules.mercurial.ui.status.SyncTable;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.LifecycleManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class VersioningPanel
extends JPanel
implements ExplorerManager.Provider,
PreferenceChangeListener,
PropertyChangeListener,
ActionListener {
    private ExplorerManager explorerManager;
    private final HgVersioningTopComponent parentTopComponent;
    private final Mercurial mercurial;
    private VCSContext context;
    private int displayStatuses;
    private String branchInfo;
    private SyncTable syncTable;
    private RequestProcessor.Task refreshViewTask;
    private HgProgressSupport hgProgressSupport;
    private static final RequestProcessor rp = new RequestProcessor("MercurialView", 1, true);
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private JButton btnCommit;
    private JButton btnDiff;
    private JButton btnRefresh;
    private JButton btnUpdate;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JToolBar jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel statusLabel;

    public VersioningPanel(HgVersioningTopComponent parent) {
        this.parentTopComponent = parent;
        this.mercurial = Mercurial.getInstance();
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.explorerManager = new ExplorerManager();
        this.displayStatuses = 6612;
        this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_All"));
        this.syncTable = new SyncTable();
        this.initComponents();
        this.setVersioningComponent(this.syncTable.getComponent());
        this.reScheduleRefresh(0);
        this.jPanel2.setFloatable(false);
        this.jPanel2.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jPanel2.setLayout(new ToolbarLayout());
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.jPanel2.setBackground(color);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "status.changed") {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)evt.getNewValue();
            Mercurial.LOG.log(Level.FINE, "Status.propertyChange(): {0} file:  {1}", new Object[]{this.parentTopComponent.getContentTitle(), changedEvent.getFile()});
            if (this.affectsView(evt)) {
                this.reScheduleRefresh(1000);
            }
            return;
        }
        if (evt.getPropertyName() == "changesetChanged") {
            Object source = evt.getOldValue();
            File root = HgUtils.getRootFile(this.context);
            Mercurial.LOG.log(Level.FINE, "Mercurial.changesetChanged: source {0} repo {1} ", new Object[]{source, root});
            if (root != null && root.equals(source)) {
                this.reScheduleRefresh(1000);
            }
            return;
        }
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc != null) {
                tc.setActivatedNodes((Node[])evt.getNewValue());
            }
            return;
        }
    }

    void setContext(VCSContext ctx) {
        this.context = ctx;
        if (EventQueue.isDispatchThread()) {
            this.syncTable.setTableModel(new SyncFileNode[0]);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.mercurial.getFileStatusCache().addPropertyChangeListener(this);
        this.mercurial.addPropertyChangeListener(this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.mercurial.addPropertyChangeListener(this.syncTable);
        this.reScheduleRefresh(0);
    }

    @Override
    public void removeNotify() {
        HgModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        this.mercurial.getFileStatusCache().removePropertyChangeListener(this);
        this.mercurial.removePropertyChangeListener(this);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        this.mercurial.removePropertyChangeListener(this.syncTable);
        super.removeNotify();
    }

    private void setVersioningComponent(JComponent component) {
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (child == this.jPanel2) continue;
            if (child == component) {
                return;
            }
            this.remove(child);
            break;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)component, gbc);
        this.revalidate();
        this.repaint();
    }

    /*
     * Exception decompiling
     */
    private void setupModels() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SyncFileNode[] getNodes(VCSContext context, int includeStatus) {
        File[] files = Mercurial.getInstance().getFileStatusCache().listFiles(context, includeStatus);
        Set<File> repositories = HgUtils.getRepositoryRoots(context);
        LinkedList<HgFileNode> fnodes = new LinkedList<HgFileNode>();
        for (File file : files) {
            if (!repositories.contains(this.mercurial.getRepositoryRoot(file))) continue;
            fnodes.add(new HgFileNode(file));
        }
        SyncFileNode[] nodes = new SyncFileNode[fnodes.size()];
        int i = 0;
        for (HgFileNode fnode : fnodes) {
            if (Thread.interrupted()) {
                return null;
            }
            nodes[i] = new SyncFileNode(fnode, this);
            ++i;
        }
        return nodes;
    }

    public int getDisplayStatuses() {
        return this.displayStatuses;
    }

    public String getDisplayBranchInfo() {
        return this.branchInfo;
    }

    private void onCommitAction() {
        if (this.context == null || this.context.getRootFiles().size() == 0) {
            return;
        }
        LifecycleManager.getDefault().saveAll();
        CommitAction.commit(this.parentTopComponent.getContentTitle(), this.context);
    }

    private void onUpdateAction() {
        if (this.context == null || this.context.getRootFiles().size() == 0) {
            return;
        }
        UpdateAction.update(this.context, null);
        this.parentTopComponent.contentRefreshed();
    }

    private void onRefreshAction() {
        LifecycleManager.getDefault().saveAll();
        if (this.context == null || this.context.getRootFiles().size() == 0) {
            return;
        }
        this.refreshStatuses();
    }

    void performRefreshAction() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        File repository;
        if (this.hgProgressSupport != null) {
            this.hgProgressSupport.cancel();
            this.hgProgressSupport = null;
        }
        if ((repository = HgUtils.getRootFile(this.context)) == null) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        this.hgProgressSupport = new HgProgressSupport(){

            @Override
            public void perform() {
                StatusAction.executeStatus(VersioningPanel.this.context, this);
                VersioningPanel.this.setupModels();
            }
        };
        this.parentTopComponent.contentRefreshed();
        this.hgProgressSupport.start(rp, repository, NbBundle.getMessage(VersioningPanel.class, (String)"LBL_Refresh_Progress"));
    }

    private void onDiffAction() {
        if (this.context == null || this.context.getRootFiles().size() == 0) {
            return;
        }
        String title = this.parentTopComponent.getContentTitle();
        if (this.displayStatuses == 6612) {
            LifecycleManager.getDefault().saveAll();
            DiffAction.diff(this.context, 0, title);
        } else if (this.displayStatuses == 1696) {
            DiffAction.diff(this.context, 1, title);
        } else {
            LifecycleManager.getDefault().saveAll();
            DiffAction.diff(this.context, 2, title);
        }
    }

    private void onDisplayedStatusChanged() {
        this.setDisplayStatuses(8180);
        this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_All"));
    }

    private void setDisplayStatuses(int displayStatuses) {
        this.displayStatuses = displayStatuses;
        this.reScheduleRefresh(0);
    }

    private boolean affectsView(PropertyChangeEvent event) {
        FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
        File file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context == null ? false : HgUtils.contains(this.context.getRootFiles(), file);
    }

    private void reScheduleRefresh(int delayMillis) {
        this.refreshViewTask.schedule(delayMillis);
    }

    void deserialize() {
        if (this.syncTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VersioningPanel.this.syncTable.setDefaultColumnSizes();
                }
            });
        }
    }

    void focus() {
        this.syncTable.focus();
    }

    public void cancelRefresh() {
        this.refreshViewTask.cancel();
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jPanel2 = new JToolBar();
        this.jPanel4 = new JPanel();
        this.statusLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.btnRefresh = new JButton();
        this.btnDiff = new JButton();
        this.jPanel3 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCommit = new JButton();
        this.jPanel5 = new JPanel();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBorderPainted(false);
        this.jPanel4.setOpaque(false);
        this.jPanel2.add(this.jPanel4);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/status/Bundle");
        this.statusLabel.setText(bundle.getString("CTL_Versioning_Status_Table_Title"));
        this.statusLabel.setHorizontalTextPosition(0);
        this.jPanel2.add(this.statusLabel);
        this.statusLabel.getAccessibleContext().setAccessibleName(bundle.getString("CTL_Versioning_Status_Table_Title"));
        this.jPanel1.setOpaque(false);
        this.jPanel1.add(this.jSeparator1);
        this.jPanel2.add(this.jPanel1);
        this.jSeparator2.setOrientation(1);
        this.jPanel2.add(this.jSeparator2);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/refresh.png")));
        this.btnRefresh.setToolTipText(NbBundle.getMessage(VersioningPanel.class, (String)"CTL_Synchronize_Action_Refresh_Tooltip"));
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setPreferredSize(new Dimension(22, 25));
        this.btnRefresh.addActionListener(this);
        this.jPanel2.add(this.btnRefresh);
        this.btnRefresh.getAccessibleContext().setAccessibleName("Refresh Status");
        this.btnDiff.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff.png")));
        this.btnDiff.setToolTipText(bundle.getString("CTL_Synchronize_Action_Diff_Tooltip"));
        this.btnDiff.setFocusable(false);
        this.btnDiff.setPreferredSize(new Dimension(22, 25));
        this.btnDiff.addActionListener(this);
        this.jPanel2.add(this.btnDiff);
        this.btnDiff.getAccessibleContext().setAccessibleName("Diff All");
        this.jPanel3.setOpaque(false);
        this.jPanel2.add(this.jPanel3);
        this.btnUpdate.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/update.png")));
        this.btnUpdate.setToolTipText(bundle.getString("CTL_Synchronize_Action_Update_Tooltip"));
        this.btnUpdate.setFocusable(false);
        this.btnUpdate.setPreferredSize(new Dimension(22, 25));
        this.btnUpdate.addActionListener(this);
        this.jPanel2.add(this.btnUpdate);
        this.btnUpdate.getAccessibleContext().setAccessibleName("Update");
        this.btnCommit.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/commit.png")));
        this.btnCommit.setToolTipText(bundle.getString("CTL_CommitForm_Action_Commit_Tooltip"));
        this.btnCommit.setFocusable(false);
        this.btnCommit.setPreferredSize(new Dimension(22, 25));
        this.btnCommit.addActionListener(this);
        this.jPanel2.add(this.btnCommit);
        this.btnCommit.getAccessibleContext().setAccessibleName("Commit");
        this.jPanel5.setOpaque(false);
        this.jPanel2.add(this.jPanel5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.btnRefresh) {
            this.btnRefreshActionPerformed(evt);
        } else if (evt.getSource() == this.btnDiff) {
            this.btnDiffActionPerformed(evt);
        } else if (evt.getSource() == this.btnUpdate) {
            this.btnUpdateActionPerformed(evt);
        } else if (evt.getSource() == this.btnCommit) {
            this.btnCommitActionPerformed(evt);
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.onRefreshAction();
    }

    private void btnDiffActionPerformed(ActionEvent evt) {
        this.onDiffAction();
    }

    private void btnUpdateActionPerformed(ActionEvent evt) {
        this.onUpdateAction();
    }

    private void btnCommitActionPerformed(ActionEvent evt) {
        this.onCommitAction();
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set<JComponent> adjusted = new HashSet<JComponent>();

        private ToolbarLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension dim = VersioningPanel.this.getSize();
            Dimension max = parent.getSize();
            int reminder = max.width - this.minimumLayoutSize((Container)parent).width;
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                JComponent comp = (JComponent)parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setLocation(horizont, 0);
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                if (comp instanceof JProgressBar && reminder > 0) {
                    width += reminder;
                }
                int height = this.getToolbarHeight(dim) - 1;
                comp.setSize(width, height);
                horizont += width;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = VersioningPanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                if (comp instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)comp);
                } else {
                    this.adjustToolbarComponentSize((JComponent)comp);
                }
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                horizont += width;
            }
            return new Dimension(horizont, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = VersioningPanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            return new Dimension(Integer.MAX_VALUE, height);
        }

        private int getToolbarHeight(Dimension parent) {
            if (this.parentSize == null || !this.parentSize.equals(parent)) {
                this.parentSize = parent;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage image = new BufferedImage(1, 1, 10);
                Graphics2D g = image.createGraphics();
                UIDefaults def = UIManager.getLookAndFeelDefaults();
                int height = 0;
                String[] fonts = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < fonts.length; ++i) {
                    Font f = def.getFont(fonts[i]);
                    FontMetrics fm = g.getFontMetrics(f);
                    height = Math.max(height, fm.getHeight());
                }
                this.toolbarHeight = height + this.TOOLBAR_HEIGHT_ADJUSTMENT;
                if (parent.height - parent.width > 0) {
                    this.toolbarHeight += this.TOOLBAR_HEIGHT_ADJUSTMENT;
                }
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (!(button instanceof JToggleButton)) {
                button.setContentAreaFilled(false);
                button.setMargin(new Insets(0, 3, 0, 3));
                button.setBorderPainted(false);
                button.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        button.setContentAreaFilled(true);
                        button.setBorderPainted(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        button.setContentAreaFilled(false);
                        button.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(button);
        }

        private void adjustToolbarComponentSize(JComponent button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (button.getBorder() instanceof CompoundBorder) {
                Dimension pref = button.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    pref.width += 9;
                }
                button.setPreferredSize(pref);
            }
            this.adjusted.add(button);
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            VersioningPanel.this.setupModels();
        }
    }
}

