/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.QCommitTable;
import org.netbeans.modules.mercurial.ui.queues.QCreatePatchParameters;
import org.netbeans.modules.mercurial.ui.queues.QFileNode;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.ui.queues.RefreshPanelModifier;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.HgQueueHook;
import org.netbeans.modules.versioning.hooks.HgQueueHookContext;
import org.netbeans.modules.versioning.hooks.VCSHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.VCSCommitDiffProvider;
import org.netbeans.modules.versioning.util.common.VCSCommitPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitParameters;
import org.netbeans.modules.versioning.util.common.VCSCommitTable;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class QCommitPanel
extends VCSCommitPanel<QFileNode> {
    private final Collection<HgQueueHook> hooks;
    private final File[] roots;
    private final File repository;
    private final NodesProvider nodesProvider;
    private final HelpCtx helpCtx;
    HgProgressSupport support;

    private QCommitPanel(QCommitTable table, File[] roots, File repository, VCSCommitParameters.DefaultCommitParameters parameters, Preferences preferences, Collection<HgQueueHook> hooks, VCSHookContext hooksContext, VCSCommitDiffProvider diffProvider, NodesProvider nodesProvider, HelpCtx helpCtx) {
        super((VCSCommitTable)table, (VCSCommitParameters)parameters, preferences, hooks, hooksContext, Collections.emptyList(), diffProvider);
        this.roots = roots;
        this.repository = repository;
        this.hooks = hooks;
        this.nodesProvider = nodesProvider;
        this.helpCtx = helpCtx;
    }

    public static QCommitPanel createNewPanel(File[] roots, File repository, String commitMessage, String helpCtxId) {
        Preferences preferences = HgModuleConfig.getDefault().getPreferences();
        QCreatePatchParameters parameters = new QCreatePatchParameters(preferences, commitMessage, null);
        Collection hooks = VCSHooks.getInstance().getHooks(HgQueueHook.class);
        HgQueueHookContext hooksCtx = new HgQueueHookContext(roots, null, null, new HgHookContext.LogEntry[0]);
        DiffProvider diffProvider = new DiffProvider();
        RefreshPanelModifier modifier = RefreshPanelModifier.getDefault("create");
        return new QCommitPanel(new QCommitTable(modifier), roots, repository, parameters, preferences, hooks, (VCSHookContext)hooksCtx, diffProvider, new ModifiedNodesProvider(), new HelpCtx(helpCtxId));
    }

    public static QCommitPanel createRefreshPanel(File[] roots, File repository, String commitMessage, QPatch patch, HgLogMessage.HgRevision parentRevision, String helpCtxId) {
        Preferences preferences = HgModuleConfig.getDefault().getPreferences();
        QCreatePatchParameters parameters = new QCreatePatchParameters(preferences, commitMessage, patch);
        Collection hooks = VCSHooks.getInstance().getHooks(HgQueueHook.class);
        HgQueueHookContext hooksCtx = new HgQueueHookContext(roots, null, patch.getId(), new HgHookContext.LogEntry[0]);
        QDiffProvider diffProvider = new QDiffProvider(parentRevision);
        RefreshPanelModifier msgProvider = RefreshPanelModifier.getDefault("refresh");
        return new QCommitPanel(new QCommitTable(msgProvider), roots, repository, parameters, preferences, hooks, (VCSHookContext)hooksCtx, diffProvider, new QRefreshNodesProvider(parentRevision), new HelpCtx(helpCtxId));
    }

    public QCreatePatchParameters getParameters() {
        return (QCreatePatchParameters)super.getParameters();
    }

    public Collection<HgQueueHook> getHooks() {
        return this.hooks;
    }

    protected void computeNodes() {
        this.computeNodesIntern();
    }

    HelpCtx getHelpContext() {
        return this.helpCtx;
    }

    public boolean open(VCSContext context, HelpCtx helpCtx) {
        assert (EventQueue.isDispatchThread());
        boolean ok = super.open(context, helpCtx);
        HgProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        return ok;
    }

    RequestProcessor.Task computeNodesIntern() {
        final boolean[] refreshFinnished = new boolean[]{false};
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.repository);
        HgProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        this.support = this.getProgressSupport(refreshFinnished);
        String preparingMessage = NbBundle.getMessage(QCommitPanel.class, (String)"Progress_Preparing_Commit");
        this.setupProgress(preparingMessage, this.support.getProgressComponent());
        RequestProcessor.Task task = this.support.start(rp, this.repository, preparingMessage);
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!refreshFinnished[0]) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QCommitPanel.this.showProgress();
                        }
                    });
                }
            }
        }, 1000L);
        return task;
    }

    protected HgProgressSupport getProgressSupport(final boolean[] refreshFinished) {
        return new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QCommitPanel.this.getCommitTable().setNodes((VCSFileNode[])new QFileNode[0]);
                        }
                    });
                    final QFileNode[] nodes = QCommitPanel.this.nodesProvider.getNodes(QCommitPanel.this.repository, QCommitPanel.this.roots, refreshFinished);
                    if (nodes != null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                QCommitPanel.this.getCommitTable().setNodes((VCSFileNode[])nodes);
                            }
                        });
                    }
                    refreshFinished[0] = true;
                }
                catch (Throwable throwable) {
                    refreshFinished[0] = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QCommitPanel.this.stopProgress();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
    }

    private static final class QRefreshNodesProvider
    implements NodesProvider {
        private final HgLogMessage.HgRevision parent;

        private QRefreshNodesProvider(HgLogMessage.HgRevision parentRevision) {
            this.parent = parentRevision;
        }

        @Override
        public QFileNode[] getNodes(File repository, File[] roots, boolean[] refreshFinished) {
            try {
                if (this.parent != null && this.parent != HgLogMessage.HgRevision.EMPTY) {
                    Map<File, FileInformation> patchChanges = HgCommand.getStatus(repository, Collections.singletonList(repository), this.parent.getRevisionNumber(), "qtip");
                    FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                    HashSet<File> toRefresh = new HashSet<File>(Arrays.asList(roots));
                    toRefresh.addAll(patchChanges.keySet());
                    cache.refreshAllRoots(Collections.singletonMap(repository, toRefresh));
                    Map<File, FileInformation> statuses = this.getLocalChanges(roots, cache);
                    statuses.keySet().retainAll(HgUtils.flattenFiles(roots, statuses.keySet()));
                    Set<File> patchChangesUnderSelection = this.getPatchChangesUnderSelection(patchChanges, roots);
                    for (Map.Entry<File, FileInformation> e : patchChanges.entrySet()) {
                        if (patchChangesUnderSelection.contains(e.getKey())) {
                            if (statuses.containsKey(e.getKey())) continue;
                            statuses.put(e.getKey(), new FileInformation(8, null, false));
                            continue;
                        }
                        FileInformation info = cache.getCachedStatus(e.getKey());
                        if ((info.getStatus() & 0x19D4) == 0) continue;
                        statuses.put(e.getKey(), info);
                    }
                    refreshFinished[0] = true;
                    if (statuses.isEmpty()) {
                        return null;
                    }
                    ArrayList<QFileNode> nodesList = new ArrayList<QFileNode>(statuses.size());
                    for (Map.Entry<File, FileInformation> e : statuses.entrySet()) {
                        File f = e.getKey();
                        FileInformation fi = e.getValue();
                        if ((fi.getStatus() & 4) != 0 && HgUtils.isIgnored(f)) continue;
                        QFileNode node = new QFileNode(repository, f, fi);
                        nodesList.add(node);
                    }
                    return nodesList.toArray(new QFileNode[nodesList.size()]);
                }
            }
            catch (HgException.HgCommandCanceledException ex) {
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            return null;
        }

        private Set<File> getPatchChangesUnderSelection(Map<File, FileInformation> patchChanges, File[] roots) {
            Set<File> patchChangesUnderSelection = new HashSet<File>(patchChanges.keySet());
            Iterator it = patchChangesUnderSelection.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                boolean isUnderRoots = false;
                for (File root : roots) {
                    if (!Utils.isAncestorOrEqual((File)root, (File)f)) continue;
                    isUnderRoots = true;
                    break;
                }
                if (isUnderRoots) continue;
                it.remove();
            }
            patchChangesUnderSelection = HgUtils.flattenFiles(roots, patchChangesUnderSelection);
            return patchChangesUnderSelection;
        }

        private Map<File, FileInformation> getLocalChanges(File[] roots, FileStatusCache cache) {
            File[] files = cache.listFiles(roots, 6612);
            HashMap<File, FileInformation> retval = new HashMap<File, FileInformation>(files.length);
            for (File file : files) {
                retval.put(file, cache.getCachedStatus(file));
            }
            return retval;
        }
    }

    private static final class ModifiedNodesProvider
    implements NodesProvider {
        private ModifiedNodesProvider() {
        }

        @Override
        public QFileNode[] getNodes(File repository, File[] roots, boolean[] refreshFinished) {
            FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
            cache.refreshAllRoots(Collections.singletonMap(repository, new HashSet<File>(Arrays.asList(roots))));
            refreshFinished[0] = true;
            File[][] split = Utils.splitFlatOthers((File[])roots);
            ArrayList<File> fileList = new ArrayList<File>();
            for (int c = 0; c < split.length; ++c) {
                int i;
                File[] files;
                boolean recursive;
                File[] splitRoots = split[c];
                boolean bl = recursive = c == 1;
                if (recursive) {
                    files = cache.listFiles(splitRoots, 6612);
                    for (i = 0; i < files.length; ++i) {
                        for (int r = 0; r < splitRoots.length; ++r) {
                            if (!Utils.isAncestorOrEqual((File)splitRoots[r], (File)files[i]) || fileList.contains(files[i])) continue;
                            fileList.add(files[i]);
                        }
                    }
                    continue;
                }
                files = HgUtils.flatten(splitRoots, 6612);
                for (i = 0; i < files.length; ++i) {
                    if (fileList.contains(files[i])) continue;
                    fileList.add(files[i]);
                }
            }
            if (fileList.isEmpty()) {
                return null;
            }
            ArrayList<QFileNode> nodesList = new ArrayList<QFileNode>(fileList.size());
            for (File file : fileList) {
                QFileNode node = new QFileNode(repository, file);
                nodesList.add(node);
            }
            return nodesList.toArray(new QFileNode[fileList.size()]);
        }
    }

    private static interface NodesProvider {
        public QFileNode[] getNodes(File var1, File[] var2, boolean[] var3);
    }

    private static class QDiffProvider
    extends DiffProvider {
        private final HgLogMessage.HgRevision parent;

        QDiffProvider(HgLogMessage.HgRevision parent) {
            this.parent = parent;
        }

        @Override
        public JComponent createDiffComponent(File file) {
            MultiDiffPanel panel = new MultiDiffPanel(file, this.parent, HgLogMessage.HgRevision.CURRENT, false);
            this.panels.put(file, panel);
            return panel;
        }
    }

    private static class DiffProvider
    extends VCSCommitDiffProvider {
        final Map<File, MultiDiffPanel> panels = new HashMap<File, MultiDiffPanel>();

        private DiffProvider() {
        }

        public Set<File> getModifiedFiles() {
            return this.getSaveCookiesPerFile().keySet();
        }

        private Map<File, SaveCookie> getSaveCookiesPerFile() {
            HashMap<File, SaveCookie> modifiedFiles = new HashMap<File, SaveCookie>();
            for (Map.Entry<File, MultiDiffPanel> e : this.panels.entrySet()) {
                SaveCookie[] cookies = e.getValue().getSaveCookies(false);
                if (cookies.length <= 0) continue;
                modifiedFiles.put(e.getKey(), cookies[0]);
            }
            return modifiedFiles;
        }

        public JComponent createDiffComponent(File file) {
            MultiDiffPanel panel = new MultiDiffPanel(file, HgLogMessage.HgRevision.BASE, HgLogMessage.HgRevision.CURRENT, false);
            this.panels.put(file, panel);
            return panel;
        }

        protected SaveCookie[] getSaveCookies() {
            return this.getSaveCookiesPerFile().values().toArray(new SaveCookie[0]);
        }

        protected EditorCookie[] getEditorCookies() {
            LinkedList<EditorCookie> allCookies = new LinkedList<EditorCookie>();
            for (Map.Entry<File, MultiDiffPanel> e : this.panels.entrySet()) {
                EditorCookie[] cookies = e.getValue().getEditorCookies(true);
                if (cookies.length <= 0) continue;
                allCookies.add(cookies[0]);
            }
            return allCookies.toArray(new EditorCookie[allCookies.size()]);
        }
    }
}

