/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.queues.PatchSeriesPanel;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class GoToPatch {
    private final File repository;
    private final PatchSeriesPanel panel;
    private HgProgressSupport support;
    private static final String GETTING_PATCHES = NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatch.loadingPatches");
    private static final String NO_PATCHES = NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatch.noPatches");
    public static final String POP_ALL_PATCHES = NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatch.popAllPatches");
    private QPatch onTopPatch;

    public GoToPatch(File repository) {
        this.repository = repository;
        this.panel = new PatchSeriesPanel();
        this.panel.lstPatches.setCellRenderer(new PatchRenderer());
    }

    public boolean showDialog() {
        final JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(GoToPatch.class, (String)"CTL_GoToPatch.ok.text"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(GoToPatch.class, (String)"LBL_GoToPatchPanel.title", (Object)this.repository.getName()), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx(GoToPatch.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        okButton.setEnabled(false);
        this.setInfo(null);
        this.panel.lstPatches.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selectedPatch = ((GoToPatch)GoToPatch.this).panel.lstPatches.getSelectedValue();
                    okButton.setEnabled(selectedPatch == POP_ALL_PATCHES && GoToPatch.this.onTopPatch != null || selectedPatch instanceof QPatch && GoToPatch.this.onTopPatch != selectedPatch);
                    if (selectedPatch == POP_ALL_PATCHES && GoToPatch.this.onTopPatch == null) {
                        GoToPatch.this.setInfo(NbBundle.getMessage(GoToPatch.class, (String)"PatchSeriesPanel.lblInfo.noAppliedPatches"));
                    } else if (selectedPatch instanceof QPatch && GoToPatch.this.onTopPatch == selectedPatch) {
                        GoToPatch.this.setInfo(NbBundle.getMessage(GoToPatch.class, (String)"PatchSeriesPanel.lblInfo.alreadyOnTop"));
                    } else {
                        GoToPatch.this.setInfo(null);
                    }
                }
            }
        });
        this.loadPatches();
        dialog.setVisible(true);
        HgProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        return dd.getValue() == okButton;
    }

    private void setInfo(String message) {
        if (message == null || message.isEmpty()) {
            this.panel.lblInfo.setVisible(false);
        } else {
            this.panel.lblInfo.setText(message);
            this.panel.lblInfo.setVisible(true);
        }
    }

    private void loadPatches() {
        this.panel.lstPatches.setListData(new String[]{GETTING_PATCHES});
        this.panel.lstPatches.setEnabled(false);
        this.support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            protected void perform() {
                QPatch[] qPatches;
                QPatch[] patches = null;
                try {
                    qPatches = patches = HgCommand.qListSeries(GoToPatch.this.repository);
                }
                catch (HgException ex) {
                    QPatch[] qPatches2 = patches;
                    EventQueue.invokeLater(new Runnable(qPatches2){
                        final /* synthetic */ QPatch[] val$qPatches;
                        {
                            this.val$qPatches = qPatchArray;
                        }

                        @Override
                        public void run() {
                            GoToPatch.this.displayPatches(this.val$qPatches);
                        }
                    });
                    catch (Throwable throwable) {
                        QPatch[] qPatches3 = patches;
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.support.start(Mercurial.getInstance().getRequestProcessor(this.repository), this.repository, GETTING_PATCHES);
    }

    private void displayPatches(QPatch[] patches) {
        if (patches == null || patches.length == 0) {
            this.panel.lstPatches.setListData(new String[]{NO_PATCHES});
        } else {
            Object[] toAdd = new Object[patches.length + 1];
            toAdd[0] = POP_ALL_PATCHES;
            int i = 0;
            while (i < patches.length) {
                QPatch p = patches[i];
                toAdd[++i] = p;
                if (!p.isApplied()) continue;
                this.onTopPatch = p;
            }
            this.panel.lstPatches.setListData(toAdd);
            this.panel.lstPatches.setEnabled(true);
            if (this.onTopPatch == null) {
                this.panel.lstPatches.setSelectedIndex(1);
            } else {
                this.panel.lstPatches.setSelectedValue(this.onTopPatch, true);
            }
            this.panel.lstPatches.requestFocusInWindow();
        }
    }

    String getSelectedPatch() {
        String retval = null;
        Object selected = this.panel.lstPatches.getSelectedValue();
        if (selected instanceof QPatch) {
            retval = ((QPatch)selected).getId();
        } else if (selected == POP_ALL_PATCHES) {
            retval = POP_ALL_PATCHES;
        }
        return retval;
    }

    private static class PatchRenderer
    extends DefaultListCellRenderer {
        private PatchRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp;
            String tooltip = null;
            if (value instanceof QPatch) {
                QPatch patch = (QPatch)value;
                StringBuilder sb = new StringBuilder(100);
                if (patch.isApplied()) {
                    sb.append("<html><strong>").append(patch.getId()).append("</strong>");
                } else {
                    sb.append(patch.getId());
                }
                sb.append(" (").append(NbBundle.getMessage(GoToPatch.class, (String)(patch.isApplied() ? "LBL_PatchSeriesPanel.applied" : "LBL_PatchSeriesPanel.unapplied"))).append(')');
                if (patch.isApplied()) {
                    sb.append("</html>");
                }
                value = sb.toString();
                if (!patch.getMessage().trim().isEmpty()) {
                    tooltip = patch.getMessage();
                }
            }
            if ((comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus)) instanceof JComponent) {
                ((JComponent)comp).setToolTipText(tooltip);
            }
            return comp;
        }
    }
}

