/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.menu;

import java.io.File;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.branch.CloseBranchAction;
import org.netbeans.modules.mercurial.ui.branch.CreateBranchAction;
import org.netbeans.modules.mercurial.ui.branch.SwitchToBranchAction;
import org.netbeans.modules.mercurial.ui.menu.DynamicMenu;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class BranchMenu
extends DynamicMenu
implements Presenter.Menu {
    private final Lookup lkp;
    private final VCSContext ctx;

    public BranchMenu(Lookup lkp) {
        this(lkp, null);
    }

    public BranchMenu(Lookup lkp, VCSContext ctx) {
        super(NbBundle.getMessage(BranchMenu.class, (String)"CTL_MenuItem_BranchMenu"));
        this.lkp = lkp;
        this.ctx = ctx;
    }

    @Override
    protected JMenu createMenu() {
        JMenu menu = new JMenu(this);
        if (this.lkp == null) {
            Mnemonics.setLocalizedText((AbstractButton)menu, (String)NbBundle.getMessage(BranchMenu.class, (String)"CTL_MenuItem_BranchMenu"));
            JMenuItem item = new JMenuItem();
            SystemAction action = SystemAction.get(SwitchToBranchAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Mercurial/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(CreateBranchAction.class);
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            Utils.setAcceleratorBindings((String)"Actions/Mercurial/", (Action[])new Action[]{action});
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(CloseBranchAction.class);
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            Utils.setAcceleratorBindings((String)"Actions/Mercurial/", (Action[])new Action[]{action});
            menu.add(item);
        } else {
            JMenuItem item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SwitchToBranchAction.class), (String)NbBundle.getMessage(SwitchToBranchAction.class, (String)"CTL_PopupMenuItem_SwitchToBranch"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            if (this.ctx != null) {
                List recentlySwitched;
                File repositoryRoot = null;
                for (File f : this.ctx.getRootFiles()) {
                    repositoryRoot = Mercurial.getInstance().getRepositoryRoot(f);
                    if (repositoryRoot == null) continue;
                    break;
                }
                if (repositoryRoot != null && !(recentlySwitched = Utils.getStringList((Preferences)NbPreferences.forModule(BranchMenu.class), (String)("recentlySwitchedBranches" + repositoryRoot.getAbsolutePath()))).isEmpty()) {
                    int index = 0;
                    for (String recentBranch : recentlySwitched) {
                        menu.add(new SwitchToBranchAction.KnownBranchAction(recentBranch, this.ctx));
                        if (++index <= 2) continue;
                        break;
                    }
                    menu.add(new JSeparator());
                }
            }
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CreateBranchAction.class), (String)NbBundle.getMessage(CreateBranchAction.class, (String)"CTL_PopupMenuItem_CreateBranch"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CloseBranchAction.class), (String)NbBundle.getMessage(CloseBranchAction.class, (String)"CTL_PopupMenuItem_CloseBranch"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        return menu;
    }

    public JMenuItem getMenuPresenter() {
        JMenu menu = this.createMenu();
        menu.setText(NbBundle.getMessage(BranchMenu.class, (String)"CTL_MenuItem_BranchMenu.popupName"));
        BranchMenu.enableMenu(menu);
        return menu;
    }
}

