/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.ui.rollback.BackoutAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

final class SummaryView
extends AbstractSummaryView
implements DiffSetupSource {
    private final SearchHistoryPanel master;
    private static DateFormat defaultFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final Color HIGHLIGHT_BRANCH_FG = Color.BLACK;
    private static final Color HIGHLIGHT_TAG_FG = Color.BLACK;
    private static final Color HIGHLIGHT_BRANCH_BG = Color.decode("0xd5dde6");
    private static final Color HIGHLIGHT_BRANCH_HEAD_BG = Color.decode("0xaaffaa");
    private static final Color HIGHLIGHT_TAG_BG = Color.decode("0xffffaa");

    public SummaryView(SearchHistoryPanel master, List<? extends AbstractSummaryView.LogEntry> results, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap) {
        super(SummaryView.createViewSummaryMaster(master), results, kenaiUserMap);
        this.master = master;
    }

    private static AbstractSummaryView.SummaryViewMaster createViewSummaryMaster(final SearchHistoryPanel master) {
        final HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("A", "#008000");
        colors.put("C", "#008000");
        colors.put("R", "#008000");
        colors.put("M", "#0000ff");
        colors.put("D", "#999999");
        return new AbstractSummaryView.SummaryViewMaster(){

            public JComponent getComponent() {
                return master;
            }

            public File[] getRoots() {
                return master.getRoots();
            }

            public Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> getSearchHighlights() {
                return master.getSearchHighlights();
            }

            public Map<String, String> getActionColors() {
                return colors;
            }

            public void getMoreResults(PropertyChangeListener callback, int count) {
                master.getMoreRevisions(callback, count);
            }

            public boolean hasMoreResults() {
                return master.hasMoreResults();
            }
        };
    }

    @Override
    public Collection<Setup> getSetups() {
        Object[] sel;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            List<RepositoryRevision> results = this.master.getResults();
            return this.master.getSetups(results.toArray(new RepositoryRevision[results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Object revCon : sel = this.getSelection()) {
            if (revCon instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)revCon);
                continue;
            }
            events.add((RepositoryRevision.Event)revCon);
        }
        return this.master.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    protected void onPopup(JComponent invoker, Point p, final Object[] selection) {
        boolean diffToPrevEnabled;
        boolean viewEnabled;
        RepositoryRevision.Event[] drev;
        RepositoryRevision container;
        boolean revisionSelected;
        if (this.master.isIncomingSearch()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        String previousRevision = null;
        Object revCon = selection[0];
        boolean noExDeletedExistingFiles = true;
        boolean missingFile = false;
        boolean oneRevisionMultiselected = true;
        if (revCon instanceof HgLogEntry && selection.length == 1) {
            revisionSelected = true;
            container = ((HgLogEntry)selection[0]).revision;
            drev = new RepositoryRevision.Event[]{};
            oneRevisionMultiselected = true;
            noExDeletedExistingFiles = true;
        } else {
            revisionSelected = false;
            drev = new RepositoryRevision.Event[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof HgLogEvent)) {
                    return;
                }
                drev[i] = ((HgLogEvent)((Object)selection[i])).getEvent();
                if (!missingFile && drev[i].getFile() == null) {
                    missingFile = true;
                }
                if (oneRevisionMultiselected && i > 0 && drev[0].getLogInfoHeader().getLog().getRevisionNumber().equals(drev[i].getLogInfoHeader().getLog().getRevisionNumber())) {
                    oneRevisionMultiselected = false;
                }
                if (drev[i].getFile() == null || !drev[i].getFile().exists() || drev[i].getChangedPath().getAction() != 'D') continue;
                noExDeletedExistingFiles = false;
            }
            container = drev[0].getLogInfoHeader();
        }
        long revision = Long.parseLong(container.getLog().getRevisionNumber());
        final boolean revertToEnabled = !missingFile && !revisionSelected && oneRevisionMultiselected;
        final boolean backoutChangeEnabled = !missingFile && oneRevisionMultiselected && drev.length == 0;
        final boolean annotationsEnabled = viewEnabled = selection.length == 1 && !revisionSelected && drev[0].getFile() != null && drev[0].getChangedPath().getAction() != HgLogMessage.HgDelStatus;
        boolean bl = diffToPrevEnabled = selection.length == 1;
        if (revision > 0L) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)("" + previousRevision))){
                {
                    super(x0);
                    this.setEnabled(diffToPrevEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.diffPrevious(SummaryView.this.master, selection[0]);
                }
            }));
        }
        if (revisionSelected) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
                {
                    super(x0);
                    this.setEnabled(backoutChangeEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.backout(container);
                }
            }));
        } else {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)("" + revision))){
                {
                    super(x0);
                    this.setEnabled(revertToEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.revertModifications(selection);
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.view(drev[0], false);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(annotationsEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.view(drev[0], true);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ExportFileDiff")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.exportFileDiff(drev[0]);
                }
            }));
        }
        menu.show(invoker, p.x, p.y);
    }

    private static void backout(RepositoryRevision repoRev) {
        BackoutAction.backout(repoRev);
    }

    static void backout(RepositoryRevision.Event event) {
        RepositoryRevision repoRev = event.getLogInfoHeader();
        BackoutAction.backout(repoRev);
    }

    static void revertModifications(RepositoryRevision.Event event) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        events.add(event);
        SummaryView.revert(null, events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    public void revertModifications(Object[] selection) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Object o : selection) {
            if (o instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)o);
                continue;
            }
            if (o instanceof HgLogEntry) {
                revisions.add(((HgLogEntry)o).getRepositoryRevision());
                continue;
            }
            if (o instanceof AbstractSummaryView.LogEntry.Event) {
                events.add(((HgLogEvent)((Object)o)).getEvent());
                continue;
            }
            events.add((RepositoryRevision.Event)o);
        }
        SummaryView.revert(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    static void revert(final RepositoryRevision[] revisions, final RepositoryRevision.Event[] events) {
        File root;
        if (revisions == null || revisions.length == 0) {
            if (events == null || events.length == 0 || events[0].getLogInfoHeader() == null) {
                return;
            }
            root = events[0].getLogInfoHeader().getRepositoryRoot();
        } else {
            root = revisions[0].getRepositoryRoot();
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                SummaryView.revertImpl(revisions, events, this);
            }
        };
        support.start(rp, root, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(RepositoryRevision[] revisions, RepositoryRevision.Event[] events, HgProgressSupport progress) {
        ArrayList<File> revertFiles = new ArrayList<File>();
        boolean doBackup = HgModuleConfig.getDefault().getBackupOnRevertModifications();
        if (revisions != null) {
            for (RepositoryRevision revision : revisions) {
                File root = revision.getRepositoryRoot();
                for (RepositoryRevision.Event event : revision.getEvents()) {
                    if (event.getFile() == null) continue;
                    revertFiles.add(event.getFile());
                }
                RevertModificationsAction.performRevert(root, revision.getLog().getRevisionNumber(), revertFiles, doBackup, false, progress.getLogger());
                revertFiles.clear();
            }
        }
        HashMap<File, ArrayList<RepositoryRevision.Event>> revertMap = new HashMap<File, ArrayList<RepositoryRevision.Event>>();
        for (RepositoryRevision.Event event : events) {
            ArrayList<RepositoryRevision.Event> revEvents;
            if (event.getFile() == null) continue;
            File root = Mercurial.getInstance().getRepositoryRoot(event.getFile());
            if (revertMap == null) {
                revertMap = new HashMap();
            }
            if ((revEvents = (ArrayList<RepositoryRevision.Event>)revertMap.get(root)) == null) {
                revEvents = new ArrayList<RepositoryRevision.Event>();
                revertMap.put(root, revEvents);
            }
            revEvents.add(event);
        }
        if (events != null && events.length > 0 && revertMap != null && !revertMap.isEmpty()) {
            Set roots = revertMap.keySet();
            for (File root : roots) {
                List revEvents = (List)revertMap.get(root);
                for (RepositoryRevision.Event event : revEvents) {
                    if (event.getFile() == null) continue;
                    revertFiles.add(event.getFile());
                }
                if (revEvents == null || revEvents.isEmpty()) continue;
                RevertModificationsAction.performRevert(root, ((RepositoryRevision.Event)revEvents.get(0)).getLogInfoHeader().getLog().getRevisionNumber(), revertFiles, doBackup, false, progress.getLogger());
            }
        }
    }

    private static void view(RepositoryRevision.Event drev, boolean showAnnotations) {
        try {
            HgUtils.openInRevision(drev.getFile(), -1, drev.getLogInfoHeader().getLog().getHgRevision(), showAnnotations);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void diffPrevious(SearchHistoryPanel master, Object o) {
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            master.showDiff(drev);
        } else if (o instanceof AbstractSummaryView.LogEntry.Event) {
            RepositoryRevision.Event drev = ((HgLogEvent)((Object)o)).getEvent();
            master.showDiff(drev);
        } else if (o instanceof HgLogEntry) {
            RepositoryRevision container = ((HgLogEntry)o).getRepositoryRevision();
            master.showDiff(container);
        } else {
            RepositoryRevision container = (RepositoryRevision)o;
            master.showDiff(container);
        }
    }

    private void exportDiffs(RepositoryRevision repoRev) {
        ExportDiffAction.exportDiffRevision(repoRev, this.master.getRoots());
    }

    private static void exportFileDiff(RepositoryRevision.Event drev) {
        ExportDiffAction.exportDiffFileRevision(drev);
    }

    static class HgLogEvent
    extends AbstractSummaryView.LogEntry.Event {
        private final RepositoryRevision.Event event;
        private final SearchHistoryPanel master;

        HgLogEvent(SearchHistoryPanel master, RepositoryRevision.Event event) {
            this.master = master;
            this.event = event;
        }

        public String getPath() {
            return this.event.getChangedPath().getPath();
        }

        public String getOriginalPath() {
            return this.event.getChangedPath().getCopySrcPath();
        }

        public String getAction() {
            return Character.toString(this.event.getChangedPath().getAction());
        }

        public RepositoryRevision.Event getEvent() {
            return this.event;
        }

        public Action[] getUserActions() {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            if (!this.master.isIncomingSearch()) {
                boolean viewEnabled = this.event.getFile() != null && this.event.getChangedPath().getAction() != HgLogMessage.HgDelStatus;
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(HgLogEvent.this.master, HgLogEvent.this.event);
                    }
                });
                if (this.event.getFile() != null) {
                    actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)this.event.getLogInfoHeader().getLog().getRevisionNumber())){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SummaryView.revertModifications(HgLogEvent.this.event);
                        }
                    });
                }
                if (viewEnabled) {
                    actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    SummaryView.view(HgLogEvent.this.event, false);
                                }
                            });
                        }
                    });
                    actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    SummaryView.view(HgLogEvent.this.event, true);
                                }
                            });
                        }
                    });
                    actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ExportFileDiff")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SummaryView.exportFileDiff(HgLogEvent.this.event);
                        }
                    });
                }
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean isVisibleByDefault() {
            return this.master.isShowInfo() || this.event.isUnderRoots();
        }

        public String toString() {
            return this.event.toString();
        }
    }

    static final class HgLogEntry
    extends AbstractSummaryView.LogEntry
    implements PropertyChangeListener {
        private RepositoryRevision revision;
        private List<AbstractSummaryView.LogEntry.Event> events = new ArrayList<AbstractSummaryView.LogEntry.Event>(10);
        private List<AbstractSummaryView.LogEntry.Event> dummyEvents;
        private SearchHistoryPanel master;
        private String complexRevision;
        private final PropertyChangeListener list;
        private Collection<AbstractSummaryView.LogEntry.RevisionHighlight> complexRevisionHighlights;

        public HgLogEntry(RepositoryRevision revision, SearchHistoryPanel master) {
            this.revision = revision;
            this.master = master;
            this.dummyEvents = Collections.emptyList();
            if (revision.isEventsInitialized()) {
                this.refreshEvents();
                this.list = null;
            } else {
                this.prepareDummyEvents();
                this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)revision);
                revision.addPropertyChangeListener("eventsChanged", this.list);
            }
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getEvents() {
            return this.events;
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getDummyEvents() {
            return this.dummyEvents;
        }

        public String getAuthor() {
            return this.revision.getLog().getAuthor();
        }

        public String getDate() {
            Date date = this.revision.getLog().getDate();
            return date != null ? defaultFormat.format(date) : null;
        }

        public String getRevision() {
            if (this.complexRevision == null) {
                this.complexRevisionHighlights = new ArrayList<AbstractSummaryView.LogEntry.RevisionHighlight>(this.revision.getLog().getBranches().length + this.revision.getLog().getTags().length + 1);
                StringBuilder sb = new StringBuilder(this.revision.getLog().getRevisionNumber()).append(" (");
                int pos = sb.length();
                StringBuilder labelBuilder = new StringBuilder();
                if (this.revision.getLog().getBranches().length == 0 && this.revision.isHeadOfBranch(HgBranch.DEFAULT_NAME)) {
                    this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(pos + labelBuilder.length(), HgBranch.DEFAULT_NAME.length(), HIGHLIGHT_BRANCH_FG, HIGHLIGHT_BRANCH_HEAD_BG));
                    labelBuilder.append(HgBranch.DEFAULT_NAME).append(' ');
                } else {
                    for (String s : this.revision.getLog().getBranches()) {
                        this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(pos + labelBuilder.length(), s.length(), HIGHLIGHT_BRANCH_FG, this.revision.isHeadOfBranch(s) ? HIGHLIGHT_BRANCH_HEAD_BG : HIGHLIGHT_BRANCH_BG));
                        labelBuilder.append(s).append(' ');
                    }
                }
                for (String s : this.revision.getLog().getTags()) {
                    this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(pos + labelBuilder.length(), s.length(), HIGHLIGHT_TAG_FG, HIGHLIGHT_TAG_BG));
                    labelBuilder.append(s).append(' ');
                }
                if (labelBuilder.length() == 0) {
                    labelBuilder.append(this.revision.getLog().getCSetShortID());
                } else {
                    labelBuilder.append(this.revision.getLog().getCSetShortID().substring(0, 7));
                }
                this.complexRevision = sb.append((CharSequence)labelBuilder).append(")").toString();
            }
            return this.complexRevision;
        }

        protected Collection<AbstractSummaryView.LogEntry.RevisionHighlight> getRevisionHighlights() {
            this.getRevision();
            return this.complexRevisionHighlights;
        }

        public String getMessage() {
            return this.revision.getLog().getMessage();
        }

        public Action[] getActions() {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            if (!this.master.isIncomingSearch()) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffRevision")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(HgLogEntry.this.master, HgLogEntry.this.revision);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_BackoutRevision")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.backout(HgLogEntry.this.revision);
                    }
                });
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public String toString() {
            return this.revision.toString();
        }

        protected void expand() {
            this.revision.expandEvents();
        }

        protected void cancelExpand() {
            this.revision.cancelExpand();
        }

        protected boolean isEventsInitialized() {
            return this.revision.isEventsInitialized();
        }

        public boolean isVisible() {
            return this.master.applyFilter(this.revision);
        }

        protected boolean isLessInteresting() {
            return this.getRepositoryRevision().getLog().isMerge();
        }

        RepositoryRevision getRepositoryRevision() {
            return this.revision;
        }

        void prepareDummyEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getDummyEvents().length);
            for (RepositoryRevision.Event event : this.revision.getDummyEvents()) {
                evts.add(new HgLogEvent(this.master, event));
            }
            this.dummyEvents = evts;
        }

        void refreshEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getEvents().length);
            for (RepositoryRevision.Event event : this.revision.getEvents()) {
                evts.add(new HgLogEvent(this.master, event));
            }
            ArrayList<AbstractSummaryView.LogEntry.Event> oldEvents = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.events);
            ArrayList newEvents = new ArrayList(evts);
            this.dummyEvents.clear();
            this.events = evts;
            this.eventsChanged(oldEvents, newEvents);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("eventsChanged".equals(evt.getPropertyName()) && this.revision == evt.getSource()) {
                this.refreshEvents();
            }
        }
    }
}

