/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.HistoryRegistry;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;

public class RepositoryRevision {
    private HgLogMessage message;
    private final File repositoryRoot;
    private final File[] selectionRoots;
    private boolean eventsInitialized;
    private Search currentSearch;
    private final PropertyChangeSupport support;
    public static final String PROP_EVENTS_CHANGED = "eventsChanged";
    private final List<Event> events = new ArrayList<Event>(5);
    private final List<Event> dummyEvents;
    private final boolean incoming;
    private final Set<String> headOfBranches;

    public RepositoryRevision(HgLogMessage message, File repositoryRoot, File[] selectionRoots, boolean isIncoming, Set<String> headOfBranches) {
        this.message = message;
        this.repositoryRoot = repositoryRoot;
        this.selectionRoots = selectionRoots;
        this.incoming = isIncoming;
        this.headOfBranches = headOfBranches;
        this.support = new PropertyChangeSupport(this);
        this.dummyEvents = this.prepareEvents(message.getDummyChangedPaths());
    }

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    Event[] getEvents() {
        return this.events.toArray(new Event[this.events.size()]);
    }

    Event[] getDummyEvents() {
        return this.dummyEvents.toArray(new Event[this.dummyEvents.size()]);
    }

    public HgLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getLog().getRevisionNumber());
        text.append("\t");
        text.append(this.getLog().getCSetShortID());
        text.append("\t");
        text.append(this.getLog().getDate());
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getMessage());
        return text.toString();
    }

    boolean expandEvents() {
        Search s = this.currentSearch;
        if (s == null && !this.eventsInitialized) {
            this.currentSearch = new Search();
            this.currentSearch.start(Mercurial.getInstance().getRequestProcessor(this.repositoryRoot));
            return true;
        }
        return !this.eventsInitialized;
    }

    void cancelExpand() {
        Search s = this.currentSearch;
        if (s != null) {
            s.cancel();
            this.currentSearch = null;
        }
    }

    boolean isEventsInitialized() {
        return this.eventsInitialized;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    boolean isHeadOfBranch(String branchName) {
        return this.headOfBranches.contains(branchName);
    }

    private List<Event> prepareEvents(HgLogMessageChangedPath[] paths) {
        ArrayList<Event> logEvents = new ArrayList<Event>(paths.length);
        for (HgLogMessageChangedPath path : paths) {
            logEvents.add(new Event(path));
        }
        for (Event event : logEvents) {
            File selectionRoot;
            String filePath = event.getChangedPath().getPath();
            File f = new File(this.repositoryRoot, filePath);
            File cachedRename = HistoryRegistry.getInstance().getHistoryFile(this.repositoryRoot, f, this.message.getCSetShortID(), true);
            boolean underRoots = false;
            File[] arr$ = this.selectionRoots;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(underRoots = VersioningSupport.isFlat((File)(selectionRoot = arr$[i$])) ? selectionRoot.equals(f.getParentFile()) : Utils.isAncestorOrEqual((File)selectionRoot, (File)f)); ++i$) {
            }
            if (cachedRename != null) {
                f = cachedRename;
            }
            event.setFile(f, underRoots);
            event.setOriginalFile(f);
        }
        for (Event event : logEvents) {
            if (event.getChangedPath().getAction() != HgLogMessage.HgCopyStatus && event.getChangedPath().getAction() != HgLogMessage.HgRenameStatus || event.getChangedPath().getCopySrcPath() == null) continue;
            File originalFile = new File(this.repositoryRoot, event.getChangedPath().getCopySrcPath());
            event.setOriginalFile(originalFile);
        }
        return logEvents;
    }

    private class Search
    extends HgProgressSupport {
        private Search() {
        }

        @Override
        protected void perform() {
            HistoryRegistry.ChangePathCollector coll = RepositoryRevision.this.incoming ? new HistoryRegistry.ChangePathCollector(){

                @Override
                public HgLogMessageChangedPath[] getChangePaths() {
                    HgLogMessage[] messages = HgCommand.getIncomingMessages(RepositoryRevision.this.repositoryRoot, RepositoryRevision.this.getLog().getCSetShortID(), true, true, false, 1, Search.this.getLogger());
                    return messages == null || messages.length == 0 ? new HgLogMessageChangedPath[]{} : messages[0].getChangedPaths();
                }
            } : new HistoryRegistry.DefaultChangePathCollector(RepositoryRevision.this.repositoryRoot, this.getLogger(), RepositoryRevision.this.getLog().getCSetShortID());
            List<HgLogMessageChangedPath> pathList = HistoryRegistry.getInstance().initializeChangePaths(RepositoryRevision.this.repositoryRoot, coll, RepositoryRevision.this.getLog(), false);
            HgLogMessageChangedPath[] paths = pathList.toArray(new HgLogMessageChangedPath[pathList.size()]);
            final List logEvents = RepositoryRevision.this.prepareEvents(paths);
            if (!this.isCanceled()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Search.this.isCanceled()) {
                            RepositoryRevision.this.events.clear();
                            RepositoryRevision.this.dummyEvents.clear();
                            RepositoryRevision.this.events.addAll(logEvents);
                            RepositoryRevision.this.eventsInitialized = true;
                            RepositoryRevision.this.currentSearch = null;
                            RepositoryRevision.this.support.firePropertyChange(RepositoryRevision.PROP_EVENTS_CHANGED, null, new ArrayList(RepositoryRevision.this.events));
                        }
                    }
                });
            }
        }

        @Override
        protected void finnishProgress() {
        }

        @Override
        protected void startProgress() {
        }

        @Override
        protected ProgressHandle getProgressHandle() {
            return null;
        }
    }

    public class Event {
        private File file;
        private File originalFile;
        private HgLogMessageChangedPath changedPath;
        private String name;
        private String path;
        private boolean underRoots;

        Event(HgLogMessageChangedPath changedPath) {
            this.changedPath = changedPath;
            this.name = changedPath.getPath().substring(changedPath.getPath().lastIndexOf(47) + 1);
            int indexPath = changedPath.getPath().lastIndexOf(47);
            this.path = indexPath > -1 ? changedPath.getPath().substring(0, indexPath) : "";
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        HgLogMessageChangedPath getChangedPath() {
            return this.changedPath;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file, boolean isUnderRoots) {
            this.file = file;
            this.underRoots = isUnderRoots;
        }

        public File getOriginalFile() {
            return this.originalFile;
        }

        void setOriginalFile(File file) {
            this.originalFile = file;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.changedPath.getPath();
        }

        boolean isUnderRoots() {
            return this.underRoots;
        }
    }
}

