/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.DiffResultsViewForLine;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryAction;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryTopComponent;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LogAction
extends SearchHistoryAction {
    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Log";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        this.openHistory(context, NbBundle.getMessage(LogAction.class, (String)"MSG_Log_TabTitle", (Object)Utils.getContextDisplayName((VCSContext)context)));
    }

    private void openHistory(VCSContext context, String title) {
        File repositoryRoot = this.getRepositoryRoot(context);
        File[] files = LogAction.replaceCopiedFiles(this.getFiles(context, repositoryRoot));
        LogAction.openHistory(repositoryRoot, files, title);
    }

    public static void openHistory(File repositoryRoot, File[] files) {
        ArrayList<Node> nodes = new ArrayList<Node>(files.length);
        for (File file : files) {
            DataObject dao;
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            try {
                dao = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            nodes.add(dao.getNodeDelegate());
        }
        if (nodes.isEmpty()) {
            return;
        }
        String title = NbBundle.getMessage(LogAction.class, (String)"MSG_Log_TabTitle", (Object)Utils.getContextDisplayName((VCSContext)VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]))));
        LogAction.openHistory(repositoryRoot, files, title);
    }

    private static void openHistory(final File repositoryRoot, final File[] files, final String title) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                if (files == null) {
                    return;
                }
                SearchHistoryAction.outputSearchContextTab(repositoryRoot, files, "MSG_Log_Title");
                final boolean startSearch = files != null && (files.length == 1 && !files[0].isDirectory() || files.length > 1 && Utils.shareCommonDataObject((File[])files));
                HgLogMessage[] parents = WorkingCopyInfo.getInstance(repositoryRoot).getWorkingCopyParents();
                final String branchName = parents.length == 1 ? (parents[0].getBranches().length > 0 ? parents[0].getBranches()[0] : HgBranch.DEFAULT_NAME) : "";
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(files, branchName);
                        tc.setDisplayName(title);
                        tc.open();
                        tc.requestActive();
                        if (startSearch) {
                            tc.search(false);
                        }
                    }
                });
            }
        }, (int)0);
    }

    private static File[] replaceCopiedFiles(File[] files) {
        if (files == null) {
            return null;
        }
        LinkedHashSet<File> originalFiles = new LinkedHashSet<File>(files.length);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (File file : files) {
            FileStatus st = cache.getStatus(file).getStatus(null);
            if (st != null && st.isCopied() && st.getOriginalFile() != null) {
                file = st.getOriginalFile();
            }
            originalFiles.add(file);
        }
        return originalFiles.toArray(new File[originalFiles.size()]);
    }

    public static void openSearch(File file, final int lineNumber) {
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(file, new SearchHistoryTopComponent.DiffResultsViewFactory(){

            @Override
            DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
                return new DiffResultsViewForLine(panel, results, lineNumber);
            }
        });
        String tcTitle = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)file.getName());
        tc.setDisplayName(tcTitle);
        tc.open();
        tc.requestActive();
        tc.search(true);
        tc.activateDiffView(true);
    }
}

