/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final HgLogMessage.HgRevision revision;
    private final String title;
    private String mimeType;
    private Boolean start;
    private File remoteFile;
    private Boolean canWriteBaseFile;

    public DiffStreamSource(File baseFile, HgLogMessage.HgRevision revision, String title) {
        this.baseFile = Utilities.isMac() || Utilities.isWindows() ? FileUtil.normalizeFile((File)baseFile) : baseFile;
        this.revision = revision;
        this.title = title;
        this.start = true;
    }

    public DiffStreamSource(String title) {
        this.baseFile = null;
        this.revision = null;
        this.title = title;
        this.start = true;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        if (this.baseFile.isDirectory()) {
            return "content/unknown";
        }
        try {
            this.init();
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        if (this.baseFile.isDirectory()) {
            return new StringReader(NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_NoFolderDiff"));
        }
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return HgLogMessage.HgRevision.CURRENT.equals(this.revision) && this.isPrimary() && this.isBaseFileWritable();
    }

    private boolean isBaseFileWritable() {
        if (this.canWriteBaseFile == null) {
            FileObject fo = FileUtil.toFileObject((File)this.baseFile);
            this.canWriteBaseFile = fo != null && fo.canWrite();
        }
        return this.canWriteBaseFile;
    }

    private boolean isPrimary() {
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    synchronized void init() throws IOException {
        if (this.baseFile.isDirectory()) {
            return;
        }
        if (!this.start.booleanValue()) {
            return;
        }
        this.start = false;
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        this.mimeType = Mercurial.getInstance().getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                File tempFolder = Utils.getTempFolder();
                Set allFiles = Utils.getAllDataObjectFiles((File)this.baseFile);
                for (File file : allFiles) {
                    boolean isBase = file.equals(this.baseFile);
                    try {
                        File rf = VersionsCache.getInstance().getFileRevision(file, this.revision);
                        if (rf == null || !rf.exists()) {
                            this.remoteFile = null;
                            return;
                        }
                        File newRemoteFile = new File(tempFolder, file.getName());
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(newRemoteFile), (InputStream)new FileInputStream(rf));
                        newRemoteFile.deleteOnExit();
                        if (!isBase) continue;
                        this.remoteFile = newRemoteFile;
                        Utils.associateEncoding((File)file, (File)newRemoteFile);
                    }
                    catch (Exception e) {
                        if (!isBase) continue;
                        throw e;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = Mercurial.getInstance().getMimeType(this.remoteFile);
            }
        }
        catch (Exception e) {
            throw new IOException("Can not load remote file for " + this.baseFile, e);
        }
    }
}

