/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;

public class ThreadStateCellRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private Color unselectedBackground;
    private Color unselectedForeground;
    private ThreadData threadData;
    private ThreadsPanel viewManager;
    private long dataEnd;
    private long dataStart;
    private long viewEnd;
    private long viewStart;

    public ThreadStateCellRenderer(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.isFocusOwner() ? table.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            super.setBackground(table.isFocusOwner() ? table.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if ((row & 1) == 0) {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(UIUtils.getDarker(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground()));
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        if (value instanceof ThreadData) {
            this.threadData = (ThreadData)value;
        }
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.dataEnd = this.viewManager.getDataEnd();
        return this;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void paint(Graphics g) {
        int index;
        super.paint(g);
        this.paintTimeMarks(g);
        if (this.threadData != null && (index = this.getFirstVisibleDataUnit()) != -1) {
            int width = this.getWidth();
            if (this.viewEnd - this.viewStart > 0L) {
                float factor = (float)width / (float)(this.viewEnd - this.viewStart);
                while (index < this.threadData.size() && this.threadData.getTimeStampAt(index) <= this.viewEnd) {
                    if (this.threadData.getStateAt(index) != 0) {
                        this.paintThreadState(g, index, this.threadData.getThreadStateColorAt(index), factor, width);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public void validate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    private boolean isFinishedDataUnit(int index) {
        return this.threadData.getStateAt(index) == 0;
    }

    private int getFirstVisibleDataUnit() {
        for (int i = 0; i < this.threadData.size(); ++i) {
            long timestamp = this.threadData.getTimeStampAt(i);
            if (timestamp <= this.viewEnd && i == this.threadData.size() - 1) {
                return i;
            }
            if (!(timestamp <= this.viewStart ? this.threadData.getTimeStampAt(i + 1) > this.viewStart : timestamp <= this.viewEnd)) continue;
            return i;
        }
        return -1;
    }

    private boolean isLastDataUnit(int index) {
        return index == this.threadData.size() - 1;
    }

    private void paintThreadState(Graphics g, int index, Color threadStateColor, float factor, int width) {
        int x = Math.max((int)((float)(this.threadData.getTimeStampAt(index) - this.viewStart) * factor), 0);
        int xx = index < this.threadData.size() - 1 ? Math.min((int)((float)(this.threadData.getTimeStampAt(index + 1) - this.viewStart) * factor), width) : Math.min((int)((float)(this.dataEnd - this.viewStart) * factor), width + 1);
        g.setColor(threadStateColor);
        g.fillRect(x, 4, xx - x, this.getHeight() - 8);
    }

    private void paintTimeMarks(Graphics g) {
        if (this.viewEnd - this.viewStart > 0L) {
            int firstValue = (int)(this.viewStart - this.dataStart);
            int lastValue = (int)(this.viewEnd - this.dataStart);
            float factor = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int optimalUnits = TimeLineUtils.getOptimalUnits(factor);
            int firstMark = Math.max((int)(Math.ceil((double)firstValue / (double)optimalUnits) * (double)optimalUnits), 0);
            for (int currentMark = firstMark - optimalUnits; currentMark <= lastValue + optimalUnits; currentMark += optimalUnits) {
                if (currentMark < 0) continue;
                float currentMarkRel = currentMark - firstValue;
                int markPosition = (int)(currentMarkRel * factor);
                this.paintTimeTicks(g, (int)(currentMarkRel * factor), (int)((currentMarkRel + (float)optimalUnits) * factor), TimeLineUtils.getTicksCount(optimalUnits));
                g.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                g.drawLine(markPosition, 0, markPosition, this.getHeight() - 1);
            }
        }
    }

    private void paintTimeTicks(Graphics g, int startPos, int endPos, int count) {
        float factor = (float)(endPos - startPos) / (float)count;
        g.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < count; ++i) {
            int x = startPos + (int)((float)i * factor);
            g.drawLine(x, 0, x, this.getHeight() - 1);
        }
    }
}

