/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.AllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.modules.profiler.api.GoToSource;

public class SnapshotAllocResultsPanel
extends AllocResultsPanel
implements ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_ShowStackTracesPopupItemName");
    private AllocMemoryResultsSnapshot snapshot;
    private JMenuItem popupShowSource;
    private JMenuItem popupShowStacks;
    private JPopupMenu memoryResPopupMenu;

    public SnapshotAllocResultsPanel(AllocMemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler);
        this.snapshot = snapshot;
        this.fetchResultsFromSnapshot();
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (e.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.showSourceForClass(this.selectedClassId);
        }
    }

    @Override
    protected String getClassName(int classId) {
        return this.snapshot.getClassName(classId);
    }

    @Override
    protected String[] getClassNames() {
        return this.snapshot.getClassNames();
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font boldfont = this.memoryResPopupMenu.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setFont(boldfont);
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
            }
            if (this.snapshot.containsStacks()) {
                if (GoToSource.isAvailable()) {
                    this.memoryResPopupMenu.addSeparator();
                }
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
        }
        return this.memoryResPopupMenu;
    }

    private void fetchResultsFromSnapshot() {
        this.totalAllocObjectsSize = UIUtils.copyArray(this.snapshot.getObjectsSizePerClass());
        this.nTotalAllocObjects = UIUtils.copyArray(this.snapshot.getObjectsCounts());
        this.nTrackedItems = this.snapshot.getNProfiledClasses();
        if (this.nTrackedItems > this.nTotalAllocObjects.length) {
            this.nTrackedItems = this.nTotalAllocObjects.length;
        }
        if (this.nTrackedItems > this.totalAllocObjectsSize.length) {
            this.nTrackedItems = this.totalAllocObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalBytes = 0L;
        this.nTotalClasses = 0L;
        for (int i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalAllocObjectsSize[i]) {
                this.maxValue = this.totalAllocObjectsSize[i];
            }
            this.nTotalBytes += this.totalAllocObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalAllocObjects[i];
        }
        this.initDataUponResultsFetch();
    }

    public void exportData(int typeOfFile, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (typeOfFile) {
            case 1: {
                this.exportCSV(",", eDD);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD);
                break;
            }
            case 3: {
                this.exportXML(eDD, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, viewName);
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private void exportHTML(ExportDataDumper eDD, String viewName) {
        int i;
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append("<th>").append(this.columnNames[i]).append("</th>");
        }
        result.append("</tr>");
        eDD.dumpData(result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[i]) + "</td>");
            result.append("<td align=\"right\">").append(this.percentFormat.format((double)this.totalAllocObjectsSize[i] / (double)this.nTotalBytes)).append("</td>");
            result.append("<td align=\"right\">").append(this.totalAllocObjectsSize[i]).append("</td>");
            result.append("<td align=\"right\">").append(this.nTotalAllocObjects[i]).append("</td></tr>");
            eDD.dumpData(result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, String viewName) {
        int i;
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\">" + newline);
        result.append(" <TableData NumRows=\"").append(this.nTrackedItems).append("\" NumColumns=\"4\">").append(newline).append("<TableHeader>");
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append("  <TableColumn><![CDATA[").append(this.columnNames[i]).append("]]></TableColumn>").append(newline);
        }
        result.append("</TableHeader>");
        eDD.dumpData(result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("  <TableRow>" + newline + "   <TableColumn><![CDATA[" + this.sortedClassNames[i] + "]]></TableColumn>" + newline);
            result.append("   <TableColumn><![CDATA[").append(this.percentFormat.format((double)this.totalAllocObjectsSize[i] / (double)this.nTotalBytes)).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.totalAllocObjectsSize[i]).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.nTotalAllocObjects[i]).append("]]></TableColumn>").append(newline).append("  </TableRow>").append(newline);
            eDD.dumpData(result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData(result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer();
            result.append(quote).append(this.sortedClassNames[i]).append(quote).append(separator);
            result.append(quote).append(this.percentFormat.format((double)this.totalAllocObjectsSize[i] / (double)this.nTotalBytes)).append(quote).append(separator);
            result.append(quote).append(this.totalAllocObjectsSize[i]).append(quote).append(separator);
            result.append(quote).append(this.nTotalAllocObjects[i]).append(quote).append(newLine);
            eDD.dumpData(result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

