/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.PercentLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerGCXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;

public final class SurvivingGenerationsGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final boolean smallPanel;

    public static SurvivingGenerationsGraphPanel createBigPanel(VMTelemetryModels models) {
        return new SurvivingGenerationsGraphPanel(models, false, null);
    }

    public static SurvivingGenerationsGraphPanel createSmallPanel(VMTelemetryModels models, Action chartAction) {
        return new SurvivingGenerationsGraphPanel(models, true, chartAction);
    }

    private SurvivingGenerationsGraphPanel(VMTelemetryModels models, boolean smallPanel, Action chartAction) {
        this.models = models;
        this.smallPanel = smallPanel;
        this.initComponents(chartAction);
        models.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                SurvivingGenerationsGraphPanel.this.updateData();
            }

            public void dataReset() {
                SurvivingGenerationsGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
        VMTelemetryDataManager manager;
        long[] timestamps;
        if (this.smallPanel && this.chart.fitsWidth() && (timestamps = manager.timeStamps)[(manager = this.models.getDataManager()).getItemCount() - 1] - timestamps[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 2L));
    }

    private void initComponents(final Action chartAction) {
        PaintersModel paintersModel = this.createGenerationsPaintersModel();
        this.chart = this.createChart(this.models.generationsItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent hAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.generationsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem survgenItem = this.models.generationsItemsModel().getItem(1);
        XYItemPainter survgenPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)survgenItem);
        SimpleLongMarksPainter survgenMarksPainter = new SimpleLongMarksPainter();
        survgenMarksPainter.setForeground(GraphsUI.SURVGEN_PAINTER_LINE_COLOR);
        AxisComponent sAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)survgenItem, survgenPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)survgenMarksPainter, 7, 2);
        SynchronousXYItem gcTimeItem = this.models.generationsItemsModel().getItem(2);
        XYItemPainter gcTimePainter = (XYItemPainter)paintersModel.getPainter((ChartItem)gcTimeItem);
        PercentLongMarksPainter gcTimeMarksPainter = new PercentLongMarksPainter(0L, 1000L);
        gcTimeMarksPainter.setForeground(GraphsUI.GC_TIME_PAINTER_LINE_COLOR);
        AxisComponent gAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)gcTimeItem, gcTimePainter, this.chart.getChartContext(), 1), (AxisMarksPainter)gcTimeMarksPainter, 3, 0);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        chartPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        chartPanel.add((Component)((Object)this.chart), new Integer[]{0});
        chartPanel.add((Component)hAxis, new Integer[]{5, 4, 6});
        chartPanel.add((Component)sAxis, new Integer[]{7, 6});
        chartPanel.add((Component)gAxis, new Integer[]{3, 4});
        if (this.smallPanel) {
            this.chart.setMouseZoomingEnabled(false);
            this.chart.getSelectionModel().setHoverMode(100);
            JLabel heapSizeSmall = new JLabel(GraphsUI.SURVGEN_NAME, new ColorIcon(GraphsUI.SURVGEN_PAINTER_LINE_COLOR, null, 8, 8), 10);
            heapSizeSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            heapSizeSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JLabel usedHeapSmall = new JLabel(GraphsUI.GC_TIME_NAME, new ColorIcon(GraphsUI.GC_TIME_PAINTER_LINE_COLOR, null, 8, 8), 10);
            usedHeapSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            usedHeapSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JPanel smallLegendPanel = new JPanel(new FlowLayout(1, 0, 1));
            smallLegendPanel.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            smallLegendPanel.setBorder(new LineBorder(GraphsUI.SMALL_LEGEND_BORDER_COLOR, 1));
            smallLegendPanel.add(heapSizeSmall);
            smallLegendPanel.add(usedHeapSmall);
            JPanel smallLegendContainer = new JPanel(new FlowLayout(1));
            smallLegendContainer.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            smallLegendContainer.add(smallLegendPanel);
            this.setLayout(new BorderLayout());
            this.add((Component)chartPanel, "Center");
            this.add((Component)smallLegendContainer, "South");
            this.chart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        chartAction.actionPerformed(null);
                    }
                }
            });
            this.chartActions = new Action[0];
        } else {
            ProfilerXYTooltipPainter tooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, tooltipPainter));
            JScrollBar hScrollBar = new JScrollBar(0);
            this.chart.attachHorizontalScrollBar(hScrollBar);
            JPanel chartContainer = new JPanel(new BorderLayout());
            chartContainer.setBorder(BorderFactory.createEmptyBorder());
            chartContainer.add((Component)chartPanel, "Center");
            chartContainer.add((Component)hScrollBar, "South");
            JLabel heapSizeBig = new JLabel(GraphsUI.SURVGEN_NAME, new ColorIcon(GraphsUI.SURVGEN_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            heapSizeBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel usedHeapBig = new JLabel(GraphsUI.GC_TIME_NAME, new ColorIcon(GraphsUI.GC_TIME_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            usedHeapBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel bigLegendPanel = new JPanel(new FlowLayout(4, 7, 8));
            bigLegendPanel.setOpaque(false);
            bigLegendPanel.add(heapSizeBig);
            bigLegendPanel.add(usedHeapBig);
            JPanel legendContainer = new JPanel(new BorderLayout(0, 0));
            UIUtils.decorateProfilerPanel(legendContainer);
            legendContainer.add((Component)UIUtils.createHorizontalLine(legendContainer.getBackground()), "North");
            legendContainer.add((Component)bigLegendPanel, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)chartContainer, "Center");
            this.add((Component)legendContainer, "South");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                return GraphPanel.DATE_FORMATTER.format(new Date(timestamp));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.SURVGEN_NAME;
                    }
                    case 1: {
                        return GraphsUI.GC_TIME_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.SURVGEN_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.GC_TIME_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                switch (index) {
                    case 0: {
                        return GraphPanel.INT_FORMATTER.format(itemValue);
                    }
                    case 1: {
                        String val = GraphPanel.PERCENT_FORMATTER.format((float)itemValue / 1000.0f);
                        return this.trimPercents(val);
                    }
                }
                return null;
            }

            @Override
            public String getRowUnits(int index, long itemValue) {
                switch (index) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "%";
                    }
                }
                return null;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int index) {
                return SurvivingGenerationsGraphPanel.this.getMaxValueString(this.getRowName(index));
            }

            @Override
            public Color getExtraRowColor(int index) {
                return this.getRowColor(index);
            }

            @Override
            public String getExtraRowValue(int index) {
                SynchronousXYItem item = SurvivingGenerationsGraphPanel.this.models.generationsItemsModel().getItem(index + 1);
                switch (index) {
                    case 0: {
                        return GraphPanel.INT_FORMATTER.format(item.getMaxYValue());
                    }
                    case 1: {
                        String val = GraphPanel.PERCENT_FORMATTER.format((float)item.getMaxYValue() / 1000.0f);
                        return this.trimPercents(val);
                    }
                }
                return null;
            }

            @Override
            public String getExtraRowUnits(int index) {
                return this.getRowUnits(index, -1L);
            }

            private String trimPercents(String percents) {
                return !percents.endsWith("%") ? percents : percents.substring(0, percents.length() - 1).trim();
            }
        };
    }

    private PaintersModel createGenerationsPaintersModel() {
        SynchronousXYItemPainter survgenPainter = SynchronousXYItemPainter.absolutePainter((float)3.0f, (Color)GraphsUI.SURVGEN_PAINTER_LINE_COLOR, (Color)GraphsUI.SURVGEN_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker survgenMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.SURVGEN_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.SURVGEN_MARKER_LINE2_COLOR, (Color)GraphsUI.SURVGEN_MARKER_FILL_COLOR);
        CompoundXYItemPainter sgp = new CompoundXYItemPainter((XYItemPainter)survgenPainter, (XYItemPainter)survgenMarker);
        SynchronousXYItemPainter gcTimePainter = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.GC_TIME_PAINTER_LINE_COLOR, (Color)GraphsUI.GC_TIME_PAINTER_FILL_COLOR, (int)10);
        SynchronousXYItemMarker gcTimeMarker = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.GC_TIME_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.GC_TIME_MARKER_LINE2_COLOR, (Color)GraphsUI.GC_TIME_MARKER_FILL_COLOR, (int)10);
        CompoundXYItemPainter gtp = new CompoundXYItemPainter((XYItemPainter)gcTimePainter, (XYItemPainter)gcTimeMarker);
        ProfilerGCXYItemPainter gep = ProfilerGCXYItemPainter.painter(GraphsUI.GC_ACTIVITY_FILL_COLOR);
        SynchronousXYItemsModel items = this.models.generationsItemsModel();
        PaintersModel.Default model = new PaintersModel.Default(new ChartItem[]{items.getItem(0), items.getItem(1), items.getItem(2)}, (ItemPainter[])new XYItemPainter[]{gep, sgp, gtp});
        return model;
    }
}

