/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.BytesAxisUtils;
import org.netbeans.lib.profiler.charts.axis.BytesMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.BytesXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;

public final class MemoryGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final boolean smallPanel;

    public static MemoryGraphPanel createBigPanel(VMTelemetryModels models) {
        return new MemoryGraphPanel(models, false, null);
    }

    public static MemoryGraphPanel createSmallPanel(VMTelemetryModels models, Action chartAction) {
        return new MemoryGraphPanel(models, true, chartAction);
    }

    private MemoryGraphPanel(VMTelemetryModels models, boolean smallPanel, Action chartAction) {
        this.models = models;
        this.smallPanel = smallPanel;
        this.initComponents(chartAction);
        models.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                MemoryGraphPanel.this.updateData();
            }

            public void dataReset() {
                MemoryGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
        VMTelemetryDataManager manager;
        long[] timestamps;
        if (this.smallPanel && this.chart.fitsWidth() && (timestamps = manager.timeStamps)[(manager = this.models.getDataManager()).getItemCount() - 1] - timestamps[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 0x4F0000L));
    }

    private void initComponents(final Action chartAction) {
        PaintersModel paintersModel = this.createMemoryPaintersModel();
        this.chart = this.createChart(this.models.memoryItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        this.chart.addPreDecorator(this.createMaxHeapDecorator());
        AxisComponent hAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.memoryItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem memoryItem = this.models.memoryItemsModel().getItem(0);
        XYItemPainter memoryPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)memoryItem);
        AxisComponent vAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new BytesXYItemMarksComputer((XYItem)memoryItem, memoryPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)new BytesMarksPainter(), 7, 2);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        chartPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        chartPanel.add((Component)((Object)this.chart), new Integer[]{0});
        chartPanel.add((Component)hAxis, new Integer[]{5, 6});
        chartPanel.add((Component)vAxis, new Integer[]{7, 6});
        if (this.smallPanel) {
            this.chart.setMouseZoomingEnabled(false);
            this.chart.getSelectionModel().setHoverMode(100);
            JLabel heapSizeSmall = new JLabel(GraphsUI.HEAP_SIZE_NAME, new ColorIcon(GraphsUI.HEAP_SIZE_PAINTER_FILL_COLOR, null, 8, 8), 10);
            heapSizeSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            heapSizeSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JLabel usedHeapSmall = new JLabel(GraphsUI.USED_HEAP_NAME, new ColorIcon(GraphsUI.USED_HEAP_PAINTER_FILL_COLOR, null, 8, 8), 10);
            usedHeapSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            usedHeapSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JPanel smallLegendPanel = new JPanel(new FlowLayout(1, 0, 1));
            smallLegendPanel.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            smallLegendPanel.setBorder(new LineBorder(GraphsUI.SMALL_LEGEND_BORDER_COLOR, 1));
            smallLegendPanel.add(heapSizeSmall);
            smallLegendPanel.add(usedHeapSmall);
            JPanel smallLegendContainer = new JPanel(new FlowLayout(1));
            smallLegendContainer.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            smallLegendContainer.add(smallLegendPanel);
            this.setLayout(new BorderLayout());
            this.add((Component)chartPanel, "Center");
            this.add((Component)smallLegendContainer, "South");
            this.chart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        chartAction.actionPerformed(null);
                    }
                }
            });
            this.chartActions = new Action[0];
        } else {
            ProfilerXYTooltipPainter tooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, tooltipPainter));
            JScrollBar hScrollBar = new JScrollBar(0);
            this.chart.attachHorizontalScrollBar(hScrollBar);
            JPanel chartContainer = new JPanel(new BorderLayout());
            chartContainer.setBorder(BorderFactory.createEmptyBorder());
            chartContainer.add((Component)chartPanel, "Center");
            chartContainer.add((Component)hScrollBar, "South");
            JLabel heapSizeBig = new JLabel(GraphsUI.HEAP_SIZE_NAME, new ColorIcon(GraphsUI.HEAP_SIZE_PAINTER_FILL_COLOR, Color.BLACK, 18, 9), 10);
            heapSizeBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel usedHeapBig = new JLabel(GraphsUI.USED_HEAP_NAME, new ColorIcon(GraphsUI.USED_HEAP_PAINTER_FILL_COLOR, Color.BLACK, 18, 9), 10);
            usedHeapBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel bigLegendPanel = new JPanel(new FlowLayout(4, 7, 8));
            bigLegendPanel.setOpaque(false);
            bigLegendPanel.add(heapSizeBig);
            bigLegendPanel.add(usedHeapBig);
            JPanel legendContainer = new JPanel(new BorderLayout(0, 0));
            UIUtils.decorateProfilerPanel(legendContainer);
            legendContainer.add((Component)UIUtils.createHorizontalLine(legendContainer.getBackground()), "North");
            legendContainer.add((Component)bigLegendPanel, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)chartContainer, "Center");
            this.add((Component)legendContainer, "South");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                return GraphPanel.DATE_FORMATTER.format(new Date(timestamp));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.HEAP_SIZE_NAME;
                    }
                    case 1: {
                        return GraphsUI.USED_HEAP_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.HEAP_SIZE_PAINTER_FILL_COLOR;
                    }
                    case 1: {
                        return GraphsUI.USED_HEAP_PAINTER_FILL_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                return GraphPanel.INT_FORMATTER.format(itemValue);
            }

            @Override
            public String getRowUnits(int index, long itemValue) {
                return BytesAxisUtils.UNITS_B;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int index) {
                return MemoryGraphPanel.this.getMaxValueString(this.getRowName(index));
            }

            @Override
            public Color getExtraRowColor(int index) {
                return this.getRowColor(index);
            }

            @Override
            public String getExtraRowValue(int index) {
                SynchronousXYItem item = MemoryGraphPanel.this.models.memoryItemsModel().getItem(index);
                return GraphPanel.INT_FORMATTER.format(item.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int index) {
                return this.getRowUnits(index, -1L);
            }
        };
    }

    private PaintersModel createMemoryPaintersModel() {
        SynchronousXYItemPainter heapSizePainter = SynchronousXYItemPainter.absolutePainter((float)0.0f, (Color)GraphsUI.HEAP_SIZE_PAINTER_LINE_COLOR, (Color)GraphsUI.HEAP_SIZE_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker heapSizeMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.HEAP_SIZE_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.HEAP_SIZE_MARKER_LINE2_COLOR, (Color)GraphsUI.HEAP_SIZE_MARKER_FILL_COLOR);
        CompoundXYItemPainter hsp = new CompoundXYItemPainter((XYItemPainter)heapSizePainter, (XYItemPainter)heapSizeMarker);
        SynchronousXYItemPainter usedHeapPainter = SynchronousXYItemPainter.absolutePainter((float)0.0f, (Color)GraphsUI.USED_HEAP_PAINTER_LINE_COLOR, (Color)GraphsUI.USED_HEAP_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker usedHeapMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.USED_HEAP_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.USED_HEAP_MARKER_LINE2_COLOR, (Color)GraphsUI.USED_HEAP_MARKER_FILL_COLOR);
        CompoundXYItemPainter uhp = new CompoundXYItemPainter((XYItemPainter)usedHeapPainter, (XYItemPainter)usedHeapMarker);
        SynchronousXYItemsModel items = this.models.memoryItemsModel();
        PaintersModel.Default model = new PaintersModel.Default(new ChartItem[]{items.getItem(0), items.getItem(1)}, (ItemPainter[])new XYItemPainter[]{hsp, uhp});
        return model;
    }

    private ChartDecorator createMaxHeapDecorator() {
        return new ChartDecorator(){

            public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
                int limitHeight = Utils.checkedInt((double)context.getViewY((double)((MemoryGraphPanel)MemoryGraphPanel.this).models.getDataManager().maxHeapSize));
                if (limitHeight <= context.getViewportHeight()) {
                    g.setColor(GraphsUI.HEAP_LIMIT_FILL_COLOR);
                    if (context.isBottomBased()) {
                        g.fillRect(0, 0, context.getViewportWidth(), limitHeight);
                    } else {
                        g.fillRect(0, limitHeight, context.getViewportWidth(), context.getViewportHeight() - limitHeight);
                    }
                }
            }
        };
    }
}

