/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public abstract class ProfilerToolbar {
    public static ProfilerToolbar create(boolean showSeparator) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(showSeparator) : new Impl(showSeparator);
    }

    public abstract JComponent getComponent();

    public abstract Component add(Action var1);

    public abstract Component add(Component var1);

    public abstract Component add(Component var1, int var2);

    public abstract void addSeparator();

    public abstract void addSpace(int var1);

    public abstract void addFiller();

    public abstract void remove(Component var1);

    public abstract void remove(int var1);

    public abstract int getComponentCount();

    protected ProfilerToolbar() {
    }

    public static class Impl
    extends ProfilerToolbar {
        protected static int preferredHeight = -1;
        protected final JComponent component;
        protected final JToolBar toolbar = new JToolBar(){

            @Override
            protected void addImpl(Component comp, Object constraints, int index) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)comp);
                }
                super.addImpl(comp, constraints, index);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (preferredHeight == -1) {
                    JToolBar tb = new JToolBar();
                    tb.setBorder(Impl.this.toolbar.getBorder());
                    tb.setBorderPainted(Impl.this.toolbar.isBorderPainted());
                    tb.setRollover(Impl.this.toolbar.isRollover());
                    tb.setFloatable(Impl.this.toolbar.isFloatable());
                    Icon icon = Icons.getIcon((String)"GeneralIcons.Save");
                    JButton b = new JButton("Button", icon);
                    tb.add(b);
                    JToggleButton t = new JToggleButton("Button", icon);
                    tb.add(t);
                    JComboBox<Object> c = new JComboBox<Object>();
                    c.setEditor(new BasicComboBoxEditor());
                    c.setRenderer(new BasicComboBoxRenderer());
                    tb.add(c);
                    tb.addSeparator();
                    preferredHeight = tb.getPreferredSize().height;
                }
                dim.height = Math.max(dim.height, preferredHeight);
                return dim;
            }

            @Override
            public void doLayout() {
                for (Component component : this.getComponents()) {
                    component.setFocusable(Impl.this.isFocusableComponent(component));
                }
                super.doLayout();
            }
        };

        protected Impl(boolean showSeparator) {
            if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
                this.toolbar.setLayout(new BoxLayout(this.toolbar, 2));
            }
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            this.toolbar.setBorderPainted(false);
            this.toolbar.setRollover(true);
            this.toolbar.setFloatable(false);
            if (showSeparator) {
                this.component = new JPanel(new BorderLayout(0, 0));
                this.component.setOpaque(false);
                this.component.add((Component)this.toolbar, "Center");
                this.component.add((Component)UIUtils.createHorizontalLine(this.toolbar.getBackground()), "South");
            } else {
                this.component = this.toolbar;
            }
        }

        protected boolean isFocusableComponent(Component component) {
            if (!component.isVisible()) {
                return false;
            }
            if (component instanceof JLabel) {
                return false;
            }
            if (component instanceof JPanel) {
                return false;
            }
            return !(component instanceof JSeparator);
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public Component add(Action action) {
            JButton c = this.toolbar.add(action);
            this.toolbar.repaint();
            return c;
        }

        @Override
        public Component add(Component component) {
            Component c = this.toolbar.add(component);
            this.toolbar.repaint();
            return c;
        }

        @Override
        public Component add(Component component, int index) {
            Component c = this.toolbar.add(component, index);
            this.toolbar.repaint();
            return c;
        }

        @Override
        public void addSeparator() {
            this.toolbar.addSeparator();
            this.toolbar.repaint();
        }

        @Override
        public void addSpace(int width) {
            this.toolbar.addSeparator(new Dimension(width, 0));
            this.toolbar.repaint();
        }

        @Override
        public void addFiller() {
            Dimension minDim = new Dimension(0, 0);
            Dimension maxDim = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.toolbar.add(new Box.Filler(minDim, minDim, maxDim));
            this.toolbar.repaint();
        }

        @Override
        public void remove(Component component) {
            this.toolbar.remove(component);
            this.toolbar.repaint();
        }

        @Override
        public void remove(int index) {
            this.toolbar.remove(index);
            this.toolbar.repaint();
        }

        @Override
        public int getComponentCount() {
            return this.toolbar.getComponentCount();
        }
    }

    public static abstract class Provider {
        public abstract ProfilerToolbar create(boolean var1);
    }
}

