/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.indexing.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.indexing.impl.CndTextIndexImpl;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.relocate.api.RelocationSupport;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.parsing.lucene.support.IndexManager;

public class CndTextIndexManager {
    public static final String FIELD_IDS = "ids";
    public static final String FIELD_UNIT_ID = "unitId";
    private static final Map<CacheLocation, CndTextIndexImpl> indexMap = new HashMap<CacheLocation, CndTextIndexImpl>();
    private static final String INDEX_FOLDER_NAME = "text_index";

    public static synchronized CndTextIndexImpl get(CacheLocation location) {
        CndTextIndexImpl index = indexMap.get(location);
        if (index == null) {
            File indexRoot = new File(location.getLocation(), INDEX_FOLDER_NAME);
            indexRoot.mkdirs();
            try {
                UnitCodec unitCodec = RelocationSupport.get((CacheLocation)location);
                index = new CndTextIndexImpl(IndexManager.createDocumentIndex((File)indexRoot), unitCodec);
            }
            catch (IOException ex) {
                Logger.getLogger(CndTextIndexManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            indexMap.put(location, index);
        }
        return index;
    }

    public static class Cleanup
    implements Runnable {
        @Override
        public void run() {
            for (CndTextIndexImpl idx : indexMap.values()) {
                idx.store();
            }
        }
    }
}

